/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mimparser.state;

import org.xml.sax.Attributes;
import se.ericsson.cello.mimparser.model.DomainExtensionImpl;
import se.ericsson.cello.mimparser.model.MomActionImpl;
import se.ericsson.cello.mimparser.model.MomParameterImpl;
import se.ericsson.cello.mimparser.state.ConditionState;
import se.ericsson.cello.mimparser.state.DependenciesScriptState;
import se.ericsson.cello.mimparser.state.DependenciesState;
import se.ericsson.cello.mimparser.state.DeprecatedState;
import se.ericsson.cello.mimparser.state.DisturbancesState;
import se.ericsson.cello.mimparser.state.DomainExtensionState;
import se.ericsson.cello.mimparser.state.FeatureState;
import se.ericsson.cello.mimparser.state.FilterState;
import se.ericsson.cello.mimparser.state.MomBaseState;
import se.ericsson.cello.mimparser.state.ObsoleteState;
import se.ericsson.cello.mimparser.state.ParameterState;
import se.ericsson.cello.mimparser.state.PreConditionState;
import se.ericsson.cello.mimparser.state.SideEffectsState;
import se.ericsson.cello.mimparser.state.SpecificationState;
import se.ericsson.cello.mimparser.state.TakesEffectState;
import se.ericsson.cello.mimparser.state.TransactionConstraintState;
import se.ericsson.cello.mimparser.state.VisibilityState;
import se.ericsson.cello.mimparser.statemachine.StateMachine;

class ActionState
extends MomBaseState {
    private MomActionImpl momAction;
    public static final String ACTION_TAG = "action";

    public ActionState(MomActionImpl moAction) {
        super(ACTION_TAG);
        this.momAction = moAction;
    }

    public void startElement(StateMachine stateMachine, String name, Attributes attributes) {
        super.startElement(stateMachine, name, this.momAction);
        stateMachine.getDataTypeManager().handleDataTypes(this.momAction, name, attributes);
        if (ParameterState.isParameter(name)) {
            MomParameterImpl parameter = new MomParameterImpl(name, attributes, stateMachine.getParseInfo().getMimModel(), stateMachine.getParseInfo().getNextId());
            this.momAction.addParameter(parameter);
            stateMachine.pushState(new ParameterState(parameter, name));
        } else if (name.equals("raisesException")) {
            String exceptionName = attributes.getValue("name");
            this.momAction.addException(exceptionName);
        } else if (name.equals("deprecated")) {
            stateMachine.pushState(new DeprecatedState(this.momAction));
        } else if (name.equals("disturbances")) {
            stateMachine.pushState(new DisturbancesState(this.momAction));
        } else if (name.equals("takesEffect")) {
            stateMachine.pushState(new TakesEffectState(this.momAction));
        } else if (name.equals("sideEffects")) {
            stateMachine.pushState(new SideEffectsState(this.momAction));
        } else if (name.equals("dependencies")) {
            stateMachine.pushState(new DependenciesState(this.momAction));
        } else if (name.equals("precondition")) {
            stateMachine.pushState(new PreConditionState(this.momAction));
        } else if (name.equals("condition")) {
            stateMachine.pushState(new ConditionState(this.momAction));
        } else if (name.equals("specification")) {
            stateMachine.pushState(new SpecificationState(this.momAction));
        } else if (name.equals("obsolete")) {
            stateMachine.pushState(new ObsoleteState(this.momAction));
        } else if (name.equals("visibility")) {
            stateMachine.pushState(new VisibilityState(this.momAction));
        } else if (name.equals("filter")) {
            stateMachine.pushState(new FilterState(this.momAction));
        } else if (name.equals("dependenciesScript")) {
            stateMachine.pushState(new DependenciesScriptState(this.momAction));
        } else if (name.equals("feature")) {
            stateMachine.pushState(new FeatureState(this.momAction));
        } else if (name.equals("transactionConstraint")) {
            stateMachine.pushState(new TransactionConstraintState(this.momAction));
        } else if (name.equals("domainExtension")) {
            DomainExtensionImpl domainObject = new DomainExtensionImpl(name, attributes, stateMachine.getParseInfo().getMimModel(), stateMachine.getParseInfo().getNextId());
            this.momAction.setDomain(domainObject);
            stateMachine.pushState(new DomainExtensionState(domainObject));
        } else if (name.equals("lockBeforeModify")) {
            this.momAction.setLockBeforeModify();
        } else if (name.equals("lockBeforeExecute")) {
            this.momAction.setLockBeforeExecute();
        } else if (name.equals("transactionRequired")) {
            this.momAction.setTransactionRequired();
        } else if (name.equals("interfaceOnly")) {
            this.momAction.setInterfaceOnly();
        }
    }
}

