/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mimparser.state;

import org.xml.sax.Attributes;
import se.ericsson.cello.mimparser.model.DerivedDataTypeImpl;
import se.ericsson.cello.mimparser.model.DomainExtensionImpl;
import se.ericsson.cello.mimparser.model.MimModelImpl;
import se.ericsson.cello.mimparser.model.MimPartImpl;
import se.ericsson.cello.mimparser.model.MomClassImpl;
import se.ericsson.cello.mimparser.model.MomEnumImpl;
import se.ericsson.cello.mimparser.model.MomExceptionImpl;
import se.ericsson.cello.mimparser.model.MomMetaDataImpl;
import se.ericsson.cello.mimparser.model.MomRelationshipExtImpl;
import se.ericsson.cello.mimparser.model.MomStructImpl;
import se.ericsson.cello.mimparser.state.ApplicationTagState;
import se.ericsson.cello.mimparser.state.ClassState;
import se.ericsson.cello.mimparser.state.CopyrightState;
import se.ericsson.cello.mimparser.state.DerivedDataTypeState;
import se.ericsson.cello.mimparser.state.DescriptionSettable;
import se.ericsson.cello.mimparser.state.DescriptionState;
import se.ericsson.cello.mimparser.state.DomainExtensionState;
import se.ericsson.cello.mimparser.state.DtdVersionState;
import se.ericsson.cello.mimparser.state.EnumState;
import se.ericsson.cello.mimparser.state.ExceptionState;
import se.ericsson.cello.mimparser.state.MimPartState;
import se.ericsson.cello.mimparser.state.MomBaseState;
import se.ericsson.cello.mimparser.state.MomMetaDataState;
import se.ericsson.cello.mimparser.state.RelationshipState;
import se.ericsson.cello.mimparser.state.StructState;
import se.ericsson.cello.mimparser.statemachine.StateMachine;

class ModelsState
extends MomBaseState
implements DescriptionSettable {
    private MimModelImpl mimModel;
    public static final String MODELS_TAG = "models";

    public ModelsState(MimModelImpl momRoot) {
        super(MODELS_TAG);
        this.mimModel = momRoot;
    }

    public void startElement(StateMachine stateMachine, String name, Attributes attributes) {
        if (name.equals("description")) {
            stateMachine.pushState(new DescriptionState(this));
        } else if (name.equals("applicationTag")) {
            stateMachine.pushState(new ApplicationTagState(this));
        } else if (name.equals("copyright")) {
            stateMachine.pushState(new CopyrightState(this.mimModel));
        } else if (name.equals("dtdVersion")) {
            stateMachine.pushState(new DtdVersionState(this.mimModel));
        } else if (name.equals("momMetaData")) {
            MomMetaDataImpl momMetaData = new MomMetaDataImpl(name, attributes, stateMachine.getParseInfo().getMimModel(), stateMachine.getParseInfo().getNextId());
            this.mimModel.setMomMetaData(momMetaData);
            stateMachine.pushState(new MomMetaDataState(momMetaData));
        } else if (name.equals("class")) {
            MomClassImpl moClassObject = new MomClassImpl(name, attributes, stateMachine.getParseInfo().getMimModel(), stateMachine.getParseInfo().getNextId());
            this.mimModel.addClass(moClassObject.getName(), moClassObject);
            stateMachine.pushState(new ClassState(moClassObject));
        } else if (name.equals("struct")) {
            MomStructImpl moStructObject = new MomStructImpl(name, attributes, stateMachine.getParseInfo().getMimModel(), stateMachine.getParseInfo().getNextId());
            this.mimModel.addStruct(moStructObject.getName(), moStructObject);
            stateMachine.pushState(new StructState(moStructObject));
        } else if (name.equals("enum")) {
            MomEnumImpl moEnumObject = new MomEnumImpl(name, attributes, stateMachine.getParseInfo().getMimModel(), stateMachine.getParseInfo().getNextId());
            this.mimModel.addEnum(moEnumObject.getName(), moEnumObject);
            stateMachine.pushState(new EnumState(moEnumObject));
        } else if (name.equals("relationship")) {
            MomRelationshipExtImpl momRelationshipExtObject = new MomRelationshipExtImpl(name, attributes, stateMachine.getParseInfo().getMimModel(), stateMachine.getParseInfo().getNextId());
            stateMachine.pushState(new RelationshipState(momRelationshipExtObject));
        } else if (name.equals("exception")) {
            MomExceptionImpl moExceptionObject = new MomExceptionImpl(name, attributes, stateMachine.getParseInfo().getMimModel(), stateMachine.getParseInfo().getNextId());
            stateMachine.pushState(new ExceptionState(moExceptionObject));
        } else if (name.equals("mimPart")) {
            MimPartImpl mimPartObject = new MimPartImpl(name, attributes, stateMachine.getParseInfo().getMimModel(), stateMachine.getParseInfo().getNextId());
            this.mimModel.addMimParts(mimPartObject);
            stateMachine.pushState(new MimPartState(mimPartObject));
        } else if (name.equals("derivedDataType")) {
            DerivedDataTypeImpl dataTypeObject = new DerivedDataTypeImpl(name, attributes, stateMachine.getParseInfo().getMimModel(), stateMachine.getParseInfo().getNextId());
            this.mimModel.addDerivedDataType(dataTypeObject.getName(), dataTypeObject);
            stateMachine.pushState(new DerivedDataTypeState(dataTypeObject));
        } else if (name.equals("domainExtension")) {
            DomainExtensionImpl domainObject = new DomainExtensionImpl(name, attributes, stateMachine.getParseInfo().getMimModel(), stateMachine.getParseInfo().getNextId());
            this.mimModel.setDomain(domainObject);
            stateMachine.pushState(new DomainExtensionState(domainObject));
        } else if (name.equals("mim")) {
            String mimName = attributes.getValue("name");
            this.mimModel.setName(mimName);
            String mimVersion = attributes.getValue("version");
            this.mimModel.setVersion(mimVersion);
            String mimRelease = attributes.getValue("release");
            this.mimModel.setRelease(mimRelease);
        }
    }

    public void setDescription(String description) {
        this.mimModel.setDescription(description);
    }

    public void setApplicationTag(String applicationTag) {
        this.mimModel.setApplicationTag(applicationTag);
    }
}

