/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mimparser.statemachine;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import se.ericsson.cello.mimparser.parser.ParseInfo;
import se.ericsson.cello.mimparser.state.DataTypeManager;
import se.ericsson.cello.mimparser.statemachine.State;
import se.ericsson.cello.mimparser.statemachine.StateStack;

public class StateMachine {
    private StateStack myHistory = new StateStack();
    private ParseInfo parseInfo;
    private DataTypeManager dataTypeManager;

    public StateMachine(State initialState, ParseInfo parseInfo) {
        this.parseInfo = parseInfo;
        this.myHistory.push(initialState);
        this.dataTypeManager = new DataTypeManager(parseInfo.getMimModel(), this);
    }

    public void pushState(State state) {
        this.myHistory.push(state);
    }

    public State popState() {
        return this.myHistory.pop();
    }

    public State peekState() {
        return this.myHistory.peek();
    }

    public void startDocument() {
        this.myHistory.peek().startDocument(this);
    }

    public void endDocument() {
        this.myHistory.peek().endDocument(this);
    }

    public void startElement(String name, Attributes attributes) {
        this.myHistory.peek().startElement(this, name, attributes);
    }

    public void endElement(String name) {
        this.myHistory.peek().endElement(this, name);
    }

    public void characters(char[] ch, int start, int length) {
        this.myHistory.peek().characters(this, ch, start, length);
    }

    public void warning(SAXParseException e) throws SAXException {
        this.myHistory.peek().warning(this, e);
    }

    public void error(SAXParseException e) throws SAXException {
        this.myHistory.peek().error(this, e);
    }

    public ParseInfo getParseInfo() {
        return this.parseInfo;
    }

    public DataTypeManager getDataTypeManager() {
        return this.dataTypeManager;
    }
}

