/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello;

import java.lang.reflect.Constructor;
import se.ericsson.cello.equipment.EquipMgr;
import se.ericsson.cello.ipoam.IpMgr;
import se.ericsson.cello.iptransport.IpTransportMgr;
import se.ericsson.cello.licensing.LicensingMgr;
import se.ericsson.cello.log.LogMgr;
import se.ericsson.cello.managedelement.ManagedElementMgr;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.moframework.Mopplet;
import se.ericsson.cello.moframework.internal.DependencyAwareMopplet;
import se.ericsson.cello.moframework.internal.MoppletId;
import se.ericsson.cello.moframework.internal.MoppletRunner;
import se.ericsson.cello.security.SecurityMgr;
import se.ericsson.cello.su.SuMgr;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.swmanagement.SwManagementMgr;
import se.ericsson.cello.sync.SyncMgr;

public class CmaBootStrapper
implements DependencyAwareMopplet {
    private MoppletRunner mopplets = new MoppletRunner();
    private MoppletId id;
    private static final MoppletId[] DEPENDENCIES = new MoppletId[0];

    public CmaBootStrapper() {
        this.mopplets.add((Mopplet)new ManagedElementMgr());
        this.mopplets.add((Mopplet)new EquipMgr());
        this.mopplets.add((Mopplet)new SwManagementMgr());
        this.mopplets.add((Mopplet)new SuMgr());
        this.mopplets.add((Mopplet)new SecurityMgr());
        this.mopplets.add((Mopplet)new LicensingMgr());
        this.mopplets.add((Mopplet)new LogMgr());
        this.mopplets.add((Mopplet)new IpMgr());
        this.mopplets.add((Mopplet)new SyncMgr());
        this.mopplets.add((Mopplet)new IpTransportMgr());
        this.addOptionalMopplet("se.ericsson.cello.spu.SpuMgr");
        this.addOptionalMopplet("se.ericsson.cello.internaltransport.InternalTrspMgr");
        this.addOptionalMopplet("se.ericsson.cello.extethswitch.ExtEthSwitchMgr");
        this.addOptionalMopplet("se.ericsson.cello.atm.AtmMgr");
        this.addOptionalMopplet("se.ericsson.cello.pdhsdhtrans.PdhSdhTransMgr");
        this.addOptionalMopplet("se.ericsson.cello.sctp.SctpMgr");
        this.addOptionalMopplet("se.ericsson.cello.usaal.UsaalMgr");
        this.addOptionalMopplet("se.ericsson.cello.ss7.Ss7Mgr");
        this.addOptionalMopplet("se.ericsson.cello.ncli.mao.NcliMgr");
        this.addOptionalMopplet("se.ericsson.cello.coll.DataCollectorMgr");
        this.addOptionalMopplet("se.ericsson.cello.viewfilecreator.mao.ViewfileCreator");
        this.addOptionalMopplet("se.ericsson.cello.clustersupport.ClusterSupportMgr");
        this.addOptionalMopplet("se.ericsson.cello.pmreporter.PmReporterMgr");
        this.addOptionalMopplet("se.ericsson.cello.pmkpi.PmKpiMgr");
        this.addOptionalMopplet("se.ericsson.cello.ipsec.IpSecMgr");
        this.addOptionalMopplet("se.ericsson.cello.iprouting.IpRoutingMgr");
        this.addOptionalMopplet("se.ericsson.cello.benchmark.BenchmarkMgr");
        this.id = new MoppletId("CMA Bootstrapper");
    }

    private void addOptionalMopplet(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            Class[] classArray = new Class[]{};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object obj = constructor.newInstance(new Object[0]);
            this.mopplets.add((Mopplet)obj);
        }
        catch (ClassNotFoundException classNotFoundException) {
            UpgradeTrace.info(this.getClass(), (String)"addOptionalMopplet()", (String)("The definiton of ManagedArea " + string + " is not found, considered to be optional."));
            MessageLog.info(this.getClass(), (String)("addOptionalMopplet() The definiton of ManagedArea " + string + " is not found, considered to be optional."));
        }
        catch (Throwable throwable) {
            UpgradeTrace.error(this.getClass(), (String)"addOptionalMopplet()", (String)("Unable to load optional mopplet " + string), (Throwable)throwable);
            MessageLog.traceError(this.getClass(), (String)("addOptionalMopplet() Unable to load optional mopplet " + string), (Throwable)throwable);
        }
    }

    public MoppletId getMoppletId() {
        return this.id;
    }

    public MoppletId[] getDependencies() {
        return DEPENDENCIES;
    }

    public void init() {
        this.mopplets.init();
    }

    public void start() {
        this.mopplets.start();
    }

    public void finish() {
        this.mopplets.finish();
    }
}

