/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.omf.aue.step1.actions;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.actions.NoSuchTableException;
import se.ericsson.crbs.omf.aue.common.actions.TableAlreadyExistsException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.LdnUtil;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractCreateInstanceAction;
import se.ericsson.crbs.omf.aue.step1.actions.AddAttributeAction;
import se.ericsson.crbs.omf.aue.step1.actions.ChangeAttributeValueAction;
import se.ericsson.crbs.omf.aue.step1.actions.CreateOneInstanceAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.util.TableDataUtil;
import se.ericsson.crbs.supsys.omf.aue.step1.util.CabinetParametersHelper;

public class CreateDefaultNbrExternalNodesAction
extends AbstractCreateInstanceAction {
    protected static final String SUPPORT_SYSTEM_CONTROL_ATTR_NAME = "supportSystemControl";
    private static final Class THIS_CLASS = CreateDefaultNbrExternalNodesAction.class;
    private static final String MANAGED_ELEMENT_LDN = "ManagedElement=1";
    protected static final String EQUIPMENT_LDN = LdnUtil.createChildLdn((String)"ManagedElement=1", (String)"Equipment", (String)"1");
    protected static final String EQUIPMENT_SUPPORT_FUNCTION = "EquipmentSupportFunction";
    protected static final String EQUIPMENT_SUPPORT_FUNCTION_LDN = LdnUtil.createChildLdn((String)"ManagedElement=1", (String)"EquipmentSupportFunction", (String)"1");
    protected static final String EXTERNAL_NODE = "ExternalNode";
    private static final String EXTERNAL_NODE_FRO_TYPE = Integer.toString(0x7040007);
    protected static final String INFORMATION_ONLY = "informationOnly";
    protected static final String INFORMATION_ONLY_DEFAULT_VALUE = "1";
    private static final String LDNS_OF_EXTARNAL_NODES_TO_CREATE = "ldnsOfExternalNodesToCreate";
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public void createInstance(AueContext aueContext) throws CrbsAueException {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.isSuportSystemControlOnEquipmentSupportFunction()) {
            int n = this.getDefaultNumberOfExternalNodesByParsingCabinetParametersFile(aueContext);
            Set set = this.getIdsForExistingMoInstances(EXTERNAL_NODE);
            TreeSet<Integer> treeSet = new TreeSet<Integer>();
            int n2 = 1;
            for (int i = 0; i < n - set.size(); ++i) {
                while (set.contains(new Integer(n2))) {
                    ++n2;
                }
                treeSet.add(new Integer(n2++));
            }
            if (!treeSet.isEmpty()) {
                this.createExternalNodes(stringBuffer, treeSet, aueContext);
            }
        }
        try {
            this.tableHandler.storeInAuePersistency("", LDNS_OF_EXTARNAL_NODES_TO_CREATE, stringBuffer.toString());
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException(tableDataException.getMessage(), (Throwable)tableDataException);
        }
    }

    private void createExternalNodes(StringBuffer stringBuffer, Set set, AueContext aueContext) throws CrbsAueException, CrbsAueException {
        TableData tableData;
        try {
            tableData = this.tableHandler.getTableData(EXTERNAL_NODE);
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("It is not possible to get the table data: ExternalNode", (Throwable)tableDataException);
        }
        boolean bl = tableData.doesAttributeExist(INFORMATION_ONLY);
        CreateOneInstanceAction createOneInstanceAction = new CreateOneInstanceAction();
        ChangeAttributeValueAction changeAttributeValueAction = new ChangeAttributeValueAction();
        Map map = this.createCreateOneInstanceActionArgsMap(bl);
        Map map2 = this.createChangeAttributeValueActionArgsMap();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = String.valueOf((Integer)iterator.next());
            map.put("rdnValue", string);
            createOneInstanceAction.setMoActionArgs(map);
            createOneInstanceAction.convert(aueContext);
            changeAttributeValueAction.setMoActionArgs(map2);
            try {
                changeAttributeValueAction.convert(aueContext);
            }
            catch (TableAlreadyExistsException tableAlreadyExistsException) {
                throw new CrbsAueException(tableAlreadyExistsException.getMessage(), (Throwable)tableAlreadyExistsException);
            }
            catch (NoSuchTableException noSuchTableException) {
                throw new CrbsAueException(noSuchTableException.getMessage(), (Throwable)noSuchTableException);
            }
            String string2 = LdnUtil.createChildLdn((String)EQUIPMENT_LDN, (String)EXTERNAL_NODE, (String)string);
            stringBuffer.append((stringBuffer.length() > 0 ? " " : "") + string2);
        }
        this.addInformationOnlyAttrIfNotExist(aueContext, bl);
    }

    private Map createChangeAttributeValueActionArgsMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Mo", EXTERNAL_NODE);
        hashMap.put("attribute", INFORMATION_ONLY);
        hashMap.put("newAttributeValue", INFORMATION_ONLY_DEFAULT_VALUE);
        return hashMap;
    }

    private Map createCreateOneInstanceActionArgsMap(boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("name", EXTERNAL_NODE);
        hashMap.put("frotype", EXTERNAL_NODE_FRO_TYPE);
        hashMap.put("parentldn", EQUIPMENT_LDN);
        hashMap.put("parentRefExists", Boolean.FALSE.toString());
        if (bl) {
            hashMap.put("childAttributes", "<attr name=\"informationOnly\" type=\"S32\" value=\"1\"/>");
        }
        return hashMap;
    }

    private void addInformationOnlyAttrIfNotExist(AueContext aueContext, boolean bl) throws CrbsAueException {
        if (!bl) {
            AddAttributeAction addAttributeAction = new AddAttributeAction();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("name", INFORMATION_ONLY);
            hashMap.put("Mo", EXTERNAL_NODE);
            hashMap.put("type", "S32");
            hashMap.put("defaultValue", INFORMATION_ONLY_DEFAULT_VALUE);
            addAttributeAction.setMoActionArgs(hashMap);
            addAttributeAction.convert(aueContext);
        }
    }

    private boolean isSuportSystemControlOnEquipmentSupportFunction() throws CrbsAueException {
        try {
            TableData tableData = this.tableHandler.getTableData(EQUIPMENT_SUPPORT_FUNCTION);
            Map map = TableDataUtil.getAttributes((String)EQUIPMENT_SUPPORT_FUNCTION_LDN, (TableData)tableData);
            if (!map.containsKey(SUPPORT_SYSTEM_CONTROL_ATTR_NAME)) {
                throw new CrbsAueException("Can not fetch attribute supportSystemControl from " + EQUIPMENT_SUPPORT_FUNCTION_LDN);
            }
            Integer n = (Integer)map.get(SUPPORT_SYSTEM_CONTROL_ATTR_NAME);
            return n != 0;
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Unable to get table data for EquipmentSupportFunction", (Throwable)tableDataException);
        }
    }

    private int getDefaultNumberOfExternalNodesByParsingCabinetParametersFile(AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "getDefaultNumberOfExternalNodesByParsingCabinetParametersFile");
        CabinetParametersHelper cabinetParametersHelper = new CabinetParametersHelper();
        int n = cabinetParametersHelper.getDefaultNumberOfExternalNodes(aueContext);
        logger.traceReturn(THIS_CLASS, "getProductNameFromManagedElementMO - defaultNumberOfExternalNodes: " + n);
        return n;
    }

    private Set getIdsForExistingMoInstances(String string) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "getIdsForExistingMoInstances - moType: " + string);
        try {
            TreeSet<Integer> treeSet = new TreeSet<Integer>();
            StringBuffer stringBuffer = new StringBuffer();
            TableData tableData = this.tableHandler.getTableData(string);
            if (tableData.isNotEmpty()) {
                Object[] objectArray = TableDataUtil.getLdns((TableData)tableData);
                for (int i = 0; i < objectArray.length; ++i) {
                    String string2 = LdnUtil.getRdnValue((String)objectArray[i].toString());
                    stringBuffer.append(' ').append(string2);
                    treeSet.add(new Integer(string2));
                }
            }
            logger.traceReturn(THIS_CLASS, "getIdsForExistingMoInstances - id's:" + stringBuffer);
            return treeSet;
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Unable to get table data for " + string, (Throwable)tableDataException);
        }
    }
}

