/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.omf.aue.step1.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.LdnUtil;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractCreateInstanceAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;

public class RemoveDuplicateMOEnergyMeterAction
extends AbstractCreateInstanceAction {
    private static final Class THIS_CLASS = RemoveDuplicateMOEnergyMeterAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String REMOVE_DUPLICATE_MO_ENERGYMETER_STEP2_ACTION = "energymetersToRemove";
    protected static final String HWUNIT = "HwUnit";
    protected static final String ENERGYMETER = "EnergyMeter";

    public void createInstance(AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "convert()");
        Object[] objectArray = this.getExistEnergyMeterLDNs();
        ArrayList arrayList = new ArrayList();
        if (objectArray.length >= 2) {
            arrayList = this.getEnergyMeterLDNsToBeRemoved(objectArray);
            this.removeDuplicateEnergyMeters(arrayList);
            this.informStep2(arrayList);
        }
        logger.traceReturn(THIS_CLASS, "convert()");
    }

    private void removeDuplicateEnergyMeters(ArrayList arrayList) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "removeDuplicateEnergyMeters()");
        TableData tableData = this.getTableData(this.tableHandler, ENERGYMETER);
        for (int i = 0; i < arrayList.size(); ++i) {
            int n;
            String string = arrayList.get(i).toString();
            boolean bl = false;
            for (n = 0; n < tableData.getNumberOfRecords(); ++n) {
                if (!((String)tableData.getRecord(n)[1]).equals(string)) continue;
                bl = true;
                break;
            }
            if (bl) {
                logger.traceDebug(THIS_CLASS, "Deleting ldn: " + string);
                tableData.deleteRowData(n);
                continue;
            }
            logger.traceDebug(THIS_CLASS, "Could not find ldn to delete: " + string);
        }
        logger.traceReturn(THIS_CLASS, "removeDuplicateEnergyMeters");
    }

    private ArrayList getEnergyMeterLDNsToBeRemoved(Object[] objectArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < objectArray.length - 1; ++i) {
            boolean bl = false;
            String string = objectArray[i].toString();
            for (int j = i + 1; j < objectArray.length; ++j) {
                if (!string.equalsIgnoreCase(objectArray[j].toString())) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            arrayList.add(string);
            logger.info(THIS_CLASS, "getDuplicatedEnergyMeterLDNs(): Duplicate EnergyMeter" + string);
        }
        return arrayList;
    }

    private void informStep2(List list) throws CrbsAueException {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        String string2 = "";
        String string3 = "";
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            string2 = LdnUtil.getParentLdn((String)string);
            string3 = LdnUtil.getRdnValue((String)string2);
            stringBuffer.append((stringBuffer.length() > 0 ? " " : "") + string3);
        }
        try {
            logger.info(THIS_CLASS, "informStep2, storeing in Auepersistency: " + stringBuffer.toString());
            this.tableHandler.storeInAuePersistency("", REMOVE_DUPLICATE_MO_ENERGYMETER_STEP2_ACTION, stringBuffer.toString());
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException(tableDataException.getMessage(), (Throwable)tableDataException);
        }
    }

    private Object[] getExistEnergyMeterLDNs() throws CrbsAueException {
        TableData tableData = this.getTableData(this.tableHandler, ENERGYMETER);
        Object[] objectArray = new Object[]{};
        try {
            if (tableData.isNotEmpty()) {
                objectArray = tableData.getAttributeValues("ldn");
            }
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException(tableDataException.getMessage(), (Throwable)tableDataException);
        }
        return objectArray;
    }

    private TableData getTableData(TableHandler tableHandler, String string) throws CrbsAueException {
        TableData tableData;
        try {
            tableData = tableHandler.getTableData(string);
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("It is not possible to get the table data: " + string, (Throwable)tableDataException);
        }
        return tableData;
    }
}

