/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.omf.aue.step1.actions;

import java.util.HashMap;
import java.util.Map;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.actions.NoSuchTableException;
import se.ericsson.crbs.omf.aue.common.actions.TableAlreadyExistsException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.LdnUtil;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;
import se.ericsson.crbs.omf.aue.step1.actions.ChangeAttributeValueAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;
import se.ericsson.crbs.omf.aue.step1.actions.util.TableDataUtil;

public class SetEquipmentSupportFunctionRefOnExternalNodesAction
extends AbstractConversionAction {
    private static final Class THIS_CLASS = SetEquipmentSupportFunctionRefOnExternalNodesAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String EXTERNALNODE_MO_TYPE = "ExternalNode";
    private static final String ESF_MO_TYPE = "EquipmentSupportFunction";
    private static final String LDN_ATTRIBUTE_NAME = "ldn";
    private static final String ESFREF_ATTRIBUTE_NAME = "equipmentSupportFunctionRef";
    private static final int CRBS_FRO_TYPE_BASE = 0x7040000;
    private static final int CRBS_SUP_SYS_CTRL_FRO_TYPE_BASE = 0x7040000;
    private static final int EQUIPMENT_SUPPORT_FUNCTION_FRO_TYPE = 117702666;
    private TableHandler m_tableHandler;

    public void convert(AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "convert()");
        this.m_tableHandler = (TableHandler)aueContext.getAttribute("CURRENT_TABLE_HANDLER");
        try {
            TableData tableData;
            TableData tableData2;
            try {
                tableData2 = this.m_tableHandler.getTableData(EXTERNALNODE_MO_TYPE);
            }
            catch (TableDataException tableDataException) {
                tableData2 = null;
            }
            try {
                tableData = this.m_tableHandler.getTableData(ESF_MO_TYPE);
            }
            catch (TableDataException tableDataException) {
                tableData = null;
            }
            if (tableData != null && tableData.getNumberOfRecords() == 1 && tableData2 != null && tableData2.getNumberOfRecords() > 0) {
                Map map = tableData.getRecordMap(0);
                String string = (String)map.get(LDN_ATTRIBUTE_NAME);
                String string2 = TableDataUtil.getFroid((String)string, (TableData)tableData);
                logger.traceDebug(THIS_CLASS, "EquipmentSupportFunction Ldn: " + string + " FroId: " + string2);
                this.setEquipmentSupportFunctionRef(string, string2, tableData2, aueContext);
            } else {
                logger.traceDebug(THIS_CLASS, "No EcBus MOs or no EquipmentSupportFunction MO. Nothing to upgrade.");
            }
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Failed to find read EquipmentSupportFunction or EcBus tabledata.", (Throwable)tableDataException);
        }
        logger.traceReturn(THIS_CLASS, "convert()");
    }

    private void setEquipmentSupportFunctionRef(String string, String string2, TableData tableData, AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "updateEquipmentSupportFunctionRef()");
        try {
            Object[] objectArray = TableDataUtil.getLdns((TableData)tableData);
            String string3 = TableDataUtil.createMoRefXmlString((String)ESF_MO_TYPE, (String)string, (String)Integer.toString(117702666), (String)string2);
            int n = tableData.getNumberOfRecords();
            for (int i = 0; i < n; ++i) {
                try {
                    String string4 = objectArray[i].toString();
                    String string5 = LdnUtil.getRdnValue((String)string4);
                    logger.traceDebug(THIS_CLASS, "ExternalNode ldn: " + string4 + ", rdn: " + string5);
                    ChangeAttributeValueAction changeAttributeValueAction = new ChangeAttributeValueAction();
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("Mo", EXTERNALNODE_MO_TYPE);
                    hashMap.put("rdnValue", string5);
                    hashMap.put("attribute", ESFREF_ATTRIBUTE_NAME);
                    hashMap.put("newAttributeValue", string3);
                    changeAttributeValueAction.setMoActionArgs(hashMap);
                    changeAttributeValueAction.convert(aueContext);
                    continue;
                }
                catch (NoSuchTableException noSuchTableException) {
                    throw new CrbsAueException(noSuchTableException.getMessage(), (Throwable)noSuchTableException);
                }
                catch (TableAlreadyExistsException tableAlreadyExistsException) {
                    throw new CrbsAueException(tableAlreadyExistsException.getMessage(), (Throwable)tableAlreadyExistsException);
                }
            }
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException(tableDataException.getMessage(), (Throwable)tableDataException);
        }
        logger.traceReturn(THIS_CLASS, "updateEquipmentSupportFunctionRef()");
    }
}

