/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.common;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;

public class BoamGenericMoFactory
implements MoFactory {
    private static final Class SELF = BoamGenericMoFactory.class;
    private Method createMethod = null;
    private Constructor recoveryConstructor = null;
    private final Class myMoImpl;
    private final String myTypeName;

    public BoamGenericMoFactory(Class moImpl, String moTypeName) {
        MessageLog.traceEnter(SELF, "BoamGenericMoFactory(), moImpl: " + moImpl.getName() + ", moTypeName: " + moTypeName);
        if (MoFactoryMgr.instance().lookup(moTypeName) != null) {
            MessageLog.traceError(SELF, "BoamGenericMoFactory(), factory already exists!! Mo type: " + moTypeName);
        }
        this.myMoImpl = moImpl;
        this.myTypeName = moTypeName;
        if (this.init()) {
            MoFactoryMgr.instance().register((MoFactory)this, this.getMoTypeName());
        }
    }

    public ManagedObject createMo(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        ManagedObject obj = null;
        try {
            obj = (ManagedObject)this.createMethod.invoke(null, parent, attributes, identity, source, context);
        }
        catch (InvocationTargetException e) {
            MessageLog.info(SELF, "createMo(), method invoke failed!! MO=" + this.myTypeName + ", exception: " + e);
            BoamGenericMoFactory.rollback(context);
            if (e.getTargetException() instanceof MoAccessException) {
                MoAccessException moae = (MoAccessException)e.getTargetException();
                MessageLog.info(SELF, "createMo(), nested exception: " + moae);
                throw moae;
            }
            throw new MoCanNotBeCreatedException(this.getMoTypeName());
        }
        catch (Exception e) {
            MessageLog.info(SELF, "createMo(), method invoke failed!! MO=" + this.myTypeName + ", exception: " + e + (e.getCause() != null ? ", caused by: " + e.getCause() : ""));
            BoamGenericMoFactory.rollback(context);
            throw new MoCanNotBeCreatedException(this.getMoTypeName());
        }
        return obj;
    }

    private static void rollback(Coordinator context) {
        try {
            context.rollbackOnly();
        }
        catch (InactiveTransactionException e1) {
            MessageLog.traceError(SELF, "rollback transaction failed", e1);
        }
    }

    public ManagedObject recoverMo(MoData moAttributes) throws MoNameAlreadyTakenException {
        ManagedObject obj = null;
        String errorMsg = "recoverMo(), instantiation failed!!";
        try {
            obj = (ManagedObject)this.recoveryConstructor.newInstance(moAttributes);
        }
        catch (IllegalArgumentException are) {
            MessageLog.traceError(SELF, "recoverMo(), instantiation failed!!", are);
            throw new MoNameAlreadyTakenException(this.getMoTypeName());
        }
        catch (IllegalAccessException ae) {
            MessageLog.traceError(SELF, "recoverMo(), instantiation failed!!", ae);
            throw new MoNameAlreadyTakenException(this.getMoTypeName());
        }
        catch (InstantiationException ie) {
            MessageLog.traceError(SELF, "recoverMo(), instantiation failed!!", ie);
        }
        catch (InvocationTargetException e) {
            throw (MoNameAlreadyTakenException)e.getTargetException();
        }
        return obj;
    }

    public String getMoTypeName() {
        return this.myTypeName;
    }

    private boolean init() {
        String errorMsg = "Couldn't find create method /recovery Constructor for: ";
        try {
            this.createMethod = this.myMoImpl.getMethod("create", ManagedObject.class, AttrList.class, String.class, ManagedObject.class, Coordinator.class);
        }
        catch (NoSuchMethodException e) {
            MessageLog.traceError(SELF, "Couldn't find create  for: " + this.myMoImpl.getName(), e);
        }
        catch (SecurityException e) {
            MessageLog.traceError(SELF, "SecurityException was thrown", e);
        }
        try {
            this.recoveryConstructor = this.myMoImpl.getDeclaredConstructor(MoData.class);
        }
        catch (NoSuchMethodException e) {
            MessageLog.traceError(SELF, "Couldn't find recovery Constructor for: " + this.myMoImpl.getName(), e);
        }
        catch (SecurityException e) {
            MessageLog.traceError(SELF, "SecurityException was thrown", e);
        }
        if (this.createMethod == null || this.recoveryConstructor == null) {
            MessageLog.traceError(SELF, "Couldn't find create method /recovery Constructor for: " + this.myMoImpl.getName());
            return false;
        }
        return true;
    }
}

