/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.common;

import java.lang.reflect.Field;
import java.util.HashMap;
import se.ericsson.wcdma.rbs.boam.common.Strings;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.common.reflect.common.Fields;

public class FroObjectTypeDefs {
    private static final Class SELF = FroObjectTypeDefs.class;
    public static final int UN_DEF_FRO_ID = -1;
    public static final int DEVICE_GROUP = 49552;
    public static final int ACCU = 99;
    public static final int ANTENNA_BRANCH = 100;
    public static final int CARRIER = 27;
    public static final int DOWNLINK_BASE_BAND_POOL = 43;
    public static final int EXTERNAL_TMA = 47;
    public static final int RBS_LOCAL_CELL = 279;
    public static final int AC_DEVICE = 11;
    public static final int AC_DEVICE_SET = 49763;
    public static final int AI_DEVICE = 7;
    public static final int AI_DEVICE_SET = 49759;
    public static final int AIU_DEVICE_GROUP = 49570;
    public static final int ALM_DEVICE = 15;
    public static final int ALM_DEVICE_SET = 49767;
    public static final int ANT_FEEDER_CABLE = 50155;
    public static final int ASC_DEVICE_GROUP = 800004;
    public static final int AUX_PLUG_IN_UNIT = 49152;
    public static final int BBIF_BOARD = 50352;
    public static final int BCH = 21;
    public static final int BF_DEVICE = 10;
    public static final int BF_DEVICE_SET = 49762;
    public static final int BFU_DEVICE_GROUP = 49567;
    public static final int BFU = 49167;
    public static final int CL_DEVICE = 12;
    public static final int CL_DEVICE_SET = 49764;
    public static final int CLU_DEVICE_GROUP = 49568;
    public static final int CLU = 49168;
    public static final int CU_DEVICE_GROUP = 49554;
    public static final int DBCC_DEVICE = 3;
    public static final int DBCC_DEVICE_SET = 49755;
    public static final int DBCH_DEVICE = 2;
    public static final int DBCH_DEVICE_SET = 49754;
    public static final int DIGITAL_CABLE = 50165;
    public static final int RDI_CABLE = 50166;
    public static final int DPCL_DEVICE = 5;
    public static final int DPCL_DEVICE_SET = 49757;
    public static final int E_DBCH_DEVICE_SET = 20;
    public static final int E_SC_DEVICE_SET = 49777;
    public static final int FACH = 48;
    public static final int FAN_DEVICE_GROUP = 49555;
    public static final int FCU_DEVICE_GROUP = 49565;
    public static final int FU_DEVICE_GROUP = 49564;
    public static final int GAMMA_CABLE = 50160;
    public static final int HI_POW_TX_CABLE = 50154;
    public static final int HS_DBCH_DEVICE_SET = 19;
    public static final int INTER_SUB_TIMING_CABLE = 50158;
    public static final int INT_JUMPER_CABLE = 50157;
    public static final int INTRA_CAB_TIMING_CABLE = 50159;
    public static final int LO_POW_TX_CABLE = 50153;
    public static final int MCPA_DEVICE_GROUP = 49553;
    public static final int MCPA_SUBRACK = 49153;
    public static final int NBAP_COMMON = 62;
    public static final int NBAP_DEDICATED = 63;
    public static final int NODE_B_FUNCTION = 24577;
    public static final int NODE_SYNCH_TP = 65;
    public static final int OBIF_DEVICE_GROUP = 49576;
    public static final int OPTICAL_INTERFACE_LINK = 50164;
    public static final int OPTO_COMM_CABLE = 50162;
    public static final int OUT_DEVICE = 16;
    public static final int OUT_DEVICE_SET = 49768;
    public static final int PAU_DEVICE_GROUP = 49560;
    public static final int PCCPCH = 72;
    public static final int PCH = 73;
    public static final int PCU_DEVICE_GROUP = 49556;
    public static final int PD_DEVICE = 13;
    public static final int PD_DEVICE_SET = 49765;
    public static final int PICH = 78;
    public static final int POWER_DISTR_SYSTEM = 79;
    public static final int POWER_SUPPLY_SYSTEM = 81;
    public static final int PREDEF_RBS_SCANNER_GPEH = 83;
    public static final int PS_DEVICE = 9;
    public static final int PS_DEVICE_SET = 49761;
    public static final int PSU = 49166;
    public static final int PSU_DEVICE_GROUP = 49566;
    public static final int RAX_DEVICE_GROUP = 49571;
    public static final int RBS_SYNCHRONIZATION = 95;
    public static final int RET_DEVICE = 17;
    public static final int RET_DEVICE_SET = 49769;
    public static final int RETU_DEVICE_GROUP = 49559;
    public static final int RF_CABLE = 50163;
    public static final int RFIF_DEVICE_GROUP = 49574;
    public static final int RRU_DEVICE_GROUP = 49562;
    public static final int RU_DEVICE_GROUP = 49563;
    public static final int RUIF_DEVICE_GROUP = 49577;
    public static final int RUW_DEVICE_GROUP = 49579;
    public static final int SAIU_DEVICE_GROUP = 49561;
    public static final int SCCPCH = 106;
    public static final int SECTOR = 108;
    public static final int STRX_DEVICE_GROUP = 49575;
    public static final int TIM_DEVICE = 1;
    public static final int TIM_DEVICE_SET = 49773;
    public static final int TMA_DEVICE = 14;
    public static final int TMA_DEVICE_SET = 49766;
    public static final int TPA_DEVICE = 8;
    public static final int TPA_DEVICE_SET = 49760;
    public static final int TR_DEVICE = 4;
    public static final int TR_DEVICE_SET = 49756;
    public static final int TRX_DEVICE_GROUP = 49572;
    public static final int TRX_RF_CABLE = 50156;
    public static final int TU_DEVICE_GROUP = 49569;
    public static final int TX_DEVICE_GROUP = 49573;
    public static final int UBCH_DEVICE = 6;
    public static final int UBCH_DEVICE_SET = 49758;
    public static final int UPLINK_BASE_BAND_POOL = 124;
    public static final int XALM_DEVICE_GROUP = 49558;
    public static final int XP_PROGRAM = 126;
    public static final int IUB = 127;
    public static final int SECTOR_ANTENNA = 128;
    public static final int FAN_GROUP = -1;
    public static final int CABINET = 129;
    public static final int TMA_DEVICE_GROUP = 49557;
    public static final int DUI_DEVICE_GROUP = 49582;
    public static final int RBS_CONFIGURATION = 130;
    public static final int ULSA = 131;
    private static final HashMap MO_TYPE_NAMES = new HashMap();

    public static int getFroObjectType(String moTypeName) {
        Integer fieldValue = (Integer)Fields.getConstValue(FroObjectTypeDefs.class, Strings.toConstantCase(moTypeName));
        if (fieldValue == null) {
            MessageLog.traceError(SELF, "getFroObjectType(): unknown MO name: " + moTypeName);
            return 0;
        }
        return fieldValue;
    }

    public static String getMoTypeName(int froType) {
        Object moTypeName = MO_TYPE_NAMES.get(new Integer(froType));
        if (moTypeName == null) {
            MessageLog.traceError(FroObjectTypeDefs.class, "getMoTypeName(): unknown froType: " + froType);
            return "";
        }
        return (String)moTypeName;
    }

    private static void setupMoTypeNames() {
        Field[] allFields = Fields.getConstFields(FroObjectTypeDefs.class, Integer.TYPE, null);
        for (int i = 0; i < allFields.length; ++i) {
            try {
                MO_TYPE_NAMES.put(allFields[i].get(allFields[i]), Strings.toPascalCase(allFields[i].getName()));
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    static void addEntry(int froType, String moTypeName) {
        Integer key = new Integer(froType);
        Object existingTypeName = MO_TYPE_NAMES.get(key);
        if (existingTypeName != null) {
            MessageLog.traceError(SELF, "mapping already exists for froType " + froType + ", consider using redefineEntry()");
            throw new RuntimeException();
        }
        if (!MO_TYPE_NAMES.values().contains(moTypeName)) {
            MessageLog.traceError(SELF, "no constant declaration exists for " + moTypeName + ", consider adding one");
            throw new RuntimeException();
        }
        MO_TYPE_NAMES.put(key, moTypeName);
    }

    static void redefineEntry(int froType, String moTypeName) {
        Integer key = new Integer(froType);
        Object existingTypeName = MO_TYPE_NAMES.get(key);
        if (existingTypeName == null) {
            MessageLog.traceError(SELF, "no previous mapping for froType: " + froType + ", consider using addEntry()");
            throw new RuntimeException();
        }
        if (moTypeName.equals((String)existingTypeName)) {
            MessageLog.traceError(SELF, "mapping of froType " + froType + " to " + moTypeName + " already exists");
            throw new RuntimeException();
        }
        MessageLog.trace(5, SELF, "redefining mapping of froType: " + froType + "; old mapping: " + existingTypeName + ", new mapping: " + moTypeName);
        MO_TYPE_NAMES.put(key, moTypeName);
    }

    static {
        FroObjectTypeDefs.setupMoTypeNames();
        FroObjectTypeDefs.redefineEntry(49582, "DeviceGroup");
        FroObjectTypeDefs.redefineEntry(49579, "DeviceGroup");
        FroObjectTypeDefs.addEntry(49578, "DeviceGroup");
        FroObjectTypeDefs.addEntry(24581, "Carrier");
    }
}

