/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.common.generic;

public class MOAttributeMetadata {
    private String attributeName;
    private boolean isPMAttribute = false;
    private boolean isLicenseAttribute = false;
    private boolean isFeatureAttribute = false;

    public MOAttributeMetadata(String attrName) {
        this.attributeName = attrName;
        if (attrName != null) {
            if (attrName.startsWith("pm")) {
                this.isPMAttribute = true;
            } else if (attrName.startsWith("feature")) {
                this.isFeatureAttribute = true;
            } else if (attrName.startsWith("license")) {
                this.isLicenseAttribute = true;
            }
        }
    }

    public boolean isPMAttribute() {
        return this.isPMAttribute;
    }

    public boolean isLicenseAttribute() {
        return this.isLicenseAttribute;
    }

    public boolean isFeatureAttribute() {
        return this.isFeatureAttribute;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public static class LicFeatureMetadata
    extends MOAttributeMetadata {
        private String nameInSignal;
        private boolean zeroDelivery;
        private int identity;
        private int min;
        private int max;
        private Class attrClazz;

        public LicFeatureMetadata(String attrName, int identityInSignal, String nameInSignal, int min, int max, Class attrClazz, boolean zeroDeliveryFlag) {
            super(attrName);
            this.identity = identityInSignal;
            this.nameInSignal = nameInSignal;
            this.min = min;
            this.max = max;
            this.attrClazz = attrClazz;
            this.zeroDelivery = zeroDeliveryFlag;
        }

        public String getNameInSignal() {
            return this.nameInSignal;
        }

        public boolean isZeroDelivery() {
            return this.zeroDelivery;
        }

        public int getIdentity() {
            return this.identity;
        }

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }

        public Class getSignalClazz() {
            return this.attrClazz;
        }
    }

    public static class PMCounterMetadata
    extends MOAttributeMetadata {
        private int counterId;
        private String counterName;
        private int counterSize;
        private int measurementType;
        private String momTypeName;

        public PMCounterMetadata(String attrName, int counterId, String counterName, int counterSize, int measurementType, String momTypeName) {
            super(attrName);
            this.counterId = counterId;
            this.counterName = counterName;
            this.counterSize = counterSize;
            this.measurementType = measurementType;
            this.momTypeName = momTypeName;
        }

        public int getCounterId() {
            return this.counterId;
        }

        public String getCounterName() {
            return this.counterName;
        }

        public int getCounterSize() {
            return this.counterSize;
        }

        public int getMeasurementType() {
            return this.measurementType;
        }

        public String getMomTypeName() {
            return this.momTypeName;
        }
    }
}

