/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.common.pbootutil;

import enea.ose.system.OseProcess;
import enea.ose.system.Signal;
import se.ericsson.cello.support.sigutil.SignalHelper;
import se.ericsson.crbs.omf.common.proxy.OseSenderReceiverImpl;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.common.pbootutil.CsPbootGetParam;
import se.ericsson.wcdma.rbs.boam.common.pbootutil.CsPbootGetParamReply;

public class OseProcessHelper
extends OseSenderReceiverImpl {
    private static final String ETHERNET_ID_0 = "ethernetid0";
    private static final String CS_PBOOT_SERVER_PROCESS = "Cs_pbootServer_proc";
    private static final int CS_PBOOT_TIMEOUT = 500;

    public static String getPbootParameter(String pbootParameterName) {
        MessageLog.traceEnter(OseProcessHelper.class, "getPbootParameter");
        String pbootParameterValue = null;
        OseProcess pbootProc = OseProcess.hunt((String)CS_PBOOT_SERVER_PROCESS);
        if (pbootProc != null) {
            if (ETHERNET_ID_0.equals(pbootParameterName)) {
                SignalHelper.send((OseProcess)pbootProc, (Signal)new CsPbootGetParam(pbootParameterName, 15L));
            } else {
                SignalHelper.send((OseProcess)pbootProc, (Signal)new CsPbootGetParam(pbootParameterName));
            }
            CsPbootGetParamReply csPbootGetParamReply = (CsPbootGetParamReply)SignalHelper.receive((Class)CsPbootGetParamReply.class, (int)500);
            if (csPbootGetParamReply != null) {
                if (csPbootGetParamReply.getResultCode() == 0L) {
                    if (!csPbootGetParamReply.getName().equals(pbootParameterName)) {
                        MessageLog.traceError(OseProcessHelper.class, "Received parameter value for wrong parameter from PBOOT server: name = \"" + csPbootGetParamReply.getName() + "\"");
                    } else {
                        pbootParameterValue = csPbootGetParamReply.getValue();
                    }
                }
            } else {
                MessageLog.traceError(OseProcessHelper.class, "No response received from PBOOT server");
            }
        } else {
            MessageLog.traceError(OseProcessHelper.class, "PBOOT server not found");
        }
        MessageLog.traceError(OseProcessHelper.class, "getPbootParameter(\"" + pbootParameterName + "\")");
        return pbootParameterValue;
    }
}

