/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.common.xmlutil;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.common.log.StackDumper;

public class SimpleXMLParser {
    public static final String START_COMMENT = "<!--";
    public static final String END_COMMENT = "-->";
    private File inputFile = null;
    private Hashtable elements = new Hashtable();

    public SimpleXMLParser(File anInputFile) {
        MessageLog.traceEnter(this.getClass(), "SimpleXMLParser() BoamXmlParser A01<--, file name: " + anInputFile.getAbsolutePath());
        this.inputFile = anInputFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean run() {
        MessageLog.traceEnter(this.getClass(), "run()<--");
        boolean resultOK = true;
        StringReader reader = null;
        try {
            String xmlAsString = this.readFileAsString();
            xmlAsString = this.removeAllXmlComments(xmlAsString);
            reader = new StringReader(xmlAsString);
            StreamTokenizer st = new StreamTokenizer(reader);
            st.ordinaryChar(60);
            st.ordinaryChar(62);
            st.ordinaryChar(61);
            st.ordinaryChar(33);
            st.ordinaryChar(63);
            st.ordinaryChar(47);
            st.wordChars(48, 57);
            this.parseElements(st, this.elements);
            MessageLog.trace(2, this.getClass(), "Parsing done successfully. File name:" + this.inputFile.getAbsolutePath());
            this.closeFile(reader);
        }
        catch (Exception e) {
            try {
                MessageLog.traceError(this.getClass(), "Parsing Xml file failed!! Probably syntax error in the XML file!! Exception:", e);
                this.elements.clear();
                resultOK = false;
                this.closeFile(reader);
            }
            catch (Throwable throwable) {
                this.closeFile(reader);
                throw throwable;
            }
        }
        return resultOK;
    }

    private void closeFile(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readFileAsString() throws IOException {
        MessageLog.traceEnter(this.getClass(), "readFileAsString()<--, file name: " + this.inputFile.getAbsolutePath());
        BufferedReader reader = null;
        try {
            StringBuffer fileData = new StringBuffer(1000);
            reader = new BufferedReader(new FileReader(this.inputFile));
            char[] buf = new char[1024];
            int numRead = 0;
            while ((numRead = reader.read(buf)) != -1) {
                String readData = String.valueOf(buf, 0, numRead);
                fileData.append(readData);
                buf = new char[1024];
            }
            MessageLog.trace(2, this.getClass(), "readFileAsString() -->, Read the xml file as string done successfully. The file contents:\n" + fileData.toString());
            String string = fileData.toString();
            return string;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public Hashtable getElements() {
        return this.elements;
    }

    public Hashtable getChildElements(String parentElement) {
        Hashtable<String, Element> result2 = new Hashtable<String, Element>();
        Element element = (Element)this.elements.get(parentElement);
        if (element != null) {
            List elementContent = element.contents;
            Iterator iterator = elementContent.iterator();
            while (iterator.hasNext()) {
                Content content = (Content)iterator.next();
                result2.put(content.element.name, content.element);
            }
        }
        return result2;
    }

    public Element getElement(String name) {
        return this.getElement(this.getElements(), name);
    }

    private Element getElement(Hashtable elements, String nameToFind) {
        Object[] elementNames = elements.keySet().toArray();
        Element elementToReturn = null;
        for (int i = 0; i < elementNames.length; ++i) {
            String elementName = (String)elementNames[i];
            Element element = (Element)elements.get(elementNames[i]);
            if (nameToFind.equals(elementName)) {
                return element;
            }
            elementToReturn = this.getElement(this.getChildElements(elementName), nameToFind);
            if (elementToReturn == null) continue;
            return elementToReturn;
        }
        return elementToReturn;
    }

    public void printOn(PrintStream ps) {
        MessageLog.traceEnter(this.getClass(), "printOn()<--");
        Enumeration e = this.elements.elements();
        while (e.hasMoreElements()) {
            Element elm = (Element)e.nextElement();
            this.printElement(elm, ps, "");
        }
        MessageLog.trace(2, this.getClass(), "printOn()-->, Print the parsing result on the print stream: " + ps.toString());
    }

    private void parseElements(StreamTokenizer st, Hashtable elements) throws IOException {
        MessageLog.traceEnter(this.getClass(), "parseElements()<--, StreamTokenizer: " + st.toString());
        while (st.ttype != -1) {
            Element e;
            while (st.ttype != -1) {
                st.nextToken();
                MessageLog.trace(2, this.getClass(), "StreamTokenizer: " + st.toString());
                if (st.ttype != 60) continue;
            }
            if ((e = this.getXmlElement(st)) == null) continue;
            MessageLog.trace(2, this.getClass(), "XML Element is Found: " + e.toString());
            elements.put(e.name, e);
        }
        MessageLog.trace(2, this.getClass(), "parseElements() -->");
    }

    private Element getXmlElement(StreamTokenizer st) throws IOException {
        MessageLog.traceEnter(this.getClass(), "getXmlElement()<--, StreamTokenizer: " + st.toString());
        boolean isComplete = false;
        Element e = new Element();
        st.nextToken();
        MessageLog.trace(2, this.getClass(), "1- StreamTokenizer: " + st.toString());
        if (st.ttype != -3) {
            return null;
        }
        e.name = st.sval;
        this.getAttrList(st, e.attributes);
        st.nextToken();
        MessageLog.trace(2, this.getClass(), "2- StreamTokenizer: " + st.toString());
        if (st.ttype == 47) {
            e.isEmpty = true;
            st.nextToken();
            MessageLog.trace(2, this.getClass(), "3- StreamTokenizer: " + st.toString());
            if (st.ttype == 62) {
                isComplete = true;
            }
        } else if (st.ttype == 62) {
            boolean quit = false;
            boolean haveContents = false;
            e.cdata = this.getOptionalCdata(st);
            while (st.ttype != -1 && !quit) {
                Content c = new Content();
                st.nextToken();
                MessageLog.trace(2, this.getClass(), "4- StreamTokenizer: " + st.toString());
                if (st.ttype == 60) {
                    st.nextToken();
                    MessageLog.trace(2, this.getClass(), "5- StreamTokenizer: " + st.toString());
                    if (st.ttype == 47) {
                        quit = true;
                    } else if (st.ttype == 33) {
                        while (st.nextToken() != 62 && st.ttype != -1) {
                        }
                        isComplete = false;
                    } else {
                        st.pushBack();
                        Element ee = this.getXmlElement(st);
                        if (ee != null) {
                            c.element = ee;
                        }
                        c.cdataPost = this.getOptionalCdata(st);
                        e.contents.add(c);
                    }
                } else {
                    st.pushBack();
                    quit = true;
                }
                haveContents = haveContents || e.cdata != "";
                haveContents = haveContents || c.element != null;
                if (!(haveContents = haveContents || c.cdataPost != "")) continue;
                e.isEmpty = false;
            }
            st.nextToken();
            MessageLog.trace(2, this.getClass(), "6- StreamTokenizer: " + st.toString());
            if (st.ttype == -3 && st.sval.equals(e.name)) {
                st.nextToken();
                MessageLog.trace(2, this.getClass(), "7- StreamTokenizer: " + st.toString());
                if (st.ttype == 62) {
                    isComplete = true;
                }
            }
        }
        if (!isComplete) {
            MessageLog.trace(2, this.getClass(), "getXmlElement() --> null");
            return null;
        }
        MessageLog.trace(2, this.getClass(), "getXmlElement() -->, element name: " + e.name);
        return e;
    }

    private String getOptionalCdata(StreamTokenizer st) throws IOException {
        MessageLog.traceEnter(this.getClass(), "getOptionalCdata()<--, st: " + st.toString());
        String retVal = "";
        st.nextToken();
        MessageLog.trace(2, this.getClass(), "1- StreamTokenizer: " + st.toString());
        while (st.ttype != 60) {
            if (st.ttype == -3 || st.ttype == 34) {
                retVal = retVal + st.sval;
            } else {
                if (st.ttype == -1) break;
                retVal = retVal + (char)st.ttype;
            }
            st.nextToken();
            MessageLog.trace(2, this.getClass(), "2- StreamTokenizer: " + st.toString());
        }
        st.pushBack();
        MessageLog.trace(2, this.getClass(), "getOptionalCdata() -->,retVal: " + retVal);
        return retVal;
    }

    private void getAttrList(StreamTokenizer st, Hashtable attrList) throws IOException {
        MessageLog.traceEnter(this.getClass(), "getAttrList()<--, st: " + st.toString());
        while (st.ttype != -1 && this.getAttrVal(st, attrList)) {
        }
        MessageLog.trace(2, this.getClass(), "getAttrList() -->");
    }

    private boolean getAttrVal(StreamTokenizer st, Hashtable attrList) throws IOException {
        MessageLog.traceEnter(this.getClass(), "getAttrVal()<--, st: " + st.toString());
        boolean isAttr = false;
        st.nextToken();
        MessageLog.trace(2, this.getClass(), "1- StreamTokenizer: " + st.toString());
        if (st.ttype == -3) {
            String name = st.sval;
            st.nextToken();
            MessageLog.trace(2, this.getClass(), "2- StreamTokenizer: " + st.toString());
            if (st.ttype == 61) {
                st.nextToken();
                MessageLog.trace(2, this.getClass(), "3- StreamTokenizer: " + st.toString());
                if (st.ttype == 34 || st.ttype == -3) {
                    String val = st.sval;
                    attrList.put(name, val);
                    isAttr = true;
                }
            }
        }
        if (!isAttr) {
            st.pushBack();
        }
        MessageLog.trace(2, this.getClass(), "getAttrVal() -->, isAttr:" + isAttr);
        return isAttr;
    }

    private String removeAllXmlComments(String xmlAsStr) throws Exception {
        MessageLog.traceEnter(this.getClass(), "removeAllXmlComments()<--  xmlAsStr:\n" + xmlAsStr);
        boolean START = false;
        int startComment = -1;
        int endComment = -1;
        while (xmlAsStr.indexOf(START_COMMENT) > -1) {
            startComment = xmlAsStr.indexOf(START_COMMENT);
            endComment = xmlAsStr.indexOf(END_COMMENT);
            if (endComment < 0) {
                MessageLog.traceEnter(this.getClass(), "XML Syntax Error!! XML end comment '-->' not fount!!");
                throw new RuntimeException("XML Syntax Error!! XML end comment '-->' not fount!!");
            }
            xmlAsStr = xmlAsStr.substring(0, startComment) + xmlAsStr.substring(endComment + END_COMMENT.length(), xmlAsStr.length());
        }
        MessageLog.trace(1, this.getClass(), "All comments are removed from XML file:\n" + xmlAsStr);
        return xmlAsStr;
    }

    private void printElement(Element elm, PrintStream p, String is) {
        MessageLog.traceEnter(this.getClass(), "printElement()<--");
        if (elm != null) {
            p.println(is + "Name = " + elm.name);
            p.println(is + "   " + "Is empty = " + elm.isEmpty);
            if (elm.cdata.length() != 0) {
                p.println(is + "   " + "CDATA pre = " + elm.cdata);
            }
            if (elm.attributes.size() > 0) {
                p.println(is + "   " + "Has attributes:");
                Enumeration e = elm.attributes.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    String value = (String)elm.attributes.get(key);
                    p.println(is + "      " + key + " = " + value);
                }
            }
            if (elm.contents.size() > 0) {
                p.println(is + "   " + "Has contents:");
                for (int i = 0; i < elm.contents.size(); ++i) {
                    Content c = (Content)elm.contents.get(i);
                    if (c.element != null) {
                        this.printElement(c.element, p, is + "      ");
                    }
                    if (c.cdataPost.length() == 0) continue;
                    p.println(is + "      " + "CDATA post = " + c.cdataPost);
                }
            }
        } else {
            p.println(is + "Element = NULL");
            MessageLog.trace(2, this.getClass(), "printElement(), " + is);
        }
        MessageLog.trace(2, this.getClass(), "printElement() -->");
    }

    public static void main(String[] args) {
        try {
            SimpleXMLParser p = new SimpleXMLParser(new File(args[0]));
            p.run();
            p.printOn(System.out);
        }
        catch (Error err) {
            StackDumper.stackDump(err);
        }
        catch (Exception exc) {
            StackDumper.stackDump(exc);
        }
    }

    public static class Content {
        public String cdataPost = "";
        public Element element = null;

        public String toString() {
            String result2 = "null";
            if (this.element != null) {
                result2 = this.element.toString();
            }
            return result2;
        }
    }

    public static class Element {
        public String name = "";
        public Hashtable attributes = new Hashtable();
        public boolean isEmpty = true;
        public boolean isComment = false;
        public String cdata = "";
        public List contents = new ArrayList(2);

        public String toString() {
            StringBuffer b = new StringBuffer("");
            b.append("name= ").append(this.name).append(",  ");
            b.append("attributes: ").append(this.attributes.toString()).append(",  ");
            b.append("contents: ").append(this.contents.toString());
            return b.toString();
        }
    }
}

