/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies;

import enea.ose.system.InSignal;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.wcdma.rbs.boam.common.AvcIndication;
import se.ericsson.wcdma.rbs.boam.common.generic.LicenseNameKeyIdDataMap;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcAvcIndS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcLicenseAvcIndS;
import se.ericsson.wcdma.rbs.boam.fpx.proxies.AvcIndProxy;
import se.ericsson.wcdma.rbs.boam.mao.rmo.node.NodeBFunctionMoImpl;

public class ChcAvcIndProxy
extends AvcIndProxy {
    private static final String SERVICE_NAME = "EqcRrhOmServiceName";
    private static ChcAvcIndProxy uniqueInstance;

    private ChcAvcIndProxy() {
        super(SERVICE_NAME);
        this.boamSignalPort.addSignalObserver(this, ChcAvcIndS.class);
        this.boamSignalPort.addSignalObserver(this, ChcLicenseAvcIndS.class);
    }

    public static synchronized ChcAvcIndProxy instance() {
        if (uniqueInstance == null) {
            uniqueInstance = new ChcAvcIndProxy();
        }
        return uniqueInstance;
    }

    public void signalReceived(InSignal inSig) {
        MessageLog.traceEnter(this.getClass(), "signalReceived");
        try {
            if (inSig instanceof AvcIndication) {
                this.handleAVCind((AvcIndication)inSig);
            } else {
                super.signalReceived(inSig);
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable e) {
            MessageLog.traceError(this.getClass(), "SW error, exception caught in ChcAvcIndProxy.java->signalReceived(). Exception: ", e);
        }
    }

    protected void handleAVCind(AvcIndication avcSig) throws MoAccessException {
        if (avcSig instanceof ChcLicenseAvcIndS) {
            ChcLicenseAvcIndS chcLicenseAvcIndS = (ChcLicenseAvcIndS)avcSig;
            String keyId = chcLicenseAvcIndS.keyId;
            String[] licenseName = (String[])LicenseNameKeyIdDataMap.LICENSENAME_KEYID_MAP.get(keyId);
            if (null != licenseName) {
                for (int i = 0; i < licenseName.length; ++i) {
                    if (licenseName[i].startsWith("licenseState")) {
                        NodeBFunctionMoImpl.getTheOneAndOnly().sendAVC(licenseName[i], chcLicenseAvcIndS.licenseStateValue);
                        MessageLog.trace(9, this.getClass(), "Send AVC for attribute: " + licenseName[i] + ", value: " + chcLicenseAvcIndS.licenseStateValue + "  successfully.");
                        continue;
                    }
                    NodeBFunctionMoImpl.getTheOneAndOnly().sendAVC(licenseName[i], chcLicenseAvcIndS.licenseCapacityValue);
                    MessageLog.trace(9, this.getClass(), "Send AVC for attribute: " + licenseName[i] + ", value: " + chcLicenseAvcIndS.licenseCapacityValue + "  successfully.");
                }
            }
        } else {
            super.handleAVCind(avcSig);
        }
    }
}

