/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies;

import java.util.ArrayList;
import java.util.List;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.FroNotAccessibleException;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.RbsErrorException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcGenericProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcHsdpaProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcMeasurementProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcBbpParamsT;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcGetBbpParamReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcGetBbpParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcGetDlBbpCeAllocRejReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcGetDlBbpCeAllocRejRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcGetDlbbpAllRejAdchReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcGetDlbbpAllRejAdchRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcGetDlbbpCeAllAttReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcGetDlbbpCeAllAttRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcGetDlbbpCeCapNumReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcGetDlbbpCeCapNumRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcGetDlbbpCeUsageReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcGetDlbbpCeUsageRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcGetDlbbpUsedAdchReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcGetDlbbpUsedAdchRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcGetHschCpcActFReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcGetHschCpcActFRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcGetUlBbpCeAllocRejReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcGetUlBbpCeAllocRejRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcGetUlbbpCeAllAttReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcGetUlbbpCeAllAttRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcGetUlbbpCeCapNumReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcGetUlbbpCeCapNumRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcGetUlbbpCeUsageReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcGetUlbbpCeUsageRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcHsGetPmHwCeConsumRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcSetBbpParamReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.EqcBbpPrimFaultCeaseIndS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.EqcBbpPrimFaultIndS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.EqcCreateDlbbpReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.EqcCreateDlbbpRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.EqcCreateUlbbpReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.EqcCreateUlbbpRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.EqcDeleteDlbbpReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.EqcDeleteDlbbpRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.EqcDeleteUlbbpReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.EqcDeleteUlbbpRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.EqcDlbbpStartPmReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.EqcDlbbpStartPmRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.EqcDlbbpStopPmReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.EqcDlbbpStopPmRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.EqcGetDlbbpRlAddFailReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.EqcGetDlbbpRlAddFailRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.EqcGetDlbbpRlSetupAttReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.EqcGetDlbbpRlSetupAttRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.EqcGetDlbbpRlSetupFailReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.EqcGetDlbbpRlSetupFailRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.EqcGetDlbbpRlUsageReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.EqcGetDlbbpRlUsageRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.EqcGetUlbbpRlSetupAttReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.EqcGetUlbbpRlSetupAttRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.EqcGetUlbbpRlSetupFailReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.EqcGetUlbbpRlSetupFailRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.EqcGetUlbbpRlUsageReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.EqcGetUlbbpRlUsageRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.EqcSubscrBbpFaultReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.EqcSubscrBbpFaultRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.EqcUlbbpStartPmReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.EqcUlbbpStartPmRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.EqcUlbbpStopPmReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.EqcUlbbpStopPmRspS;
import se.ericsson.wcdma.rbs.boam.fpx.common.PmCounterTableManager;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.RbsServiceNameT;
import se.ericsson.wcdma.rbs.boam.fpx.proxies.ScannedValue;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.pms.iface.ProxyScanner;
import se.ericsson.wcdma.rbs.boam.pms.impl.PmsConst;

public class ChcBbpProxy
extends ChcGenericProxy
implements ProxyScanner {
    private static ChcBbpProxy theOneAndOnly = null;
    private static final String SERVICE_NAME = "EqcRrhOmServiceName";
    public static final String CURRENT_CLASS = ChcBbpProxy.class.getName();
    private int clientID = 0;

    private ChcBbpProxy() {
        super(SERVICE_NAME);
        this.boamSignalPort.addSignalObserver(this, EqcBbpPrimFaultIndS.class);
        this.boamSignalPort.addSignalObserver(this, EqcBbpPrimFaultCeaseIndS.class);
    }

    public static synchronized ChcBbpProxy instance() {
        if (theOneAndOnly == null) {
            theOneAndOnly = new ChcBbpProxy();
        }
        return theOneAndOnly;
    }

    private EqcSubscrBbpFaultRspS subscrAlarms() throws FroRequestFailedException, FroNotAccessibleException {
        RbsServiceNameT rbsServiceName = new RbsServiceNameT();
        rbsServiceName.serviceName = this.signalPort.getServiceName();
        EqcSubscrBbpFaultReqS reqSig = new EqcSubscrBbpFaultReqS(this.clientID, rbsServiceName, 0);
        return (EqcSubscrBbpFaultRspS)this.sendAndRec(reqSig);
    }

    public void pmsStart(String name, int granularityPeriod, int froId, int bbPoolId, int[] additionalInfo) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "pmsStart():" + name);
        if (this.useChcMeasurementProxy(name)) {
            ChcMeasurementProxy.instance().pmsStart(name, granularityPeriod, -1, bbPoolId, additionalInfo);
        } else if (additionalInfo != null) {
            if (additionalInfo[0] == 1) {
                this.startDlbbpPm(this.clientID, froId, this.getMeasType(name), granularityPeriod);
            } else if (name.equalsIgnoreCase("pmHwCePoolEul") || name.equalsIgnoreCase("capacityNumUlCe") || name.equalsIgnoreCase("capacityUlCe")) {
                ChcHsdpaProxy.instance().startHschPm(0, froId, this.getMeasType(name), granularityPeriod, additionalInfo[1]);
            } else if (name.equalsIgnoreCase("pmCpcUlActivityFactor")) {
                ChcHsdpaProxy.instance().startPmCpcUlActivityFactor(0, this.getMeasType(name), froId, granularityPeriod, additionalInfo[1]);
            } else if (!name.equalsIgnoreCase("pmNoOfIbho")) {
                this.startUlbbpPm(this.clientID, froId, this.getMeasType(name), granularityPeriod);
            }
        }
    }

    public void pmsStop(String name, int froId, int bbPoolId, int[] additionalInfo) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "pmsStop():" + name);
        if (this.useChcMeasurementProxy(name)) {
            ChcMeasurementProxy.instance().pmsStop(name, -1, bbPoolId, additionalInfo);
        } else if (additionalInfo != null) {
            if (additionalInfo[0] == 1) {
                this.stopDlbbpPm(this.clientID, froId, this.getMeasType(name));
            } else if (name.equalsIgnoreCase("pmHwCePoolEul") || name.equalsIgnoreCase("capacityNumUlCe") || name.equalsIgnoreCase("capacityUlCe")) {
                ChcHsdpaProxy.instance().stopHschPm(0, froId, this.getMeasType(name), additionalInfo[1]);
            } else if (name.equalsIgnoreCase("pmCpcUlActivityFactor") || name.equalsIgnoreCase("Sequence")) {
                ChcHsdpaProxy.instance().stopPmCpcUlActivityFactor(0, this.getMeasType(name), froId, additionalInfo[1]);
            } else if (!name.equalsIgnoreCase("pmNoOfIbho")) {
                this.stopUlbbpPm(this.clientID, froId, this.getMeasType(name));
            }
        }
    }

    public ScannedValue[] getPmsAttribute(String name, int froId, int bbPoolId, int[] additionalInfo) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getPmsAttribute():" + name);
        if (this.useChcMeasurementProxy(name)) {
            return ChcMeasurementProxy.instance().getPmsAttribute(name, -1, bbPoolId, additionalInfo);
        }
        if (this.getBaseBandPoolState(null, froId) == 0) {
            int[] counterDefaultArray = PmsConst.getCounterDefaultArray(name);
            int arrayLength = counterDefaultArray.length;
            ArrayList<Integer> result2 = new ArrayList<Integer>();
            for (int i = 0; i < arrayLength; ++i) {
                result2.set(i, new Integer(counterDefaultArray[i]));
            }
            return result2.toArray(new ScannedValue[result2.size()]);
        }
        if (additionalInfo != null && additionalInfo[0] == 1) {
            return this.getPmsAttributeDlink(name, froId, additionalInfo);
        }
        return this.getPmsAttributeUplink(name, froId, additionalInfo);
    }

    public int getBaseBandPoolState(Coordinator c, int bbpFroId) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getBaseBandPoolState()");
        return this.getBbpParam((long)((long)ValidateAttributes.getTxIdNonTransactional((Coordinator)c)), (int)bbpFroId).bbpStatus;
    }

    private ScannedValue[] getPmsAttributeDlink(String name, int froId, int[] additionalInfo) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getPmsAttributeDlink():" + name);
        List<ScannedValue> result2 = new ArrayList();
        if (name.equals("pmNoOfRadioLinksSf")) {
            EqcGetDlbbpRlUsageRspS rspSig = this.getDlbbpRlUsage(this.clientID, froId);
            result2 = this.replayGroupValues(name, rspSig.index, rspSig.rlUsage, 15);
        } else if (name.equals("pmSetupAttemptsSf")) {
            EqcGetDlbbpRlSetupAttRspS rspSig = this.getDlbbpRlSetupAtt(this.clientID, froId);
            result2 = this.replayGroupValues(name, rspSig.index, rspSig.rlSetupAtt, 1);
        } else if (name.equals("pmSetupFailuresSf")) {
            EqcGetDlbbpRlSetupFailRspS rspSig = this.getDlbbpRlSetupFail(this.clientID, froId);
            result2 = this.replayGroupValues(name, rspSig.index, rspSig.rlSetupFail, 1);
        } else if (name.equals("pmNoOfRlAdditionFailuresSf")) {
            EqcGetDlbbpRlAddFailRspS rspSig = this.getDlbbpRlAddFail(this.clientID, froId);
            result2 = this.replayGroupValues(name, rspSig.index, rspSig.rlAddFail, 1);
        } else if (name.equals("pmCapacityDlCe")) {
            ChcGetDlbbpCeUsageRspS rspSig = (ChcGetDlbbpCeUsageRspS)this.sendAndRec(new ChcGetDlbbpCeUsageReqS(this.clientID, froId));
            ScannedValue aValue = new ScannedValue(name, rspSig.ceUsage);
            result2.add(aValue);
        } else if (name.equals("pmCapacityAllocAttDlCe")) {
            ChcGetDlbbpCeAllAttRspS rspSig = (ChcGetDlbbpCeAllAttRspS)this.sendAndRec(new ChcGetDlbbpCeAllAttReqS(this.clientID, froId));
            int[] allocAttempts = new int[]{rspSig.allocAttempts};
            ScannedValue aValue = new ScannedValue(name, allocAttempts);
            result2.add(aValue);
        } else if (name.equals("pmCapacityAllocRejDlCe")) {
            ChcGetDlBbpCeAllocRejRspS rspSig = (ChcGetDlBbpCeAllocRejRspS)this.sendAndRec(new ChcGetDlBbpCeAllocRejReqS(this.clientID, froId));
            int[] allocAttempts = new int[]{rspSig.rejectedAllocAttempts};
            ScannedValue aValue = new ScannedValue(name, allocAttempts);
            result2.add(aValue);
        } else if (name.equals("capacityNumDlCe")) {
            ChcGetDlbbpCeCapNumRspS rspSig = (ChcGetDlbbpCeCapNumRspS)this.sendAndRec(new ChcGetDlbbpCeCapNumReqS(this.clientID, froId));
            int[] noOfSamples = new int[]{rspSig.noOfSamples};
            ScannedValue aValue = new ScannedValue("pmSamplesCapacityDlCe", noOfSamples);
            result2.add(aValue);
            int[] sumOfCeUsageSamples = new int[]{rspSig.sumOfCeUsageSamples};
            aValue = new ScannedValue("pmSumCapacityDlCe", sumOfCeUsageSamples);
            result2.add(aValue);
            int[] sumOfSqrCeUsageSamples = new int[]{rspSig.sumOfSqrCeUsageSamples};
            aValue = new ScannedValue("pmSumSqrCapacityDlCe", sumOfSqrCeUsageSamples);
            result2.add(aValue);
        } else if (name.equals("pmAllocRejADch")) {
            ChcGetDlbbpAllRejAdchRspS rspSig = (ChcGetDlbbpAllRejAdchRspS)this.sendAndRec(new ChcGetDlbbpAllRejAdchReqS(this.clientID, froId));
            ScannedValue aValue = new ScannedValue(name, new int[]{rspSig.pmAllocRejADch});
            result2.add(aValue);
        } else if (name.equals("pmUsedADch")) {
            ChcGetDlbbpUsedAdchRspS rspSig = (ChcGetDlbbpUsedAdchRspS)this.sendAndRec(new ChcGetDlbbpUsedAdchReqS(this.clientID, froId));
            ScannedValue aValue = new ScannedValue(name, rspSig.pmUsedADch);
            result2.add(aValue);
        } else {
            MessageLog.traceError(this.getClass(), "No such a PM counter: " + name);
            throw new RbsErrorException("getMeasType():No such a PM counter: " + name);
        }
        return result2.toArray(new ScannedValue[result2.size()]);
    }

    private ScannedValue[] getPmsAttributeUplink(String name, int froId, int[] additionalInfo) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getPmsAttributeUplink():" + name);
        List<ScannedValue> result2 = new ArrayList();
        if (name.equals("pmNoOfRadioLinksSf")) {
            EqcGetUlbbpRlUsageRspS rspSig = this.getUlbbpRlUsage(this.clientID, froId);
            result2 = this.replayGroupValues(name, rspSig.index, rspSig.rlUsage, 15);
        } else if (name.equals("pmHwCePoolEul")) {
            ChcHsGetPmHwCeConsumRspS rspSig = ChcHsdpaProxy.instance().getPmHwCePoolEul(this.clientID, additionalInfo[1]);
            ScannedValue aValue = new ScannedValue(name, rspSig.pmHwCePoolEul);
            result2.add(aValue);
        } else if (name.equals("pmCpcUlActivityFactor")) {
            ChcGetHschCpcActFRspS rspSig = (ChcGetHschCpcActFRspS)this.sendAndRec(new ChcGetHschCpcActFReqS(this.clientID, additionalInfo[1]));
            ScannedValue aValue = new ScannedValue(name, rspSig.pmCpcUlActivityFactor);
            result2.add(aValue);
        } else if (name.equals("pmSetupAttemptsSf")) {
            EqcGetUlbbpRlSetupAttRspS rspSig = this.getUlbbpRlSetupAtt(this.clientID, froId);
            result2 = this.replayGroupValues(name, rspSig.index, rspSig.rlSetupAtt, 1);
        } else if (name.equals("pmSetupFailuresSf")) {
            EqcGetUlbbpRlSetupFailRspS rspSig = this.getUlbbpRlSetupFail(this.clientID, froId);
            result2 = this.replayGroupValues(name, rspSig.index, rspSig.rlSetupFail, 1);
        } else if (name.equals("pmNoOfIbho")) {
            int[] noIbhoArr = new int[]{0};
            ScannedValue aValue = new ScannedValue(name, noIbhoArr);
            result2.add(aValue);
        } else if (name.equals("capacityUlCe")) {
            ChcGetUlbbpCeUsageRspS rspSig = (ChcGetUlbbpCeUsageRspS)this.sendAndRec(new ChcGetUlbbpCeUsageReqS(this.clientID, additionalInfo[1]));
            ScannedValue aValue = new ScannedValue("pmCapacityUlCe", rspSig.ceUsage);
            result2.add(aValue);
            aValue = new ScannedValue("pmCapacityUlCeExt", rspSig.ceExtUsage);
            result2.add(aValue);
        } else if (name.equals("pmCapacityAllocAttUlCe")) {
            ChcGetUlbbpCeAllAttRspS rspSig = (ChcGetUlbbpCeAllAttRspS)this.sendAndRec(new ChcGetUlbbpCeAllAttReqS(this.clientID, froId));
            int[] allocAttempts = new int[]{rspSig.allocAttempts};
            ScannedValue aValue = new ScannedValue(name, allocAttempts);
            result2.add(aValue);
        } else if (name.equals("pmCapacityAllocRejUlCe")) {
            ChcGetUlBbpCeAllocRejRspS rspSig = (ChcGetUlBbpCeAllocRejRspS)this.sendAndRec(new ChcGetUlBbpCeAllocRejReqS(this.clientID, froId));
            int[] allocAttempts = new int[]{rspSig.rejectedAllocAttempts};
            ScannedValue aValue = new ScannedValue(name, allocAttempts);
            result2.add(aValue);
        } else if (name.equals("capacityNumUlCe")) {
            ChcGetUlbbpCeCapNumRspS rspSig = (ChcGetUlbbpCeCapNumRspS)this.sendAndRec(new ChcGetUlbbpCeCapNumReqS(this.clientID, additionalInfo[1]));
            int[] noOfSamples = new int[]{rspSig.noOfSamples};
            ScannedValue aValue = new ScannedValue("pmSamplesCapacityUlCe", noOfSamples);
            result2.add(aValue);
            int[] sumOfCeUsageSamples = new int[]{rspSig.sumOfCeUsageSamples};
            aValue = new ScannedValue("pmSumCapacityUlCe", sumOfCeUsageSamples);
            result2.add(aValue);
            int[] sumOfSqrCeUsageSamples = new int[]{rspSig.sumOfSqrCeUsageSamples};
            aValue = new ScannedValue("pmSumSqrCapacityUlCe", sumOfSqrCeUsageSamples);
            result2.add(aValue);
        } else {
            MessageLog.traceError(this.getClass(), "No such a PM counter: " + name);
            throw new RbsErrorException("getMeasType():No such a PM counter: " + name);
        }
        return result2.toArray(new ScannedValue[result2.size()]);
    }

    private List replayGroupValues(String name, int index, int[] values, int noOfElement) throws MoAccessException {
        ArrayList<ScannedValue> result2 = new ArrayList<ScannedValue>();
        int nameIndex = 4;
        for (int i = 0; i < 7; ++i) {
            int sfInd = i;
            int baseRoInd = sfInd * noOfElement;
            int[] pmNoOfRadioLinks = new int[noOfElement];
            for (int ind = 0; ind < noOfElement; ++ind) {
                pmNoOfRadioLinks[ind] = values[baseRoInd + ind];
            }
            ScannedValue aValue = new ScannedValue(name + nameIndex, pmNoOfRadioLinks);
            result2.add(aValue);
            nameIndex *= 2;
        }
        return result2;
    }

    private EqcUlbbpStartPmRspS startUlbbpPm(long clientId, long id, int measType, int granularityPeriod) throws FroRequestFailedException, FroNotAccessibleException {
        EqcUlbbpStartPmReqS reqSig = new EqcUlbbpStartPmReqS(clientId, id, measType, granularityPeriod);
        return (EqcUlbbpStartPmRspS)this.sendAndRec(reqSig);
    }

    private EqcUlbbpStopPmRspS stopUlbbpPm(long clientId, long id, int measType) throws FroRequestFailedException, FroNotAccessibleException {
        EqcUlbbpStopPmReqS reqSig = new EqcUlbbpStopPmReqS(clientId, id, measType);
        return (EqcUlbbpStopPmRspS)this.sendAndRec(reqSig);
    }

    private EqcDlbbpStartPmRspS startDlbbpPm(long clientId, long id, int measType, int granularityPeriod) throws FroRequestFailedException, FroNotAccessibleException {
        EqcDlbbpStartPmReqS reqSig = new EqcDlbbpStartPmReqS(clientId, id, measType, granularityPeriod);
        return (EqcDlbbpStartPmRspS)this.sendAndRec(reqSig);
    }

    private EqcDlbbpStopPmRspS stopDlbbpPm(long clientId, long id, int measType) throws FroRequestFailedException, FroNotAccessibleException {
        EqcDlbbpStopPmReqS reqSig = new EqcDlbbpStopPmReqS(clientId, id, measType);
        return (EqcDlbbpStopPmRspS)this.sendAndRec(reqSig);
    }

    public EqcCreateUlbbpRspS createUlbbp(long transactionId, long clientId, int bbPoolId) throws FroRequestFailedException, FroNotAccessibleException {
        EqcCreateUlbbpReqS reqSig = new EqcCreateUlbbpReqS(transactionId, clientId, bbPoolId);
        return (EqcCreateUlbbpRspS)this.sendAndRec(reqSig);
    }

    public EqcDeleteUlbbpRspS deleteUlbbp(long transactionId, long clientId, long froId) throws FroRequestFailedException, FroNotAccessibleException {
        EqcDeleteUlbbpReqS reqSig = new EqcDeleteUlbbpReqS(transactionId, clientId, froId);
        return (EqcDeleteUlbbpRspS)this.sendAndRec(reqSig);
    }

    public EqcGetUlbbpRlUsageRspS getUlbbpRlUsage(long clientId, long id) throws FroRequestFailedException, FroNotAccessibleException {
        EqcGetUlbbpRlUsageReqS reqSig = new EqcGetUlbbpRlUsageReqS(clientId, id);
        return (EqcGetUlbbpRlUsageRspS)this.sendAndRec(reqSig);
    }

    public EqcGetUlbbpRlSetupAttRspS getUlbbpRlSetupAtt(long clientId, long id) throws FroRequestFailedException, FroNotAccessibleException {
        this.verifyProxyAvaliable();
        EqcGetUlbbpRlSetupAttReqS reqSig = new EqcGetUlbbpRlSetupAttReqS(clientId, id);
        return (EqcGetUlbbpRlSetupAttRspS)this.sendAndRec(reqSig);
    }

    public EqcGetUlbbpRlSetupFailRspS getUlbbpRlSetupFail(long clientId, long id) throws FroRequestFailedException, FroNotAccessibleException {
        EqcGetUlbbpRlSetupFailReqS reqSig = new EqcGetUlbbpRlSetupFailReqS(clientId, id);
        return (EqcGetUlbbpRlSetupFailRspS)this.sendAndRec(reqSig);
    }

    public EqcCreateDlbbpRspS createDlbbp(long transactionId, long clientId, int bbPoolId) throws FroRequestFailedException, FroNotAccessibleException {
        EqcCreateDlbbpReqS reqSig = new EqcCreateDlbbpReqS(transactionId, clientId, bbPoolId);
        return (EqcCreateDlbbpRspS)this.sendAndRec(reqSig);
    }

    public EqcDeleteDlbbpRspS deleteDlbbp(long transactionId, long clientId, long froId) throws FroRequestFailedException, FroNotAccessibleException {
        EqcDeleteDlbbpReqS reqSig = new EqcDeleteDlbbpReqS(transactionId, clientId, froId);
        return (EqcDeleteDlbbpRspS)this.sendAndRec(reqSig);
    }

    private EqcGetDlbbpRlUsageRspS getDlbbpRlUsage(long clientId, long id) throws FroRequestFailedException, FroNotAccessibleException {
        EqcGetDlbbpRlUsageReqS reqSig = new EqcGetDlbbpRlUsageReqS(clientId, id);
        return (EqcGetDlbbpRlUsageRspS)this.sendAndRec(reqSig);
    }

    private EqcGetDlbbpRlSetupAttRspS getDlbbpRlSetupAtt(long clientId, long id) throws FroRequestFailedException, FroNotAccessibleException {
        EqcGetDlbbpRlSetupAttReqS reqSig = new EqcGetDlbbpRlSetupAttReqS(clientId, id);
        return (EqcGetDlbbpRlSetupAttRspS)this.sendAndRec(reqSig);
    }

    private EqcGetDlbbpRlSetupFailRspS getDlbbpRlSetupFail(long clientId, long id) throws FroRequestFailedException, FroNotAccessibleException {
        EqcGetDlbbpRlSetupFailReqS reqSig = new EqcGetDlbbpRlSetupFailReqS(clientId, id);
        return (EqcGetDlbbpRlSetupFailRspS)this.sendAndRec(reqSig);
    }

    private EqcGetDlbbpRlAddFailRspS getDlbbpRlAddFail(long clientId, long id) throws FroRequestFailedException, FroNotAccessibleException {
        EqcGetDlbbpRlAddFailReqS reqSig = new EqcGetDlbbpRlAddFailReqS(clientId, id);
        return (EqcGetDlbbpRlAddFailRspS)this.sendAndRec(reqSig);
    }

    public ChcBbpParamsT getBbpParam(long transactionId, int bbpFroId) throws FroRequestFailedException, FroNotAccessibleException {
        ChcGetBbpParamReqS reqSig = new ChcGetBbpParamReqS(transactionId, this.clientID, bbpFroId);
        ChcGetBbpParamRspS rspSig = (ChcGetBbpParamRspS)this.sendAndRec(reqSig);
        return rspSig.params;
    }

    public void setBbpParam(long transactionId, int bbpFroId, int paramId, int value) throws FroRequestFailedException, FroNotAccessibleException {
        ChcSetBbpParamReqS reqSig = new ChcSetBbpParamReqS(transactionId, this.clientID, bbpFroId, paramId, value);
        this.sendAndRec(reqSig);
    }

    private int getMeasType(String cntName) throws MoAccessException {
        int measType = 0;
        if (cntName.equals("pmNoOfRadioLinksSf")) {
            measType = 1;
        } else if (cntName.equals("pmSetupAttemptsSf")) {
            measType = 2;
        } else if (cntName.equals("pmCpcUlActivityFactor")) {
            measType = 162;
        } else if (cntName.equals("pmSetupFailuresSf")) {
            measType = 3;
        } else if (cntName.equals("pmHwCePoolEul")) {
            measType = 159;
        } else if (cntName.equals("pmNoOfRlAdditionFailuresSf")) {
            measType = 4;
        } else if (cntName.equals("pmCapacityDlCe")) {
            measType = 9;
        } else if (cntName.equals("pmCapacityAllocAttDlCe")) {
            measType = 10;
        } else if (cntName.equals("pmCapacityAllocRejDlCe")) {
            measType = 11;
        } else if (cntName.equals("capacityNumDlCe")) {
            measType = 12;
        } else if (cntName.equals("pmCapacityAllocAttUlCe")) {
            measType = 14;
        } else if (cntName.equals("pmCapacityAllocRejUlCe")) {
            measType = 15;
        } else if (cntName.equals("capacityNumUlCe")) {
            measType = 910;
        } else if (cntName.equals("capacityUlCe")) {
            measType = 911;
        } else if (cntName.equals("pmAllocRejADch")) {
            measType = 30;
        } else if (cntName.equals("pmUsedADch")) {
            measType = 29;
        } else {
            MessageLog.traceError(this.getClass(), "No such a PM counters " + cntName);
            throw new RbsErrorException("getMeasType():No such a PM counter " + cntName);
        }
        return measType;
    }

    private boolean useChcMeasurementProxy(String counterName) {
        return PmCounterTableManager.isInPmCounterTable(counterName);
    }

    public void subscribeToFroNotification() {
        MessageLog.traceEnter(this.getClass(), "subscribeToFroNotification");
        try {
            this.subscrAlarms();
        }
        catch (FroRequestFailedException e) {
            MessageLog.traceError(this.getClass(), "Received result NOK from resource when subscribing to the notifications" + (Object)((Object)e));
        }
        catch (FroNotAccessibleException e) {
            MessageLog.traceError(this.getClass(), "Received result NOK from resource when subscribing to the notifications" + (Object)((Object)e));
        }
    }
}

