/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies;

import java.util.ArrayList;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.wcdma.rbs.boam.common.FroNotAccessibleException;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.RbsErrorException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcGenericProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcMeasurementProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcAichCreatedIndS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcAichDeletedIndS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcGetAichParamReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcGetAichParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsGetPrachParamReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsGetPrachParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsPrachCreatedIndS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsPrachDeletedIndS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsPrachGetPmRecblocksReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsPrachGetPmRecblocksRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsPrachStartPmReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsPrachStartPmRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsPrachStopPmReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsPrachStopPmRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsStartBlerRachReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsStartBlerRachRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsStopBlerRachReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsStopBlerRachRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsSubscCmPrachReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsSubscCmPrachRspS;
import se.ericsson.wcdma.rbs.boam.fpx.common.PmCounterTableManager;
import se.ericsson.wcdma.rbs.boam.fpx.proxies.ScannedValue;
import se.ericsson.wcdma.rbs.boam.pms.iface.ProxyScanner;

public class ChcPrachProxy
extends ChcGenericProxy
implements ProxyScanner {
    private static ChcPrachProxy theOneAndOnly = null;
    private static final String SERVICE_NAME = "lrsCchPrachResMgr";
    public static final String PMS_GRP_PRACH_PM_MEAS_RECEIVED_BLOCKS = "PrachPmMeasReceivedBlocks";
    public static final String PMS_GRP_PRACH_PM_MEAS_RACH_PREAMBLE = "PrachPmMeasRachPower";
    public static final String PMS_GRP_PRACH_PM_MEAS_PROPAGATION_DELAY = "PrachPmMeasPropagationDelay";

    private ChcPrachProxy() {
        super(SERVICE_NAME);
        MessageLog.traceEnter(this.getClass(), "Constructor");
        this.boamSignalPort.addSignalObserver(this, LrsPrachCreatedIndS.class);
        this.boamSignalPort.addSignalObserver(this, LrsPrachDeletedIndS.class);
        this.boamSignalPort.addSignalObserver(this, ChcAichCreatedIndS.class);
        this.boamSignalPort.addSignalObserver(this, ChcAichDeletedIndS.class);
    }

    public static synchronized ChcPrachProxy instance() {
        if (theOneAndOnly == null) {
            theOneAndOnly = new ChcPrachProxy();
        }
        return theOneAndOnly;
    }

    public LrsSubscCmPrachRspS subscCmPrach(int clientId, int subscribeOperation) throws FroRequestFailedException, FroNotAccessibleException {
        LrsSubscCmPrachReqS reqSig = new LrsSubscCmPrachReqS(clientId, subscribeOperation, this.signalPort.getServiceName());
        return (LrsSubscCmPrachRspS)this.sendAndRec(reqSig);
    }

    public LrsStartBlerRachRspS startBlerRach(int clientId, int prachFroId, int measTime, String fileName) throws FroRequestFailedException, FroNotAccessibleException {
        LrsStartBlerRachReqS reqSig = new LrsStartBlerRachReqS(clientId, prachFroId, measTime, fileName);
        return (LrsStartBlerRachRspS)this.sendAndRec(reqSig);
    }

    public LrsStopBlerRachRspS stopBlerRach(int clientId, int prachFroId) throws FroRequestFailedException, FroNotAccessibleException {
        LrsStopBlerRachReqS reqSig = new LrsStopBlerRachReqS(clientId, prachFroId);
        return (LrsStopBlerRachRspS)this.sendAndRec(reqSig);
    }

    public LrsGetPrachParamRspS getPrachParam(int clientId, int prachFroId) throws FroRequestFailedException, FroNotAccessibleException {
        LrsGetPrachParamReqS reqSig = new LrsGetPrachParamReqS(clientId, prachFroId);
        return (LrsGetPrachParamRspS)this.sendAndRec(reqSig);
    }

    public ChcGetAichParamRspS getAichParam(int clientId, int aichFroId) throws FroRequestFailedException, FroNotAccessibleException {
        ChcGetAichParamReqS reqSig = new ChcGetAichParamReqS(clientId, aichFroId);
        return (ChcGetAichParamRspS)this.sendAndRec(reqSig);
    }

    public void pmsStart(String name, int granularityPeriod, int chFroId, int bbPoolId, int[] additionalInfo) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " pmsStart()");
        if (this.useChcMeasurementProxy(name)) {
            ChcMeasurementProxy.instance().pmsStart(name, granularityPeriod, chFroId, bbPoolId, additionalInfo);
        } else if (name.equals(PMS_GRP_PRACH_PM_MEAS_RECEIVED_BLOCKS)) {
            this.prachStartPm(0, 0, chFroId, granularityPeriod);
        } else {
            String diagnosis = " Unknown PMS counter [group] name `" + name + "'" + " passed to pmsStart().";
            MessageLog.traceError(this.getClass(), diagnosis);
            throw new RbsErrorException(diagnosis);
        }
    }

    public void pmsStop(String name, int chFroId, int bbPoolId, int[] additionalInfo) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " pmsStop()");
        if (this.useChcMeasurementProxy(name)) {
            ChcMeasurementProxy.instance().pmsStop(name, chFroId, bbPoolId, additionalInfo);
        } else if (name.equals(PMS_GRP_PRACH_PM_MEAS_RECEIVED_BLOCKS)) {
            this.prachStopPm(0, 0, chFroId);
        } else {
            String diagnosis = " Unknown PMS counter [group] name `" + name + "'" + " passed to pmsStop().";
            MessageLog.traceError(this.getClass(), diagnosis);
            throw new RbsErrorException(diagnosis);
        }
    }

    public ScannedValue[] getPmsAttribute(String name, int chFroId, int bbPoolId, int[] additionalInfo) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " getPmsAttribute()");
        if (this.useChcMeasurementProxy(name)) {
            return ChcMeasurementProxy.instance().getPmsAttribute(name, chFroId, bbPoolId, additionalInfo);
        }
        ArrayList<ScannedValue> valueList = new ArrayList<ScannedValue>();
        if (!name.equals(PMS_GRP_PRACH_PM_MEAS_RECEIVED_BLOCKS)) {
            String diagnosis = " Unknown PMS counter [group] name `" + name + "'" + " passed to getPmsAttribute().";
            MessageLog.traceError(this.getClass(), diagnosis);
            throw new RbsErrorException(diagnosis);
        }
        LrsPrachGetPmRecblocksRspS rspSig = this.prachGetPmRecblocks(0, chFroId);
        ScannedValue aValue = new ScannedValue("pmSuccReceivedBlocks", new int[]{rspSig.successfulRecBlocks});
        valueList.add(aValue);
        aValue = new ScannedValue("pmUnsuccReceivedBlocks", new int[]{rspSig.unsuccessfulRecBlocks});
        valueList.add(aValue);
        return valueList.toArray(new ScannedValue[valueList.size()]);
    }

    private LrsPrachStartPmRspS prachStartPm(int clientId, int measType, int prachFroId, int granularityPeriod) throws FroRequestFailedException, FroNotAccessibleException {
        LrsPrachStartPmReqS reqSig = new LrsPrachStartPmReqS(clientId, measType, prachFroId, granularityPeriod);
        return (LrsPrachStartPmRspS)this.sendAndRec(reqSig);
    }

    private LrsPrachStopPmRspS prachStopPm(int clientId, int measType, int prachFroId) throws FroRequestFailedException, FroNotAccessibleException {
        LrsPrachStopPmReqS reqSig = new LrsPrachStopPmReqS(clientId, measType, prachFroId);
        return (LrsPrachStopPmRspS)this.sendAndRec(reqSig);
    }

    private LrsPrachGetPmRecblocksRspS prachGetPmRecblocks(int clientId, int prachFroId) throws FroRequestFailedException, FroNotAccessibleException {
        LrsPrachGetPmRecblocksReqS reqSig = new LrsPrachGetPmRecblocksReqS(clientId, prachFroId);
        return (LrsPrachGetPmRecblocksRspS)this.sendAndRec(reqSig);
    }

    public void subscribeToFroNotification() {
        int CLIENT_ID = 0;
        try {
            this.subscCmPrach(CLIENT_ID, 0);
        }
        catch (FroRequestFailedException e) {
            MessageLog.traceError(this.getClass(), "Received result NOK from resource when subscribing to the notifications" + (Object)((Object)e));
        }
        catch (FroNotAccessibleException e) {
            MessageLog.traceError(this.getClass(), "Received result NOK from resource when subscribing to the notifications" + (Object)((Object)e));
        }
    }

    private boolean useChcMeasurementProxy(String counterName) {
        return PmCounterTableManager.isInPmCounterTable(counterName);
    }
}

