/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies;

import java.util.ArrayList;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.wcdma.rbs.boam.common.FroNotAccessibleException;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.RbsErrorException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcGenericProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcMbmsGetFramesReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcMbmsGetFramesRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsFachEventIndS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsFachGetPmFramesReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsFachGetPmFramesRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsFachStartPmReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsFachStartPmRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsFachStopPmReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsFachStopPmRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsGetSccpchParamReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsGetSccpchParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsGetToaeCchReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsGetToaeCchRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsPchEventIndS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsSccpchCreatedIndS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsSccpchDeletedIndS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsSetToaeCchReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsSetToaeCchRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsStartPiTestPatternReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsStartPiTestPatternRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsStartPnGenPchFachReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsStartPnGenPchFachRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsStartPnGenSccpchReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsStartPnGenSccpchRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsStopPiTestPatternReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsStopPiTestPatternRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsStopPnGenPchFachReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsStopPnGenPchFachRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsStopPnGenSccpchReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsStopPnGenSccpchRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsSubscCmSccpchReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsSubscCmSccpchRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsSubscFmSccpchReqS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsSubscFmSccpchRspS;
import se.ericsson.wcdma.rbs.boam.fpx.proxies.ScannedValue;
import se.ericsson.wcdma.rbs.boam.pms.iface.ProxyScanner;

public class ChcSccpchProxy
extends ChcGenericProxy
implements ProxyScanner {
    private static ChcSccpchProxy theOneAndOnly = null;
    private static final String SERVICE_NAME = "lrsCchSccpchResMgr";
    public static final int CLIENT_ID = 0;
    public static final int CM_OPERATION_OK = 0;

    private ChcSccpchProxy() {
        super(SERVICE_NAME);
        MessageLog.traceEnter(this.getClass(), "Constructor");
        this.boamSignalPort.addSignalObserver(this, LrsSccpchCreatedIndS.class);
        this.boamSignalPort.addSignalObserver(this, LrsSccpchDeletedIndS.class);
        this.boamSignalPort.addSignalObserver(this, LrsPchEventIndS.class);
        this.boamSignalPort.addSignalObserver(this, LrsFachEventIndS.class);
    }

    public static synchronized ChcSccpchProxy instance() {
        if (theOneAndOnly == null) {
            theOneAndOnly = new ChcSccpchProxy();
        }
        return theOneAndOnly;
    }

    public LrsSubscCmSccpchRspS subscCmSccpch(int clientId, int subscribeOperation) throws FroRequestFailedException, FroNotAccessibleException {
        LrsSubscCmSccpchReqS reqSig = new LrsSubscCmSccpchReqS(clientId, subscribeOperation, this.signalPort.getServiceName());
        return (LrsSubscCmSccpchRspS)this.sendAndRec(reqSig);
    }

    public LrsSubscFmSccpchRspS subscFmSccpch(int clientId, int subscribeOperation) throws FroRequestFailedException, FroNotAccessibleException {
        LrsSubscFmSccpchReqS reqSig = new LrsSubscFmSccpchReqS(clientId, subscribeOperation, this.signalPort.getServiceName());
        return (LrsSubscFmSccpchRspS)this.sendAndRec(reqSig);
    }

    public LrsGetSccpchParamRspS getSccpchParam(int clientId, int sccpchFroId) throws FroRequestFailedException, FroNotAccessibleException {
        LrsGetSccpchParamReqS reqSig = new LrsGetSccpchParamReqS(clientId, sccpchFroId);
        return (LrsGetSccpchParamRspS)this.sendAndRec(reqSig);
    }

    public LrsStartPnGenPchFachRspS startPnGenPchFach(int clientId, int froId, int sccpchFroId, int isFach, int pnTfi) throws FroRequestFailedException, FroNotAccessibleException {
        LrsStartPnGenPchFachReqS reqSig = new LrsStartPnGenPchFachReqS(clientId, froId, sccpchFroId, isFach, pnTfi);
        return (LrsStartPnGenPchFachRspS)this.sendAndRec(reqSig);
    }

    public LrsStopPnGenPchFachRspS stopPnGenPchFach(int clientId, int sccpchFroId, int froId, int isFach) throws FroRequestFailedException, FroNotAccessibleException {
        LrsStopPnGenPchFachReqS reqSig = new LrsStopPnGenPchFachReqS(clientId, sccpchFroId, froId, isFach);
        return (LrsStopPnGenPchFachRspS)this.sendAndRec(reqSig);
    }

    public LrsStartPnGenSccpchRspS startPnGenSccpch(int clientId, int sccpchFroId) throws FroRequestFailedException, FroNotAccessibleException {
        LrsStartPnGenSccpchReqS reqSig = new LrsStartPnGenSccpchReqS(clientId, sccpchFroId);
        return (LrsStartPnGenSccpchRspS)this.sendAndRec(reqSig);
    }

    public LrsStopPnGenSccpchRspS stopPnGenSccpch(int clientId, int sccpchFroId) throws FroRequestFailedException, FroNotAccessibleException {
        LrsStopPnGenSccpchReqS reqSig = new LrsStopPnGenSccpchReqS(clientId, sccpchFroId);
        return (LrsStopPnGenSccpchRspS)this.sendAndRec(reqSig);
    }

    public void pmsStart(String name, int granularityPeriod, int froId, int bbPoolId, int[] additionalInfo) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " pmsStart()");
        this.sccpchStartPm(0, this.getMeasType(name), froId, granularityPeriod);
    }

    public void pmsStop(String name, int froId, int bbPoolId, int[] additionalInfo) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " pmsStop()");
        this.sccpchStopPm(0, this.getMeasType(name), froId);
    }

    private int getMeasType(String cntName) throws MoAccessException {
        int measType = 0;
        if (cntName.equals("FachNoOfTrchFrames")) {
            measType = 0;
        } else if (cntName.equals("pmMbmsSccpchTransmittedTfc")) {
            measType = 1;
        } else {
            MessageLog.traceError(this.getClass(), "No such a PM counters " + cntName);
            throw new RbsErrorException("getMeasType():No such a PM counter " + cntName);
        }
        return measType;
    }

    public ScannedValue[] getPmsAttribute(String name, int froId, int bbPoolId, int[] additionalInfo) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), " getPmsAttribute()");
        ArrayList<ScannedValue> valueList = new ArrayList<ScannedValue>();
        if (name.equals("FachNoOfTrchFrames")) {
            LrsFachGetPmFramesRspS rspSig = this.sccpchGetPmFrames(0, froId);
            ScannedValue aValue = new ScannedValue("pmNoOfTfc1OnFach1", new int[]{rspSig.noOfTfc1OnFach1});
            valueList.add(aValue);
            aValue = new ScannedValue("pmNoOfTfc2OnFach1", new int[]{rspSig.noOfTfc2OnFach1});
            valueList.add(aValue);
            aValue = new ScannedValue("pmNoOfTfc3OnFach2", new int[]{rspSig.noOfTfc3OnFach2});
            valueList.add(aValue);
        } else if (name.equals("pmMbmsSccpchTransmittedTfc")) {
            ChcMbmsGetFramesRspS rspSig = (ChcMbmsGetFramesRspS)this.sendAndRec(new ChcMbmsGetFramesReqS(0, froId));
            ScannedValue aValue = new ScannedValue(name, rspSig.pmMbmsSccpchTranmittedTfc);
            valueList.add(aValue);
        } else {
            String diagnosis = " Unknown PMS counter [group] name `" + name + "'" + " passed to getPmsAttribute().";
            MessageLog.traceError(this.getClass(), diagnosis);
            throw new RbsErrorException(diagnosis);
        }
        return valueList.toArray(new ScannedValue[valueList.size()]);
    }

    private LrsFachGetPmFramesRspS sccpchGetPmFrames(int clientId, int sccpchFroId) throws FroRequestFailedException, FroNotAccessibleException {
        LrsFachGetPmFramesReqS reqSig = new LrsFachGetPmFramesReqS(clientId, sccpchFroId);
        return (LrsFachGetPmFramesRspS)this.sendAndRec(reqSig);
    }

    private LrsFachStartPmRspS sccpchStartPm(int clientId, int measType, int sccpchFroId, int granularityPeriod) throws FroRequestFailedException, FroNotAccessibleException {
        LrsFachStartPmReqS reqSig = new LrsFachStartPmReqS(clientId, measType, sccpchFroId, granularityPeriod);
        return (LrsFachStartPmRspS)this.sendAndRec(reqSig);
    }

    private LrsFachStopPmRspS sccpchStopPm(int clientId, int measType, int sccpchFroId) throws FroRequestFailedException, FroNotAccessibleException {
        LrsFachStopPmReqS reqSig = new LrsFachStopPmReqS(clientId, measType, sccpchFroId);
        return (LrsFachStopPmRspS)this.sendAndRec(reqSig);
    }

    public LrsStartPiTestPatternRspS startPiTestPattern(int clientId, int sccpchFroId) throws FroRequestFailedException, FroNotAccessibleException {
        LrsStartPiTestPatternReqS reqSig = new LrsStartPiTestPatternReqS(clientId, sccpchFroId);
        return (LrsStartPiTestPatternRspS)this.sendAndRec(reqSig);
    }

    public LrsStopPiTestPatternRspS stopPiTestPattern(int clientId, int sccpchFroId) throws FroRequestFailedException, FroNotAccessibleException {
        LrsStopPiTestPatternReqS reqSig = new LrsStopPiTestPatternReqS(clientId, sccpchFroId);
        return (LrsStopPiTestPatternRspS)this.sendAndRec(reqSig);
    }

    public LrsGetToaeCchRspS getToAeCch(int transactionId, int clientId) throws FroRequestFailedException, FroNotAccessibleException {
        LrsGetToaeCchReqS reqSig = new LrsGetToaeCchReqS(transactionId, clientId);
        return (LrsGetToaeCchRspS)this.sendAndRec(reqSig);
    }

    public LrsSetToaeCchRspS setToAeCch(int transactionId, int clientId, int toAE) throws FroRequestFailedException, FroNotAccessibleException {
        LrsSetToaeCchReqS reqSig = new LrsSetToaeCchReqS(transactionId, clientId, toAE);
        return (LrsSetToaeCchRspS)this.sendAndRec(reqSig);
    }

    public void subscribeToFroNotification() {
        try {
            this.subscCmSccpch(0, 0);
            this.subscFmSccpch(0, 0);
        }
        catch (FroRequestFailedException e) {
            MessageLog.traceError(this.getClass(), "Received result NOK from resource when subscribing to the notifications" + (Object)((Object)e));
        }
        catch (FroNotAccessibleException e) {
            MessageLog.traceError(this.getClass(), "Received result NOK from resource when subscribing to the notifications" + (Object)((Object)e));
        }
    }
}

