/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies;

import se.ericsson.wcdma.rbs.boam.common.FroNotAccessibleException;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EcGenericProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCreateExtTmaReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCreateExtTmaRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcDeleteExtTmaReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcDeleteExtTmaRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGetExtTmaParamReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGetExtTmaParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcSetExtTmaParamReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcSetExtTmaParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcSubscrExtTmaFaultReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.RbsServiceNameT;

public class EqcExtTmaProxy
extends EcGenericProxy {
    private static EqcExtTmaProxy theOneAndOnly = null;
    private static final String SERVICE_NAME = "EqcBdhBoardDeviceHandler";
    public static final String CURRENT_CLASS = EqcExtTmaProxy.class.getName();

    private EqcExtTmaProxy() {
        super(SERVICE_NAME);
    }

    public static synchronized EqcExtTmaProxy instance() {
        if (theOneAndOnly == null) {
            theOneAndOnly = new EqcExtTmaProxy();
        }
        return theOneAndOnly;
    }

    public EqcCreateExtTmaRspS createExtTma(int transactionId, int clientId, int sectorFroId, int sectorAntennaFroId, int internalPower, int dcVoltage, int dlAttenuation, int ulGain, int dlTrafficDelayA, int dlTrafficDelayB, int ulTrafficDelayA, int ulTrafficDelayB) throws FroRequestFailedException, FroNotAccessibleException {
        EqcCreateExtTmaReqS reqSig = new EqcCreateExtTmaReqS(transactionId, clientId, sectorFroId, sectorAntennaFroId, internalPower, dcVoltage, dlAttenuation, ulGain, dlTrafficDelayA, dlTrafficDelayB, ulTrafficDelayA, ulTrafficDelayB);
        return (EqcCreateExtTmaRspS)this.sendAndRec(reqSig);
    }

    public EqcDeleteExtTmaRspS deleteExtTma(int transactionId, int clientId, int extTmaFroId) throws FroRequestFailedException, FroNotAccessibleException {
        EqcDeleteExtTmaReqS reqSig = new EqcDeleteExtTmaReqS(transactionId, clientId, extTmaFroId);
        return (EqcDeleteExtTmaRspS)this.sendAndRec(reqSig);
    }

    public EqcGetExtTmaParamRspS getExtTmaParam(int transactionId, int clientId, int extTmaFroId) throws FroRequestFailedException, FroNotAccessibleException {
        EqcGetExtTmaParamReqS reqSig = new EqcGetExtTmaParamReqS(transactionId, clientId, extTmaFroId);
        EqcGetExtTmaParamRspS resp = (EqcGetExtTmaParamRspS)this.sendAndRec(reqSig);
        return resp;
    }

    public EqcSetExtTmaParamRspS setExtTmaParam(int transactionId, int clientId, int extTmaFroId, int internalPower, int dcVoltage, int dlAttenuation, int ulGain, int dlTrafficDelayA, int dlTrafficDelayB, int ulTrafficDelayA, int ulTrafficDelayB, int validParameter, int currentValue) throws FroRequestFailedException, FroNotAccessibleException {
        EqcSetExtTmaParamReqS reqSig = new EqcSetExtTmaParamReqS(transactionId, clientId, extTmaFroId, internalPower, dcVoltage, dlAttenuation, ulGain, dlTrafficDelayA, dlTrafficDelayB, ulTrafficDelayA, ulTrafficDelayB, validParameter, currentValue);
        return (EqcSetExtTmaParamRspS)this.sendAndRec(reqSig);
    }

    public void subscExtTma(int clientId, int subscriptionRequest) throws FroRequestFailedException, FroNotAccessibleException {
        RbsServiceNameT rbsServiceName = new RbsServiceNameT();
        rbsServiceName.serviceName = this.signalPort.getServiceName();
        Integer CL = new Integer(clientId);
        EqcSubscrExtTmaFaultReqS reqSig = new EqcSubscrExtTmaFaultReqS(CL.longValue(), rbsServiceName, subscriptionRequest);
        this.sendAndRec(reqSig);
    }

    public void subscribeToFroNotification() {
        MessageLog.traceEnter(this.getClass(), "subscribeToFroNotification");
        try {
            this.subscExtTma(0, 0);
        }
        catch (FroRequestFailedException e) {
            MessageLog.traceError(this.getClass(), "Received result NOK from resource when subscribing to the notifications" + (Object)((Object)e));
        }
        catch (FroNotAccessibleException e) {
            MessageLog.traceError(this.getClass(), "Received result NOK from resource when subscribing to the notifications" + (Object)((Object)e));
        }
    }

    public String[] getSpecificErrorCodePrefixes() {
        return new String[]{"RBS_ERR"};
    }
}

