/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs;

import enea.ose.io.SignalInputStream;
import enea.ose.io.SignalOutputStream;
import enea.ose.system.UnlinkedSignal;
import java.io.IOException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;

public class EqcGetRetsParametersRspS
extends UnlinkedSignal {
    public static final int SIG_NO = 16815291;
    public long clientId;
    public int result;
    public int errorCode;
    public String productNumber;
    public String productRevision;
    public int retType;

    public EqcGetRetsParametersRspS() {
        super(16815291);
        this.productNumber = "";
        this.productRevision = "";
    }

    public EqcGetRetsParametersRspS(long clientId, int result2, int errorCode, String productNumber, String productRevision, int retType) {
        super(16815291);
        this.clientId = clientId;
        this.result = result2;
        this.errorCode = errorCode;
        this.productNumber = productNumber;
        this.productRevision = productRevision;
        this.retType = retType;
    }

    public void initReceive() {
        SignalInputStream in = this.getSignalInputStream();
        try {
            this.clientId = in.readU32();
            this.result = in.readS32();
            this.errorCode = in.readS32();
            this.productNumber = in.readString();
            long bytesToSkip = 25 - this.productNumber.length() - 1;
            if (in.skip(bytesToSkip) != bytesToSkip) {
                MessageLog.traceError(((Object)((Object)this)).getClass(), "skip() could not skip the requested amount of bytes");
            }
            this.productRevision = in.readString();
            bytesToSkip = 8 - this.productRevision.length() - 1;
            if (in.skip(bytesToSkip) != bytesToSkip) {
                MessageLog.traceError(((Object)((Object)this)).getClass(), "skip() could not skip the requested amount of bytes");
            }
            this.retType = in.readS32();
        }
        catch (IOException e) {
            MessageLog.traceError(((Object)((Object)this)).getClass(), "initReceive failed in EqcGetRetsParametersRspS: " + e);
        }
    }

    public void initSend() {
        SignalOutputStream sos = this.getSignalOutputStream();
        try {
            sos.writeU32(this.clientId);
            sos.writeU32((long)this.result);
            sos.writeU32((long)this.errorCode);
            sos.writeString(this.productNumber);
            sos.writeU8Array(new int[25 - this.productNumber.length() - 1]);
            sos.writeString(this.productRevision);
            sos.writeU8Array(new int[8 - this.productRevision.length() - 1]);
            sos.writeU32((long)this.retType);
            sos.flush();
        }
        catch (IOException e) {
            MessageLog.traceError(((Object)((Object)this)).getClass(), "initSend failed in EqcGetRetsParametersRspS: " + e);
        }
    }
}

