/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs;

import enea.ose.io.SignalInputStream;
import enea.ose.io.SignalOutputStream;
import enea.ose.system.UnlinkedSignal;
import java.io.IOException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.RbsServiceNameT;

public class EqcSwUpgradeReqS
extends UnlinkedSignal {
    public static final int SIG_NO = 16815880;
    public long clientId;
    public int swUpgradePhase;
    public RbsServiceNameT receiverServiceName = new RbsServiceNameT();

    public EqcSwUpgradeReqS() {
        super(16815880);
    }

    public EqcSwUpgradeReqS(long clientId, int swUpgradePhase, RbsServiceNameT receiverServiceName) {
        super(16815880);
        this.clientId = clientId;
        this.swUpgradePhase = swUpgradePhase;
        this.receiverServiceName = receiverServiceName;
    }

    public void initReceive() {
        SignalInputStream in = this.getSignalInputStream();
        try {
            this.clientId = in.readU32();
            this.swUpgradePhase = in.readS32();
            this.receiverServiceName.serviceName = in.readString();
            long bytesToSkip = 25 - this.receiverServiceName.serviceName.length() - 1;
            if (in.skip(bytesToSkip) != bytesToSkip) {
                MessageLog.traceError(((Object)((Object)this)).getClass(), "skip() could not skip the requested amount of bytes");
            }
        }
        catch (IOException e) {
            MessageLog.traceError(((Object)((Object)this)).getClass(), "initReceive failed in EqcSwUpgradeReqS: " + e);
        }
    }

    public void initSend() {
        SignalOutputStream out = this.getSignalOutputStream();
        try {
            out.writeU32(this.clientId);
            out.writeS32(this.swUpgradePhase);
            out.writeString(this.receiverServiceName.serviceName);
            out.writeU8Array(new int[64 - this.receiverServiceName.serviceName.length() - 1]);
            out.flush();
        }
        catch (IOException e) {
            MessageLog.traceError(((Object)((Object)this)).getClass(), "initSend failed in EqcSwUpgradeReqS: " + e);
        }
    }
}

