/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.fpx.ncmi.proxies;

import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.proxies.NcGenericProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.sigs.BcDeleteSysConstReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.sigs.BcGetSysConstReqS;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.sigs.BcGetSysConstRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ncmi.sigs.BcWriteSysConstReqS;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.ParameterValueErrorException;

public class NcSystemConstantsProxy
extends NcGenericProxy {
    private static NcSystemConstantsProxy uniqueInstance;
    private static final String SERVICE_NAME = "bcNmSystemConstantHandler";

    private NcSystemConstantsProxy() {
        super(SERVICE_NAME);
        MessageLog.traceEnter(this.getClass(), "NcSystemConstantsProxy() <---");
    }

    public static synchronized NcSystemConstantsProxy instance() {
        if (uniqueInstance == null) {
            uniqueInstance = new NcSystemConstantsProxy();
        }
        return uniqueInstance;
    }

    public void deleteSystemConstant(int clientId, int transactionId, String name) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "deleteSystemConstants(" + clientId + "," + transactionId + "," + name + ")<---");
        if (name == null) {
            MessageLog.trace(2, this.getClass(), "In parameter is null!!.");
            throw new ParameterValueErrorException();
        }
        if (name.length() >= 32) {
            this.handleTooLongName(name);
        } else {
            BcDeleteSysConstReqS reqSig = new BcDeleteSysConstReqS(transactionId, clientId, name);
            this.sendAndRec(reqSig);
        }
    }

    public void writeSystemConstant(int clientId, int transactionId, String name, String value) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "writeSystemConstant(" + clientId + "," + transactionId + "," + name + "," + value + ")<---");
        if (name == null || value == null) {
            MessageLog.trace(2, this.getClass(), "in-parameter is null!!.");
            throw new ParameterValueErrorException();
        }
        if (name.length() >= 32) {
            this.handleTooLongName(name);
        } else {
            BcWriteSysConstReqS reqSig = new BcWriteSysConstReqS(transactionId, clientId, name, value);
            this.sendAndRec(reqSig);
        }
    }

    private void handleTooLongName(String name) throws MoAccessException {
        MessageLog.trace(2, this.getClass(), "Name '" + name + "' too long; max accepted length is: " + 31);
        throw new ParameterValueErrorException();
    }

    public BcGetSysConstRspS getSystemConstants(int clientId, int transactionId) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getSystemConstants(" + clientId + "," + transactionId + ")<---");
        BcGetSysConstReqS reqSig = new BcGetSysConstReqS(transactionId, clientId);
        return (BcGetSysConstRspS)this.sendAndRec(reqSig);
    }
}

