/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.fpx.proxies;

import enea.ose.system.InSignal;
import enea.ose.system.UnlinkedSignal;
import java.lang.reflect.Field;
import se.ericsson.wcdma.rbs.boam.common.FroNotAccessibleException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;

public final class BoamProxyUtils {
    public static final String NULL_RESPONSE_SIGNAL_MSG = "No response signal is received!! Probably problem in the TA application. Problem can be caused if:\n\t 1-The TA is not up and running. \n\t 2- This signal is not implemented by TA.\n ";
    public static final String SIGNAL_PACKAGE_PERFIX = "se.ericsson.wcdma.rbs.boam.fpx.";

    public static void unexpectedSignalReceived(InSignal receiveSig, Class originatedClass) {
        String unknownSignal = receiveSig.getClass().getName();
        MessageLog.traceError(originatedClass, "Unknown signal received: " + unknownSignal);
    }

    public static void verifyRoLayerResponse(InSignal rspSig, Class originatedClass, String serviceName) throws FroNotAccessibleException {
        if (rspSig == null) {
            MessageLog.traceError(originatedClass, NULL_RESPONSE_SIGNAL_MSG);
            throw new FroNotAccessibleException(originatedClass.getName(), serviceName, NULL_RESPONSE_SIGNAL_MSG);
        }
    }

    public static Object getFieldValue(String name, UnlinkedSignal rspSig) {
        String NO_SUCH_PARAM = "0";
        try {
            Field resultF = rspSig.getClass().getField(name);
            return resultF.get(rspSig);
        }
        catch (Exception e) {
            MessageLog.trace(2, rspSig.getClass(), "Couldn't get parameter " + name + ", signal: " + rspSig.getClass().getName() + ", due to exception:" + e);
            return "0";
        }
    }
}

