/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.alarm;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import se.ericsson.cello.equipment.PlugInUnitMo;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.wcdma.rbs.boam.common.EnumConverter;
import se.ericsson.wcdma.rbs.boam.common.FaultIndSignalInfo;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.EqcNodeBPrimFaultIndS;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.enumer.AuxPIUAuType;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.enumer.DigitalCableObjectAConnector;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.enumer.DigitalCableObjectBConnector;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.enumer.GammaCableConnector;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.enumer.InterSubTimingCableBbifConnector;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.enumer.InterSubTimingCableRfifConnector;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.enumer.IntraCabTimingCableBbifConnector;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.enumer.IntraCabTimingCableRfifConnector;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.enumer.LoPowTxCableAiuConnector;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.enumer.LoPowTxCableMcpaConnector;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.enumer.OilObjectAConnector;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.enumer.OilObjectBConnector;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.enumer.RfCableObjectAConnector;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.enumer.RfCableObjectBConnector;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.enumer.TrxRfCableAiuConnector;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.enumer.TrxRfCableConnector;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AntennaBranchMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AscDeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AuxPlugInUnitMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.DigitalCableMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.ExternalAntennaMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.GammaCableMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.InterSubTimingCableMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.IntraCabTimingCableMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.LoPowTxCableMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.OpticalInterfaceLinkMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RfCableMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.SectorAntennaMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.SectorMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.TmaDeviceMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.TpaDeviceMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.TrxRfCableMo;

public abstract class AdditionalTextExcep {
    private static final Class SELF = AdditionalTextExcep.class;
    private static final String PREFIX = "getAdditionalText_";
    public static final String CONFIGURATION_FILE_MISSING = "Configuration file missing";
    public static final int BUFFER_SIZE = 128;
    private static final String EMPTY_ADDITIONAL_TEXT = "";
    private static final String NULL_CONNECTOR = "null";

    public static String getAdditionalText(ManagedObject mo, FaultIndSignalInfo alarmInd) {
        MessageLog.traceEnter(SELF, "getAdditionalText()");
        if (mo == null) {
            return EMPTY_ADDITIONAL_TEXT;
        }
        try {
            String methodName = PREFIX + mo.getType();
            Method m = SELF.getMethod(methodName, ManagedObject.class, FaultIndSignalInfo.class);
            try {
                return (String)m.invoke((Object)SELF, mo, alarmInd);
            }
            catch (IllegalArgumentException e) {
                MessageLog.trace(5, SELF, "method " + m + " not applicable to (ManagedObject, FaultIndSignalInfo)");
                return EMPTY_ADDITIONAL_TEXT;
            }
            catch (IllegalAccessException e) {
                MessageLog.trace(5, SELF, "Caught: " + e);
                return EMPTY_ADDITIONAL_TEXT;
            }
            catch (InvocationTargetException e) {
                MessageLog.trace(5, SELF, "Invocation caused exception: " + e.getCause());
                return EMPTY_ADDITIONAL_TEXT;
            }
        }
        catch (NoSuchMethodException e) {
            String additionalText = alarmInd.getAdditionalText();
            if (additionalText.length() > 0) {
                MessageLog.trace(5, SELF, "No exceptional rule is defined to get AdditionalText for MO: " + mo.getFullDistinguishedName() + ", yet received AdditionalText: '" + additionalText + "' in alarm indication signal: " + alarmInd.getClass().getName());
            } else {
                MessageLog.trace(5, SELF, "No exceptional rule is defined to get AdditionalText for MO: " + mo.getFullDistinguishedName() + "; returning empty string");
            }
            return EMPTY_ADDITIONAL_TEXT;
        }
    }

    public static String getAdditionalText_AlmDevice(ManagedObject mo, FaultIndSignalInfo alarmInd) throws MoAccessException {
        switch (alarmInd.getSpecificProblem()) {
            case 49154: {
                return AdditionalTextExcep.getAdditionalTextCoSitedRBS(mo, alarmInd);
            }
            case 49577: {
                return alarmInd.getAdditionalText();
            }
        }
        return EMPTY_ADDITIONAL_TEXT;
    }

    public static String getAdditionalText_AlmDeviceSet(ManagedObject mo, FaultIndSignalInfo alarmInd) throws MoAccessException {
        switch (alarmInd.getSpecificProblem()) {
            case 49154: {
                return alarmInd.getAdditionalText();
            }
        }
        return EMPTY_ADDITIONAL_TEXT;
    }

    public static String getAdditionalText_AntennaBranch(ManagedObject mo, FaultIndSignalInfo alarmInd) throws MoAccessException {
        switch (alarmInd.getSpecificProblem()) {
            case 50180: 
            case 50181: 
            case 50182: 
            case 50183: 
            case 50186: 
            case 50187: 
            case 50188: 
            case 50189: {
                return alarmInd.getAdditionalText();
            }
            case 50184: 
            case 50185: {
                StringBuffer additionalText = new StringBuffer(128);
                String tecText = alarmInd.getAdditionalText();
                if (tecText.length() > 0) {
                    additionalText.append(tecText);
                }
                if (AdditionalTextExcep.isCascadedRETUsed(mo)) {
                    additionalText.append(". Affected cascaded RETs might impact corresponding co-sited RBSs");
                }
                return additionalText.toString();
            }
        }
        return EMPTY_ADDITIONAL_TEXT;
    }

    public static String getAdditionalText_AntFeederCable(ManagedObject mo, FaultIndSignalInfo alarmInd) throws Exception {
        switch (alarmInd.getSpecificProblem()) {
            case 49577: {
                return alarmInd.getAdditionalText();
            }
        }
        return EMPTY_ADDITIONAL_TEXT;
    }

    public static String getAdditionalText_AscDeviceGroup(ManagedObject mo, FaultIndSignalInfo alarmInd) throws Exception {
        switch (alarmInd.getSpecificProblem()) {
            case 49183: {
                if (AdditionalTextExcep.isCascadedRETUsed(mo)) {
                    return "Affected cascaded RETs might impact corresponding co-sited RBSs";
                }
                return EMPTY_ADDITIONAL_TEXT;
            }
        }
        return EMPTY_ADDITIONAL_TEXT;
    }

    public static String getAdditionalText_AuxPlugInUnit(ManagedObject mo, FaultIndSignalInfo alarmInd) throws Exception {
        switch (alarmInd.getSpecificProblem()) {
            case 49356: {
                StringBuffer additionalText = new StringBuffer(128);
                int auType = ((AuxPlugInUnitMo)mo).getAuType(null);
                additionalText.append(EnumConverter.intEnum2StringEnum(AuxPIUAuType.class, auType));
                if (auType == 7) {
                    additionalText.append(". Cable to RETU disconnected");
                } else if (auType == 12) {
                    additionalText.append(". RU-FU DC cable disconnected");
                }
                return additionalText.toString();
            }
            case 49354: {
                StringBuffer additionalText = new StringBuffer(128);
                additionalText.append(EnumConverter.intEnum2StringEnum(AuxPIUAuType.class, ((AuxPlugInUnitMo)mo).getAuType(null)));
                String coSitedText = AdditionalTextExcep.getAdditionalTextCoSitedRBS(mo, alarmInd);
                if (coSitedText.length() > 0) {
                    additionalText.append(". ").append(coSitedText);
                }
                return additionalText.toString();
            }
            case 49187: 
            case 49353: 
            case 49355: {
                return EnumConverter.intEnum2StringEnum(AuxPIUAuType.class, ((AuxPlugInUnitMo)mo).getAuType(null));
            }
            case 49360: 
            case 49565: {
                return alarmInd.getAdditionalText();
            }
        }
        return EMPTY_ADDITIONAL_TEXT;
    }

    public static String getAdditionalText_DeviceGroup(ManagedObject mo, FaultIndSignalInfo alarmInd) throws MoAccessException {
        switch (alarmInd.getSpecificProblem()) {
            case 49575: 
            case 49576: {
                ManagedObject parent = mo.getParent();
                DigitalCableMo cableMo = null;
                if (alarmInd.getNrOfFaultyResources() > 0) {
                    int cableFroId = (int)alarmInd.getFaultyResourceFroId()[0];
                    cableMo = (DigitalCableMo)BoamHelper.getMoForFroId("DigitalCable", cableFroId);
                }
                StringBuffer additionalText = AdditionalTextExcep.getBoardType(parent, cableMo);
                additionalText.append(alarmInd.getAdditionalText());
                return additionalText.toString();
            }
            case 49155: 
            case 49181: {
                return alarmInd.getAdditionalText();
            }
            case 50158: {
                return "Not possible to upgrade SW due to incompatibility of running SW";
            }
        }
        return alarmInd.getAdditionalText();
    }

    public static String getAdditionalText_DigitalCable(ManagedObject mo, FaultIndSignalInfo alarmInd) throws MoAccessException {
        switch (alarmInd.getSpecificProblem()) {
            case 49575: 
            case 50153: 
            case 50156: 
            case 50157: {
                DigitalCableMo cableMo = (DigitalCableMo)mo;
                StringBuffer additionalText = AdditionalTextExcep.getBoardType(cableMo.getConnectedToObjectARef(null), cableMo);
                additionalText.append(alarmInd.getAdditionalText());
                return additionalText.toString();
            }
            case 50158: {
                return "Either the CPRI cable is wrongly connected or there is a configuration fault";
            }
        }
        return EMPTY_ADDITIONAL_TEXT;
    }

    public static String getAdditionalText_FcuDeviceGroup(ManagedObject mo, FaultIndSignalInfo alarmInd) throws MoAccessException {
        switch (alarmInd.getSpecificProblem()) {
            case 49565: {
                return alarmInd.getAdditionalText();
            }
        }
        return EMPTY_ADDITIONAL_TEXT;
    }

    public static String getAdditionalText_GammaCable(ManagedObject mo, FaultIndSignalInfo alarmInd) throws Exception {
        switch (alarmInd.getSpecificProblem()) {
            case 49176: 
            case 49177: 
            case 50152: {
                StringBuffer additionalText = new StringBuffer(128);
                GammaCableMo cableMo = (GammaCableMo)mo;
                additionalText.append(cableMo.getBbifBoardRef(null).getType());
                additionalText.append(" connector ");
                additionalText.append(EnumConverter.intEnum2StringEnum(GammaCableConnector.class, cableMo.getBbifConnector(null)));
                additionalText.append(" and ");
                String boardTypeName = AdditionalTextExcep.getBoardType(cableMo.getRfifPlugInUnitRef(null).getType());
                additionalText.append(boardTypeName).append(" connector ");
                additionalText.append(EnumConverter.intEnum2StringEnum(GammaCableConnector.class, cableMo.getRfifConnector(null)));
                return additionalText.toString();
            }
        }
        return EMPTY_ADDITIONAL_TEXT;
    }

    public static String getAdditionalText_InterSubTimingCable(ManagedObject mo, FaultIndSignalInfo alarmInd) throws Exception {
        switch (alarmInd.getSpecificProblem()) {
            case 49171: {
                StringBuffer additionalText = new StringBuffer(128);
                InterSubTimingCableMo cableMo = (InterSubTimingCableMo)mo;
                String boardTypeName = AdditionalTextExcep.getBoardType(cableMo.getRfifPlugInUnitRef(null).getType());
                additionalText.append(boardTypeName).append(" connector ");
                additionalText.append(EnumConverter.intEnum2StringEnum(InterSubTimingCableRfifConnector.class, cableMo.getRfifConnector(null))).append(" and ");
                additionalText.append(cableMo.getBbifBoardRef(null).getType()).append(" connector ");
                additionalText.append(EnumConverter.intEnum2StringEnum(InterSubTimingCableBbifConnector.class, cableMo.getBbifConnector(null)));
                return additionalText.toString();
            }
        }
        return EMPTY_ADDITIONAL_TEXT;
    }

    public static String getAdditionalText_IntraCabTimingCable(ManagedObject mo, FaultIndSignalInfo alarmInd) throws Exception {
        switch (alarmInd.getSpecificProblem()) {
            case 49171: {
                StringBuffer additionalText = new StringBuffer(128);
                IntraCabTimingCableMo cableMo = (IntraCabTimingCableMo)mo;
                String boardTypeName = AdditionalTextExcep.getBoardType(cableMo.getRfifPlugInUnitRef(null).getType());
                additionalText.append(boardTypeName).append(" connector ");
                additionalText.append(EnumConverter.intEnum2StringEnum(IntraCabTimingCableRfifConnector.class, cableMo.getRfifConnector(null))).append(" and ");
                additionalText.append(cableMo.getBbifBoardRef(null).getType()).append(" connector ");
                additionalText.append(EnumConverter.intEnum2StringEnum(IntraCabTimingCableBbifConnector.class, cableMo.getBbifConnector(null)));
                return additionalText.toString();
            }
        }
        return EMPTY_ADDITIONAL_TEXT;
    }

    public static String getAdditionalText_LoPowTxCable(ManagedObject mo, FaultIndSignalInfo alarmInd) throws Exception {
        switch (alarmInd.getSpecificProblem()) {
            case 49356: {
                StringBuffer additionalText = new StringBuffer(128);
                LoPowTxCableMo cableMo = (LoPowTxCableMo)mo;
                String boardTypeName = AdditionalTextExcep.getBoardType(cableMo.getAiuPlugInUnitRef(null).getType());
                additionalText.append(boardTypeName).append(" connector ");
                additionalText.append(EnumConverter.intEnum2StringEnum(LoPowTxCableAiuConnector.class, cableMo.getAiuConnector(null))).append(" and ");
                boardTypeName = AdditionalTextExcep.getBoardType(cableMo.getMcpaAuxPlugInUnitRef(null).getType());
                additionalText.append(boardTypeName).append(" connector ");
                additionalText.append(EnumConverter.intEnum2StringEnum(LoPowTxCableMcpaConnector.class, cableMo.getMcpaConnector(null)));
                return additionalText.toString();
            }
        }
        return EMPTY_ADDITIONAL_TEXT;
    }

    public static String getAdditionalText_NodeBFunction(ManagedObject mo, FaultIndSignalInfo alarmInd) throws Exception {
        switch (alarmInd.getSpecificProblem()) {
            case 26004: 
            case 26005: 
            case 26007: 
            case 26008: {
                StringBuffer additionalText = new StringBuffer(128);
                additionalText.append("LicencedCapacity=");
                additionalText.append(((EqcNodeBPrimFaultIndS)alarmInd).licensedCapacity);
                additionalText.append(",CapacityLimitEnforceDate=");
                additionalText.append(((EqcNodeBPrimFaultIndS)alarmInd).capacityLimitEnforceDate);
                return additionalText.toString();
            }
            case 26006: 
            case 26009: {
                StringBuffer additionalText = new StringBuffer(128);
                additionalText.append("LicencedCapacity=");
                additionalText.append(((EqcNodeBPrimFaultIndS)alarmInd).licensedCapacity);
                return additionalText.toString();
            }
        }
        return EMPTY_ADDITIONAL_TEXT;
    }

    public static String getAdditionalText_ObifDeviceGroup(ManagedObject mo, FaultIndSignalInfo alarmInd) throws MoAccessException {
        switch (alarmInd.getSpecificProblem()) {
            case 49575: {
                StringBuffer additionalText = new StringBuffer(128);
                PlugInUnitMo parent = (PlugInUnitMo)mo.getParent();
                additionalText.append(parent.getUnitType(null));
                additionalText.append(" connector ");
                String connector = NULL_CONNECTOR;
                if (alarmInd.getNrOfFaultyResources() > 0) {
                    int cableFroId = (int)alarmInd.getFaultyResourceFroId()[0];
                    try {
                        OpticalInterfaceLinkMo cableMo = (OpticalInterfaceLinkMo)BoamHelper.getMoForFroId("OpticalInterfaceLink", cableFroId);
                        if (cableMo.getConnectedToObjectARef(null) == parent) {
                            connector = EnumConverter.intEnum2StringEnum(OilObjectAConnector.class, cableMo.getObjectAConnector(null));
                        } else if (cableMo.getConnectedToObjectBRef(null) == parent) {
                            connector = EnumConverter.intEnum2StringEnum(OilObjectBConnector.class, cableMo.getObjectBConnector(null));
                        }
                    }
                    catch (MoNotFoundException e) {
                        // empty catch block
                    }
                }
                additionalText.append(connector);
                additionalText.append(". ");
                additionalText.append(alarmInd.getAdditionalText());
                return additionalText.toString();
            }
        }
        return EMPTY_ADDITIONAL_TEXT;
    }

    public static String getAdditionalText_OpticalInterfaceLink(ManagedObject mo, FaultIndSignalInfo alarmInd) throws Exception {
        switch (alarmInd.getSpecificProblem()) {
            case 50154: 
            case 50155: {
                StringBuffer additionalText = new StringBuffer(128);
                OpticalInterfaceLinkMo cableMo = (OpticalInterfaceLinkMo)mo;
                String boardTypeName = AdditionalTextExcep.getBoardType(cableMo.getConnectedToObjectARef(null).getType());
                additionalText.append(boardTypeName).append(" connector ");
                additionalText.append(EnumConverter.intEnum2StringEnum(OilObjectAConnector.class, cableMo.getObjectAConnector(null))).append(" and ");
                boardTypeName = AdditionalTextExcep.getBoardType(cableMo.getConnectedToObjectBRef(null).getType());
                additionalText.append(boardTypeName).append(" connector ");
                additionalText.append(EnumConverter.intEnum2StringEnum(OilObjectBConnector.class, cableMo.getObjectBConnector(null)));
                return additionalText.toString();
            }
        }
        return EMPTY_ADDITIONAL_TEXT;
    }

    public static String getAdditionalText_RbsLocalCell(ManagedObject mo, FaultIndSignalInfo alarmInd) throws MoAccessException {
        switch (alarmInd.getSpecificProblem()) {
            case 37471: {
                return "Preambles without RACH data.";
            }
            case 37475: {
                return "The number of auto recoveries for a suspected sleeping cell has reached the limit in the past 24 hours. No more auto recovery.";
            }
            case 37473: 
            case 37474: {
                return alarmInd.getAdditionalText();
            }
        }
        return EMPTY_ADDITIONAL_TEXT;
    }

    public static String getAdditionalText_RetDevice(ManagedObject ignoredMo, FaultIndSignalInfo alarmInd) throws Exception {
        return alarmInd.getAdditionalText();
    }

    public static String getAdditionalText_RfCable(ManagedObject mo, FaultIndSignalInfo alarmInd) throws Exception {
        StringBuffer additionalText = new StringBuffer(128);
        RfCableMo cableMo = (RfCableMo)mo;
        String boardTypeName = AdditionalTextExcep.getBoardType(cableMo.getConnectedToObjectARef(null).getType());
        additionalText.append(boardTypeName).append(" connector ");
        additionalText.append(EnumConverter.intEnum2StringEnum(RfCableObjectAConnector.class, cableMo.getObjectAConnector(null))).append(" and ");
        boardTypeName = AdditionalTextExcep.getBoardType(cableMo.getConnectedToObjectBRef(null).getType());
        additionalText.append(boardTypeName).append(" connector ");
        additionalText.append(EnumConverter.intEnum2StringEnum(RfCableObjectBConnector.class, cableMo.getObjectBConnector(null)));
        return additionalText.toString();
    }

    public static String getAdditionalText_RruDeviceGroup(ManagedObject mo, FaultIndSignalInfo alarmInd) throws Exception {
        switch (alarmInd.getSpecificProblem()) {
            case 49575: 
            case 49576: {
                StringBuffer additionalText = new StringBuffer(128);
                AuxPlugInUnitMo parent = (AuxPlugInUnitMo)mo.getParent();
                additionalText.append(parent.getNamingAttributeValue());
                additionalText.append(" connector ");
                String connector = NULL_CONNECTOR;
                boolean cableFound = false;
                if (alarmInd.getNrOfFaultyResources() > 0) {
                    ManagedObject cableMo;
                    int cableFroId = (int)alarmInd.getFaultyResourceFroId()[0];
                    try {
                        cableMo = (OpticalInterfaceLinkMo)BoamHelper.getMoForFroId("OpticalInterfaceLink", cableFroId);
                        cableFound = true;
                        if (cableMo.getConnectedToObjectARef(null) == parent) {
                            connector = EnumConverter.intEnum2StringEnum(OilObjectAConnector.class, cableMo.getObjectAConnector(null));
                        } else if (cableMo.getConnectedToObjectBRef(null) == parent) {
                            connector = EnumConverter.intEnum2StringEnum(OilObjectBConnector.class, cableMo.getObjectBConnector(null));
                        }
                    }
                    catch (MoNotFoundException e) {
                        // empty catch block
                    }
                    if (!cableFound) {
                        try {
                            cableMo = (DigitalCableMo)BoamHelper.getMoForFroId("DigitalCable", cableFroId);
                            if (cableMo.getConnectedToObjectARef(null) == parent) {
                                connector = EnumConverter.intEnum2StringEnum(DigitalCableObjectAConnector.class, cableMo.getObjectAConnector(null));
                            } else if (cableMo.getConnectedToObjectBRef(null) == parent) {
                                connector = EnumConverter.intEnum2StringEnum(DigitalCableObjectBConnector.class, cableMo.getObjectBConnector(null));
                            }
                        }
                        catch (MoNotFoundException e) {
                            // empty catch block
                        }
                    }
                }
                additionalText.append(connector);
                additionalText.append(". ");
                additionalText.append(alarmInd.getAdditionalText());
                return additionalText.toString();
            }
            case 50158: {
                return "Not possible to upgrade SW due to incompatibility of running SW";
            }
        }
        return alarmInd.getAdditionalText();
    }

    public static String getAdditionalText_Sector(ManagedObject mo, FaultIndSignalInfo alarmInd) throws MoAccessException {
        switch (alarmInd.getSpecificProblem()) {
            case 37266: {
                return alarmInd.getAdditionalText();
            }
        }
        return alarmInd.getAdditionalText();
    }

    public static String getAdditionalText_SectorAntenna(ManagedObject mo, FaultIndSignalInfo alarmInd) throws MoAccessException {
        switch (alarmInd.getSpecificProblem()) {
            case 50200: {
                if (AdditionalTextExcep.isCascadedRETUsed(mo)) {
                    return alarmInd.getAdditionalText() + ". Affected cascaded RETs might impact corresponding co-sited RBSs";
                }
                return alarmInd.getAdditionalText();
            }
        }
        return alarmInd.getAdditionalText();
    }

    public static String getAdditionalText_TmaDevice(ManagedObject mo, FaultIndSignalInfo alarmInd) throws MoAccessException {
        switch (alarmInd.getSpecificProblem()) {
            case 49154: 
            case 49155: 
            case 49988: 
            case 49989: {
                String coSitedText;
                StringBuffer additionalText = new StringBuffer(128);
                if (AdditionalTextExcep.isAntennaShared((TmaDeviceMo)mo)) {
                    additionalText.append("Also affects other sector with shared antenna");
                }
                if ((coSitedText = AdditionalTextExcep.getAdditionalTextCoSitedRBS(mo, alarmInd)).length() > 0) {
                    additionalText.append(". ").append(coSitedText);
                }
                return additionalText.toString();
            }
        }
        return EMPTY_ADDITIONAL_TEXT;
    }

    public static String getAdditionalText_TmaDeviceSet(ManagedObject mo, FaultIndSignalInfo alarmInd) throws MoAccessException {
        switch (alarmInd.getSpecificProblem()) {
            case 49155: {
                String coSitedText;
                StringBuffer additionalText = new StringBuffer(128);
                MoIterator moIter = mo.getChildren();
                if (moIter.size() > 0 && AdditionalTextExcep.isAntennaShared((TmaDeviceMo)moIter.nextElement())) {
                    additionalText.append("Also affects other sector with shared antenna");
                }
                if ((coSitedText = AdditionalTextExcep.getAdditionalTextCoSitedRBS(mo, alarmInd)).length() > 0) {
                    additionalText.append(". ").append(coSitedText);
                }
                return additionalText.toString();
            }
            case 49154: {
                String coSitedText;
                StringBuffer additionalText = new StringBuffer(128);
                MoIterator moIter = mo.getChildren();
                if (moIter.size() > 0 && AdditionalTextExcep.isAntennaShared((TmaDeviceMo)moIter.nextElement())) {
                    additionalText.append("Also affects other sector with shared antenna");
                }
                if ((coSitedText = alarmInd.getAdditionalText()).length() > 0) {
                    additionalText.append(". ").append(coSitedText);
                }
                return additionalText.toString();
            }
            case 49186: 
            case 49577: {
                return alarmInd.getAdditionalText();
            }
        }
        return EMPTY_ADDITIONAL_TEXT;
    }

    public static String getAdditionalText_TrxRfCable(ManagedObject mo, FaultIndSignalInfo alarmInd) throws Exception {
        StringBuffer additionalText = new StringBuffer(128);
        TrxRfCableMo cableMo = (TrxRfCableMo)mo;
        String boardTypeName = AdditionalTextExcep.getBoardType(cableMo.getTrxPlugInUnitRef(null).getType());
        additionalText.append(boardTypeName).append(" connector ");
        additionalText.append(EnumConverter.intEnum2StringEnum(TrxRfCableConnector.class, cableMo.getTrxConnector(null))).append(" and ");
        boardTypeName = AdditionalTextExcep.getBoardType(cableMo.getAiuPlugInUnitRef(null).getType());
        additionalText.append(boardTypeName).append(" connector ");
        additionalText.append(EnumConverter.intEnum2StringEnum(TrxRfCableAiuConnector.class, cableMo.getAiuConnector(null)));
        return additionalText.toString();
    }

    public static String getAdditionalText_TpaDevice(ManagedObject mo, FaultIndSignalInfo alarmInd) throws Exception {
        switch (alarmInd.getSpecificProblem()) {
            case 36966: {
                ManagedObject carrier = null;
                String carrierType = "Carrier";
                try {
                    ManagedObject[] reserve_mos = ((TpaDeviceMo)mo).getReservedBy(null);
                    for (int i = 0; i < reserve_mos.length; ++i) {
                        if (!"Carrier".equals(reserve_mos[i].getType())) continue;
                        carrier = reserve_mos[i];
                        break;
                    }
                }
                catch (MoAccessException e) {
                    MessageLog.traceError(SELF, "Could not access the reservedByList");
                }
                if (carrier == null) {
                    return alarmInd.getAdditionalText();
                }
                SectorMo sector = (SectorMo)carrier.getParent();
                boolean mixedModeRadio = sector.getMixedModeRadio(null);
                if (mixedModeRadio) {
                    return "RU output power exceeded in Mixed Mode";
                }
                return alarmInd.getAdditionalText();
            }
        }
        return alarmInd.getAdditionalText();
    }

    public static String getAdditionalText_TxDeviceGroup(ManagedObject mo, FaultIndSignalInfo alarmInd) throws Exception {
        return alarmInd.getAdditionalText();
    }

    public static String getAdditionalText_RaxDeviceGroup(ManagedObject mo, FaultIndSignalInfo alarmInd) throws Exception {
        return alarmInd.getAdditionalText();
    }

    public static String getAdditionalText_RdiCable(ManagedObject mo, FaultIndSignalInfo alarmInd) throws Exception {
        return alarmInd.getAdditionalText();
    }

    private static String getBoardType(String moType) {
        String boardType = EMPTY_ADDITIONAL_TEXT;
        String DEV = "Device";
        int index = moType.indexOf("Device");
        boardType = moType.substring(0, index);
        return boardType;
    }

    private static StringBuffer getBoardType(ManagedObject objectA, ManagedObject digitalCableMo) throws MoAccessException {
        AuxPlugInUnitMo castedParent;
        ManagedObject grandParent = objectA.getParent();
        StringBuffer additionalText = new StringBuffer();
        if (objectA instanceof AuxPlugInUnitMo) {
            castedParent = (AuxPlugInUnitMo)objectA;
            additionalText.append(castedParent.getUnitType(null));
        } else if (objectA instanceof PlugInUnitMo) {
            castedParent = (PlugInUnitMo)objectA;
            additionalText.append(castedParent.getUnitType(null));
        } else if (grandParent instanceof PlugInUnitMo) {
            PlugInUnitMo castedGrantParent = (PlugInUnitMo)grandParent;
            additionalText.append(castedGrantParent.getUnitType(null));
        } else {
            MessageLog.trace(5, SELF, "Couldn't find MO parent of correct type ");
            return new StringBuffer(EMPTY_ADDITIONAL_TEXT);
        }
        additionalText.append(" connector ");
        String connector = NULL_CONNECTOR;
        if (null != digitalCableMo) {
            try {
                DigitalCableMo cableMo = (DigitalCableMo)digitalCableMo;
                if (objectA.equals(cableMo.getConnectedToObjectARef(null)) || grandParent.equals(cableMo.getConnectedToObjectARef(null))) {
                    connector = EnumConverter.intEnum2StringEnum(DigitalCableObjectAConnector.class, cableMo.getObjectAConnector(null));
                } else if (objectA.equals(cableMo.getConnectedToObjectBRef(null)) || grandParent.equals(cableMo.getConnectedToObjectBRef(null))) {
                    connector = EnumConverter.intEnum2StringEnum(DigitalCableObjectBConnector.class, cableMo.getObjectBConnector(null));
                }
            }
            catch (MoNotFoundException e) {
                MessageLog.trace(5, SELF, "Couldn't find MO." + e.toString());
            }
        }
        additionalText.append(connector);
        additionalText.append(". ");
        return additionalText;
    }

    private static String getAdditionalTextCoSitedRBS(ManagedObject _mo, FaultIndSignalInfo _alarmInd) {
        String CO_SITED_RBS_TOKEN = "co-sited RBS";
        if (_alarmInd.getAdditionalText().indexOf("co-sited RBS") != -1) {
            return _alarmInd.getAdditionalText();
        }
        return EMPTY_ADDITIONAL_TEXT;
    }

    private static boolean isAntennaShared(TmaDeviceMo mo) throws MoAccessException {
        ManagedObject[] reservedByList = mo.getReservedBy(null);
        for (int i = 0; i < reservedByList.length; ++i) {
            if (!(reservedByList[i] instanceof SectorMo) || !((SectorMo)reservedByList[i]).getMixedModeRadio(null)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isCascadedRETUsed(ManagedObject mo) throws MoAccessException {
        ManagedObject[] sectorByList;
        SectorAntennaMo sa = null;
        if (mo instanceof AscDeviceGroupMo) {
            AuxPlugInUnitMo piu = null;
            ManagedObject tempMo = ((AscDeviceGroupMo)mo).getParent();
            if (!(tempMo instanceof AuxPlugInUnitMo)) return false;
            piu = (AuxPlugInUnitMo)tempMo;
            tempMo = piu.getParent();
            if (!(tempMo instanceof SectorAntennaMo)) return false;
            sa = (SectorAntennaMo)tempMo;
        } else if (mo instanceof AntennaBranchMo) {
            ManagedObject tempMo = ((AntennaBranchMo)mo).getParent();
            if (!(tempMo instanceof SectorAntennaMo)) return false;
            sa = (SectorAntennaMo)tempMo;
        } else if (mo instanceof SectorAntennaMo) {
            sa = (SectorAntennaMo)mo;
        }
        if (sa == null || (sectorByList = sa.getReservedBy(null)) == null || sectorByList.length <= 0) return false;
        for (int i = 0; i < sectorByList.length; ++i) {
            ManagedObject[] externalByList;
            if (!(sectorByList[i] instanceof SectorMo) || (externalByList = ((SectorMo)sectorByList[i]).getReservedBy(null)) == null || externalByList.length <= 0) continue;
            for (int j = 0; j < externalByList.length; ++j) {
                if (!(externalByList[j] instanceof ExternalAntennaMo)) continue;
                return true;
            }
        }
        return false;
    }
}

