/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.autoconf.oss;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import se.ericsson.cello.ipoam.IpHostLinkMo;
import se.ericsson.cello.iptransport.IpInterfaceMo;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.wcdma.rbs.boam.common.log.AiMessageLog;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.smartmos.RbsConfigurationMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RbsConfigurationMo;

public class OssInformerHelper {
    private static final Class THIS_CLASS = OssInformerHelper.class;
    private final RbsConfigurationMo rbsConfigMo;
    private final MoRepository moRepository;

    public OssInformerHelper(RbsConfigurationMo rbsConfigMo) {
        this.rbsConfigMo = rbsConfigMo;
        this.moRepository = MoRepository.instance();
    }

    public String getOssAddress() throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "getOssAddress()");
        String address = ((RbsConfigurationMoImpl)this.rbsConfigMo).getOssCorbaNameServiceAddress(null);
        MessageLog.traceReturn(THIS_CLASS, "getOssAddress() - " + address);
        return address;
    }

    public String getOssNodeDiscoveryServiceName() {
        MessageLog.traceEnter(THIS_CLASS, "getOssNodeDiscoveryServiceName()");
        String name = "com/ericsson/nms/umts/ranos/WmaNodeDiscoveryUnsecure";
        if (this.isCorbaSecure()) {
            name = "com/ericsson/nms/umts/ranos/WmaNodeDiscovery";
        }
        MessageLog.traceReturn(THIS_CLASS, "getOssNodeDiscoveryServiceName() - " + name);
        return name;
    }

    public String getOssNodeIpAddressChangeServiceName() {
        MessageLog.traceEnter(THIS_CLASS, "getOssNodeIpAddressChangeServiceName()");
        String name = "/com/ericsson/nms/umts/ranos/WMANodeIPChangeUnsecure";
        if (this.isCorbaSecure()) {
            name = "/com/ericsson/nms/umts/ranos/WMANodeIPChange";
        }
        MessageLog.traceReturn(THIS_CLASS, "getOssNodeIpAddressChangeServiceName() - " + name);
        return name;
    }

    public String getOssNodeSecurityIntegrationServiceName(String ipAddress) {
        MessageLog.traceEnter(THIS_CLASS, "getOssNodeSecurityIntegrationServiceName(): ipAddress=" + ipAddress);
        String name = "com/ericsson/nms/umts/ranos/WmaNodeSecurity";
        if (!this.isCorbaSecure()) {
            name = "com/ericsson/nms/umts/ranos/WmaNodeSecurityUnsecure";
        }
        try {
            InetAddress validIpAddress = InetAddress.getByName(ipAddress);
            if (validIpAddress instanceof Inet6Address) {
                name = name + "V6";
            }
        }
        catch (UnknownHostException e) {
            MessageLog.traceError(THIS_CLASS, "Illegal ip address: " + ipAddress);
        }
        MessageLog.traceReturn(THIS_CLASS, "getOssNodeSecurityIntegrationServiceName() - " + name);
        return name;
    }

    public boolean isCorbaSecure() {
        boolean securityActive = false;
        try {
            ManagedObject securityMo = this.moRepository.lookup("ManagedElement=1,SystemFunctions=1,Security=1");
            Boolean corbaSecurityActive = null;
            if (securityMo != null) {
                corbaSecurityActive = (Boolean)securityMo.getAttribute("corbaSecurityActive", null);
            }
            securityActive = securityMo != null && corbaSecurityActive != null && corbaSecurityActive != false;
        }
        catch (MoAccessException mae) {
            AiMessageLog.traceError(this.getClass(), "MO Operation failure, Failed to retrieve the current security on the Corba Interface.");
        }
        return securityActive;
    }

    public static boolean oamConfigModeIsDhcp() {
        boolean oamConfigModeIsDhcp = false;
        MessageLog.trace(8, THIS_CLASS, "oamConfigModeIsDhcp start!");
        MoIterator moIter = BoamHelper.findMOs("IpHostLink");
        while (moIter.hasMoreElements()) {
            IpHostLinkMo ipHostLinkMo = (IpHostLinkMo)moIter.nextMo();
            ManagedObject ipInterfaceMo = null;
            try {
                if (ipHostLinkMo != null) {
                    MessageLog.trace(8, THIS_CLASS, "Get IpHostLink Mo!");
                    ipInterfaceMo = ipHostLinkMo.getIpInterfaceMoRef(null);
                }
            }
            catch (MoAccessException e) {
                MessageLog.traceError(THIS_CLASS, "Could not get ipInterfaceMoRef from ipHostLink MO instance.");
            }
            if (ipInterfaceMo == null || !(ipInterfaceMo instanceof IpInterfaceMo)) continue;
            int comfigMode = 0;
            IpInterfaceMo oamIpinterface = (IpInterfaceMo)ipInterfaceMo;
            try {
                MessageLog.trace(8, THIS_CLASS, "Get the configMode from ipInterface!");
                comfigMode = oamIpinterface.getConfigurationMode(null);
            }
            catch (MoAccessException e) {
                MessageLog.traceError(THIS_CLASS, "IpInterface MO is recovered.");
                e.printStackTrace();
            }
            MessageLog.trace(8, THIS_CLASS, "The configMode is: " + comfigMode);
            if (comfigMode != 1) continue;
            oamConfigModeIsDhcp = true;
            break;
        }
        return oamConfigModeIsDhcp;
    }
}

