/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.autoconf.smartmos;

import java.util.ArrayList;
import java.util.Date;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.cello.transaction.TransactionServiceImpl;
import se.ericsson.wcdma.rbs.boam.common.log.AiMessageLog;
import se.ericsson.wcdma.rbs.boam.common.log.StackDumper;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.smartmos.ActionCounterIdHandler;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.smartmos.ActionResult;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.smartmos.ActionResultObserver;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.smartmos.NbaCommand;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RbsConfigurationMo;

public class NbaHandler {
    private RbsConfigurationMo rbsConfigurationMo;
    private Control tx;
    private Coordinator c;
    private ArrayList actionResultObservers = new ArrayList(5);

    public NbaHandler(RbsConfigurationMo rbsConfigurationMo) {
        this.rbsConfigurationMo = rbsConfigurationMo;
    }

    public int handleNonBlocking(int invokedAction, NbaCommand nbaCommand) throws ValueOutOfRangeException, MoAccessException {
        int actionId = -1;
        AiMessageLog.traceEnter(this.getClass(), "handleNonBlocking() ");
        try {
            this.startTransaction();
            actionId = new ActionCounterIdHandler(this.rbsConfigurationMo).getNextActionId(this.c);
            this.endTransaction();
            this.startInThread(invokedAction, nbaCommand, actionId);
        }
        catch (TransactionRolledBackException e) {
            AiMessageLog.traceError(this.getClass(), "TransactionRolledBackException: " + e.getMessage());
        }
        catch (InactiveTransactionException e) {
            AiMessageLog.traceError(this.getClass(), "InactiveTransactionException: " + e.getMessage());
        }
        return actionId;
    }

    private boolean isInvokedActionValid(int invokedAction) {
        AiMessageLog.traceEnter(this.getClass(), "isInvokedActionValid() ");
        return invokedAction >= 1 && invokedAction <= 4;
    }

    protected void startInThread(final int invokedAction, final NbaCommand nbaCommand, final int actionId) {
        AiMessageLog.traceEnter(this.getClass(), "startInThread() ");
        Runnable r = new Runnable(){

            public void run() {
                NbaHandler.this.startAction(invokedAction, nbaCommand, actionId);
            }
        };
        Thread t = new Thread(r);
        t.start();
    }

    protected void startAction(int invokedAction, NbaCommand nbaCommand, int actionId) {
        ActionResult actionResult = null;
        AiMessageLog.traceEnter(this.getClass(), "startAction()");
        try {
            nbaCommand.execute();
            actionResult = this.checkIfConfigurationSucceeded(actionId, invokedAction);
        }
        catch (Throwable e) {
            AiMessageLog.traceError(this.getClass(), "Could not execute action", e);
            actionResult = this.createActionResult(actionId, "Could not execute action: " + StackDumper.stackDump(e), 2, invokedAction);
        }
        try {
            this.setActionResult(actionResult);
        }
        catch (ValueOutOfRangeException e) {
            AiMessageLog.traceError(this.getClass(), "Invoked action is out of range! Valid range: 1 - 4 but is: " + invokedAction, e);
        }
        catch (MoAccessException e) {
            AiMessageLog.traceError(this.getClass(), "Could not store actionResult", e);
        }
    }

    public ActionResult getActionResult(int actionId) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "getActionResult()");
        Struct[] actionResults = this.rbsConfigurationMo.getActionResult(this.c);
        if (actionResults != null) {
            for (int i = 0; i < actionResults.length; ++i) {
                Struct tmpActionResult = actionResults[i];
                if ((Integer)tmpActionResult.getValue("actionId") != actionId) continue;
                return ActionResult.fromStruct(tmpActionResult);
            }
        }
        return null;
    }

    private void setActionResult(ActionResult actionResult) throws ValueOutOfRangeException, MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "setActionResult()");
        if (!this.isInvokedActionValid(actionResult.getTypeOfInvokedAction())) {
            throw new ValueOutOfRangeException("typeOfInvokedAction", "RbsConfiguration");
        }
        try {
            Struct[] actionResults = this.rbsConfigurationMo.getActionResult(this.c);
            AiMessageLog.trace(2, this.getClass(), "before add, length of actionResults:" + actionResults.length);
            actionResults = new ActionResultStructQueueHelper().addActionResult((Struct)actionResult, actionResults);
            AiMessageLog.trace(2, this.getClass(), "after add, length of actionResults:" + actionResults.length);
            this.startTransaction();
            this.rbsConfigurationMo.setActionResult(actionResults, this.c);
            this.endTransaction();
            for (int i = 0; i < this.actionResultObservers.size(); ++i) {
                ActionResultObserver actionResultObserver = (ActionResultObserver)this.actionResultObservers.get(i);
                AiMessageLog.traceEnter(this.getClass(), "actionResultObserver.onResult() = " + actionResult.toString());
                actionResultObserver.onResult(actionResult);
            }
        }
        catch (MoAccessException e) {
            AiMessageLog.traceError(this.getClass(), "Error when trying to store actionResult", e);
        }
    }

    private ActionResult createActionResult(int actionId, String additionalInfo, int info, int invokedAction) {
        return new ActionResult(actionId, additionalInfo, info, new Date().toString(), invokedAction);
    }

    private ActionResult checkIfConfigurationSucceeded(int actionId, int invokedAction) {
        AiMessageLog.traceEnter(this.getClass(), "checkIfConfigurationSucceeded()");
        ActionResult actionResult = null;
        try {
            String msg = "";
            if (this.isConfigurationSuccessful(invokedAction)) {
                msg = "Done with " + this.invokedActionAsString(invokedAction) + "!";
                actionResult = this.createActionResult(actionId, msg, 0, invokedAction);
                AiMessageLog.trace(2, this.getClass(), msg);
            } else {
                msg = "Failed with " + this.invokedActionAsString(invokedAction) + "!";
                AiMessageLog.trace(2, this.getClass(), msg);
                actionResult = this.createActionResult(actionId, msg, 2, invokedAction);
            }
        }
        catch (MoAccessException e) {
            AiMessageLog.traceError(this.getClass(), "Could not get configurationLevel or configurationPhase", e);
            actionResult = this.createActionResult(actionId, "Could not get configurationLevel or configurationPhase: " + StackDumper.stackDump(e), 2, invokedAction);
        }
        return actionResult;
    }

    private boolean isConfigurationSuccessful(int invokedAction) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "isConfigurationSuccessful()");
        String rbsConfigPhase = this.rbsConfigurationMo.getRbsConfigPhase(this.c);
        int rbsConfigLevel = this.rbsConfigurationMo.getRbsConfigLevel(this.c);
        switch (invokedAction) {
            case 2: {
                return rbsConfigLevel == 2 && rbsConfigPhase.equals("Cabinet configuration completed");
            }
            case 3: {
                return rbsConfigLevel == 3 && rbsConfigPhase.equals("OaM configuration completed");
            }
            case 4: {
                return rbsConfigLevel >= 4 && rbsConfigPhase.equals("Site configuration completed");
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    private String invokedActionAsString(int invokedAction) {
        AiMessageLog.traceEnter(this.getClass(), "invokedActionAsString()");
        String invokedActionAsString = "";
        if (invokedAction == 1) {
            invokedActionAsString = "Active DHCP configuration";
        } else if (invokedAction == 2) {
            invokedActionAsString = "Active cabinet configuration";
        } else if (invokedAction == 3) {
            invokedActionAsString = "Active O&M configuration";
        } else if (invokedAction == 4) {
            invokedActionAsString = "Active site configuration";
        }
        return invokedActionAsString;
    }

    public void setActionResultObserver(ActionResultObserver actionResultObserver) {
        AiMessageLog.traceEnter(this.getClass(), "setActionResultObserver()");
        this.actionResultObservers.add(actionResultObserver);
    }

    protected ArrayList getActionResultObservers() {
        return this.actionResultObservers;
    }

    private void startTransaction() {
        try {
            this.tx = TransactionServiceImpl.instance().getTransactionFactory().create(0);
            this.c = this.tx.getCoordinator();
        }
        catch (TransactionRolledBackException e) {
            AiMessageLog.traceError(this.getClass(), "TransactionRolledBackException: failed to start transaction" + e.getMessage(), e);
        }
    }

    private void endTransaction() {
        try {
            this.tx.getTerminator().commit();
            this.c = null;
        }
        catch (TransactionRolledBackException e) {
            AiMessageLog.traceError(this.getClass(), "TransactionRolledBackException: failed to commit transaction" + e.getMessage(), e);
        }
        catch (InactiveTransactionException e) {
            AiMessageLog.traceError(this.getClass(), "InactiveTransactionException: failed to commit transaction" + e.getMessage(), e);
        }
    }

    protected static class ActionResultStructQueueHelper {
        public Struct[] addActionResult(Struct actionResult, Struct[] actionResultsStruct) {
            AiMessageLog.traceEnter(this.getClass(), "addActionResult: actionResultsStruct len = " + actionResultsStruct.length);
            if (actionResultsStruct.length == 4) {
                AiMessageLog.trace(2, this.getClass(), "actionResult struct is already max size, shift out oldest action result" + actionResultsStruct.length);
                this.stepQueue(actionResultsStruct);
            } else {
                Struct[] expandedActionResultsStruct = new Struct[actionResultsStruct.length + 1];
                System.arraycopy(actionResultsStruct, 0, expandedActionResultsStruct, 0, actionResultsStruct.length);
                actionResultsStruct = expandedActionResultsStruct;
            }
            return this.addLast(actionResult, actionResultsStruct);
        }

        private void stepQueue(Struct[] structQueue) {
            System.arraycopy(structQueue, 1, structQueue, 0, structQueue.length - 1);
        }

        private Struct[] addLast(Struct struct, Struct[] structQueue) {
            structQueue[structQueue.length - 1] = struct;
            return structQueue;
        }
    }
}

