/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.autoconf.smartmos;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import se.ericsson.cello.equipment.PlugInUnitMo;
import se.ericsson.cello.ipoam.DhcpMaoi;
import se.ericsson.cello.ipoam.EthernetLinkMo;
import se.ericsson.cello.ipoam.IpHostLinkMo;
import se.ericsson.cello.managedelement.ManagedElementMo;
import se.ericsson.cello.moframework.AccessControlHelper;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.BooleanAttribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructAttribute;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.Resource;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.cello.transaction.TransactionServiceImpl;
import se.ericsson.crbs.omf.common.logger.ConfigurationReportLoggerService;
import se.ericsson.wcdma.rbs.bem.common.config.configlogic.IntegrationTypeReporter;
import se.ericsson.wcdma.rbs.bem.common.config.configlogic.ProgressReporter;
import se.ericsson.wcdma.rbs.bem.common.config.configlogic.RbsNclFactory;
import se.ericsson.wcdma.rbs.bem.common.config.configlogic.RbsNodeConfigurationLogic;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalLog;
import se.ericsson.wcdma.rbs.boam.common.FtpUtil;
import se.ericsson.wcdma.rbs.boam.common.FtpUtilityException;
import se.ericsson.wcdma.rbs.boam.common.Strings;
import se.ericsson.wcdma.rbs.boam.common.log.AiMessageLog;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.common.xmlutil.RbsSummaryFileParsHelper;
import se.ericsson.wcdma.rbs.boam.common.xmlutil.XmlHelper;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.oss.OssInformer;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.oss.OssInformerFactory;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.oss.OssInformerHelper;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.oss.OssInformerStatusHandler;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.smartmos.ActionResult;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.smartmos.AiConfigurationImpl;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.smartmos.AutoIntegrationHandler;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.smartmos.ConfigurationVersionHelper;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.smartmos.DhcpOptionsReader;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.smartmos.NbaCommand;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.smartmos.NbaHandler;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.smartmos.RbsConfigurationIpHelper;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.smartmos.StateHandler;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.smartmos.geo.GeoLocationCheckHandler;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.smartmos.geo.GeoLocationCheckHandlerFactory;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.smartmos.geo.GeoLocationCheckHandlerImpl;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObject;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.enumer.RbsConfigurationConfigLevels;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.FileMissingOnServerException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.FtpServerNotAccessibleException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.InternalErrorException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.OperationFailedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.RbsConfigurationFailedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.struct.IpAddressInformationStruct;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RbsConfigurationMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RbsLocalCellMo;

public class RbsConfigurationMoImpl
extends BoamManagedObject
implements RbsConfigurationMo,
OssInformerStatusHandler {
    public static final int MO_DATA_REVISION = 6040700;
    public static final String CONFIG_REPORT_FILE_NAME = "config_report.txt";
    public static final int READY_FOR_SERVICE_CHECK_INTERVAL = 60000;
    public static final String NODE_ID_TYPE = "NodeIDType";
    public static final String NODE_ID_VALUE = "NodeIDValue";
    public static final int NODE_ID_MIN_LENGTH = 0;
    public static final int NODE_ID_TYPE_MAX_LENGTH = 20;
    public static final int NODE_ID_VALUE_MAX_LENGTH = 200;
    public static final String NODE_ID_TYPE_FDN = "FDN";
    private static String localAntennaSystemConfigPath = "/c/systemfiles/rbs/antenna_system_config/";
    private static final int RESTART_INFO_MAX_LENGTH = 80;
    private String[] diskCleanFiles = new String[]{"/c/pmd", "/c/logfiles/systemlog", "/c/logfiles/dspdumps", "/c/pi_data", "/c/tmp", "/c/usr", "/c/logs", "/c/public_html/cello/XML_files", "/c/public_html/pi_data", "/c/logfiles/CollectTraces.log.zip", "/c/logfiles/CollectTraces.log.gz"};
    private String localFilePathname = "/c/public_html/em/";
    private String localFileName = "tmp";
    private MoData myMoData;
    private StringAttribute strAttribute;
    private IntegerAttribute intAttribute;
    private NbaHandler nbaHandler;
    private OssInformer ossInformer;
    private GeoLocationCheckHandler geoLocationCheckHandler = null;
    private Map rbsConfigLevelToName;
    private Thread rbsConfigurationStateHandlerThread;
    private int integrationType = 0;
    static /* synthetic */ Class class$se$ericsson$wcdma$rbs$boam$mao$autoconf$smartmos$RbsConfigurationMoImpl;
    static /* synthetic */ Class class$se$ericsson$wcdma$rbs$boam$mao$autoconf$smartmos$RbsConfigurationMoImpl$RegisterTransactionResource;

    public RbsConfigurationMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData.getLocalDistinguishedName());
        this.myMoData = recoveredData;
        try {
            this.initTransientMoData();
        }
        catch (TransactionRequiredException e) {
            AiMessageLog.traceError(this.getClass(), "Could not initiate transianet attributes", e);
        }
        this.generateRbsConfigMap();
        AiMessageLog.trace(1, this.getClass(), "Recovery ready for RbsConfiguration");
    }

    public RbsConfigurationMoImpl(ManagedObject parent, String identity, Coordinator c) throws MoAccessException, MoNameAlreadyTakenException {
        super(parent, "RbsConfiguration", identity, c);
        this.initMoData(c);
        this.generateRbsConfigMap();
    }

    private void generateRbsConfigMap() {
        Field[] f = RbsConfigurationConfigLevels.class.getFields();
        this.rbsConfigLevelToName = new HashMap();
        for (int i = 0; i < f.length; ++i) {
            String name = f[i].getName();
            try {
                this.rbsConfigLevelToName.put(f[i].get(name), name);
                continue;
            }
            catch (Exception e) {
                AiMessageLog.traceError(this.getClass(), "Could not generate map for rbsConfigLevel", e);
            }
        }
    }

    public void delete(Coordinator c) throws MoAccessException {
        throw new UndeletableMoException((ManagedObject)this);
    }

    public MoData getMyMoData() {
        return this.myMoData;
    }

    public void setNbaHandler(NbaHandler nbaHandler) {
        this.nbaHandler = nbaHandler;
    }

    public boolean isMyMoDataPersistent() {
        return true;
    }

    public String getType() {
        return "RbsConfiguration";
    }

    public int actionActivateCabinetConfiguration(Coordinator c) throws MoAccessException, RbsConfigurationFailedException {
        AccessControlHelper.performAccessControl();
        AiMessageLog.traceEnter(this.getClass(), "actionActivateCabinetConfiguration()<--");
        final String cabinetConfigFile = this.getCabinetConfigFile(c);
        int actionId = -1;
        if (this.nbaHandler != null) {
            actionId = this.nbaHandler.handleNonBlocking(2, new NbaCommand(){

                public void execute() {
                    AiMessageLog.traceEnter(this.getClass(), "execute actionActivateCabinetConfiguration()");
                    RbsNclFactory.getRbsNcl((NalLog)AiMessageLog.getInstance(), (ProgressReporter)RbsConfigurationMoImpl.this, (IntegrationTypeReporter)RbsConfigurationMoImpl.this).performCabinetConfiguration(cabinetConfigFile);
                    AiMessageLog.info(this.getClass(), "Done with Cabinet configuration!");
                }
            });
        } else {
            AiMessageLog.traceError(this.getClass(), "nbaHandler is null, can not activate cabinet configuration");
        }
        return actionId;
    }

    public int actionActivateSiteConfiguration(Coordinator c) throws MoAccessException, RbsConfigurationFailedException {
        AccessControlHelper.performAccessControl();
        AiMessageLog.traceEnter(this.getClass(), "actionActivateSiteConfiguration()<--");
        final String siteConfigFile = this.getSiteConfigFile(c);
        int actionId = -1;
        if (this.nbaHandler != null) {
            actionId = this.nbaHandler.handleNonBlocking(4, new NbaCommand(){

                public void execute() {
                    AiMessageLog.traceEnter(this.getClass(), "execute actionActivateSiteConfiguration()");
                    RbsNclFactory.getRbsNcl((NalLog)AiMessageLog.getInstance(), (ProgressReporter)RbsConfigurationMoImpl.this, (IntegrationTypeReporter)RbsConfigurationMoImpl.this).performSiteConfiguration(siteConfigFile);
                    AiMessageLog.info(this.getClass(), "Done with Site configuration!!!!");
                    RbsConfigurationMoImpl.this.informOss(10, null);
                }
            });
        } else {
            AiMessageLog.traceError(this.getClass(), "nbaHandler is null, can not activate site configuration");
        }
        return actionId;
    }

    public void actionDeleteLogFile(Coordinator c) throws MoAccessException, RbsConfigurationFailedException {
        AiMessageLog.traceEnter(this.getClass(), "actionDeleteLogFile()<--");
        AccessControlHelper.performAccessControl();
        AiMessageLog.deleteLog(this.getType());
    }

    public Struct actionFetchDhcpConfiguration(Coordinator c) throws MoAccessException, RbsConfigurationFailedException {
        AiMessageLog.traceEnter(this.getClass(), "actionFetchDhcpConfiguration() Rev PA03<--");
        Struct dhcpStruct = this.getDhcpDataStruct(c);
        if (dhcpStruct == null) {
            AiMessageLog.trace(2, this.getClass(), "Cello returned Dhcp Struct is null !");
            MoIterator moIter = MoRepository.instance().lookupType("IpHostLink");
            if (moIter == null) {
                throw new RbsConfigurationFailedException("RbsConfigurationFailedException: Please check the configuration, no ipHostLink");
            }
            moIter = MoRepository.instance().lookupType("Dhcp");
            if (moIter == null) {
                throw new RbsConfigurationFailedException("RbsConfigurationFailedException: Please check the configuration, no DHCP");
            }
            throw new RbsConfigurationFailedException();
        }
        this.setEthernetIpAddress(this.validateAttribute("yourIpAddress", dhcpStruct.getValue("yourIpAddress")), c);
        this.validateAndSetDhcpOptions(dhcpStruct, c);
        return new IpAddressInformationStruct(this.getEthernetIpAddress(c), this.getEthernetSubnetMask(c));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean actionFileExistsOnSmrs(String ipAddress, String filePath, String userId, String password, Coordinator c) throws MoAccessException, FtpServerNotAccessibleException, OperationFailedException {
        AiMessageLog.traceEnter(this.getClass(), "actionFileExistsOnSmrs()");
        String tmpLocalFilePath = this.localFilePathname + this.localFileName;
        File localFile = null;
        try {
            localFile = new File(tmpLocalFilePath);
            try {
                FtpUtil.ftpGet(ipAddress, userId, password, filePath, localFile.getAbsolutePath());
            }
            catch (FileMissingOnServerException e) {
                boolean bl = false;
                Object var11_10 = null;
                if (localFile == null) return bl;
                if (!localFile.exists() || localFile.delete()) return bl;
                AiMessageLog.traceError(this.getClass(), "Unable to delete file: " + localFile.getAbsolutePath());
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            if (localFile == null || !localFile.exists() || localFile.delete()) throw throwable;
            AiMessageLog.traceError(this.getClass(), "Unable to delete file: " + localFile.getAbsolutePath());
            throw throwable;
        }
        Object var11_11 = null;
        if (localFile == null) return true;
        if (!localFile.exists() || localFile.delete()) return true;
        AiMessageLog.traceError(this.getClass(), "Unable to delete file: " + localFile.getAbsolutePath());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionFetchRbsConfigurationFiles(String userId, String password, Coordinator c) throws MoAccessException, RbsConfigurationFailedException {
        RbsSummaryFileParsHelper xmlParser = null;
        XmlHelper xmlHelper = null;
        try {
            AiMessageLog.traceEnter(this.getClass(), "actionFetchRbsConfigurationFiles()<--");
            String sumFilePath = this.getSummaryFileFilePath(c);
            File f = new File(this.localFilePathname + new File(this.getSummaryFileFilePath(c)).getName());
            this.getCofigurationFileFromFTP(this.getSmrsIpAddress(c), userId, password, this.getSummaryFileFilePath(c), f.getAbsolutePath());
            AiMessageLog.trace(2, this.getClass(), "Fetching of " + sumFilePath + " completed.");
            xmlHelper = new XmlHelper(f);
            this.setSummaryFile(xmlHelper.getXmlFileAsString(), c);
            xmlParser = new RbsSummaryFileParsHelper(f);
            String siteBasicFilePath = xmlParser.getSiteBasicFilePath();
            f = new File(siteBasicFilePath);
            String serverPath = xmlParser.getServerAddress();
            this.getCofigurationFileFromFTP(serverPath, userId, password, siteBasicFilePath, this.localFilePathname + f.getName());
            AiMessageLog.trace(2, this.getClass(), "Fetching of " + siteBasicFilePath + " completed.");
            xmlHelper = new XmlHelper(new File(this.localFilePathname + f.getName()));
            this.setOamConfigFile(xmlHelper.getXmlFileAsString(), c);
            String externalHwFilePath = xmlParser.getExternalHwFilePath();
            f = new File(externalHwFilePath);
            this.getCofigurationFileFromFTP(serverPath, userId, password, externalHwFilePath, this.localFilePathname + f.getName());
            AiMessageLog.trace(2, this.getClass(), "Fetching of " + externalHwFilePath + " completed.");
            xmlHelper = new XmlHelper(new File(this.localFilePathname + f.getName()));
            this.setSiteConfigFile(xmlHelper.getXmlFileAsString(), c);
        }
        finally {
            xmlParser = null;
            xmlHelper = null;
        }
    }

    public void actionStoreConfigurationReport(String ipAddress, String filePath, String userId, String password, Coordinator c) throws MoAccessException, RbsConfigurationFailedException {
        AccessControlHelper.performAccessControl();
        AiMessageLog.traceEnter(this.getClass(), "actionStoreConfigurationReport()<--");
        String configurationReportFilePath = ConfigurationReportLoggerService.getConfigurationReportLogger().getDefaultConfigurationReportPath();
        File configurationReportFile = new File(configurationReportFilePath);
        if (!configurationReportFile.exists()) {
            configurationReportFilePath = this.localFilePathname + CONFIG_REPORT_FILE_NAME;
            this.createConfigReportFile(configurationReportFilePath, this.getConfigurationReport(c));
        }
        try {
            FtpUtil.ftpPut(false, ipAddress, userId, password, configurationReportFilePath, filePath);
        }
        catch (FtpUtilityException e) {
            throw new RbsConfigurationFailedException("FTPException: " + e.getMessage());
        }
    }

    public int actionActivateDhcpConfiguration(final Coordinator c) throws MoAccessException, RbsConfigurationFailedException {
        AccessControlHelper.performAccessControl();
        AiMessageLog.traceEnter(this.getClass(), "actionActivateDhcpConfiguration()<--");
        int actionId = -1;
        if (this.nbaHandler != null) {
            actionId = this.nbaHandler.handleNonBlocking(1, new NbaCommand(){

                public void execute() {
                    AiMessageLog.traceEnter(this.getClass(), "execute actionActivateDhcpConfiguration()");
                    try {
                        RbsNclFactory.getRbsNcl((NalLog)AiMessageLog.getInstance(), (ProgressReporter)RbsConfigurationMoImpl.this).performDhcpConfiguration(RbsConfigurationMoImpl.this.getEthernetIpAddress(c), RbsConfigurationMoImpl.this.getEthernetSubnetMask(c), RbsConfigurationMoImpl.this.getDhcpIpAddress(c), RbsConfigurationMoImpl.this.getDnsIpAddress(c), RbsConfigurationMoImpl.this.getDefaultGateway(c));
                    }
                    catch (MoAccessException e) {
                        AiMessageLog.traceError(this.getClass(), "MoAccessException: " + e.getMessage());
                    }
                    AiMessageLog.info(this.getClass(), "Done with DHCP configuration!");
                }
            });
        } else {
            AiMessageLog.traceError(this.getClass(), "nbaHandler is null, can not activate Dhcp configuration");
        }
        return actionId;
    }

    public int actionActivateOaMConfiguration(Coordinator c) throws MoAccessException, RbsConfigurationFailedException {
        AccessControlHelper.performAccessControl();
        AiMessageLog.traceEnter(this.getClass(), "actionActivateOaMConfiguration()<--");
        final String oamConfigFile = this.getOamConfigFile(c);
        int actionId = -1;
        if (this.nbaHandler != null) {
            actionId = this.nbaHandler.handleNonBlocking(3, new NbaCommand(){

                public void execute() {
                    AiMessageLog.traceEnter(this.getClass(), "execute actionActivateOaMConfiguration()");
                    RbsNodeConfigurationLogic rbsNodeConfigurationLogic = RbsNclFactory.getRbsNcl((NalLog)AiMessageLog.getInstance(), (ProgressReporter)RbsConfigurationMoImpl.this, (IntegrationTypeReporter)RbsConfigurationMoImpl.this);
                    rbsNodeConfigurationLogic.performOamConfiguration(oamConfigFile);
                    AiMessageLog.info(class$se$ericsson$wcdma$rbs$boam$mao$autoconf$smartmos$RbsConfigurationMoImpl == null ? (class$se$ericsson$wcdma$rbs$boam$mao$autoconf$smartmos$RbsConfigurationMoImpl = RbsConfigurationMoImpl.class$("se.ericsson.wcdma.rbs.boam.mao.autoconf.smartmos.RbsConfigurationMoImpl")) : class$se$ericsson$wcdma$rbs$boam$mao$autoconf$smartmos$RbsConfigurationMoImpl, "Done with OaM configuration!!!!");
                }
            });
        } else {
            AiMessageLog.traceError(this.getClass(), "nbaHandler is null, can not activate oam configuration");
        }
        return actionId;
    }

    public void reportProgress(int progress, String message) {
        AiMessageLog.traceEnter(this.getClass(), "reportProgress()");
        try {
            this.setProgressLevel(progress, null);
            this.setProgressInformation(message, null);
            AiMessageLog.trace(2, this.getClass(), message + ", len:" + message.getBytes().length);
        }
        catch (Exception e) {
            AiMessageLog.traceError(this.getClass(), "reportProgress() is failed due exception:", e);
        }
    }

    public String getProgressInformation(Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "getProgressInformation()<--");
        return this.bcmGetStringAttribute("progressInformation", c);
    }

    public int getProgressLevel(Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "getProgressLevel()<--");
        return this.bcmGetIntAttribute("progressLevel", c);
    }

    public String getConfigFaultReason(Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "getConfigFaultReason()<--");
        return this.bcmGetStringAttribute("configFaultReason", c);
    }

    public String getConfigurationReport(Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "getConfigurationReport()<--");
        return this.bcmGetStringAttribute("configurationReport", c);
    }

    public String getDefaultGateway(Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "getDefaultGateway()<--\n DefaultGateway:" + this.bcmGetStringAttribute("defaultGateway", c));
        return this.bcmGetStringAttribute("defaultGateway", c);
    }

    public String getDhcpIpAddress(Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "getDhcpIpAddress()<--");
        return this.bcmGetStringAttribute("dhcpIpAddress", c);
    }

    public String getDnsIpAddress(Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "getDnsIpAddress()<--");
        return this.bcmGetStringAttribute("dnsIpAddress", c);
    }

    public String getEthernetIpAddress(Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "getEthernetIpAddress()<--");
        return this.bcmGetStringAttribute("ethernetIpAddress", c);
    }

    public String getEthernetSubnetMask(Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "getEthernetSubnetMask()<--");
        return this.bcmGetStringAttribute("ethernetSubnetMask", c);
    }

    public String getOamConfigFile(Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "getOamConfigFile()<--");
        return this.bcmGetStringAttribute("oamConfigFile", c);
    }

    public int getRbsConfigLevel(Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "getRbsConfigLevel()<--");
        return this.bcmGetIntAttribute("rbsConfigLevel", c);
    }

    public String getRbsLogicalName(Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "getRbsLogicalName()<--");
        return this.bcmGetStringAttribute("rbsLogicalName", c);
    }

    public String getSiteConfigFile(Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "getSiteConfigFile()<--");
        return this.bcmGetStringAttribute("siteConfigFile", c);
    }

    public String getSmrsIpAddress(Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "getSmrsIpAddress()<--");
        return this.bcmGetStringAttribute("smrsIpAddress", c);
    }

    public String getSummaryFile(Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "getSummaryFile()<--");
        return this.bcmGetStringAttribute("summaryFile", c);
    }

    public String getSummaryFileFilePath(Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "getSummaryFileFilePath()<--");
        return this.bcmGetStringAttribute("summaryFileFilePath", c);
    }

    public void setConfigFaultReason(String value, Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "setConfigFaultReason()<--");
        ValidateAttributes.checkTransaction(c);
        this.bcmSetStringAttribute("configFaultReason", value, 0, 128, "RbsConfiguration", c);
    }

    public void setConfigurationReport(String value, Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "setConfigurationReport()<--");
        ValidateAttributes.checkTransaction(c);
        this.bcmSetStringAttribute("configurationReport", value, 0, 65000, "RbsConfiguration", c);
    }

    public void setOamConfigFile(String value, Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "setOamConfigFile()<--");
        ValidateAttributes.checkTransaction(c);
        this.bcmSetStringAttribute("oamConfigFile", value, 0, 65000, "RbsConfiguration", c);
    }

    public void setRbsConfigLevel(int value, Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "setRbsConfigLevel( " + this.getRbsConfigLevelName(value) + " (" + value + ") ) <--");
        ValidateAttributes.checkTransaction(c);
        if (this.getRbsConfigLevel(c) == value) {
            AiMessageLog.trace(2, this.getClass(), "trying to set configlevel to current configlevel. No action taken.");
        } else if (this.isOssAttributesSet() && (value == 12 || value == 14)) {
            if (value == 12) {
                this.setConfigurationLevel(12, c);
                RegisterTransactionResource.register(c, new StateHandler(){

                    public void start() throws MoAccessException {
                        RbsConfigurationMoImpl.this.startRbsConfigurationStateHandler();
                    }
                });
            }
            this.setIntegrationType(0);
        } else if (value == 18) {
            this.setConfigurationLevel(18, c);
            this.startGeoLocationCheckHandler(3);
        } else {
            this.setConfigurationLevel(value, c);
        }
    }

    private void startRbsConfigurationStateHandler() throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "startRbsConfigurationStateHandler()<--");
        if (this.rbsConfigurationStateHandlerThread != null && this.rbsConfigurationStateHandlerThread.isAlive()) {
            AiMessageLog.trace(2, this.getClass(), "RbsConfigurationStateHandler thread is already executing");
            return;
        }
        this.rbsConfigurationStateHandlerThread = new Thread(){
            private Coordinator c = null;
            private Control tx = null;

            public void run() {
                AiMessageLog.traceEnter(this.getClass(), "startRbsConfigurationStateHandler in thread()<--");
                try {
                    if (RbsConfigurationMoImpl.this.getRbsConfigLevel(this.c) != 12) {
                        AiMessageLog.trace(2, this.getClass(), "rbsConfigLevel is not INTEGRATION_COMPLETE, will not perform ready for service check");
                        return;
                    }
                    boolean cellsUnlocked = false;
                    while (RbsConfigurationMoImpl.this.getRbsConfigLevel(this.c) == 12 && !cellsUnlocked) {
                        cellsUnlocked = RbsConfigurationMoImpl.this.readyForServiceCellCheck(this.c);
                        if (cellsUnlocked) continue;
                        AiMessageLog.trace(2, this.getClass(), "Cells are not available, will try again in 60 sec");
                        Thread.sleep(60000L);
                    }
                    if (cellsUnlocked) {
                        this.startTransaction();
                        RbsConfigurationMoImpl.this.setConfigurationLevel(14, this.c);
                        this.endTransaction();
                    } else {
                        AiMessageLog.trace(2, this.getClass(), "Cells are not unlocked, but rbsconfigLevel changed");
                    }
                }
                catch (MoAccessException e) {
                    this.handleMoOpException((Exception)((Object)e));
                }
                catch (TransactionRolledBackException e) {
                    AiMessageLog.traceError(this.getClass(), "Transaction has rolled back", e);
                }
                catch (InactiveTransactionException e) {
                    AiMessageLog.traceError(this.getClass(), "The transaction is inactive", e);
                }
                catch (InterruptedException e) {
                    AiMessageLog.traceError(this.getClass(), "Interrupted during sleep", e);
                }
            }

            private void handleMoOpException(Exception e) {
                try {
                    AiMessageLog.traceError(this.getClass(), "Mo operation failed", e);
                    RbsConfigurationMoImpl.this.setConfigFaultReason("failed to complete MO operation", this.c);
                }
                catch (MoAccessException e1) {
                    AiMessageLog.traceError(this.getClass(), e.getMessage());
                }
            }

            private void startTransaction() throws TransactionRolledBackException {
                this.tx = TransactionServiceImpl.instance().getTransactionFactory().create(0);
                this.c = this.tx.getCoordinator();
            }

            private void endTransaction() throws TransactionRolledBackException, InactiveTransactionException {
                this.tx.getTerminator().commit();
                this.c = null;
            }
        };
        this.rbsConfigurationStateHandlerThread.setName("RbsConfigurationStateHandler");
        this.rbsConfigurationStateHandlerThread.start();
    }

    private void setConfigurationLevel(int value, Coordinator c) throws MoAccessException, ValueOutOfRangeException {
        AiMessageLog.traceEnter(this.getClass(), "setConfigurationLevel()");
        this.bcmSetIntAttribute("rbsConfigLevel", value, 0, 18, "RbsConfiguration", c);
        this.sendAVC("rbsConfigLevel", value, c);
    }

    private boolean readyForServiceCellCheck(Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "readyForServiceCheck()<--");
        MoIterator moIter = BoamHelper.findMOs("RbsLocalCell");
        while (moIter.hasMoreElements()) {
            RbsLocalCellMo localcell = (RbsLocalCellMo)moIter.nextMo();
            if (localcell.getAvailabilityStatus(c) == 0) continue;
            AiMessageLog.traceError(this.getClass(), "Invalid availabilitystatus on cell: " + localcell.getFullDistinguishedName());
            return false;
        }
        return true;
    }

    public void setRbsLogicalName(String value, Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "setRbsLogicalName()<--");
        ValidateAttributes.checkTransaction(c);
        this.bcmSetStringAttribute("rbsLogicalName", value, 0, 128, "RbsConfiguration", c);
    }

    public void setSiteConfigFile(String value, Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "setSiteConfigFile()<--");
        ValidateAttributes.checkTransaction(c);
        this.bcmSetStringAttribute("siteConfigFile", value, 0, 65000, "RbsConfiguration", c);
    }

    public void setSmrsIpAddress(String value, Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "setSmrsIpAddress()<--");
        this.setTransientStringAttribute("smrsIpAddress", value, 128, "RbsConfiguration");
    }

    public void setSummaryFile(String value, Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "setSummaryFile()<--");
        this.setTransientStringAttribute("summaryFile", value, 65000, "RbsConfiguration");
    }

    public void setSummaryFileFilePath(String value, Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "setSummaryFileFilePath()<--");
        this.setTransientStringAttribute("summaryFileFilePath", value, 128, "RbsConfiguration");
    }

    private String validateAttribute(String attrName, Object attrValue) {
        AiMessageLog.traceEnter(this.getClass(), "validateAttribute()<--");
        if (attrValue == null) {
            AiMessageLog.info(this.getClass(), "WARNING : attribute " + attrName + " is null ; setting empty string");
            return "";
        }
        return (String)attrValue;
    }

    private void validateAndSetDhcpOptions(Struct dhcpStruct, Coordinator c) throws MoAccessException {
        int[] dhcpOptions = (int[])dhcpStruct.getValue("dhcpOptions");
        DhcpOptionsReader dhcpOptionsReader = null;
        if (dhcpOptions == null || dhcpOptions.length == 0) {
            StringBuffer log = new StringBuffer();
            log.append("WARNING : dhcpOptions is null or empty ; setting default values for attributes ");
            log.append("ethernetSubnetMask").append(",");
            log.append("dhcpIpAddress").append(",");
            log.append("dnsIpAddress").append(",");
            log.append("defaultGateway").append(",");
            log.append("smrsIpAddress").append(",");
            log.append("summaryFileFilePath");
            AiMessageLog.info(this.getClass(), log.toString());
            this.setEthernetSubnetMask("", c);
            this.setDhcpIpAddress("", c);
            this.setDnsIpAddress("", c);
            this.setDefaultGateway("", c);
            this.setSmrsIpAddress("", c);
            this.setSummaryFileFilePath("", c);
        } else {
            dhcpOptionsReader = new DhcpOptionsReader(dhcpOptions);
            this.setEthernetSubnetMask(dhcpOptionsReader.getSubnetMask(), c);
            this.setDhcpIpAddress(dhcpOptionsReader.getDhcpIpAddress(), c);
            String dhcpDNS = dhcpOptionsReader.getDnsIpAddress();
            StringBuffer dns = new StringBuffer();
            int addressPoint = 0;
            for (int i = 0; i < dhcpDNS.length(); ++i) {
                if (String.valueOf(dhcpDNS.charAt(i)).equalsIgnoreCase(".")) {
                    ++addressPoint;
                }
                if (addressPoint == 4) break;
                dns.append(dhcpDNS.charAt(i));
            }
            this.setDnsIpAddress(dns.toString(), c);
            String defGateway = dhcpOptionsReader.getDefaultGateway();
            StringBuffer gw = new StringBuffer();
            addressPoint = 0;
            for (int i = 0; i < defGateway.length(); ++i) {
                if (String.valueOf(defGateway.charAt(i)).equalsIgnoreCase(".")) {
                    ++addressPoint;
                }
                if (addressPoint == 4) break;
                gw.append(defGateway.charAt(i));
            }
            this.setDefaultGateway(gw.toString(), c);
            this.setSmrsIpAddress(dhcpOptionsReader.getSmrsIpAddress(), c);
            this.setSummaryFileFilePath(dhcpOptionsReader.getSummaryAbsolutePathname(), c);
        }
    }

    private void initTransientMoData() throws TransactionRequiredException {
        this.strAttribute = new StringAttribute("ethernetIpAddress", false, "");
        this.myMoData.registerTransientAttr((Attribute)this.strAttribute);
        this.strAttribute = new StringAttribute("ethernetSubnetMask", false, "");
        this.myMoData.registerTransientAttr((Attribute)this.strAttribute);
        this.strAttribute = new StringAttribute("smrsIpAddress", false, "");
        this.myMoData.registerTransientAttr((Attribute)this.strAttribute);
        this.strAttribute = new StringAttribute("summaryFileFilePath", false, "");
        this.myMoData.registerTransientAttr((Attribute)this.strAttribute);
        this.strAttribute = new StringAttribute("dhcpIpAddress", false, "");
        this.myMoData.registerTransientAttr((Attribute)this.strAttribute);
        this.strAttribute = new StringAttribute("dnsIpAddress", false, "");
        this.myMoData.registerTransientAttr((Attribute)this.strAttribute);
        this.strAttribute = new StringAttribute("defaultGateway", false, "");
        this.myMoData.registerTransientAttr((Attribute)this.strAttribute);
        this.strAttribute = new StringAttribute("summaryFile", false, "");
        this.myMoData.registerTransientAttr((Attribute)this.strAttribute);
        this.strAttribute = new StringAttribute("progressInformation", false, "");
        this.myMoData.registerTransientAttr((Attribute)this.strAttribute);
        this.intAttribute = new IntegerAttribute("progressLevel", false, 0);
        this.myMoData.registerTransientAttr((Attribute)this.intAttribute);
        this.intAttribute = new IntegerAttribute("nlhStatus", false, 0);
        this.myMoData.registerTransientAttr((Attribute)this.intAttribute);
        this.strAttribute = new StringAttribute("rollbackCvName", false, " ");
        this.myMoData.registerTransientAttr((Attribute)this.strAttribute);
    }

    private void initMoData(Coordinator c) throws MoAccessException, TransactionRequiredException {
        AiMessageLog.traceEnter(this.getClass(), "initMoData()<--");
        this.myMoData = new MoData(this.getLocalDistinguishedName(), this.getType(), true, c);
        this.myMoData.registerPersistentAttr((Attribute)new StringAttribute("rbsLogicalName", false, ""));
        this.myMoData.registerPersistentAttr((Attribute)new IntegerAttribute("actionIdCounter", false, 0));
        this.myMoData.registerPersistentAttr((Attribute)new StringAttribute("rbsConfigPhase", false, ""));
        this.myMoData.registerPersistentAttr((Attribute)new IntegerAttribute("lmtPortsState", false, 1));
        this.myMoData.registerPersistentAttr((Attribute)new BooleanAttribute("lmtPortsDisableFunction", false, false));
        this.myMoData.registerPersistentAttr((Attribute)new StringAttribute("networkLoaderHandoverFile", false, ""));
        this.myMoData.registerPersistentAttr((Attribute)new StringAttribute("ossCorbaNameServiceAddress", false, ""));
        this.myMoData.registerPersistentAttr((Attribute)new IntegerAttribute("ossCorbaNameServicePort", false, 0));
        this.myMoData.registerPersistentAttr((Attribute)new StringAttribute("configFaultReason", false, ""));
        this.myMoData.registerPersistentAttr((Attribute)new StringAttribute("configurationReport", false, ""));
        this.myMoData.registerPersistentAttr((Attribute)new StringAttribute("cabinetConfigFile", false, ""));
        this.myMoData.registerPersistentAttr((Attribute)new StringAttribute("oamConfigFile", false, ""));
        this.myMoData.registerPersistentAttr((Attribute)new StringAttribute("siteConfigFile", false, ""));
        this.myMoData.registerPersistentAttr((Attribute)new StringAttribute("progressReport", false, ""));
        this.myMoData.registerPersistentAttr((Attribute)new IntegerAttribute("rbsConfigLevel", true, 0));
        this.myMoData.registerPersistentAttr((Attribute)new SequenceAttribute("actionResult", false));
        StructAttribute wantedPositionValue = new StructAttribute("wantedPosition", false);
        wantedPositionValue.addElement((Attribute)new StringAttribute("altitude", false, ""));
        wantedPositionValue.addElement((Attribute)new StringAttribute("latitude", false, ""));
        wantedPositionValue.addElement((Attribute)new StringAttribute("longitude", false, ""));
        wantedPositionValue.addElement((Attribute)new IntegerAttribute("tolerance", false, 50));
        this.myMoData.registerPersistentAttr((Attribute)wantedPositionValue);
        this.myMoData.handleTransaction(c, MoData.WRITE_ACCESS);
        this.initTransientMoData();
    }

    public void registerNodeIdAttributes(Coordinator c) {
        MessageLog.info(this.getClass(), "enter registerNodeIdAttributes");
        MessageLog.info(this.getClass(), "return registerNodeIdAttributes");
    }

    private void setProgressInformation(String value, Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "setProgressInformation()<--");
        this.setTransientStringAttribute("progressInformation", value, 128, "RbsConfiguration");
    }

    private void setProgressLevel(int value, Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "setProgressLevel()<--");
        this.setTransientIntAttribute("progressLevel", value, RbsConfigurationMo.PROGRESS_LEVEL_MIN_VALUES, RbsConfigurationMo.PROGRESS_LEVEL_MAX_VALUES, "RbsConfiguration");
    }

    private void setDefaultGateway(String value, Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "setDefaultGateway()<--");
        this.setTransientStringAttribute("defaultGateway", value, 128, "RbsConfiguration");
    }

    private void setDhcpIpAddress(String value, Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "setDhcpIpAddress()<--");
        this.setTransientStringAttribute("dhcpIpAddress", value, 128, "RbsConfiguration");
    }

    private void setDnsIpAddress(String value, Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "setDnsIpAddress()<--");
        this.setTransientStringAttribute("dnsIpAddress", value, 128, "RbsConfiguration");
    }

    private void setEthernetIpAddress(String value, Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "setEthernetIpAddress()<--");
        this.setTransientStringAttribute("ethernetIpAddress", value, 128, "RbsConfiguration");
    }

    private void setEthernetSubnetMask(String value, Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "setEthernetSubnetMask()<--");
        this.setTransientStringAttribute("ethernetSubnetMask", value, 128, "RbsConfiguration");
    }

    private Struct getDhcpDataStruct(Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "getOneDhcpData()<--");
        IpHostLinkMo iphostLinkMo = null;
        MoIterator moIter = MoRepository.instance().lookupType("IpHostLink");
        if (moIter == null || moIter.size() == 0) {
            return null;
        }
        iphostLinkMo = (IpHostLinkMo)moIter.nextMo();
        AiMessageLog.trace(2, this.getClass(), "Lookup of IpHostLinkMo done");
        DhcpMaoi dhcp = null;
        moIter = MoRepository.instance().lookupType("Dhcp");
        if (moIter == null || moIter.size() == 0) {
            return null;
        }
        dhcp = (DhcpMaoi)moIter.nextMo();
        int nrOfDhcpOptions = 6;
        int[] dhcpOptions = new int[]{67, 6, 54, 1, 66, 3};
        AiMessageLog.trace(2, this.getClass(), "Sending DHCP Req with params:\n. nrOfDhcpOptions:6, oprions:67,6,54,1,66,3, RBS logical name:" + this.getRbsLogicalName(c) + ", InterfaceName:" + iphostLinkMo.getInterfaceName(c));
        return dhcp.actionGetDhcpData(6, dhcpOptions, this.getRbsLogicalName(c), iphostLinkMo.getInterfaceName(c), c);
    }

    private void createConfigReportFile(String filePath, String configReport) {
        AiMessageLog.traceEnter(this.getClass(), "createConfigReportFile(), file: " + filePath + ", config report: " + configReport);
        File tmpDir = new File(this.localFilePathname);
        String failure = "Failed to create temp configuration report file: ";
        try {
            if (!tmpDir.exists() && !tmpDir.mkdir()) {
                AiMessageLog.traceError(this.getClass(), "Failed to create temp configuration report file:  failed to create directory: " + tmpDir);
                return;
            }
        }
        catch (SecurityException e) {
            AiMessageLog.traceError(this.getClass(), "Failed to create temp configuration report file:  failed to create directory: " + tmpDir, e);
            return;
        }
        try {
            PrintStream out = new PrintStream(new FileOutputStream(filePath));
            out.print(configReport);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            AiMessageLog.traceError(this.getClass(), "Failed to create temp configuration report file: " + filePath + " due to exception!!: ", e);
        }
    }

    protected void setTransientStringAttribute(String attrName, String value, int maxLength, String thisTypeName) throws MoAccessException, ValueOutOfRangeException {
        AiMessageLog.traceEnter(this.getClass(), " setTransientStringAttribute() " + attrName);
        if (value.length() > maxLength) {
            String msg = attrName + " attribute has value out of range; string length should be =< " + Integer.toString(maxLength);
            AiMessageLog.traceParam(this.getClass(), msg);
            throw new ValueOutOfRangeException(msg, thisTypeName);
        }
        StringAttribute attribute = (StringAttribute)this.myMoData.getAttribute(attrName);
        attribute.setValue(value);
    }

    protected void setTransientIntAttribute(String attrName, int value, int[] minValues, int[] maxValues, String thisTypeName) throws MoAccessException, ValueOutOfRangeException {
        AiMessageLog.traceEnter(this.getClass(), " setTransientIntAttribute() " + attrName);
        ValidateAttributes.intValueRangeCheck(attrName, value, minValues, maxValues, thisTypeName);
        IntegerAttribute attribute = (IntegerAttribute)this.myMoData.getAttribute(attrName);
        attribute.setValue(value);
    }

    protected void setTransientIntAttribute(String attrName, int value, int minValue, int maxValue, String thisTypeName) throws MoAccessException, ValueOutOfRangeException {
        this.setTransientIntAttribute(attrName, value, new int[]{minValue}, new int[]{maxValue}, thisTypeName);
    }

    public void _setlocalFilePathname_ForTestOnly(String value) {
        this.localFilePathname = value;
    }

    public void _setLocalFileName_ForTestOnly(String value) {
        this.localFileName = value;
    }

    public static void _setlocallocalAntennaSystemConfigPathName_ForTestOnly(String value) {
        localAntennaSystemConfigPath = value;
    }

    public void actionDiskClean(Coordinator c) throws MoAccessException, InternalErrorException {
        AccessControlHelper.performAccessControl();
        for (int i = 0; i < this.diskCleanFiles.length; ++i) {
            File file = new File(this.diskCleanFiles[i]);
            RbsConfigurationMoImpl.cleanFile(file);
        }
    }

    private static boolean cleanFile(File file) {
        return RbsConfigurationMoImpl.deleteFileTree(file, file.isDirectory());
    }

    private static boolean deleteFileTree(File file, boolean keep) {
        if (file.isDirectory()) {
            String[] children = file.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = RbsConfigurationMoImpl.deleteFileTree(new File(file, children[i]), false);
                if (success) continue;
                return false;
            }
        }
        return keep || file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionFetchAntennaSystemConfigurationFiles(String userId, String password, Coordinator c) throws MoAccessException, RbsConfigurationFailedException {
        RbsSummaryFileParsHelper xmlParser = null;
        XmlHelper xmlHelper = null;
        try {
            AiMessageLog.traceEnter(this.getClass(), "actionFetchAntennaSystemConfigurationFiles()<--");
            String sumFilePath = this.getSummaryFileFilePath(c);
            File f = new File(this.localFilePathname + new File(sumFilePath).getName());
            this.getCofigurationFileFromFTP(this.getSmrsIpAddress(c), userId, password, sumFilePath, f.getAbsolutePath());
            AiMessageLog.trace(2, this.getClass(), "Fetching of " + sumFilePath + " completed.");
            xmlHelper = new XmlHelper(f);
            this.setSummaryFile(xmlHelper.getXmlFileAsString(), c);
            xmlParser = new RbsSummaryFileParsHelper(f);
            String serverPath = xmlParser.getServerAddress();
            List antennaSystemConfigFileNameList = xmlParser.getAntennaSystemConfigurationFileName();
            for (int i = 0; i < antennaSystemConfigFileNameList.size(); ++i) {
                String antennaSystemConfigFileNameString = (String)antennaSystemConfigFileNameList.get(i);
                String[] antennaSystemConfigFileName = Strings.split(antennaSystemConfigFileNameString, ",");
                for (int j = 0; j < antennaSystemConfigFileName.length; ++j) {
                    f = new File(antennaSystemConfigFileName[j]);
                    this.getCofigurationFileFromFTP(serverPath, userId, password, antennaSystemConfigFileName[j], localAntennaSystemConfigPath + f.getName());
                    AiMessageLog.trace(2, this.getClass(), "Fetching of " + antennaSystemConfigFileName[j] + " completed.");
                }
            }
        }
        finally {
            xmlParser = null;
            xmlHelper = null;
        }
    }

    public static String getLocAntSysConfig() {
        return localAntennaSystemConfigPath;
    }

    private void getCofigurationFileFromFTP(String remote_host, String username, String pwd, String remote_path, String local_path) throws RbsConfigurationFailedException {
        try {
            FtpUtil.ftpGet(remote_host, username, pwd, remote_path, local_path);
        }
        catch (OperationFailedException e) {
            throw new RbsConfigurationFailedException("Failed to get file: " + e.getMessage());
        }
        catch (FileMissingOnServerException e) {
            throw new RbsConfigurationFailedException("Failed to get file: " + e.getMessage());
        }
        catch (FtpServerNotAccessibleException e) {
            throw new RbsConfigurationFailedException("Failed to get file: " + e.getMessage());
        }
    }

    public String getRbsConfigPhase(Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "getRbsConfigPhase()");
        return this.bcmGetStringAttribute("rbsConfigPhase", c);
    }

    public void setRbsConfigPhase(String value, Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "setRbsConfigPhase() value = " + value);
        ValidateAttributes.checkTransaction(c);
        this.bcmSetStringAttribute("rbsConfigPhase", value, 0, 128, this.getType(), c);
    }

    public String getCabinetConfigFile(Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "getCabinetConfigFile()<--");
        return this.bcmGetStringAttribute("cabinetConfigFile", c);
    }

    public void setCabinetConfigFile(String value, Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "setCabinetConfigFile()<--");
        ValidateAttributes.checkTransaction(c);
        this.bcmSetStringAttribute("cabinetConfigFile", value, 0, 65000, "RbsConfiguration", c);
    }

    public String getOssCorbaNameServiceAddress(Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "getOssCorbaNameServiceAddress()");
        return this.bcmGetStringAttribute("ossCorbaNameServiceAddress", c);
    }

    public boolean isOssAttributesSet() throws MoAccessException {
        return this.getOssCorbaNameServiceAddress(null).length() > 0 && this.getOssCorbaNameServicePort(null) > 0;
    }

    public void startAiHandler() {
        AiMessageLog.traceEnter(this.getClass(), "startAiHandler()");
        this.nbaHandler = new NbaHandler(this);
        AutoIntegrationHandler aiHandler = new AutoIntegrationHandler(this, new AiConfigurationImpl(), this.nbaHandler);
        try {
            Control tx = TransactionServiceImpl.instance().getTransactionFactory().create(0);
            Coordinator c = tx.getCoordinator();
            int configLevel = this.getRbsConfigLevel(c);
            if (configLevel == 0) {
                this.setRbsConfigLevel(1, c);
            }
            tx.getTerminator().commit();
            aiHandler.performConfigurationIfNeeded();
        }
        catch (MoAccessException e) {
            AiMessageLog.traceError(this.getClass(), "Could not perform the configuration", e);
        }
        catch (TransactionRolledBackException e) {
            AiMessageLog.traceError(this.getClass(), "TransactionRolledBackException : Problem with setting rbsConfigLevel", e);
        }
        catch (InactiveTransactionException e) {
            AiMessageLog.traceError(this.getClass(), "Could not commit transaction when trying to set rbsConfigLevel", e);
        }
    }

    public Struct getWantedPosition(Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "getWantedPosition()");
        return this.bcmGetStructAttribute("wantedPosition", c);
    }

    public void setWantedPosition(Struct value, Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "setWantedPosition()");
        ValidateAttributes.checkTransaction(c);
        GeoLocationCheckHandlerImpl.validateGeoPosition(value);
        this.bcmSetStructAttribute("wantedPosition", value, c);
        AiMessageLog.trace(2, this.getClass(), "IntegrationType is : " + this.getIntegrationType());
        if (this.getIntegrationType() != 1) {
            RegisterTransactionResource.register(c, new StateHandler(){

                public void start() throws MoAccessException {
                    RbsConfigurationMoImpl.this.startGeoLocationCheckHandler(2);
                }
            });
        }
    }

    public String getRollbackCvName(Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "getRollbackCvName()");
        return this.bcmGetStringAttribute("rollbackCvName", c);
    }

    public int getLmtPortsState(Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "getLmtPortsState()");
        return this.bcmGetIntAttribute("lmtPortsState", c);
    }

    public void setLmtPortsState(int value, Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "setLmtPortsState()");
        ValidateAttributes.checkTransaction(c);
        this.bcmSetIntAttribute("lmtPortsState", value, 0, 1, "RbsConfiguration", c);
    }

    public void setOssCorbaNameServiceAddress(String value, Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "setOssCorbaNameServiceAddress()");
        ValidateAttributes.checkTransaction(c);
        this.bcmSetStringAttribute("ossCorbaNameServiceAddress", value, Integer.MIN_VALUE, Integer.MAX_VALUE, "RbsConfiguration", c);
    }

    public int getOssCorbaNameServicePort(Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "getOssCorbaNameServicePort()");
        return this.bcmGetIntAttribute("ossCorbaNameServicePort", c);
    }

    public void setOssCorbaNameServicePort(int value, Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "setOssCorbaNameServicePort()");
        ValidateAttributes.checkTransaction(c);
        this.bcmSetIntAttribute("ossCorbaNameServicePort", value, RbsConfigurationMo.OSS_CORBA_NAME_SERVICE_PORT_MIN_VALUES, RbsConfigurationMo.OSS_CORBA_NAME_SERVICE_PORT_MAX_VALUES, "RbsConfiguration", c);
    }

    public Struct[] getActionResult(Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "getActionResult()");
        Attribute[] attributes = this.bcmGetSequenceAttribute("actionResult", c);
        Struct[] actionResults = new Struct[attributes.length];
        for (int i = 0; i < attributes.length; ++i) {
            Attribute attr = attributes[i];
            if (attr == null) continue;
            StructAttribute struct = (StructAttribute)attr;
            actionResults[i] = ActionResult.convertStructAttributeToActionResultStruct(struct, c);
        }
        return actionResults;
    }

    public void setActionResult(Struct[] value, Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "setActionResult(...)");
        if (value != null) {
            ValidateAttributes.checkTransaction(c);
            Attribute[] attributes = new Attribute[value.length];
            for (int i = 0; i < value.length; ++i) {
                attributes[i] = ActionResult.convertStructToStructAttribute(value[i]);
            }
            this.bcmSetSequenceAttribute("actionResult", attributes, 4, this.getType(), c);
        } else {
            AiMessageLog.trace(2, this.getClass(), "Value is null in setActionResult!");
        }
    }

    public String getProgressReport(Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "getProgressReport()");
        return this.bcmGetStringAttribute("progressReport", c);
    }

    public void setProgressReport(String value, Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "setProgressReport()");
        ValidateAttributes.checkTransaction(c);
        this.bcmSetStringAttribute("progressReport", value, 0, 65000, "RbsConfiguration", c);
    }

    public String getNetworkLoaderHandoverFile(Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "getNetworkLoaderHandoverFile");
        return this.bcmGetStringAttribute("networkLoaderHandoverFile", c);
    }

    public void setNetworkLoaderHandoverFile(String value, Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "getNetworkLoaderHandoverFile()");
        ValidateAttributes.checkTransaction(c);
        this.bcmSetStringAttribute("networkLoaderHandoverFile", value, 0, 65000, "RbsConfiguration", c);
    }

    public int getNlhStatus(Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "getNlhStatus()");
        return this.bcmGetIntAttribute("nlhStatus", c);
    }

    public void setNlhStatusValue(int value) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "setNlhStatus()");
        this.setTransientIntAttribute("nlhStatus", value, 0, 1, "RbsConfiguration");
    }

    public void setRbCvName(String value) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "setRollbackCvName()");
        this.setTransientStringAttribute("rollbackCvName", value, 40, "RbsConfiguration");
    }

    public boolean getLmtPortsDisableFunction(Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "getLmtPortsDisableFunction()");
        return this.bcmGetBooleanAttribute("lmtPortsDisableFunction", c);
    }

    public void setLmtPortsDisableFunction(boolean value, Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "setLmtPortsDisableFunction()");
        ValidateAttributes.checkTransaction(c);
        this.bcmSetBooleanAttribute("lmtPortsDisableFunction", value, "RbsConfiguration", c);
    }

    public void actionCancelRbsIntegration(Coordinator c) throws MoAccessException, OperationFailedException {
        String rollbackCvName;
        AccessControlHelper.performAccessControl();
        AiMessageLog.traceEnter(this.getClass(), "actionCancelRbsIntegration()");
        if (this.getIntegrationType() == 1) {
            int currentConfigLevel = this.getRbsConfigLevel(c);
            if (5 == currentConfigLevel || 6 == currentConfigLevel) {
                throw new RbsConfigurationFailedException("AutoIntegration can not be cancelled. Node already in contact with OSS.");
            }
            ConfigurationVersionHelper configurationVersionHelper = new ConfigurationVersionHelper();
            rollbackCvName = this.getRollbackCvName(c);
            if (!configurationVersionHelper.isCvInStoredConfigurationVersionsAndHasStatusOk(rollbackCvName)) {
                throw new RbsConfigurationFailedException("Can't execute action! The rollback CV is missing in the stored configuration versions list in the ConfigurationVersion MO");
            }
        } else {
            throw new RbsConfigurationFailedException("Can't execute action! The auto integration has to be ongoing to execute actionCancelRbsIntegration");
        }
        this.initiateRollback(rollbackCvName, "Cancel ongoing autointegration", c);
    }

    public int getActionCounterId(Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "getActionCounterId()");
        return this.bcmGetIntAttribute("actionIdCounter", c);
    }

    public void setActionCounterId(int actionId, Coordinator c) throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "setActionCounterId()");
        ValidateAttributes.checkTransaction(c);
        this.bcmSetIntAttribute("actionIdCounter", actionId, 1, Integer.MAX_VALUE, "RbsConfiguration", c);
    }

    private boolean isOssParamsReady(Coordinator c) {
        AiMessageLog.traceEnter(this.getClass(), "isOssParamsReady()<--");
        String ossNameServerAddress = "";
        int port = 0;
        try {
            ossNameServerAddress = this.getOssCorbaNameServiceAddress(c);
            port = this.getOssCorbaNameServicePort(c);
        }
        catch (MoAccessException e) {
            AiMessageLog.info(this.getClass(), "Could not find necessary information needed in order to inform OSS!");
        }
        return !"".equals(ossNameServerAddress) && port != 0;
    }

    private OssInformer getOssInformer() {
        AiMessageLog.traceEnter(this.getClass(), "getOssInformer()");
        if (this.ossInformer == null) {
            this.ossInformer = OssInformerFactory.createOssInformer(this);
        }
        return this.ossInformer;
    }

    private static String getOamIpAddress(Coordinator c) throws MoAccessException {
        RbsConfigurationIpHelper ipHelper = new RbsConfigurationIpHelper();
        return ipHelper.getOamIpAddress(c);
    }

    public void informOss(int maxNumRetries, Coordinator c) {
        block7: {
            AiMessageLog.traceEnter(this.getClass(), "informOss()<--");
            if (this.isOssParamsReady(c)) {
                try {
                    String ipAddress = RbsConfigurationMoImpl.getOamIpAddress(c);
                    if ("".equals(ipAddress)) break block7;
                    String nodeId = BoamHelper.getNodeFdn(c);
                    this.ossInformer = this.getOssInformer();
                    if (nodeId != null && !"".equals(nodeId)) {
                        if (OssInformerHelper.oamConfigModeIsDhcp()) {
                            this.ossInformer.nodeAddressChanged(nodeId, ipAddress, maxNumRetries);
                        } else {
                            this.ossInformer.ossNodeUp(this, ipAddress, maxNumRetries);
                        }
                        break block7;
                    }
                    this.ossInformer.ossNodeUp(this, ipAddress, maxNumRetries);
                }
                catch (MoAccessException e) {
                    AiMessageLog.info(this.getClass(), "Could not find necessary information needed in order to inform OSS!");
                }
            } else {
                AiMessageLog.info(this.getClass(), "Oss corba name service is not set in RbsConfiguration MO, will give up informing OSS.");
            }
        }
    }

    public void informOssOnRestart(int maxNumRetries, Coordinator c) {
        AiMessageLog.traceEnter(this.getClass(), "informOssOnRestart()");
        if (this.isOssParamsReady(c)) {
            try {
                String ipAddress = RbsConfigurationMoImpl.getOamIpAddress(c);
                if (!"".equals(ipAddress)) {
                    String nodeId = BoamHelper.getNodeFdn(c);
                    AiMessageLog.info(this.getClass(), "nodeId:\t" + nodeId);
                    AiMessageLog.info(this.getClass(), "newIp:\t" + ipAddress);
                    this.ossInformer = this.getOssInformer();
                    if (nodeId != null && !"".equals(nodeId)) {
                        this.ossInformer.nodeAddressChanged(nodeId, ipAddress, maxNumRetries);
                    } else {
                        this.ossInformer.ossNodeUp(this, ipAddress, maxNumRetries);
                    }
                }
            }
            catch (MoAccessException e) {
                MessageLog.info(this.getClass(), "Could not find necessary information needed in order to inform OSS!");
            }
        }
    }

    public void ossConnectionFailed(String errorMessage) {
        AiMessageLog.traceEnter(this.getClass(), "ossConnectionFailed");
        if (this.getIntegrationType() == 1) {
            try {
                this.initiateRollback(this.getRollbackCvName(null), "Connection towards OSS failed during node self configuration, initiating rollback", null);
            }
            catch (Exception e) {
                AiMessageLog.traceError(this.getClass(), "Failed initiating rollback", e);
            }
        }
    }

    public void ossCommunicationSuccessful() {
        block7: {
            AiMessageLog.traceEnter(this.getClass(), "ossCommunicationSuccessful()");
            if (this.getIntegrationType() == 1) {
                try {
                    boolean shouldDisablePorts = this.getLmtPortsDisableFunction(null);
                    if (shouldDisablePorts) {
                        this.disableLmtPorts();
                        AiMessageLog.info(this.getClass(), "LMT ports is disabled");
                        break block7;
                    }
                    AiMessageLog.trace(2, this.getClass(), "Will not disable LMT ports since lmtPortsDisableFunction is set to false");
                }
                catch (MoAccessException e) {
                    AiMessageLog.traceError(this.getClass(), "Could not disable LMT ports", e);
                    try {
                        this.initiateRollback(this.getRollbackCvName(null), "Could not disable LMT ports", null);
                    }
                    catch (Exception e1) {
                        AiMessageLog.traceError(this.getClass(), "Could not perform rollback", e1);
                    }
                }
            } else {
                AiMessageLog.trace(2, this.getClass(), "Will not disable LMT ports since the integration type is not NSC");
            }
        }
    }

    private void disableLmtPorts() throws MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "disableLmtPorts()");
        MoIterator iterator = BoamHelper.findMOs("PlugInUnit");
        while (iterator.hasMoreElements()) {
            PlugInUnitMo piu = (PlugInUnitMo)iterator.nextMo();
            piu.actionDisablePersistent(null);
        }
        iterator = BoamHelper.findMOs("EthernetLink");
        while (iterator.hasMoreElements()) {
            EthernetLinkMo ethernetLink = (EthernetLinkMo)iterator.nextMo();
            ethernetLink.actionDisablePersistent(null);
        }
        this.disableLmtPortsState();
    }

    public int getIntegrationType() {
        return this.integrationType;
    }

    public void setIntegrationType(int integrationType) {
        this.integrationType = integrationType;
    }

    public void initiateRollback(String cvName, String reasonForRollback, Coordinator c) throws RbsConfigurationFailedException, MoAccessException {
        AiMessageLog.traceEnter(this.getClass(), "initiateRollback(), cv: " + cvName + " reason: " + reasonForRollback);
        ConfigurationVersionHelper configurationVersionHelper = new ConfigurationVersionHelper();
        if (reasonForRollback == null) {
            reasonForRollback = "";
        }
        if (configurationVersionHelper.isCvInStoredConfigurationVersionsAndHasStatusOk(cvName)) {
            configurationVersionHelper.actionSetStartable(cvName, c);
            ManagedElementMo mangedElementMo = this.getManagedElementMo();
            if (mangedElementMo != null) {
                AiMessageLog.trace(2, this.getClass(), "restart node on cv: " + cvName + " , reason for rollback: " + reasonForRollback);
                if (reasonForRollback.length() > 80) {
                    reasonForRollback = reasonForRollback.substring(0, 80);
                }
                mangedElementMo.actionManualRestart(0, 1, reasonForRollback, c);
            } else {
                AiMessageLog.traceError(this.getClass(), "Could not find ManagedElementMo, failed to restart node.");
            }
        } else {
            throw new RbsConfigurationFailedException("Can't initiate rollback. CV: " + cvName + " is not in the" + " stored configuration versions list");
        }
    }

    private ManagedElementMo getManagedElementMo() throws MoAccessException {
        return (ManagedElementMo)BoamHelper.getFirstMatchingMo("ManagedElement");
    }

    private void disableLmtPortsState() {
        AiMessageLog.traceEnter(this.getClass(), "disableLmtPortsState()");
        try {
            Control tx = TransactionServiceImpl.instance().getTransactionFactory().create(0);
            Coordinator c = tx.getCoordinator();
            this.setLmtPortsState(0, c);
            tx.getTerminator().commit();
        }
        catch (Exception e) {
            AiMessageLog.traceError(this.getClass(), "Could not set lmtPortsState to DISABLED", e);
        }
    }

    public String getRbsConfigLevelName(int level) {
        AiMessageLog.traceEnter(this.getClass(), "getRbsConfigLevelName()");
        String name = (String)this.rbsConfigLevelToName.get(new Integer(level));
        if (name == null) {
            name = "UNKNOWN LEVEL";
        }
        return name;
    }

    public void startGeoLocationCheckHandler(int startReason) {
        AiMessageLog.traceEnter(this.getClass(), "startGeoLocationCheckHandler()");
        this.geoLocationCheckHandler = GeoLocationCheckHandlerFactory.getInstance().loadGeoLocationCheckHandler(startReason, this);
        this.geoLocationCheckHandler.start();
    }

    public void setNodeIDType(String type, Coordinator c) throws MoAccessException {
        ValidateAttributes.checkTransaction(c);
        this.bcmSetStringAttribute(NODE_ID_TYPE, type, 0, 20, "RbsConfiguration", c);
    }

    public String getNodeIDType(Coordinator c) throws MoAccessException {
        return this.bcmGetStringAttribute(NODE_ID_TYPE, c);
    }

    public void setNodeIDValue(String value, Coordinator c) throws MoAccessException {
        ValidateAttributes.checkTransaction(c);
        this.bcmSetStringAttribute(NODE_ID_VALUE, value, 0, 200, "RbsConfiguration", c);
    }

    public String getNodeIDValue(Coordinator c) throws MoAccessException {
        return this.bcmGetStringAttribute(NODE_ID_VALUE, c);
    }

    public String getNodeFDNFromSiteBasic(Coordinator c) {
        try {
            String type = this.getNodeIDType(c);
            if (NODE_ID_TYPE_FDN.equals(type)) {
                return this.getNodeIDValue(c);
            }
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Could not get FDN !", e);
        }
        return null;
    }

    private static class RegisterTransactionResource {
        private RegisterTransactionResource() {
        }

        public static void register(Coordinator c, StateHandler stateHandler) throws TransactionRequiredException {
            try {
                ValidateAttributes.checkTransaction(c);
                c.registerResource(new Resource(stateHandler){
                    private final /* synthetic */ StateHandler val$stateHandler;
                    {
                        this.val$stateHandler = val$stateHandler;
                    }

                    public void rollback() {
                        AiMessageLog.traceEnter(this.getClass(), "rollback for Resource");
                    }

                    public boolean prepare() {
                        return true;
                    }

                    public void commit() {
                        AiMessageLog.traceEnter(this.getClass(), "commit() for Resource");
                        try {
                            if (this.val$stateHandler != null) {
                                this.val$stateHandler.start();
                            } else {
                                AiMessageLog.traceError(this.getClass(), "Could not start stateHandler since statHandler is null!");
                            }
                        }
                        catch (MoAccessException e) {
                            AiMessageLog.traceError(this.getClass(), "Could not start stateHandler", e);
                        }
                    }
                });
            }
            catch (InactiveTransactionException e) {
                AiMessageLog.traceError(class$se$ericsson$wcdma$rbs$boam$mao$autoconf$smartmos$RbsConfigurationMoImpl$RegisterTransactionResource == null ? (class$se$ericsson$wcdma$rbs$boam$mao$autoconf$smartmos$RbsConfigurationMoImpl$RegisterTransactionResource = RbsConfigurationMoImpl.class$("se.ericsson.wcdma.rbs.boam.mao.autoconf.smartmos.RbsConfigurationMoImpl$RegisterTransactionResource")) : class$se$ericsson$wcdma$rbs$boam$mao$autoconf$smartmos$RbsConfigurationMoImpl$RegisterTransactionResource, "Could not register resource to transaction", e);
            }
        }
    }
}

