/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.autoconf.ue;

import java.util.StringTokenizer;
import se.ericsson.cello.mao.IpFormatException;

public class IpAddressHandler {
    public static int getNetworkPrefixLength(String subNetMask) {
        StringTokenizer tokens = new StringTokenizer(subNetMask, ".", true);
        int prefixValue = 0;
        while (tokens.hasMoreTokens()) {
            String subnetMaskPart = tokens.nextToken();
            prefixValue += IpAddressHandler.getPrefixValue(subnetMaskPart);
        }
        return prefixValue;
    }

    private static int getPrefixValue(String subnetPart) {
        if (subnetPart.equals("255")) {
            return 8;
        }
        if (subnetPart.equals("254")) {
            return 7;
        }
        if (subnetPart.equals("252")) {
            return 6;
        }
        if (subnetPart.equals("248")) {
            return 5;
        }
        if (subnetPart.equals("240")) {
            return 4;
        }
        if (subnetPart.equals("224")) {
            return 3;
        }
        if (subnetPart.equals("192")) {
            return 2;
        }
        if (subnetPart.equals("128")) {
            return 1;
        }
        if (subnetPart.equals("0")) {
            return 0;
        }
        return 0;
    }

    public static boolean checkIfOnSite(String theNodeIpAddress, String theNodeSubnetMask, String theClientIpAddress) throws IpFormatException {
        boolean onSite = true;
        String minIpAddress = IpAddressHandler.calculateMinAddress(theNodeIpAddress, theNodeSubnetMask);
        String maxIpAddress = IpAddressHandler.calculateMaxAddress(theNodeIpAddress, theNodeSubnetMask);
        int[] minAdressArray = IpAddressHandler.convertIPAddressToArray(minIpAddress);
        int[] maxAdressArray = IpAddressHandler.convertIPAddressToArray(maxIpAddress);
        int[] clientSubnetMaskArray = IpAddressHandler.convertIPAddressToArray(theClientIpAddress);
        for (int index = 0; index < minAdressArray.length; ++index) {
            if (clientSubnetMaskArray[index] >= minAdressArray[index] && clientSubnetMaskArray[index] <= maxAdressArray[index]) continue;
            onSite = false;
            break;
        }
        return onSite;
    }

    private static int[] convertIPAddressToArray(String anIpAddress) {
        StringTokenizer ipAddressTokens = new StringTokenizer(anIpAddress, ".");
        int nTokens = ipAddressTokens.countTokens();
        int[] array = new int[nTokens];
        for (int i = 0; i < nTokens; ++i) {
            array[i] = Integer.parseInt(ipAddressTokens.nextToken());
        }
        return array;
    }

    public static String calculateMaxAddress(String anIpAddress, String aSubnetMask) throws IpFormatException {
        StringBuffer broadcastAddressString = new StringBuffer();
        int[] ipAddressArray = IpAddressHandler.convertIPAddressToArray(anIpAddress);
        int[] subnetMaskArray = IpAddressHandler.convertIPAddressToArray(aSubnetMask);
        for (int index = 0; index < ipAddressArray.length; ++index) {
            if (index >= subnetMaskArray.length) {
                throw new IpFormatException("too short subnet mask: " + aSubnetMask);
            }
            int broadcastInt = IpAddressHandler.calculateIpAdresses(ipAddressArray[index], subnetMaskArray[index], "broadcast");
            broadcastAddressString.append(broadcastInt);
            if (index >= ipAddressArray.length - 1) continue;
            broadcastAddressString.append(".");
        }
        return broadcastAddressString.toString();
    }

    public static String calculateMinAddress(String anIpAddress, String aSubnetMask) throws IpFormatException {
        StringBuffer broadcastAddressString = new StringBuffer();
        int[] ipAddressArray = IpAddressHandler.convertIPAddressToArray(anIpAddress);
        int[] subnetMaskArray = IpAddressHandler.convertIPAddressToArray(aSubnetMask);
        for (int index = 0; index < ipAddressArray.length; ++index) {
            if (index >= subnetMaskArray.length) {
                throw new IpFormatException("too short subnet mask: " + aSubnetMask);
            }
            int broadcastInt = IpAddressHandler.calculateIpAdresses(ipAddressArray[index], subnetMaskArray[index], "network");
            broadcastAddressString.append(broadcastInt);
            if (index >= ipAddressArray.length - 1) continue;
            broadcastAddressString.append(".");
        }
        return broadcastAddressString.toString();
    }

    private static int calculateIpAdresses(int anIpAddressToken, int aSubnetMaskToken, String anAddressType) {
        int returnAddress = -1;
        if (anAddressType.equals("network")) {
            returnAddress = anIpAddressToken & aSubnetMaskToken;
        } else if (anAddressType.equals("broadcast")) {
            int invertedSubnetMask = aSubnetMaskToken ^ 0xFF;
            returnAddress += (anIpAddressToken | invertedSubnetMask) + 1;
        }
        return returnAddress;
    }

    public static String getNetworkMask(int prefixValue) {
        String subnetValue = "";
        subnetValue = prefixValue <= 8 ? IpAddressHandler.getSubnetValue(prefixValue) + ".0.0.0" : (prefixValue <= 16 ? "255." + IpAddressHandler.getSubnetValue(prefixValue - 8) + ".0.0" : (prefixValue <= 24 ? "255.255." + IpAddressHandler.getSubnetValue(prefixValue - 16) + ".0" : "255.255.255." + IpAddressHandler.getSubnetValue(prefixValue - 24)));
        return subnetValue;
    }

    private static String getSubnetValue(int prefixValue) {
        if (prefixValue == 8) {
            return "255";
        }
        if (prefixValue == 7) {
            return "254";
        }
        if (prefixValue == 6) {
            return "252";
        }
        if (prefixValue == 5) {
            return "248";
        }
        if (prefixValue == 4) {
            return "240";
        }
        if (prefixValue == 3) {
            return "224";
        }
        if (prefixValue == 2) {
            return "192";
        }
        if (prefixValue == 1) {
            return "128";
        }
        return "0";
    }
}

