/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.bcm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.equipment.PiuDeviceMo;
import se.ericsson.cello.equipment.PlugInUnitMo;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.Mib;
import se.ericsson.cello.moframework.MibMgr;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFilter;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.MoTypeFilter;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.MoTypeCheckMoTypeAndIdFilter;
import se.ericsson.wcdma.rbs.boam.mao.autoconf.smartmos.RbsConfigurationMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObject;
import se.ericsson.wcdma.rbs.boam.mao.common.MaoHasFro;

public final class BoamHelper {
    public static final int ANY_DEPTH = -1;

    private BoamHelper() {
    }

    public static ManagedObject getFirstMatchingMo(String moTypeName) {
        MoIterator moIter = BoamHelper.findMOs(moTypeName);
        return !moIter.hasMoreElements() ? null : moIter.nextMo();
    }

    public static ManagedObject getFirstMatchingMo(String moTypeName, String identity) {
        return BoamHelper.getMatchingMo(BoamHelper.getRootMo(), moTypeName, identity);
    }

    public static ManagedObject getFirstMatchingMo(ManagedObject base, String moTypeName) {
        MoIterator moIter = BoamHelper.findMOs(moTypeName, base);
        return !moIter.hasMoreElements() ? null : moIter.nextMo();
    }

    public static ManagedObject getFirstMatchingMo(ManagedObject[] moObjects, String moTypeName) {
        if (moObjects == null) {
            return null;
        }
        for (int i = 0; i < moObjects.length; ++i) {
            if (!moObjects[i].getType().equals(moTypeName)) continue;
            return moObjects[i];
        }
        return null;
    }

    public static ManagedObject getMatchingMo(ManagedObject base, String moTypeName, String identity) {
        MoIterator moIter = BoamHelper.findMOs(moTypeName, identity, base, -1);
        return !moIter.hasMoreElements() ? null : moIter.nextMo();
    }

    public static MoIterator findMOs(String moTypeName) {
        return BoamHelper.findMOs(moTypeName, -1);
    }

    public static MoIterator findMOs(String moTypeName, int deep) {
        return BoamHelper.findMOs(moTypeName, BoamHelper.getRootMo(), deep);
    }

    public static MoIterator findMOs(String moName, String moId) {
        return BoamHelper.findMOs(moName, moId, BoamHelper.getRootMo(), -1);
    }

    public static MoIterator findMOs(String moTypeName, ManagedObject base) {
        return BoamHelper.findMOs(moTypeName, base, -1);
    }

    public static MoIterator findMOs(String moTypeName, ManagedObject base, int deep) {
        MoTypeFilter moFilter = new MoTypeFilter(moTypeName);
        return MoRepository.instance().select(base, deep, (MoFilter)moFilter);
    }

    public static MoIterator findMOs(String moTypeName, String moId, ManagedObject base, int deep) {
        MoTypeCheckMoTypeAndIdFilter moFilter = new MoTypeCheckMoTypeAndIdFilter(moTypeName, moId);
        return MoRepository.instance().select(base, deep, (MoFilter)moFilter);
    }

    public static int getPlugInUnitFroId(ManagedObject mo, Coordinator c) throws MoAccessException {
        int froId = mo.getType().equals("PiuDevice") ? ((PiuDeviceMo)mo).getFroId(c) : (mo.getType().equals("PlugInUnit") ? ((PlugInUnitMo)mo).getFroId(c) : (mo.getType().equals("AuxPlugInUnit") ? ((MaoHasFro)mo).getFroId(c) : -1));
        return froId;
    }

    public static ManagedObject getMoForFroId(String moTypeName, int froId) throws MoAccessException {
        MoIterator moIter = BoamHelper.findMOs(moTypeName);
        while (moIter.hasMoreElements()) {
            ManagedObject mo = moIter.nextMo();
            if (mo instanceof MaoHasFro) {
                if (((MaoHasFro)mo).getFroId(null) != froId) continue;
                return mo;
            }
            throw new MoNotFoundException("Search for `" + moTypeName + "' MO with froId=" + froId + " failed, mo does not implements the MaoHasFro interface");
        }
        throw new MoNotFoundException("Search for `" + moTypeName + "' MO with froId=" + froId + " failed");
    }

    private static String getMoTypeFromLdn(String ldn) {
        if (ldn == null || ldn.equals("")) {
            MessageLog.traceError((Class)BoamHelper.class, (String)"getMoTypeFromLdn(), The input ldn is null/empty!!");
            return ldn;
        }
        int startPos = ldn.lastIndexOf(",") + 1;
        if (startPos == ldn.length()) {
            return null;
        }
        int endPos = ldn.lastIndexOf("=");
        if (endPos > startPos) {
            return ldn.substring(startPos, endPos);
        }
        return null;
    }

    public static ManagedObject getMoForLdn(String ldn) throws MoAccessException {
        String moType = BoamHelper.getMoTypeFromLdn(ldn);
        MoIterator moIter = BoamHelper.findMOs(moType);
        while (moIter.hasMoreElements()) {
            ManagedObject mo = moIter.nextMo();
            if (!mo.getLocalDistinguishedName().equals(ldn)) continue;
            return mo;
        }
        throw new MoNotFoundException("Search for MO with LDN = " + ldn + " failed");
    }

    public static String getLdnForMo(String moTypeName, int froId) {
        try {
            return BoamHelper.getMoForFroId(moTypeName, froId).getFullDistinguishedName();
        }
        catch (MoAccessException e) {
            return "";
        }
    }

    public static boolean checkObjResrvd(ManagedObject objWithRefs, List devices) throws MoAccessException {
        Iterator iter = devices.iterator();
        while (iter.hasNext()) {
            BoamManagedObject aDevice = (BoamManagedObject)((Object)iter.next());
            ManagedObject[] reservedBy = aDevice.getReservedBy(null);
            for (int i = 0; i < reservedBy.length; ++i) {
                if (objWithRefs != reservedBy[i]) continue;
                return true;
            }
        }
        return false;
    }

    public static List getDevices(ManagedObject deviceGroup) {
        ArrayList<ManagedObject> result2 = new ArrayList<ManagedObject>();
        MoIterator deviceSets = deviceGroup.getChildren();
        while (deviceSets.hasMoreElements()) {
            ManagedObject set = deviceSets.nextMo();
            MoIterator devices = set.getChildren();
            while (devices.hasMoreElements()) {
                result2.add(devices.nextMo());
            }
        }
        return result2;
    }

    public static ManagedObject getRootMo() {
        return MibMgr.instance().getMib().getRootMo();
    }

    public static String getNodeFdn(Coordinator c) {
        Mib mib = MibMgr.instance().getMib();
        String fdn = mib.getMibPrefix();
        if (fdn == null || "".equals(fdn)) {
            RbsConfigurationMoImpl rbsConfig = (RbsConfigurationMoImpl)BoamHelper.getFirstMatchingMo("RbsConfiguration");
            fdn = rbsConfig.getNodeFDNFromSiteBasic(c);
        }
        return fdn;
    }

    public static boolean checkIfIdentityFormatCorrect(String identity, int separatorNo) {
        if (null == identity) {
            return false;
        }
        char[] chars = identity.toCharArray();
        int count = 0;
        int index = -1;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != '-') continue;
            if (i != index + 1) {
                ++count;
                index = i;
                continue;
            }
            return false;
        }
        return index != chars.length - 1 && count == separatorNo;
    }
}

