/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.bcm;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import se.ericsson.cello.managedelement.ManagedElementMo;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.moframework.AttrNotSettableException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.BooleanAttribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.ManagedObjectBase;
import se.ericsson.cello.moframework.MibMgr;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCardinalityViolationException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFilter;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRemovedException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.SoftwareErrorException;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructAttribute;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.generic.GenericMOContext;
import se.ericsson.wcdma.rbs.boam.common.generic.GenericMOManager;
import se.ericsson.wcdma.rbs.boam.common.generic.RbsGenericLicenseManager;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.common.PmCounterTableManager;
import se.ericsson.wcdma.rbs.boam.mao.common.MoTypeFilter;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RbsFeatureMo;
import se.ericsson.wcdma.rbs.boam.pms.impl.PmsConst;

public abstract class BoamManagedObject
extends ManagedObjectBase {
    protected static final String PERSISTENT_RESERVERS = "persistentReservers";
    protected static final String TRANSIENT_RESERVERS = "transientReservers";
    protected static final String PM_PREFIX = "pm";
    private final ManagedObject managedElementRef = MibMgr.instance().getMib().getRootMo();

    protected BoamManagedObject(ManagedObject parent, String moTypeName, String identity, Coordinator context, int maxNoOfChildren) throws MoNameAlreadyTakenException, MoAccessException {
        super(parent, moTypeName, identity, context);
        MessageLog.traceEnter(((Object)((Object)this)).getClass(), "BoamManagedObject() normal constructor");
        this.checkNumberOfChildren(new MoTypeFilter(moTypeName), parent, maxNoOfChildren, moTypeName, context);
    }

    protected BoamManagedObject(ManagedObject parent, String moTypeName, String identity, Coordinator context) throws MoNameAlreadyTakenException, MoAccessException {
        super(parent, moTypeName, identity, context);
        MessageLog.traceEnter(((Object)((Object)this)).getClass(), "BoamManagedObject() normal constructor");
    }

    protected BoamManagedObject(String aLocalDistinguishedName) throws MoNameAlreadyTakenException {
        super(aLocalDistinguishedName);
        MessageLog.traceEnter(((Object)((Object)this)).getClass(), "BoamManagedObject() recovery constructor");
    }

    public void delete(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(((Object)((Object)this)).getClass(), "BoamManagedObject.delete() " + this.getFullDistinguishedName());
        MoData aData = this.getMyMoData();
        if (this instanceof Reservable) {
            MessageLog.traceEnter(((Object)((Object)this)).getClass(), "Check if this MO is reserved.");
            if (this.isReserved(c)) {
                MessageLog.traceEnter(((Object)((Object)this)).getClass(), "Can't delete because MO is reserved, throwing exception.");
                throw new MoReservedNotDeletableException("this MO is reserved and can not be deleted till released.");
            }
        }
        if (aData != null) {
            aData.delete(c);
        }
        super.delete(c);
    }

    public static ManagedObject getAncestor(ManagedObject mo, String ancestorTypeName) {
        if (mo == null) {
            MessageLog.traceError(BoamManagedObject.class, "getAncestor(), can't get the ancestor!! the mo is null!!");
            throw new RuntimeException("getAncestor(), can't get the ancestor!! the mo is null!!");
        }
        if (ancestorTypeName == null || ancestorTypeName.length() == 0) {
            MessageLog.traceError(BoamManagedObject.class, "getAncestor(),  ancestorTypeName is null/empty!! can't get the ancestor for mo: " + mo.getLocalDistinguishedName());
            throw new RuntimeException("getAncestor(),  ancestorTypeName is null/empty!! can't get the ancestor for mo: " + mo.getLocalDistinguishedName());
        }
        ManagedObject parent = mo.getParent();
        if (parent == null) {
            MessageLog.traceError(BoamManagedObject.class, "getAncestor(),  The parent is null!!. Couldn't find the ancestor: " + ancestorTypeName + " for mo: " + mo.getLocalDistinguishedName());
            throw new RuntimeException("getAncestor(),  The parent is null!!. Couldn't find the ancestor: " + ancestorTypeName + " for mo: " + mo.getLocalDistinguishedName());
        }
        if (!parent.getType().equalsIgnoreCase(ancestorTypeName)) {
            parent = BoamManagedObject.getAncestor(parent, ancestorTypeName);
        }
        return parent;
    }

    protected static synchronized void checkTransaction(Coordinator context) throws TransactionRequiredException {
        ValidateAttributes.checkTransaction(context);
    }

    protected int getTxIdNonTransactional(Coordinator context) {
        return ValidateAttributes.getTxIdNonTransactional(context);
    }

    protected int getTxIdTransactional(Coordinator context) throws TransactionRequiredException {
        return ValidateAttributes.getTxIdTransactional(context);
    }

    public boolean isPmCounterStartable(String name, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(((Object)((Object)this)).getClass(), "isPmCounterStartable(), counter name: " + name);
        return true;
    }

    public ManagedObject[] getReservedBy(Coordinator context) throws MoAccessException {
        SequenceAttribute tReservers;
        MessageLog.traceEnter(((Object)((Object)this)).getClass(), "getReservedBy()");
        if (!this.isReserved(context)) {
            return new ManagedObject[0];
        }
        MoData moData = this.getMyMoData();
        moData.handleTransaction(context, MoData.READ_ACCESS);
        SequenceAttribute pReservers = (SequenceAttribute)moData.getAttribute(PERSISTENT_RESERVERS);
        ArrayList<ManagedObject> result2 = new ArrayList<ManagedObject>();
        if (pReservers != null) {
            Enumeration pe = pReservers.elements();
            while (pe != null && pe.hasMoreElements()) {
                ReferenceAttribute aRefAttribute = (ReferenceAttribute)pe.nextElement();
                if (aRefAttribute == null) continue;
                result2.add(aRefAttribute.getValue(context));
            }
        }
        if ((tReservers = (SequenceAttribute)moData.getAttribute(TRANSIENT_RESERVERS)) != null) {
            Enumeration te = tReservers.elements();
            while (te != null && te.hasMoreElements()) {
                ReferenceAttribute aRefAttribute = (ReferenceAttribute)te.nextElement();
                if (aRefAttribute == null) continue;
                result2.add(aRefAttribute.getValue(context));
            }
        }
        return result2.toArray(new ManagedObject[result2.size()]);
    }

    public synchronized void release(ManagedObject aUser, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(((Object)((Object)this)).getClass(), "release() " + this.getFullDistinguishedName() + "  " + (aUser == null ? null : aUser.getFullDistinguishedName()));
        MoData aData = this.getMyMoData();
        if (aUser == null) {
            MessageLog.traceParam(((Object)((Object)this)).getClass(), " A Mo reference is null");
            throw new SoftwareErrorException();
        }
        if (aData != null) {
            ReferenceAttribute aRefAttribute;
            Enumeration e;
            boolean founded = false;
            if (context != null) {
                aData.handleTransaction(context, MoData.WRITE_ACCESS);
                SequenceAttribute persistentReservers = (SequenceAttribute)aData.getAttribute(PERSISTENT_RESERVERS);
                if (persistentReservers != null && !persistentReservers.isEmpty()) {
                    e = persistentReservers.elements();
                    while (e != null && e.hasMoreElements() && !founded) {
                        aRefAttribute = (ReferenceAttribute)e.nextElement();
                        if (aRefAttribute == null || aRefAttribute.getValue(context) != aUser) continue;
                        persistentReservers.removeElement((Attribute)aRefAttribute);
                        founded = true;
                        MessageLog.traceEnter(((Object)((Object)this)).getClass(), "Mo is removed from persistent reservers list");
                    }
                }
            }
            founded = false;
            SequenceAttribute transientReservers = (SequenceAttribute)aData.getAttribute(TRANSIENT_RESERVERS);
            if (transientReservers != null && !transientReservers.isEmpty()) {
                e = transientReservers.elements();
                while (e != null && e.hasMoreElements() && !founded) {
                    aRefAttribute = (ReferenceAttribute)e.nextElement();
                    if (aRefAttribute == null || aRefAttribute.getValue(context) != aUser) continue;
                    transientReservers.removeElement((Attribute)aRefAttribute);
                    founded = true;
                    MessageLog.traceEnter(((Object)((Object)this)).getClass(), "Mo is removed from transient reservers list");
                }
            }
        }
    }

    public synchronized void reserve(ManagedObject aUser, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(((Object)((Object)this)).getClass(), "reserve() " + this.getFullDistinguishedName() + "  " + (aUser == null ? null : aUser.getFullDistinguishedName()));
        MoData aData = this.getMyMoData();
        if (!(this instanceof Reservable)) {
            MessageLog.traceParam(((Object)((Object)this)).getClass(), "attempt to reserve non-reservable MO!");
            throw new SoftwareErrorException();
        }
        if (aUser == null) {
            MessageLog.traceParam(((Object)((Object)this)).getClass(), "A Mo reference is null");
            throw new SoftwareErrorException();
        }
        if (aData != null) {
            if (this.isMyMoDataPersistent() && context != null) {
                aData.handleTransaction(context, MoData.WRITE_ACCESS);
                SequenceAttribute persistentReservers = this.getSequenceAttribute(aData, PERSISTENT_RESERVERS);
                ReferenceAttribute aRefAttr = this.checkReserver(aUser, persistentReservers, context);
                if (aRefAttr != null) {
                    persistentReservers.addElement((Attribute)aRefAttr);
                }
            } else {
                aData.handleTransaction(context, MoData.READ_ACCESS);
                SequenceAttribute transientReservers = this.getSequenceAttribute(aData, TRANSIENT_RESERVERS);
                ReferenceAttribute aRefAttr = this.checkReserver(aUser, transientReservers, context);
                if (aRefAttr != null) {
                    transientReservers.addElement((Attribute)aRefAttr);
                }
            }
        }
    }

    protected ReferenceAttribute checkReserver(ManagedObject aUser, SequenceAttribute reservers, Coordinator context) throws TransactionRequiredException, MoRemovedException {
        ReferenceAttribute aRefAttr = new ReferenceAttribute(aUser.getLocalDistinguishedName(), false);
        aRefAttr.setValue(aUser);
        boolean isAlreadyIncluded = false;
        Enumeration e = reservers.elements();
        while (e != null && e.hasMoreElements() && !isAlreadyIncluded) {
            ReferenceAttribute aTmpAttr = (ReferenceAttribute)e.nextElement();
            if (aUser != aTmpAttr.getValue(context)) continue;
            isAlreadyIncluded = true;
            MessageLog.traceError(((Object)((Object)this)).getClass(), "  has already been reserved once by this user ");
            aRefAttr = null;
        }
        return aRefAttr;
    }

    public boolean isReserved(Coordinator context) throws MoAccessException {
        Attribute[] transientAttrList;
        SequenceAttribute transientReservers;
        Attribute[] persistentAttrList;
        MessageLog.traceEnter(((Object)((Object)this)).getClass(), "isReserved()");
        MoData aData = this.getMyMoData();
        if (!(this instanceof Reservable)) {
            return false;
        }
        if (aData == null) {
            return false;
        }
        aData.handleTransaction(context, MoData.READ_ACCESS);
        SequenceAttribute persistentReservers = (SequenceAttribute)aData.getAttribute(PERSISTENT_RESERVERS);
        if (persistentReservers != null && (persistentAttrList = persistentReservers.getValue(context)) != null) {
            for (int i = 0; i < persistentAttrList.length; ++i) {
                ReferenceAttribute pra = (ReferenceAttribute)persistentAttrList[i];
                MessageLog.trace(1, ((Object)((Object)this)).getClass(), "This MO is reserved by " + pra.getReferenceAsLDN());
            }
        }
        if ((transientReservers = (SequenceAttribute)aData.getAttribute(TRANSIENT_RESERVERS)) != null && (transientAttrList = transientReservers.getValue(context)) != null) {
            for (int i = 0; i < transientAttrList.length; ++i) {
                ReferenceAttribute tra = (ReferenceAttribute)transientAttrList[i];
                MessageLog.trace(1, ((Object)((Object)this)).getClass(), "This MO is reserved by " + tra.getReferenceAsLDN());
            }
        }
        return persistentReservers != null && persistentReservers.size() != 0 || transientReservers != null && transientReservers.size() != 0;
    }

    public boolean isAnyChildReserved(Coordinator context) throws TransactionRequiredException {
        MessageLog.traceEnter(((Object)((Object)this)).getClass(), "isAnyChildReserved()");
        boolean isAnyChildReserved = false;
        MoRepository mos = MoRepository.instance();
        MoIterator iter = mos.select((ManagedObject)this, 99, (MoFilter)new BoamMoFilter());
        while (iter.hasMoreElements()) {
            ManagedObject o = iter.nextMo();
            if (o == this || !BoamManagedObject.isReservedRefl(o, context)) continue;
            isAnyChildReserved = true;
            break;
        }
        if (isAnyChildReserved) {
            MessageLog.trace(2, ((Object)((Object)this)).getClass(), "isAnyChildReserved() returns TRUE");
        } else {
            MessageLog.trace(2, ((Object)((Object)this)).getClass(), "isAnyChildReserved() returns FALSE");
        }
        return isAnyChildReserved;
    }

    private static boolean isReservedRefl(ManagedObject o, Coordinator context) {
        try {
            Method m = o.getClass().getMethod("isReserved", Coordinator.class);
            if (m != null) {
                return (Boolean)m.invoke((Object)o, context);
            }
        }
        catch (NoSuchMethodException e) {
        }
        catch (SecurityException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return false;
    }

    protected SequenceAttribute getSequenceAttribute(MoData moData, String mode) {
        SequenceAttribute existingAttribute = (SequenceAttribute)moData.getAttribute(mode);
        if (existingAttribute == null) {
            SequenceAttribute newAttribute = new SequenceAttribute(mode, true);
            if (mode.equals(TRANSIENT_RESERVERS)) {
                moData.registerTransientAttr((Attribute)newAttribute);
            } else {
                moData.registerPersistentAttr((Attribute)newAttribute);
            }
            return newAttribute;
        }
        return existingAttribute;
    }

    protected String bcmGetMEUserLabel() {
        try {
            if (!(this.managedElementRef instanceof ManagedElementMo)) {
                return "";
            }
            return ((ManagedElementMo)this.managedElementRef).getUserLabel(null);
        }
        catch (MoAccessException e) {
            return "";
        }
    }

    protected void bcmSetIntAttribute(String attrName, int value, int[] minValues, int[] maxValues, String thisTypeName, Coordinator context) throws MoAccessException, ValueOutOfRangeException {
        MessageLog.traceEnter(((Object)((Object)this)).getClass(), " bcmSetIntAttribute() " + attrName);
        MoData aData = this.getMyMoData();
        aData.handleTransaction(context, MoData.WRITE_ACCESS);
        ValidateAttributes.intValueRangeCheck(attrName, value, minValues, maxValues, thisTypeName);
        IntegerAttribute attribute = (IntegerAttribute)aData.getAttribute(attrName);
        if (attribute == null) {
            throw new NoSuchAttributeException(attrName, this.getType());
        }
        attribute.setValue(value);
    }

    protected void bcmSetIntAttribute(String attrName, int value, int minValue, int maxValue, String thisTypeName, Coordinator context) throws MoAccessException, ValueOutOfRangeException {
        this.bcmSetIntAttribute(attrName, value, new int[]{minValue}, new int[]{maxValue}, thisTypeName, context);
    }

    protected int bcmGetIntAttribute(String attributeName, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(((Object)((Object)this)).getClass(), " bcmGetIntegerAttribute() " + attributeName);
        MoData aData = this.getMyMoData();
        aData.handleTransaction(context, MoData.READ_ACCESS);
        IntegerAttribute attribute = (IntegerAttribute)aData.getAttribute(attributeName);
        if (attribute == null) {
            throw new NoSuchAttributeException(attributeName, this.getType());
        }
        return attribute.getValue(context);
    }

    protected void bcmStoreAndRegisterIntAttribute(String attributeName, int value) throws MoAccessException {
        MessageLog.traceEnter(((Object)((Object)this)).getClass(), " bcmStoreAndRegisterIntAttribute() " + attributeName);
        MoData aData = this.getMyMoData();
        IntegerAttribute attribute = new IntegerAttribute(attributeName, false, value);
        aData.registerPersistentAttr((Attribute)attribute);
    }

    protected void bcmSetStringAttribute(String attrName, String value, int minLength, int maxLength, String thisTypeName, Coordinator context) throws MoAccessException, ValueOutOfRangeException {
        MessageLog.traceEnter(((Object)((Object)this)).getClass(), " bcmSetStringAttribute() " + attrName);
        MoData aData = this.getMyMoData();
        aData.handleTransaction(context, MoData.WRITE_ACCESS);
        if (value.length() < minLength || value.length() > maxLength) {
            String msg = attrName + " attribute has value out of range; string length should be =< " + Integer.toString(maxLength) + ", >= " + Integer.toString(minLength);
            MessageLog.traceParam(((Object)((Object)this)).getClass(), msg);
            throw new ValueOutOfRangeException(msg, thisTypeName);
        }
        StringAttribute attribute = (StringAttribute)aData.getAttribute(attrName);
        if (attribute == null) {
            throw new NoSuchAttributeException(attrName, this.getType());
        }
        attribute.setValue(value);
    }

    protected void bcmSetBooleanAttribute(String attrName, boolean value, String thisTypeName, Coordinator context) throws MoAccessException, ValueOutOfRangeException {
        MessageLog.traceEnter(((Object)((Object)this)).getClass(), " bcmSetbooleanAttribute() " + attrName);
        MoData aData = this.getMyMoData();
        aData.handleTransaction(context, MoData.WRITE_ACCESS);
        BooleanAttribute attribute = (BooleanAttribute)aData.getAttribute(attrName);
        if (attribute == null) {
            throw new NoSuchAttributeException(attrName, this.getType());
        }
        attribute.setValue(value);
    }

    protected void bcmSetSequenceAttribute(String attrName, Attribute[] value, int maxLength, String thisTypeName, Coordinator context) throws MoAccessException, ValueOutOfRangeException {
        MessageLog.traceEnter(((Object)((Object)this)).getClass(), " bcmSetSequenceAttribute() " + attrName);
        MoData aData = this.getMyMoData();
        aData.handleTransaction(context, MoData.WRITE_ACCESS);
        if (value.length > maxLength) {
            String msg = attrName + " attribute has value out of range; array length should be =< " + Integer.toString(maxLength);
            MessageLog.traceParam(((Object)((Object)this)).getClass(), msg);
            throw new ValueOutOfRangeException(msg, thisTypeName);
        }
        SequenceAttribute attribute = (SequenceAttribute)aData.getAttribute(attrName);
        if (attribute == null) {
            throw new NoSuchAttributeException(attrName, this.getType());
        }
        attribute.setValue(value);
    }

    protected void bcmSetIntArray(String attrName, int[] value, int maxLength, String thisTypeName, Coordinator context) throws MoAccessException, ValueOutOfRangeException {
        MessageLog.traceEnter(((Object)((Object)this)).getClass(), " bcmSetIntArray() " + attrName);
        Attribute[] attributes = this.convertIntsToAttributes(value);
        this.bcmSetSequenceAttribute(attrName, attributes, maxLength, thisTypeName, context);
    }

    private Attribute[] convertIntsToAttributes(int[] value) {
        Attribute[] attributes = new Attribute[value.length];
        for (int i = 0; i < attributes.length; ++i) {
            attributes[i] = new IntegerAttribute("int" + i, false, value[i]);
        }
        return attributes;
    }

    protected boolean bcmGetBooleanAttribute(String attributeName, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(((Object)((Object)this)).getClass(), " bcmGetBooleanAttribute() " + attributeName);
        MoData aData = this.getMyMoData();
        aData.handleTransaction(context, MoData.READ_ACCESS);
        BooleanAttribute attribute = (BooleanAttribute)aData.getAttribute(attributeName);
        if (attribute == null) {
            throw new NoSuchAttributeException(attributeName, this.getType());
        }
        return attribute.getValue(context);
    }

    protected String bcmGetStringAttribute(String attributeName, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(((Object)((Object)this)).getClass(), " bcmGetStringAttribute() " + attributeName);
        MoData aData = this.getMyMoData();
        aData.handleTransaction(context, MoData.READ_ACCESS);
        StringAttribute attribute = (StringAttribute)aData.getAttribute(attributeName);
        if (attribute == null) {
            throw new NoSuchAttributeException(attributeName, this.getType());
        }
        return attribute.getValue(context);
    }

    protected Struct bcmGetStructAttribute(String attributeName, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(((Object)((Object)this)).getClass(), " bcmGetStructAttribute() " + attributeName);
        MoData aData = this.getMyMoData();
        aData.handleTransaction(context, MoData.READ_ACCESS);
        StructAttribute attribute = (StructAttribute)aData.getAttribute(attributeName);
        if (attribute == null) {
            throw new NoSuchAttributeException(attributeName, this.getType());
        }
        return attribute.getValue(context);
    }

    protected void bcmStoreAndRegisterBooleanAttribute(String attributeName, boolean value) throws MoAccessException {
        MessageLog.traceEnter(((Object)((Object)this)).getClass(), " bcmStoreAndRegisterStringAttribute() " + attributeName);
        MoData aData = this.getMyMoData();
        BooleanAttribute attribute = new BooleanAttribute(attributeName, false, value);
        aData.registerPersistentAttr((Attribute)attribute);
    }

    protected void bcmStoreAndRegisterStringAttribute(String attributeName, String value) throws MoAccessException {
        MessageLog.traceEnter(((Object)((Object)this)).getClass(), " bcmStoreAndRegisterStringAttribute() " + attributeName);
        MoData aData = this.getMyMoData();
        StringAttribute attribute = new StringAttribute(attributeName, false, value);
        aData.registerPersistentAttr((Attribute)attribute);
    }

    protected ManagedObject bcmGetReferenceAttribute(String attributeName, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(((Object)((Object)this)).getClass(), " bcmGetReferenceAttribute() " + attributeName);
        ReferenceAttribute attribute = null;
        ManagedObject mo = null;
        MoData aData = this.getMyMoData();
        aData.handleTransaction(context, MoData.READ_ACCESS);
        attribute = (ReferenceAttribute)aData.getAttribute(attributeName);
        if (attribute != null) {
            mo = attribute.getValue(context);
        }
        return mo;
    }

    protected void bcmStoreAndRegisterReferenceAttribute(String attributeName, ManagedObject value) throws MoAccessException {
        MessageLog.traceEnter(((Object)((Object)this)).getClass(), " bcmStoreReferenceAttribute() " + attributeName);
        MoData aData = this.getMyMoData();
        ReferenceAttribute attribute = new ReferenceAttribute(attributeName, false, value);
        aData.registerPersistentAttr((Attribute)attribute);
    }

    protected void bcmSetReferenceAttribute(String attrName, ManagedObject value, String thisTypeName, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(((Object)((Object)this)).getClass(), " bcmSetReferenceAttribute() " + attrName);
        MoData aData = this.getMyMoData();
        aData.handleTransaction(context, MoData.WRITE_ACCESS);
        ReferenceAttribute attribute = (ReferenceAttribute)aData.getAttribute(attrName);
        if (attribute == null) {
            throw new NoSuchAttributeException(attrName, this.getType());
        }
        attribute.setValue(value);
    }

    protected void bcmSetStructAttribute(String attrName, Struct value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(((Object)((Object)this)).getClass(), " bcmSetStructAttribute() " + attrName);
        MoData aData = this.getMyMoData();
        aData.handleTransaction(context, MoData.WRITE_ACCESS);
        StructAttribute attribute = (StructAttribute)aData.getAttribute(attrName);
        if (attribute == null || value == null) {
            throw new NoSuchAttributeException(attrName, this.getType());
        }
        Attribute[] memberAttributesInDb = attribute.getElements(context);
        if (memberAttributesInDb.length != value.getNames().length) {
            MessageLog.traceError(((Object)((Object)this)).getClass(), "Number of entries in struct " + attrName + "(" + memberAttributesInDb.length + " ) differs from the one to set (" + value.getNames().length + ")");
            throw new NoSuchAttributeException(attrName, this.getType());
        }
        for (int i = 0; i < memberAttributesInDb.length; ++i) {
            Attribute member = memberAttributesInDb[i];
            String memberName = member.getName();
            Object valueToSet = value.getValue(memberName);
            if (valueToSet == null) {
                MessageLog.traceError(((Object)((Object)this)).getClass(), "Could not set member " + memberName + " for struct attribute " + attrName + " since the value is null");
                throw new NoSuchAttributeException(attrName, this.getType());
            }
            if (member instanceof StringAttribute) {
                ((StringAttribute)member).setValue((String)valueToSet);
                continue;
            }
            if (member instanceof IntegerAttribute) {
                ((IntegerAttribute)member).setValue((Integer)valueToSet);
                continue;
            }
            if (member instanceof BooleanAttribute) {
                ((BooleanAttribute)member).setValue((Boolean)valueToSet);
                continue;
            }
            MessageLog.traceError(((Object)((Object)this)).getClass(), "Member " + memberName + " is not a supported type: " + member.toString());
            throw new AttrNotSettableException(attrName, this.getType());
        }
    }

    protected String bcmGetIdentity(String localDistName, Coordinator context) throws MoAccessException {
        return this.getNamingAttributeValue();
    }

    protected ManagedObject[] bcmGetMoRefSequenceAttribute(String attributeName, Coordinator context) throws MoAccessException {
        Attribute[] attrList = this.bcmGetSequenceAttribute(attributeName, context);
        int length = attrList.length;
        ManagedObject[] moRefArr = new ManagedObject[length];
        for (int i = 0; i < length; ++i) {
            moRefArr[i] = ((ReferenceAttribute)attrList[i]).getValue(context);
        }
        return moRefArr;
    }

    protected Attribute[] bcmGetSequenceAttribute(String attributeName, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(((Object)((Object)this)).getClass(), " bcmGetSequenceAttribute() " + attributeName);
        SequenceAttribute attribute = null;
        Attribute[] attributes = null;
        MoData aData = this.getMyMoData();
        aData.handleTransaction(context, MoData.READ_ACCESS);
        attribute = (SequenceAttribute)aData.getAttribute(attributeName);
        if (attribute != null) {
            attributes = attribute.getValue(context);
            if (attributes == null) {
                throw new NoSuchAttributeException(attributeName, this.getType());
            }
        } else {
            throw new NoSuchAttributeException(attributeName, this.getType());
        }
        return attributes;
    }

    protected void bcmStoreAndRegisterSequenceAttribute(String attributeName, Attribute[] value) throws MoAccessException {
        MessageLog.traceEnter(((Object)((Object)this)).getClass(), " bcmStoreAndRegisterSequenceAttribute() " + attributeName);
        MoData aData = this.getMyMoData();
        SequenceAttribute attribute = new SequenceAttribute(attributeName, false);
        attribute.setValue(value);
        aData.registerPersistentAttr((Attribute)attribute);
    }

    protected void bcmStoreAndRegisterSequenceRefAttribute(String attributeName, ManagedObject[] supportUnitRef) throws MoAccessException {
        MessageLog.traceEnter(((Object)((Object)this)).getClass(), " bcmStoreAndRegisterSequenceRefAttribute() " + attributeName);
        MoData aData = this.getMyMoData();
        ReferenceAttribute[] attributes = new ReferenceAttribute[supportUnitRef.length];
        for (int i = 0; i < supportUnitRef.length; ++i) {
            attributes[i] = new ReferenceAttribute("", false, supportUnitRef[i]);
        }
        SequenceAttribute seqAttribute = new SequenceAttribute(attributeName, false);
        seqAttribute.setValue((Attribute[])attributes);
        aData.registerPersistentAttr((Attribute)seqAttribute);
    }

    protected int[] bcmGetIntArray(String attributeName, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(((Object)((Object)this)).getClass(), " bcmGetIntSequence() " + attributeName);
        int[] ints = null;
        Attribute[] attributes = this.bcmGetSequenceAttribute(attributeName, context);
        if (attributes != null) {
            ints = new int[attributes.length];
            for (int i = 0; i < attributes.length; ++i) {
                IntegerAttribute intAttr = (IntegerAttribute)attributes[i];
                ints[i] = intAttr.getValue(context);
            }
        }
        return ints;
    }

    protected void bcmStoreAndRegisterIntArrayAttribute(String attributeName, int[] value) throws MoAccessException {
        MessageLog.traceEnter(((Object)((Object)this)).getClass(), " bcmStoreAndRegisterIntArrayAttribute() " + attributeName);
        Attribute[] attrs = this.convertIntsToAttributes(value);
        this.bcmStoreAndRegisterSequenceAttribute(attributeName, attrs);
    }

    public abstract MoData getMyMoData();

    public abstract boolean isMyMoDataPersistent();

    public void sendAVC(String attributeName, boolean newValue, Coordinator context) {
        this.sendAVC(attributeName, (Object)newValue, context);
    }

    public void sendAVC(String attributeName, int newValue, Coordinator context) {
        this.sendAVC(attributeName, new Integer(newValue), context);
    }

    public void sendAVC(String attributeName, Object newValue, Coordinator context) {
        MessageLog.traceEnter(((Object)((Object)this)).getClass(), "sendAVC() for attribute: " + attributeName);
        String[] attrArr = new String[]{attributeName};
        Object[] valArr = new Object[]{newValue};
        NotificationSender.instance().pushAVC((ManagedObject)this, attrArr, valArr, context);
    }

    public void sendAVC(ManagedObject mo, String attributeName, Object newValue, Coordinator context) {
        MessageLog.traceEnter(((Object)((Object)this)).getClass(), "sendAVC() for attribute: " + attributeName);
        String[] attrArr = new String[]{attributeName};
        Object[] valArr = new Object[]{newValue};
        NotificationSender.instance().pushAVC(mo, attrArr, valArr, context);
    }

    public void sendAVC(String attributeName, Object newValue) {
        MessageLog.traceEnter(((Object)((Object)this)).getClass(), "sendAVC() for attribute: " + attributeName);
        String[] attrArr = new String[]{attributeName};
        Object[] valArr = new Object[]{newValue};
        NotificationSender.instance().pushAVC((ManagedObject)this, attrArr, valArr);
    }

    public void sendAVC(String attributeName, int newValue) {
        MessageLog.traceEnter(((Object)((Object)this)).getClass(), "sendAVC() for attribute: " + attributeName);
        String[] attrArr = new String[]{attributeName};
        Object[] valArr = new Object[]{new Integer(newValue)};
        NotificationSender.instance().pushAVC((ManagedObject)this, attrArr, valArr);
    }

    protected void checkNumberOfChildren(MoFilter myCriteria, ManagedObject startMo, int maxNoOfChildren, String typeName, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(((Object)((Object)this)).getClass(), "checkNumberOfChildren()");
        MoIterator anIterator = MoRepository.instance().select(startMo, 1, myCriteria);
        if (maxNoOfChildren == 0 || anIterator != null && anIterator.size() > maxNoOfChildren) {
            String msg = "The number of children exceeded the permitted (" + maxNoOfChildren + ") instances";
            MessageLog.traceParam(((Object)((Object)this)).getClass(), msg);
            throw new MoCardinalityViolationException(typeName);
        }
    }

    public final Object getAttribute(String attrName, Coordinator context) throws MoAccessException, NoSuchAttributeException {
        MoData aData = this.getMyMoData();
        aData.handleTransaction(context, MoData.READ_ACCESS);
        if (GenericMOManager.getManager().couldHandleGetter(attrName)) {
            if (PmCounterTableManager.isUnImplementedCounter(attrName)) {
                return PmsConst.getCounterStubArray(attrName);
            }
            GenericMOContext genericContext = GenericMOManager.obtainContext(context);
            return GenericMOManager.getManager().invokeAttributeGetter((Object)this, attrName, genericContext);
        }
        return super.getAttribute(attrName, context);
    }

    public final Object[] getAttributes(String[] attrNames, Coordinator context) throws MoAccessException {
        MoData aData = this.getMyMoData();
        aData.handleTransaction(context, MoData.READ_ACCESS);
        if (this.handleBatchQuery()) {
            return this.getAttributes_Batch(attrNames, context);
        }
        Object[] result2 = new Object[attrNames.length];
        for (int attrIx = 0; attrIx < attrNames.length; ++attrIx) {
            try {
                result2[attrIx] = this.getAttribute(attrNames[attrIx], context);
                continue;
            }
            catch (IllegalArgumentException e) {
                throw new WrongAttributeTypeException(attrNames[attrIx], this.getType());
            }
        }
        return result2;
    }

    public boolean handleBatchQuery() {
        return false;
    }

    public Object[] getAttributes_Batch(String[] attrNames, Coordinator context) throws MoAccessException {
        Object[] attrValues = null;
        return attrValues;
    }

    public final void setAttribute(String attrName, Object value, Coordinator context) throws MoAccessException {
        MoData aData = this.getMyMoData();
        aData.handleTransaction(context, MoData.WRITE_ACCESS);
        if (GenericMOManager.getManager().couldHandleSetter(attrName)) {
            GenericMOContext genericContext = GenericMOManager.obtainContext(context);
            GenericMOManager.getManager().invokeAttributeSetter((ManagedObject)this, attrName, value, genericContext);
        } else {
            super.setAttribute(attrName, value, context);
        }
    }

    public final void setAttributes(String[] attrNames, Object[] attrValues, Coordinator context) throws MoAccessException {
        Object[] params = null;
        MoData aData = this.getMyMoData();
        aData.handleTransaction(context, MoData.WRITE_ACCESS);
        Class<?> moc = ((Object)((Object)this)).getClass();
        Method[] methods = moc.getMethods();
        for (int attrIx = 0; attrIx < attrNames.length; ++attrIx) {
            try {
                int methodIndex;
                boolean hit = false;
                RbsFeatureMo mo = RbsGenericLicenseManager.findGenericRbsLicenseMo((Object)this, attrNames[attrIx], context);
                if (mo != null) {
                    RbsGenericLicenseManager.setGenericRbsLicenseState(mo, attrNames[attrIx], attrValues[attrIx], context);
                    continue;
                }
                if (GenericMOManager.getManager().couldHandleSetter(attrNames[attrIx])) {
                    GenericMOContext genericContext = GenericMOManager.obtainContext(context);
                    GenericMOManager.getManager().invokeAttributeSetter((ManagedObject)this, attrNames[attrIx], attrValues[attrIx], genericContext);
                    continue;
                }
                for (methodIndex = 0; methodIndex < methods.length; ++methodIndex) {
                    if (!methods[methodIndex].getName().equalsIgnoreCase("set" + attrNames[attrIx])) continue;
                    hit = true;
                    break;
                }
                if (!hit) {
                    throw new NoSuchAttributeException(attrNames[attrIx], this.getType());
                }
                params = new Object[]{attrValues[attrIx], context};
                methods[methodIndex].invoke((Object)this, params);
                continue;
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof MoAccessException) {
                    throw (MoAccessException)e.getTargetException();
                }
                MessageLog.traceError(((Object)((Object)this)).getClass(), "set attribute exception:", (Exception)e.getTargetException());
                throw new SoftwareErrorException(e.getTargetException());
            }
            catch (IllegalArgumentException e) {
                throw new WrongAttributeTypeException(attrNames[attrIx], this.getType());
            }
            catch (IllegalAccessException e) {
                throw new AttrNotSettableException((ManagedObject)this, attrNames[attrIx]);
            }
        }
    }

    private static class BoamMoFilter
    implements MoFilter {
        private BoamMoFilter() {
        }

        public boolean accept(ManagedObject mo) {
            return mo instanceof BoamManagedObject;
        }
    }
}

