/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.dmo.alarm;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCreateGroupRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.RbsGroupFroInfoT;
import se.ericsson.wcdma.rbs.boam.mao.common.ErrorMgr;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxDeviceGroupMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxDeviceGroupMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.XalmDeviceGroupMo;

public class XalmDeviceGroupMoImpl
extends AuxDeviceGroupMoImpl
implements XalmDeviceGroupMo {
    public static final int MO_DATA_REVISION = 0x2DEDD2;
    private StringAttribute userLabel;
    private IntegerAttribute froId;
    private IntegerAttribute alarmStatus;

    public XalmDeviceGroupMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        MessageLog.traceEnter(this.getClass(), "Recovery XalmDeviceGroupMoImpl() <---");
        this.userLabel = (StringAttribute)recoveredData.getAttribute("userLabel");
        this.froId = (IntegerAttribute)recoveredData.getAttribute("auxGroupFroId");
        this.alarmStatus = (IntegerAttribute)recoveredData.getAttribute("alarmStatus");
        ErrorMgr.shotDownIfNull(this.userLabel, "userLabel");
        ErrorMgr.shotDownIfNull(this.froId, "auxGroupFroId");
        ErrorMgr.shotDownIfNull(this.alarmStatus, "alarmStatus");
        try {
            this.addObservers(49558, null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Couldn't init the Observers!!");
        }
        MessageLog.trace(1, this.getClass(), "Mo recovered");
    }

    private XalmDeviceGroupMoImpl(ManagedObject parent, String userLabel, int checkedAlarmStatus, String identity, Coordinator context) throws MoAccessException {
        super(parent, "XalmDeviceGroup", identity, context);
        MessageLog.traceEnter(this.getClass(), "XalmDeviceGroup() <---");
        EqcCreateGroupRspS rsp = this.createAuxDeviceGroupResource(parent, 49558, context);
        RbsGroupFroInfoT groupFroInfo = rsp.groupFroInfo;
        int auxGroupFroId = (int)rsp.groupFroInfo.groupFroId;
        this.initMoData(userLabel, auxGroupFroId, context);
        this.initAlarmStatus(checkedAlarmStatus, context);
        AuxDeviceGroupMoFactory.instance(49558).createDeviceGroupMoTree((ManagedObject)this, groupFroInfo, "", context);
        this.addObservers(49558, context);
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(XalmDeviceGroupMoImpl.class, "create () <---");
        ValidateAttributes.checkTransaction(context);
        String checkedUserLabel = ValidateAttributes.checkAndGetStringAttribute(attributes, "userLabel", "optional", "", 0, 128, "XalmDeviceGroup");
        int checkedAlarmStatus = XalmDeviceGroupMoImpl.checkAndGetAlarmStatus(attributes, 0, "XalmDeviceGroup", context);
        ValidateAttributes.checkOtherAttributes(attributes, "XalmDeviceGroup");
        return new XalmDeviceGroupMoImpl(parent, checkedUserLabel, checkedAlarmStatus, identity, context);
    }

    private void initMoData(String userLabel, int auxGroupFroId, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "initMoData() <---");
        this.getMyMoData().handleTransaction(context, MoData.WRITE_ACCESS);
        this.bcmStoreAndRegisterStringAttribute("userLabel", userLabel);
        this.bcmStoreAndRegisterIntAttribute("auxGroupFroId", auxGroupFroId);
        this.getMyMoData().setRevision(0x2DEDD2);
    }

    public String getType() {
        return "XalmDeviceGroup";
    }
}

