/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCreateGroupRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.RbsGroupFroInfoT;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObjectWithAlarms;
import se.ericsson.wcdma.rbs.boam.mao.dmo.alarm.XalmDeviceGroupMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxDeviceSetMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.dmo.climate.CluDeviceGroupMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.climate.FanDeviceGroupMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.climate.FcuDeviceGroupMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.device.DeviceGroupMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.device.DeviceSetMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.dmo.power.BfuDeviceGroupMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.power.CuDeviceGroupMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.power.PauDeviceGroupMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.power.PcuDeviceGroupMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.power.PsuDeviceGroupMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.rru.RruDeviceGroupMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.tr.AscDeviceGroupMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.tr.FuDeviceGroupMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.tr.McpaDeviceGroupMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.tr.RetuDeviceGroupMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.tr.RuDeviceGroupMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.tr.SaiuDeviceGroupMoImpl;

public class AuxDeviceGroupMoFactory
implements MoFactory {
    private static final int RBS_SUP_GROUP_FIXME = -7771777;
    private static AuxDeviceGroupMoFactory fanInstance;
    private static AuxDeviceGroupMoFactory mcpaInstance;
    private static AuxDeviceGroupMoFactory pcuInstance;
    private static AuxDeviceGroupMoFactory cuInstance;
    private static AuxDeviceGroupMoFactory ascInstance;
    private static AuxDeviceGroupMoFactory xalmInstance;
    private static AuxDeviceGroupMoFactory retInstance;
    private static AuxDeviceGroupMoFactory pauInstance;
    private static AuxDeviceGroupMoFactory saiuInstance;
    private static AuxDeviceGroupMoFactory rruInstance;
    private static AuxDeviceGroupMoFactory ruInstance;
    private static AuxDeviceGroupMoFactory fuInstance;
    private static AuxDeviceGroupMoFactory bfuInstance;
    private static AuxDeviceGroupMoFactory cluInstance;
    private static AuxDeviceGroupMoFactory fcuInstance;
    private static AuxDeviceGroupMoFactory psuInstance;
    private static AuxDeviceGroupMoFactory atmauInstance;
    private static AuxDeviceGroupMoFactory ruwInstance;
    private static AuxDeviceGroupMoFactory supInstance;
    private static AuxDeviceGroupMoFactory xcuInstance;
    private static AuxDeviceGroupMoFactory airInstance;
    private static AuxDeviceGroupMoFactory rdInstance;
    private static AuxDeviceGroupMoFactory instance;
    private final int eqcAuxGroupType;

    private AuxDeviceGroupMoFactory(int groupType) {
        MessageLog.traceEnter(this.getClass(), "GroupType = " + groupType + ", Normal constructor");
        this.eqcAuxGroupType = groupType;
        MoFactoryMgr.instance().register((MoFactory)this, this.getMoTypeName());
    }

    public static synchronized AuxDeviceGroupMoFactory instance(int groupType) {
        switch (groupType) {
            case 49553: {
                if (mcpaInstance == null) {
                    mcpaInstance = new AuxDeviceGroupMoFactory(groupType);
                }
                instance = mcpaInstance;
                break;
            }
            case 49554: {
                if (cuInstance == null) {
                    cuInstance = new AuxDeviceGroupMoFactory(groupType);
                }
                instance = cuInstance;
                break;
            }
            case 49555: {
                if (fanInstance == null) {
                    fanInstance = new AuxDeviceGroupMoFactory(groupType);
                }
                instance = fanInstance;
                break;
            }
            case 49556: {
                if (pcuInstance == null) {
                    pcuInstance = new AuxDeviceGroupMoFactory(groupType);
                }
                instance = pcuInstance;
                break;
            }
            case 800004: {
                if (ascInstance == null) {
                    ascInstance = new AuxDeviceGroupMoFactory(groupType);
                }
                instance = ascInstance;
                break;
            }
            case 49558: {
                if (xalmInstance == null) {
                    xalmInstance = new AuxDeviceGroupMoFactory(groupType);
                }
                instance = xalmInstance;
                break;
            }
            case 49559: {
                if (retInstance == null) {
                    retInstance = new AuxDeviceGroupMoFactory(groupType);
                }
                instance = retInstance;
                break;
            }
            case 49560: {
                if (pauInstance == null) {
                    pauInstance = new AuxDeviceGroupMoFactory(groupType);
                }
                instance = pauInstance;
                break;
            }
            case 49561: {
                if (saiuInstance == null) {
                    saiuInstance = new AuxDeviceGroupMoFactory(groupType);
                }
                instance = saiuInstance;
                break;
            }
            case 49562: {
                if (rruInstance == null) {
                    rruInstance = new AuxDeviceGroupMoFactory(groupType);
                }
                instance = rruInstance;
                break;
            }
            case 49563: {
                if (ruInstance == null) {
                    ruInstance = new AuxDeviceGroupMoFactory(groupType);
                }
                instance = ruInstance;
                break;
            }
            case 49564: {
                if (fuInstance == null) {
                    fuInstance = new AuxDeviceGroupMoFactory(groupType);
                }
                instance = fuInstance;
                break;
            }
            case 49567: {
                if (bfuInstance == null) {
                    bfuInstance = new AuxDeviceGroupMoFactory(groupType);
                }
                instance = bfuInstance;
                break;
            }
            case 49568: {
                if (cluInstance == null) {
                    cluInstance = new AuxDeviceGroupMoFactory(groupType);
                }
                instance = cluInstance;
                break;
            }
            case 49565: {
                if (fcuInstance == null) {
                    fcuInstance = new AuxDeviceGroupMoFactory(groupType);
                }
                instance = fcuInstance;
                break;
            }
            case 49566: {
                if (psuInstance == null) {
                    psuInstance = new AuxDeviceGroupMoFactory(groupType);
                }
                instance = psuInstance;
                break;
            }
            case 49578: {
                if (atmauInstance == null) {
                    atmauInstance = new AuxDeviceGroupMoFactory(groupType);
                }
                instance = atmauInstance;
                break;
            }
            case 49579: {
                if (ruwInstance == null) {
                    ruwInstance = new AuxDeviceGroupMoFactory(groupType);
                }
                instance = ruwInstance;
                break;
            }
            case -7771777: {
                if (supInstance == null) {
                    supInstance = new AuxDeviceGroupMoFactory(groupType);
                }
                instance = supInstance;
                break;
            }
            case 49583: {
                if (xcuInstance == null) {
                    xcuInstance = new AuxDeviceGroupMoFactory(groupType);
                }
                instance = xcuInstance;
                break;
            }
            case 49584: {
                if (airInstance == null) {
                    airInstance = new AuxDeviceGroupMoFactory(groupType);
                }
                instance = airInstance;
                break;
            }
            case 49588: {
                if (rdInstance == null) {
                    rdInstance = new AuxDeviceGroupMoFactory(groupType);
                }
                instance = rdInstance;
                break;
            }
            default: {
                instance = null;
            }
        }
        return instance;
    }

    public ManagedObject createMo(ManagedObject parent, AttrList attributes, String identity, ManagedObject ignored, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "createMo()");
        ManagedObject createdMo = this.createTheMo(parent, attributes, identity, context);
        MessageLog.trace(1, this.getClass(), "DeviceGroup MO Created");
        return createdMo;
    }

    public ManagedObject createTheMo(ManagedObject parent, AttrList attributes, String identity, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "createTheMo()");
        ManagedObject mo = null;
        switch (this.eqcAuxGroupType) {
            case 49555: {
                mo = FanDeviceGroupMoImpl.create(parent, attributes, identity, context);
                break;
            }
            case 49553: {
                mo = McpaDeviceGroupMoImpl.create(parent, attributes, identity, context);
                break;
            }
            case 49556: {
                mo = PcuDeviceGroupMoImpl.create(parent, attributes, identity, context);
                break;
            }
            case 49554: {
                mo = CuDeviceGroupMoImpl.create(parent, attributes, identity, context);
                break;
            }
            case 800004: {
                mo = AscDeviceGroupMoImpl.create(parent, attributes, identity, context);
                break;
            }
            case 49558: {
                mo = XalmDeviceGroupMoImpl.create(parent, attributes, identity, context);
                break;
            }
            case 49559: {
                mo = RetuDeviceGroupMoImpl.create(parent, attributes, identity, context);
                break;
            }
            case 49560: {
                mo = PauDeviceGroupMoImpl.create(parent, attributes, identity, context);
                break;
            }
            case 49561: {
                mo = SaiuDeviceGroupMoImpl.create(parent, attributes, identity, context);
                break;
            }
            case 49562: {
                mo = RruDeviceGroupMoImpl.create(parent, attributes, identity, context);
                break;
            }
            case 49563: {
                mo = RuDeviceGroupMoImpl.create(parent, attributes, identity, context);
                break;
            }
            case 49564: {
                mo = FuDeviceGroupMoImpl.create(parent, attributes, identity, context);
                break;
            }
            case 49567: {
                mo = BfuDeviceGroupMoImpl.create(parent, attributes, identity, context);
                break;
            }
            case 49568: {
                mo = CluDeviceGroupMoImpl.create(parent, attributes, identity, context);
                break;
            }
            case 49565: {
                mo = FcuDeviceGroupMoImpl.create(parent, attributes, identity, context);
                break;
            }
            case 49566: {
                mo = PsuDeviceGroupMoImpl.create(parent, attributes, identity, context);
                break;
            }
            case 49578: {
                mo = new DeviceGroupMoImpl(parent, attributes, "", 0, "ATMAU", context);
                break;
            }
            case 49579: {
                mo = new DeviceGroupMoImpl(parent, attributes, "", 0, "RUW", context);
                break;
            }
            case 49583: {
                mo = DeviceGroupMoImpl.create(parent, attributes, "XCU", context);
                break;
            }
            case 49584: {
                mo = new DeviceGroupMoImpl(parent, attributes, "", 0, identity, context);
                break;
            }
            default: {
                MessageLog.traceError(this.getClass(), "createTheMo(),Software Error in BOAM, illegal group type:" + this.eqcAuxGroupType);
            }
        }
        MessageLog.trace(1, this.getClass(), "createTheMo() return");
        return mo;
    }

    public void createDeviceGroupMoTree(ManagedObject parent, EqcCreateGroupRspS createGroupRspSignal, String userLabel, Coordinator context) throws MoAccessException {
        this.createDeviceGroupMoTree(parent, createGroupRspSignal.groupFroInfo, userLabel, context);
    }

    public void createDeviceGroupMoTree(ManagedObject parent, RbsGroupFroInfoT groupFroInfo, String userLabel, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "createDeviceGroupMoTree");
        MessageLog.trace(1, this.getClass(), "createDeviceGroupMoTree groupFroInfo.numberOfSets = " + groupFroInfo.numberOfSets);
        int feDevSetIdentityCnt = 0;
        int tpaDevSetIdentityCnt = 0;
        int pdDevSetIdentityCnt = 0;
        int tmaDevSetIdentityCnt = 0;
        int almDevSetIdentityCnt = 0;
        int outDevSetIdentityCnt = 0;
        int retDevSetIdentityCnt = 0;
        int aiDevSetIdentityCnt = 0;
        int dpclDevSetIdentityCnt = 0;
        int trDevSetIdentityCnt = 0;
        int bfDevSetIdentityCnt = 0;
        int clDevSetIdentityCnt = 0;
        int psDevSetIdentityCnt = 0;
        for (int i = 0; i < groupFroInfo.numberOfSets; ++i) {
            int setType = groupFroInfo.devSetFroInfo[i].devSetType;
            int identityCnt = 0;
            MessageLog.trace(1, this.getClass(), "createDeviceGroupMoTree  setType" + setType);
            switch (setType) {
                case 800002: {
                    identityCnt = ++feDevSetIdentityCnt;
                    break;
                }
                case 49760: {
                    identityCnt = ++tpaDevSetIdentityCnt;
                    break;
                }
                case 49765: {
                    identityCnt = ++pdDevSetIdentityCnt;
                    break;
                }
                case 49766: {
                    identityCnt = ++tmaDevSetIdentityCnt;
                    break;
                }
                case 49767: {
                    identityCnt = ++almDevSetIdentityCnt;
                    break;
                }
                case 49768: {
                    identityCnt = ++outDevSetIdentityCnt;
                    break;
                }
                case 49769: {
                    identityCnt = ++retDevSetIdentityCnt;
                    break;
                }
                case 49759: {
                    identityCnt = ++aiDevSetIdentityCnt;
                    break;
                }
                case 49757: {
                    identityCnt = ++dpclDevSetIdentityCnt;
                    break;
                }
                case 49756: {
                    identityCnt = ++trDevSetIdentityCnt;
                    break;
                }
                case 49762: {
                    identityCnt = ++bfDevSetIdentityCnt;
                    break;
                }
                case 49764: {
                    identityCnt = ++clDevSetIdentityCnt;
                    break;
                }
                case 49761: {
                    identityCnt = ++psDevSetIdentityCnt;
                    break;
                }
                default: {
                    MessageLog.traceError(this.getClass(), "createDeviceGroupMoTree(), illegal device set:" + setType);
                }
            }
            String devSetIdentity = "" + identityCnt;
            AuxDeviceSetMoFactory auxDevSetFactory = AuxDeviceSetMoFactory.instance(setType);
            DeviceSetMoFactory devSetFactory = DeviceSetMoFactory.instance(setType);
            if (auxDevSetFactory == null) {
                if (devSetFactory == null) {
                    MessageLog.traceError(this.getClass(), " Device Set Factory could not be determined.");
                } else {
                    MessageLog.trace(1, this.getClass(), " (plain) Device Set Factory (Must be Dpcl) determined for setType=" + setType);
                    devSetFactory.createDeviceSetMoTree(parent, groupFroInfo.devSetFroInfo[i], devSetIdentity, userLabel, context);
                }
            } else {
                MessageLog.trace(1, this.getClass(), " Aux Device Set Factory determined for setType =  " + setType);
                auxDevSetFactory.createDeviceSetMoTree(parent, groupFroInfo.devSetFroInfo[i], devSetIdentity, userLabel, context);
            }
            MessageLog.trace(1, this.getClass(), "DeviceGroup MO Tree created properly.");
        }
    }

    public ManagedObject recoverMo(MoData recoveredData) throws MoNameAlreadyTakenException {
        MessageLog.traceEnter(this.getClass(), "recoverMo for auxiliary DeviceGroup type : " + this.eqcAuxGroupType);
        BoamManagedObjectWithAlarms mo = null;
        switch (this.eqcAuxGroupType) {
            case 49553: {
                mo = new McpaDeviceGroupMoImpl(recoveredData);
                break;
            }
            case 49554: {
                mo = new CuDeviceGroupMoImpl(recoveredData);
                break;
            }
            case 49555: {
                mo = new FanDeviceGroupMoImpl(recoveredData);
                break;
            }
            case 49556: {
                mo = new PcuDeviceGroupMoImpl(recoveredData);
                break;
            }
            case 800004: {
                mo = new AscDeviceGroupMoImpl(recoveredData);
                break;
            }
            case 49558: {
                mo = new XalmDeviceGroupMoImpl(recoveredData);
                break;
            }
            case 49559: {
                mo = new RetuDeviceGroupMoImpl(recoveredData);
                break;
            }
            case 49560: {
                mo = new PauDeviceGroupMoImpl(recoveredData);
                break;
            }
            case 49561: {
                mo = new SaiuDeviceGroupMoImpl(recoveredData);
                break;
            }
            case 49562: {
                mo = new RruDeviceGroupMoImpl(recoveredData);
                break;
            }
            case 49563: {
                mo = new RuDeviceGroupMoImpl(recoveredData);
                break;
            }
            case 49564: {
                mo = new FuDeviceGroupMoImpl(recoveredData);
                break;
            }
            case 49567: {
                mo = new BfuDeviceGroupMoImpl(recoveredData);
                break;
            }
            case 49568: {
                mo = new CluDeviceGroupMoImpl(recoveredData);
                break;
            }
            case 49565: {
                mo = new FcuDeviceGroupMoImpl(recoveredData);
                break;
            }
            case 49566: {
                mo = new PsuDeviceGroupMoImpl(recoveredData);
                break;
            }
            case -7771777: 
            case 49578: 
            case 49579: 
            case 49583: {
                mo = new DeviceGroupMoImpl(recoveredData);
                break;
            }
            default: {
                MessageLog.traceError(this.getClass(), "recoverMo(),Software Error in BOAM, illegal group type:" + this.eqcAuxGroupType);
            }
        }
        return mo;
    }

    public String getMoTypeName() {
        String name = "UnknownDeviceGroup";
        switch (this.eqcAuxGroupType) {
            case 49555: {
                name = "FanDeviceGroup";
                break;
            }
            case 49553: {
                name = "McpaDeviceGroup";
                break;
            }
            case 49556: {
                name = "PcuDeviceGroup";
                break;
            }
            case 49554: {
                name = "CuDeviceGroup";
                break;
            }
            case 800004: {
                name = "AscDeviceGroup";
                break;
            }
            case 49558: {
                name = "XalmDeviceGroup";
                break;
            }
            case 49559: {
                name = "RetuDeviceGroup";
                break;
            }
            case 49560: {
                name = "PauDeviceGroup";
                break;
            }
            case 49561: {
                name = "SaiuDeviceGroup";
                break;
            }
            case 49562: {
                name = "RruDeviceGroup";
                break;
            }
            case 49563: {
                name = "RuDeviceGroup";
                break;
            }
            case 49564: {
                name = "FuDeviceGroup";
                break;
            }
            case 49567: {
                name = "BfuDeviceGroup";
                break;
            }
            case 49568: {
                name = "CluDeviceGroup";
                break;
            }
            case 49565: {
                name = "FcuDeviceGroup";
                break;
            }
            case 49566: {
                name = "PsuDeviceGroup";
                break;
            }
            case 49578: {
                name = "DeviceGroup_ATMAU";
                break;
            }
            case 49579: {
                name = "DeviceGroup_RUW";
                break;
            }
            case 49583: {
                name = "DeviceGroup_XCU";
                break;
            }
            case 49584: {
                name = "DeviceGroup_AIR";
                break;
            }
            case 49588: {
                name = "DeviceGroup_RD";
                break;
            }
            default: {
                MessageLog.traceError(this.getClass(), "getMoTypeName(),Software Error in BOAM, unsupported group type:" + this.eqcAuxGroupType);
            }
        }
        return name;
    }

    public static synchronized void _reset_onlyForTest() {
        if (instance != null) {
            MoFactoryMgr.instance().deregister(instance.getMoTypeName());
            instance = null;
        }
    }

    static {
        instance = null;
    }
}

