/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.auxpiu;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import se.ericsson.cello.mao.IdGenerator;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.swmanagement.PiuTypeMo;
import se.ericsson.cello.swmanagement.RepertoireMaoi;
import se.ericsson.cello.swmanagement.RepertoireMo;
import se.ericsson.cello.swmanagement.SwAllocationMo;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.XpProgramMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.auxpiu.UpgradeableAuxPlugInUnit;
import se.ericsson.wcdma.rbs.boam.mao.dmo.device.DeviceGroupMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AscDeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AuxDeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AuxPlugInUnitMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.CuDeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.FanDeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.McpaDeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.PcuDeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RruDeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RuDeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.XalmDeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.XpProgramMo;

public final class AuxPlugInUnitUpgradeHelper {
    private static final Class THIS_CLASS = AuxPlugInUnitUpgradeHelper.class;
    public static final String GENERIC_PIU_TYPE_ID_RU = "RU-preInstalledSW";
    public static final String GENERIC_PIU_TYPE_ID_RRU = "RRU-preInstalledSW";
    public static final String GENERIC_PIU_TYPE_ID_RUW = "RUW-preInstalledSW";
    public static final String GENERIC_PIU_TYPE_ID_RRUW = "RRUW-preInstalledSW";
    public static final String GENERIC_PIU_TYPE_ID_IRU = "IRU-preInstalledSW";
    public static final String GENERIC_PIU_TYPE_ID_AIR = "AIR-preInstalledSW";

    public static boolean hasSwAllocation(AuxPlugInUnitMo auxPiu, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "hasSwAllocation()<---");
        return auxPiu.getSwAllocation(context) != null;
    }

    public static ManagedObject getNewRepertoire(ManagedObject auxPiu, ManagedObject piuType, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "getNewRepertoire()<---");
        if (auxPiu == null) {
            MessageLog.info(THIS_CLASS, "getNewRepertoire(): auxPiu: null");
        } else if (piuType == null) {
            MessageLog.info(THIS_CLASS, "getNewRepertoire(): piuType: null");
        } else {
            MessageLog.trace(2, THIS_CLASS, "getNewRepertoire(): auxPiu: " + auxPiu + ", type: " + auxPiu.getType());
            MessageLog.trace(2, THIS_CLASS, "getNewRepertoire(): piuType: " + piuType + ", type: " + piuType.getType());
            ManagedObject swa = ((UpgradeableAuxPlugInUnit)auxPiu).getSwAllocation(context);
            if (swa == null) {
                MessageLog.info(THIS_CLASS, "getNewRepertoire(): cannot get SwAllocation from: " + auxPiu);
            } else {
                ManagedObject[] repertoireList = ((SwAllocationMo)swa).getRepertoireList(context);
                String wantedPiuTypeName = piuType.getFullDistinguishedName();
                if (repertoireList == null) {
                    MessageLog.info(THIS_CLASS, "getNewRepertoire(): repertoire list from SwAllocation " + swa + " is: null");
                } else {
                    MessageLog.trace(2, THIS_CLASS, "getNewRepertoire(): repertoire list length is: " + repertoireList.length);
                    ArrayList<String> messages = new ArrayList<String>();
                    try {
                        for (int index = 0; index < repertoireList.length; ++index) {
                            RepertoireMo repertoireMo = (RepertoireMo)repertoireList[index];
                            ManagedObject[] piuTypes = repertoireMo.getPiuTypeList(context);
                            messages.add("getNewRepertoire(): Repertoire: " + repertoireMo + ", piuTypes list length: " + piuTypes.length);
                            for (int j = 0; j < piuTypes.length; ++j) {
                                String candidatePiuTypeName = piuTypes[j].getFullDistinguishedName();
                                messages.add("getNewRepertoire(): tried: " + candidatePiuTypeName);
                                if (!wantedPiuTypeName.equals(candidatePiuTypeName)) continue;
                                MessageLog.trace(2, THIS_CLASS, "getNewRepertoire(): names tried against " + wantedPiuTypeName + ":");
                                Iterator it = messages.iterator();
                                while (it.hasNext()) {
                                    MessageLog.trace(2, THIS_CLASS, (String)it.next());
                                }
                                MessageLog.trace(2, THIS_CLASS, "getNewRepertoire(): MATCH: retrieving repertoireList[" + index + "]=" + repertoireList[index].getFullDistinguishedName());
                                return repertoireList[index];
                            }
                        }
                        MessageLog.info(THIS_CLASS, "getNewRepertoire(): UNSUCCESSFUL MATCH, names tried against " + wantedPiuTypeName + ":");
                        Iterator it = messages.iterator();
                        while (it.hasNext()) {
                            MessageLog.info(THIS_CLASS, (String)it.next());
                        }
                    }
                    catch (MoAccessException e) {
                        Iterator it = messages.iterator();
                        while (it.hasNext()) {
                            MessageLog.info(THIS_CLASS, (String)it.next());
                        }
                        throw e;
                    }
                }
            }
        }
        return null;
    }

    public static ManagedObject getNewLoadModule(ManagedObject piuType, ManagedObject repertoire, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "getNewLoadModule()<---");
        if (repertoire == null) {
            MessageLog.info(THIS_CLASS, "cannot get new load module for piuType: " + piuType + ", repertoire: null");
            return null;
        }
        Struct[] lmDataList = ((RepertoireMaoi)repertoire).getLMData((PiuTypeMo)piuType, context);
        if (lmDataList == null || lmDataList.length == 0) {
            MessageLog.info(THIS_CLASS, "cannot get new load module for piuType: " + piuType + ", repertoire: " + repertoire);
            return null;
        }
        String lmDN = (String)lmDataList[0].getValue("loadModuleDN");
        MessageLog.trace(2, THIS_CLASS, "getNewLoadModule(): lmDN:" + lmDN);
        ManagedObject newLoadModule = MoRepository.instance().lookup(lmDN);
        if (newLoadModule == null) {
            MessageLog.info(THIS_CLASS, "cannot get new load module for piuType: " + piuType + ", repertoire: " + repertoire + ", LM distinguished name: " + lmDN);
            return null;
        }
        MessageLog.trace(2, THIS_CLASS, "new load module:" + newLoadModule.getLocalDistinguishedName());
        return newLoadModule;
    }

    public static ArrayList getAllXpProgram(ManagedObject auxPiu) {
        MessageLog.traceEnter(THIS_CLASS, "getAllXpProgram()<---");
        ArrayList<ManagedObject> xpPgmList = new ArrayList<ManagedObject>();
        ManagedObject grp = AuxPlugInUnitUpgradeHelper.getAuxDeviceGroupRef(auxPiu);
        if (grp == null) {
            MessageLog.trace(2, THIS_CLASS, "getAllXpProgram() : No DeviceGroup and no XpProgram is defined for Aux:" + auxPiu.getFullDistinguishedName());
            return xpPgmList;
        }
        MoIterator moIter = grp.getChildren();
        while (moIter.hasMoreElements()) {
            ManagedObject xpMo = moIter.nextMo();
            MessageLog.trace(2, THIS_CLASS, "getAllXpProgram() : while : parsing mo:" + xpMo.getType());
            if (!xpMo.getType().equals("XpProgram")) continue;
            MessageLog.trace(2, THIS_CLASS, "getAllXpProgram() :adding to xp list!");
            xpPgmList.add(xpMo);
        }
        return xpPgmList;
    }

    public static ManagedObject getCurrentLoadModule(ManagedObject auxPiu, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "getCurrentLoadModule()<---");
        ManagedObject auxDevGroup = null;
        MoIterator moIterator = ((UpgradeableAuxPlugInUnit)auxPiu).getChildren();
        while (moIterator.hasMoreElements()) {
            auxDevGroup = moIterator.nextMo();
        }
        moIterator = auxDevGroup.getChildren();
        ManagedObject currentLoadModule = null;
        while (moIterator.hasMoreElements()) {
            ManagedObject mo = moIterator.nextMo();
            if (!mo.getType().equals("XpProgram") || ((XpProgramMo)mo).getStartState(context) != 1) continue;
            currentLoadModule = ((XpProgramMo)mo).getLoadModule(context);
            break;
        }
        return currentLoadModule;
    }

    public static ManagedObject fetchNewPiuType(ManagedObject auxPiu, String productNumber, String productRevision, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "fetchNewPiuType()<---");
        String allRevStatusAcceptedSymbol = "*";
        ManagedObject newPiuType = null;
        MessageLog.trace(4, THIS_CLASS, "productNumber: " + productNumber + "productRevision: " + productRevision);
        ManagedObject[] allPiuTypesAvailable = AuxPlugInUnitUpgradeHelper.getAllPiuTypes(auxPiu, context);
        MessageLog.trace(4, THIS_CLASS, "Found " + (allPiuTypesAvailable != null ? allPiuTypesAvailable.length : 0) + "piuTypes");
        if (allPiuTypesAvailable != null && allPiuTypesAvailable.length != 0) {
            ArrayList<ManagedObject> candidateList = new ArrayList<ManagedObject>();
            for (int i = 0; i < allPiuTypesAvailable.length; ++i) {
                Struct pidData = ((PiuTypeMo)allPiuTypesAvailable[i]).getProductData(context);
                String prodNum = (String)pidData.getValue("productNumber");
                String prodRev = (String)pidData.getValue("productRevision");
                MessageLog.trace(4, THIS_CLASS, "Comparing with prodNum: " + prodNum + ", " + "prodRev: " + prodRev);
                if (!AuxPlugInUnitUpgradeHelper.equalsTo(productNumber, prodNum)) continue;
                if (prodRev.equalsIgnoreCase("*") || AuxPlugInUnitUpgradeHelper.equalsTo(productRevision, prodRev)) {
                    newPiuType = allPiuTypesAvailable[i];
                    MessageLog.trace(4, THIS_CLASS, "Found match!");
                    break;
                }
                if (!AuxPlugInUnitUpgradeHelper.compareRevisionSymbols(productRevision, prodRev)) continue;
                candidateList.add(allPiuTypesAvailable[i]);
            }
            if (newPiuType == null) {
                if (!AuxPlugInUnitUpgradeHelper.revisionHasDigitAsIndex(productRevision)) {
                    MessageLog.trace(4, THIS_CLASS, "Trying to find close enough match among candidates");
                    Iterator ind = candidateList.iterator();
                    int minimalCalcRev = 9999999;
                    while (ind.hasNext()) {
                        int calcValProdRev2;
                        ManagedObject aPiu = (ManagedObject)ind.next();
                        Struct pidData = ((PiuTypeMo)aPiu).getProductData(context);
                        String prodRev = (String)pidData.getValue("productRevision");
                        MessageLog.trace(4, THIS_CLASS, "Trying with prodRev: " + prodRev);
                        int calcValProdRev1 = AuxPlugInUnitUpgradeHelper.revCalc(AuxPlugInUnitUpgradeHelper.takeOffTheRevisionSymbol(productRevision).toCharArray(), 0, 0);
                        int dif = calcValProdRev1 - (calcValProdRev2 = AuxPlugInUnitUpgradeHelper.revCalc(AuxPlugInUnitUpgradeHelper.takeOffTheRevisionSymbol(prodRev).toCharArray(), 0, 0));
                        if (dif < 0 || dif >= minimalCalcRev) continue;
                        minimalCalcRev = dif;
                        newPiuType = aPiu;
                        MessageLog.trace(4, THIS_CLASS, "Found match!");
                    }
                } else {
                    MessageLog.traceError(THIS_CLASS, "R-state is on special type, no PIU possible match !");
                }
            }
        }
        return newPiuType;
    }

    /*
     * WARNING - void declaration
     */
    public static ManagedObject fetchNewGenericPiuType(ManagedObject auxPiu, String hwProductName, Coordinator context) throws MoAccessException {
        String genericPiuTypeId;
        MessageLog.traceEnter(THIS_CLASS, "fetchNewGenericPiuType()<---");
        String normalizedHwProductName = hwProductName.trim().toUpperCase(Locale.ENGLISH);
        MessageLog.trace(4, THIS_CLASS, "normalized HwProductName: " + normalizedHwProductName);
        if (normalizedHwProductName.startsWith("RRUW") || normalizedHwProductName.startsWith("RRUS") || AuxPlugInUnitUpgradeHelper.matchMarketName4NGR(normalizedHwProductName, new String[]{"RRU", "RADIO"})) {
            genericPiuTypeId = GENERIC_PIU_TYPE_ID_RRUW;
        } else if (normalizedHwProductName.startsWith("RRU")) {
            genericPiuTypeId = GENERIC_PIU_TYPE_ID_RRU;
        } else if (normalizedHwProductName.startsWith("RUW") || normalizedHwProductName.startsWith("RUS") || AuxPlugInUnitUpgradeHelper.matchNGRNewNamingRulePattern(normalizedHwProductName, "RU")) {
            genericPiuTypeId = GENERIC_PIU_TYPE_ID_RUW;
        } else if (normalizedHwProductName.indexOf("RU") == 0 && (normalizedHwProductName.indexOf("21") != -1 || normalizedHwProductName.indexOf("22") != -1)) {
            genericPiuTypeId = GENERIC_PIU_TYPE_ID_RU;
        } else if (normalizedHwProductName.startsWith("IRU")) {
            genericPiuTypeId = GENERIC_PIU_TYPE_ID_IRU;
        } else if (normalizedHwProductName.startsWith("AIR")) {
            genericPiuTypeId = GENERIC_PIU_TYPE_ID_AIR;
            if (normalizedHwProductName.indexOf("4455") != -1) {
                genericPiuTypeId = GENERIC_PIU_TYPE_ID_RRUW;
            }
        } else {
            return null;
        }
        MoIterator piuTypeIterator = MoRepository.instance().lookupType("PiuType");
        MessageLog.trace(4, THIS_CLASS, "Found " + piuTypeIterator.size() + "generic piuTypes");
        while (piuTypeIterator.hasMoreElements()) {
            void var4_4;
            PiuTypeMo maybeTheOne = (PiuTypeMo)piuTypeIterator.nextMo();
            Struct pidData = maybeTheOne.getProductData(context);
            String prodNumber = (String)pidData.getValue("productNumber");
            MessageLog.trace(4, THIS_CLASS, "Trying with prodNumber: " + prodNumber);
            if (!var4_4.equals(prodNumber)) continue;
            MessageLog.trace(4, THIS_CLASS, "Found match!");
            return maybeTheOne;
        }
        return null;
    }

    private static boolean matchMarketName4NGR(String toMatch, String[] newPrefixs) {
        for (int index = 0; index < newPrefixs.length; ++index) {
            boolean isMatch = AuxPlugInUnitUpgradeHelper.matchNGRNewNamingRulePattern(toMatch, newPrefixs[index]);
            if (!isMatch) continue;
            return true;
        }
        return false;
    }

    private static boolean matchNGRNewNamingRulePattern(String toMatch, String newPrefix) {
        boolean isMatch = false;
        StringBuffer noSpaceNameBuffer = new StringBuffer();
        for (int index = 0; index < toMatch.length(); ++index) {
            if (toMatch.charAt(index) == ' ') continue;
            noSpaceNameBuffer.append(toMatch.charAt(index));
        }
        toMatch = noSpaceNameBuffer.toString().trim();
        int DIGITAL_LENGTH = 4;
        String CONST_B_STR = "B";
        if (toMatch.startsWith(newPrefix) && toMatch.length() >= newPrefix.length() + 4 + "B".length() && AuxPlugInUnitUpgradeHelper.isAllDigital(toMatch, newPrefix.length(), 4) && toMatch.substring(newPrefix.length() + 4, newPrefix.length() + 4 + "B".length()).equals("B")) {
            isMatch = true;
        }
        return isMatch;
    }

    public static boolean isAllDigital(String toMatch, int startIndex, int digitalLength) {
        boolean isAllDigital = true;
        for (int offSet = 0; offSet < digitalLength; ++offSet) {
            if (Character.isDigit(toMatch.charAt(startIndex + offSet))) continue;
            isAllDigital = false;
            break;
        }
        return isAllDigital;
    }

    public static boolean isGenericPiuType(PiuTypeMo piuType, Coordinator context) throws MoAccessException {
        Struct pidData = piuType.getProductData(context);
        String prodNumber = (String)pidData.getValue("productNumber");
        return prodNumber.equals(GENERIC_PIU_TYPE_ID_RRU) || prodNumber.equals(GENERIC_PIU_TYPE_ID_RU) || prodNumber.equals(GENERIC_PIU_TYPE_ID_RUW) || prodNumber.equals(GENERIC_PIU_TYPE_ID_RRUW) || prodNumber.equals(GENERIC_PIU_TYPE_ID_IRU) || prodNumber.equals(GENERIC_PIU_TYPE_ID_AIR);
    }

    public static boolean isGenericPiuTypeInRepertoire(PiuTypeMo piuType, UpgradeableAuxPlugInUnit upgradeablePIU, Coordinator context) throws MoAccessException {
        ManagedObject swa = upgradeablePIU.getSwAllocation(context);
        if (swa == null) {
            MessageLog.info(THIS_CLASS, "isGenericPiuTypeInRepertoire(): cannot get SwAllocation from: " + upgradeablePIU);
        } else {
            ManagedObject[] repertoires = ((SwAllocationMo)swa).getRepertoireList(context);
            if (repertoires != null) {
                for (int i = 0; i < repertoires.length; ++i) {
                    ManagedObject[] piuTypes = ((RepertoireMo)repertoires[i]).getPiuTypeList(context);
                    String strPiuTypeDistinguishedName = piuType.getLocalDistinguishedName();
                    if (piuTypes == null) continue;
                    for (int j = 0; j < piuTypes.length; ++j) {
                        if (!piuTypes[j].getLocalDistinguishedName().equals(strPiuTypeDistinguishedName)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static void disableOldPrograms(ManagedObject auxPiu, ManagedObject piuType, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "disableOldPrograms()<---");
        Struct[] progConfigList = ((PiuTypeMo)piuType).getProgramConfiguration(c);
        if (progConfigList != null) {
            for (int pc = 0; pc < progConfigList.length; ++pc) {
                ManagedObject parent = AuxPlugInUnitUpgradeHelper.getPiuParent(progConfigList[pc], auxPiu, c);
                if (parent == null) continue;
                MoIterator xpMoIter = parent.getChildren();
                MessageLog.trace(2, THIS_CLASS, "disableOldPrograms() : piu parent != null!");
                while (xpMoIter.hasMoreElements()) {
                    ManagedObject xpMo = xpMoIter.nextMo();
                    MessageLog.trace(2, THIS_CLASS, "disableOldPrograms() : parsing iteration with current possible xpMo :" + xpMo.getType());
                    if (!xpMo.getType().equals("XpProgram")) continue;
                    MessageLog.trace(2, THIS_CLASS, "disableOldPrograms() : MATCH, calling XpProgramMo.setStartStop(DISABLED)");
                    ((XpProgramMo)xpMo).setStartState(0, c);
                }
            }
        }
    }

    public static void createNewXpProgram(ManagedObject auxPiu, ManagedObject piuType, ManagedObject loadModule, String hwProductNumber, String hwProductRevision, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "createNewXpProgram()<---");
        Struct[] progConfigList = ((PiuTypeMo)piuType).getProgramConfiguration(c);
        if (progConfigList != null) {
            MessageLog.trace(2, THIS_CLASS, "createNewXpProgram() : progConfigList != null");
            for (int pc = 0; pc < progConfigList.length; ++pc) {
                ManagedObject parent = AuxPlugInUnitUpgradeHelper.getPiuParent(progConfigList[pc], auxPiu, c);
                if (AuxPlugInUnitUpgradeHelper.isAuxGroupLoadable(parent)) {
                    XpProgramMoFactory xpProgramMoFactory = XpProgramMoFactory.instance();
                    xpProgramMoFactory.createWithUpSw(parent, IdGenerator.getNext(), hwProductNumber, hwProductRevision, loadModule, c);
                    continue;
                }
                MessageLog.trace(2, THIS_CLASS, "createNewXpProgram() : AuxPiu is not loadble!! No Program configuration is needed for:" + parent.getLocalDistinguishedName());
            }
        }
    }

    public static ManagedObject getPiuParent(Struct struct, ManagedObject auxPiu, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "getPiuParent()<---");
        ManagedObject parent = null;
        if (struct != null) {
            MessageLog.trace(2, THIS_CLASS, "getPiuParent(): struct != null ");
            String subParentLDN = (String)struct.getValue("subParentLDN");
            String parentLDN = auxPiu.getLocalDistinguishedName();
            MessageLog.trace(2, THIS_CLASS, "getPiuParent():subParentLDN : " + subParentLDN + "|||parentLDN : " + parentLDN);
            if (!subParentLDN.equalsIgnoreCase("")) {
                parentLDN = auxPiu.getLocalDistinguishedName() + "," + subParentLDN;
                MessageLog.trace(2, THIS_CLASS, "getPiuParent():subParentLDN != Strings.EMPTY_STRING : parentLDN :" + parentLDN);
            }
        }
        if ((parent = AuxPlugInUnitUpgradeHelper.getAuxDeviceGroupRef(auxPiu)) == null) {
            MessageLog.trace(2, THIS_CLASS, "getPiuParent(): WARNING, looked up parent is NULL!");
        }
        return parent;
    }

    public static void wait(int time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static ManagedObject findManagedElementDataMO() {
        MessageLog.traceEnter(THIS_CLASS, "findManagedElementDataMO()<---");
        ManagedObject meData = null;
        MoIterator iter = MoRepository.instance().lookupType("ManagedElementData");
        if (iter != null && iter.hasMoreElements()) {
            meData = iter.nextMo();
        }
        return meData;
    }

    public static void destroyTX(Control control) {
        try {
            control.getTerminator().rollback();
        }
        catch (Exception e) {
            MessageLog.trace(4, AuxPlugInUnitUpgradeHelper.class, "destroyTX(), Rollback failed due to exception:" + e);
        }
    }

    private static ManagedObject getAuxDeviceGroupRef(ManagedObject auxPiu) {
        MessageLog.traceEnter(THIS_CLASS, "getAuxDeviceGroupRef()<---");
        ManagedObject auxDevGr = null;
        MoIterator moIter = auxPiu.getChildren();
        boolean aHit = false;
        while (moIter.hasMoreElements() && !aHit) {
            ManagedObject mo;
            auxDevGr = mo = moIter.nextMo();
            aHit = AuxPlugInUnitUpgradeHelper.isAuxGroupLoadable(mo);
        }
        return auxDevGr;
    }

    public static boolean isAuxGroupLoadable(ManagedObject mo) {
        MessageLog.traceEnter(THIS_CLASS, "isAuxGroupLoadable()<---");
        boolean result2 = false;
        if (mo != null && (mo instanceof XalmDeviceGroupMo || mo instanceof CuDeviceGroupMo || mo instanceof FanDeviceGroupMo || mo instanceof PcuDeviceGroupMo || mo instanceof RruDeviceGroupMo || mo instanceof McpaDeviceGroupMo || mo instanceof RuDeviceGroupMo || mo instanceof AscDeviceGroupMo || DeviceGroupMoImpl.checkIfMoIsGenericDeviceGroupOfType(mo, "XALM") || DeviceGroupMoImpl.checkIfMoIsGenericDeviceGroupOfType(mo, "CU") || DeviceGroupMoImpl.checkIfMoIsGenericDeviceGroupOfType(mo, "FAN") || DeviceGroupMoImpl.checkIfMoIsGenericDeviceGroupOfType(mo, "PCU") || DeviceGroupMoImpl.checkIfMoIsGenericDeviceGroupOfType(mo, "RRU") || DeviceGroupMoImpl.checkIfMoIsGenericDeviceGroupOfType(mo, "MCPA") || DeviceGroupMoImpl.checkIfMoIsGenericDeviceGroupOfType(mo, "RU") || DeviceGroupMoImpl.checkIfMoIsGenericDeviceGroupOfType(mo, "ASC") || DeviceGroupMoImpl.checkIfMoIsGenericDeviceGroupOfType(mo, "RUW") || DeviceGroupMoImpl.checkIfMoIsGenericDeviceGroupOfType(mo, "XCU") || DeviceGroupMoImpl.checkIfMoIsGenericDeviceGroupOfType(mo, "AIR"))) {
            result2 = true;
        }
        return result2;
    }

    public static void restartCurrentAuxDeviceGroup(ManagedObject auxPiu, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "restartCurrentAuxDeviceGroup()<---");
        AuxDeviceGroupMo auxDevGr = (AuxDeviceGroupMo)AuxPlugInUnitUpgradeHelper.getAuxDeviceGroupRef(auxPiu);
        if (auxDevGr != null) {
            auxDevGr.startupAuxDevGr(c);
        }
    }

    public static ManagedObject createHwNewXpProgram(String hwProductNumber, String hwProductRevision, ManagedObject auxPiu, ManagedObject loadModule, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "createHwNewXpProgram() using createWithUpSw()<---");
        ManagedObject parent = AuxPlugInUnitUpgradeHelper.getAuxDeviceGroupRef(auxPiu);
        ManagedObject xpProgram = null;
        XpProgramMoFactory xpProgramMoFactory = XpProgramMoFactory.instance();
        if (xpProgramMoFactory != null) {
            xpProgram = xpProgramMoFactory.createWithUpSw(parent, IdGenerator.getNext(), hwProductNumber, hwProductRevision, loadModule, c);
        }
        return xpProgram;
    }

    public static ManagedObject createHwNewXpProgram(String hwProductNumber, String hwProductRevision, String preInstalledSwProdNum, String preInstalledSwProdRev, ManagedObject auxPiu, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "createHwNewXpProgram() using createWithpreInstalledSw()<---");
        ManagedObject parent = AuxPlugInUnitUpgradeHelper.getAuxDeviceGroupRef(auxPiu);
        ManagedObject xpProgram = null;
        XpProgramMoFactory xpProgramMoFactory = XpProgramMoFactory.instance();
        if (xpProgramMoFactory != null) {
            xpProgram = xpProgramMoFactory.createWithpreInstalledSw(parent, IdGenerator.getNext(), hwProductNumber, hwProductRevision, preInstalledSwProdNum, preInstalledSwProdRev, c);
        }
        return xpProgram;
    }

    private static String takeOffTheRevisionSymbol(String fullRev) {
        MessageLog.traceEnter(THIS_CLASS, "takeOffTheRevisionSymbol()<---");
        int indexR = fullRev.indexOf("R");
        return indexR != -1 ? fullRev.substring(indexR) : fullRev;
    }

    private static boolean compareRevisionSymbols(String rev1, String rev2) {
        MessageLog.traceEnter(THIS_CLASS, "compareRevisionSymbols()<---");
        return rev1.substring(0, 1).compareToIgnoreCase(rev2.substring(0, 1)) == 0;
    }

    private static int revCalc(char[] rev, int index, int calculatedValue) {
        MessageLog.traceEnter(THIS_CLASS, "revCalc(" + new String(rev) + "<---");
        if (rev.length < 7 && index < rev.length) {
            int specificValue = Character.getNumericValue(rev[index]);
            if (Character.isDigit(rev[index])) {
                specificValue *= 40;
            }
            calculatedValue = specificValue * UpgradeableAuxPlugInUnit.PRODUCT_REVISION_WEIGHT_CALCULATION_COEFFICIENTS[index] + AuxPlugInUnitUpgradeHelper.revCalc(rev, ++index, calculatedValue);
        }
        return calculatedValue;
    }

    private static boolean equalsTo(String id1, String id2) {
        MessageLog.traceEnter(THIS_CLASS, "equalsTo()<---");
        return id1 != null && id2 != null && id1.trim().compareToIgnoreCase(id2.trim()) == 0;
    }

    private static boolean revisionHasDigitAsIndex(String revision) {
        MessageLog.traceEnter(THIS_CLASS, "revisionHasDigitAsIndex()<---");
        return revision.indexOf("/") != -1 && Character.isDigit(revision.charAt(revision.indexOf("/") + 1));
    }

    private static ManagedObject[] getAllPiuTypes(ManagedObject auxPlugInUnit, Coordinator context) throws MoAccessException {
        ManagedObject[] repertoires;
        MessageLog.traceEnter(THIS_CLASS, "getAllPiuTypes()<---");
        ManagedObject swa = ((UpgradeableAuxPlugInUnit)auxPlugInUnit).getSwAllocation(context);
        ArrayList<ManagedObject> allPiuTypesList = new ArrayList<ManagedObject>();
        if (swa != null && (repertoires = ((SwAllocationMo)swa).getRepertoireList(context)) != null) {
            for (int i = 0; i < repertoires.length; ++i) {
                ManagedObject[] piuTypes = ((RepertoireMo)repertoires[i]).getPiuTypeList(context);
                if (piuTypes == null) continue;
                for (int j = 0; j < piuTypes.length; ++j) {
                    allPiuTypesList.add(piuTypes[j]);
                }
            }
        }
        return allPiuTypesList.toArray(new ManagedObject[allPiuTypesList.size()]);
    }
}

