/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.dmo.device;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCreateGroupRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.RbsGroupFroInfoT;
import se.ericsson.wcdma.rbs.boam.mao.dmo.device.DbDeviceGroupMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.device.DeviceSetMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.dmo.rru.ObifDeviceGroupMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.rru.RuifDeviceGroupMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.timing.RfifDeviceGroupMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.timing.TimDeviceSetMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.timing.TuDeviceGroupMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.tr.AiuDeviceGroupMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.tr.RaxDeviceGroupMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.tr.StrxDeviceGroupMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.tr.TrxDeviceGroupMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.tr.TxDeviceGroupMoImpl;

public class DeviceGroupMoFactory
implements MoFactory {
    private static DeviceGroupMoFactory tuInstance;
    private static DeviceGroupMoFactory trxInstance;
    private static DeviceGroupMoFactory strxInstance;
    private static DeviceGroupMoFactory txInstance;
    private static DeviceGroupMoFactory rfifInstance;
    private static DeviceGroupMoFactory raxInstance;
    private static DeviceGroupMoFactory aiuInstance;
    private static DeviceGroupMoFactory obifInstance;
    private static DeviceGroupMoFactory ruifInstance;
    private static DeviceGroupMoFactory duiInstance;
    private static int devGroupFaultCounter;
    private static int devGroupEventCounter;
    private static int devGroupHwLogCounter;
    private int eqcGroupType = 0;

    private DeviceGroupMoFactory(int groupType) {
        MessageLog.traceEnter(this.getClass(), "GroupType = " + groupType + ", Normal constructor");
        this.eqcGroupType = groupType;
        MoFactoryMgr.instance().register((MoFactory)this, this.getMoTypeName());
    }

    public static synchronized DeviceGroupMoFactory instance(int groupType) {
        DeviceGroupMoFactory instance = null;
        switch (groupType) {
            case 49569: {
                if (tuInstance == null) {
                    tuInstance = new DeviceGroupMoFactory(groupType);
                }
                instance = tuInstance;
                break;
            }
            case 49572: {
                if (trxInstance == null) {
                    trxInstance = new DeviceGroupMoFactory(groupType);
                }
                instance = trxInstance;
                break;
            }
            case 49575: {
                if (strxInstance == null) {
                    strxInstance = new DeviceGroupMoFactory(groupType);
                }
                instance = strxInstance;
                break;
            }
            case 49573: {
                if (txInstance == null) {
                    txInstance = new DeviceGroupMoFactory(groupType);
                }
                instance = txInstance;
                break;
            }
            case 49574: {
                if (rfifInstance == null) {
                    rfifInstance = new DeviceGroupMoFactory(groupType);
                }
                instance = rfifInstance;
                break;
            }
            case 49571: {
                if (raxInstance == null) {
                    raxInstance = new DeviceGroupMoFactory(groupType);
                }
                instance = raxInstance;
                break;
            }
            case 49570: {
                if (aiuInstance == null) {
                    aiuInstance = new DeviceGroupMoFactory(groupType);
                }
                instance = aiuInstance;
                break;
            }
            case 49576: {
                if (obifInstance == null) {
                    obifInstance = new DeviceGroupMoFactory(groupType);
                }
                instance = obifInstance;
                break;
            }
            case 49577: {
                if (ruifInstance == null) {
                    ruifInstance = new DeviceGroupMoFactory(groupType);
                }
                instance = ruifInstance;
                break;
            }
            case 49582: {
                if (duiInstance == null) {
                    duiInstance = new DeviceGroupMoFactory(groupType);
                }
                instance = duiInstance;
                break;
            }
            default: {
                instance = null;
            }
        }
        return instance;
    }

    public ManagedObject createMo(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "createMo()");
        ManagedObject createdMo = this.createTheMo(parent, attributes, identity, context);
        MessageLog.trace(1, this.getClass(), "Device Group MO Created");
        return createdMo;
    }

    public ManagedObject createTheMo(ManagedObject parent, AttrList attributes, String identity, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "createTheMo()");
        ManagedObject mo = null;
        switch (this.eqcGroupType) {
            case 49569: {
                mo = TuDeviceGroupMoImpl.create(parent, attributes, identity, context);
                break;
            }
            case 49572: {
                mo = TrxDeviceGroupMoImpl.create(parent, attributes, identity, context);
                break;
            }
            case 49575: {
                mo = StrxDeviceGroupMoImpl.create(parent, attributes, identity, context);
                break;
            }
            case 49573: {
                mo = TxDeviceGroupMoImpl.create(parent, attributes, identity, context);
                break;
            }
            case 49574: {
                mo = RfifDeviceGroupMoImpl.create(parent, attributes, identity, context);
                break;
            }
            case 49571: {
                mo = RaxDeviceGroupMoImpl.create(parent, attributes, identity, context);
                break;
            }
            case 49570: {
                mo = AiuDeviceGroupMoImpl.create(parent, attributes, identity, context);
                break;
            }
            case 49576: {
                mo = ObifDeviceGroupMoImpl.create(parent, attributes, identity, context);
                break;
            }
            case 49577: {
                mo = RuifDeviceGroupMoImpl.create(parent, attributes, identity, context);
                break;
            }
            default: {
                MessageLog.traceError(this.getClass(), "Software Error in BOAM, illegal group type");
            }
        }
        MessageLog.trace(1, this.getClass(), "createTheMo() return");
        return mo;
    }

    public void createDeviceGroupMoTree(ManagedObject targetMO, EqcCreateGroupRspS createGroupRspSignal, String userLabel, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "createDeviceGroupMoTree()");
        switch (this.eqcGroupType) {
            case 49569: {
                TimDeviceSetMoImpl.createTimDeviceSetTree4TuDeviceGroup(targetMO, createGroupRspSignal.groupFroInfo.devSetFroInfo[0], context);
                break;
            }
            default: {
                this.createDeviceGroupMoTreeDefaultCase(targetMO, createGroupRspSignal, userLabel, context);
            }
        }
        this.createSupportingMosIfAny(targetMO, createGroupRspSignal, context);
    }

    private void createDeviceGroupMoTreeDefaultCase(ManagedObject targetMO, EqcCreateGroupRspS createGroupRspSignal, String userLabel, Coordinator context) throws MoAccessException {
        RbsGroupFroInfoT groupFroInfo = createGroupRspSignal.groupFroInfo;
        int hsDbchSetIdentityCnt = 0;
        int dbchSetIdentityCnt = 0;
        int dbccSetIdentityCnt = 0;
        int dpclSetIdentityCnt = 0;
        int edbchSetIdentityCnt = 0;
        int escSetIdentityCnt = 0;
        int trSetIdentityCnt = 0;
        for (int i = 0; i < groupFroInfo.numberOfSets; ++i) {
            int setType = groupFroInfo.devSetFroInfo[i].devSetType;
            int identityCnt = 0;
            if (setType == 49775) {
                identityCnt = ++hsDbchSetIdentityCnt;
                MessageLog.trace(1, this.getClass(), "Create HsDbch!!!!");
            } else if (setType == 49754) {
                identityCnt = ++dbchSetIdentityCnt;
                MessageLog.trace(1, this.getClass(), "Create Dbch!!!!");
            } else if (setType == 49755) {
                identityCnt = ++dbccSetIdentityCnt;
                MessageLog.trace(1, this.getClass(), "Create Dbcc!!!!");
            } else if (setType == 49757) {
                identityCnt = ++dpclSetIdentityCnt;
                MessageLog.trace(1, this.getClass(), "Create Dpcl!!!!");
            } else if (setType == 49756) {
                identityCnt = ++trSetIdentityCnt;
                MessageLog.trace(1, this.getClass(), "Create Trx!!!!");
            } else if (setType == 49776) {
                identityCnt = ++edbchSetIdentityCnt;
                MessageLog.trace(1, this.getClass(), "Create EDbch!!!!");
            } else if (setType == 49777) {
                identityCnt = ++escSetIdentityCnt;
                MessageLog.trace(1, this.getClass(), "Create ESc!!!!");
            } else {
                MessageLog.trace(1, this.getClass(), "devSetType is " + setType);
                identityCnt = i + 1;
            }
            String devSetIdentity = "" + identityCnt;
            DeviceSetMoFactory setFactory = DeviceSetMoFactory.instance(setType);
            setFactory.createDeviceSetMoTree(targetMO, groupFroInfo.devSetFroInfo[i], devSetIdentity, userLabel, context);
        }
    }

    private void createSupportingMosIfAny(ManagedObject targetMO, EqcCreateGroupRspS createGroupRspSignal, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "createSupportingMosIfAny()");
        switch (this.eqcGroupType) {
            case 49569: 
            case 49570: 
            case 49571: 
            case 49572: 
            case 49574: {
                break;
            }
            case 49575: {
                if (createGroupRspSignal.bbPoolId != 1 && createGroupRspSignal.bbPoolId != 2) break;
                DbDeviceGroupMoImpl.createSystemMos(createGroupRspSignal.bbPoolId, 49575, targetMO, context);
                break;
            }
            case 49573: {
                TxDeviceGroupMoImpl.extraActivityAfterCreate(targetMO, context);
                break;
            }
            case 49576: {
                if (createGroupRspSignal.bbPoolId == 1 || createGroupRspSignal.bbPoolId == 2) {
                    DbDeviceGroupMoImpl.createSystemMos(createGroupRspSignal.bbPoolId, 49576, targetMO, context);
                    break;
                }
                MessageLog.info(this.getClass(), "undefined bbPoolId received: " + createGroupRspSignal.bbPoolId);
                break;
            }
            case 49577: {
                if (createGroupRspSignal.bbPoolId == 1 || createGroupRspSignal.bbPoolId == 2) {
                    DbDeviceGroupMoImpl.createSystemMos(createGroupRspSignal.bbPoolId, 49577, targetMO, context);
                    break;
                }
                MessageLog.info(this.getClass(), "undefined bbPoolId received: " + createGroupRspSignal.bbPoolId);
                break;
            }
            case 49582: {
                MessageLog.info(this.getClass(), "enter DUI case, createGroupRspSigbbpp");
                if (createGroupRspSignal.bbPoolId == 1 || createGroupRspSignal.bbPoolId == 2) {
                    DbDeviceGroupMoImpl.createSystemMos(createGroupRspSignal.bbPoolId, 49582, targetMO, context);
                } else {
                    MessageLog.info(this.getClass(), "undefined bbPoolId received: " + createGroupRspSignal.bbPoolId);
                }
                if (createGroupRspSignal.bbPoolId2 == 3 || createGroupRspSignal.bbPoolId2 == 4) {
                    DbDeviceGroupMoImpl.createSystemMos(createGroupRspSignal.bbPoolId2, 49582, targetMO, context);
                    break;
                }
                MessageLog.info(this.getClass(), "undefined bbPoolId2 received: " + createGroupRspSignal.bbPoolId2);
                break;
            }
            default: {
                MessageLog.traceError(this.getClass(), "Software Error in BOAM, illegal group type");
            }
        }
    }

    public ManagedObject recoverMo(MoData recoveredData) throws MoNameAlreadyTakenException {
        MessageLog.traceEnter(this.getClass(), "recoverMo");
        DbDeviceGroupMoImpl mo = null;
        switch (this.eqcGroupType) {
            case 49569: {
                mo = new TuDeviceGroupMoImpl(recoveredData);
                break;
            }
            case 49572: {
                mo = new TrxDeviceGroupMoImpl(recoveredData);
                break;
            }
            case 49575: {
                mo = new StrxDeviceGroupMoImpl(recoveredData);
                break;
            }
            case 49573: {
                mo = new TxDeviceGroupMoImpl(recoveredData);
                break;
            }
            case 49574: {
                mo = new RfifDeviceGroupMoImpl(recoveredData);
                break;
            }
            case 49571: {
                mo = new RaxDeviceGroupMoImpl(recoveredData);
                break;
            }
            case 49570: {
                mo = new AiuDeviceGroupMoImpl(recoveredData);
                break;
            }
            case 49576: {
                mo = new ObifDeviceGroupMoImpl(recoveredData);
                break;
            }
            case 49577: {
                mo = new RuifDeviceGroupMoImpl(recoveredData);
                break;
            }
            default: {
                MessageLog.traceError(this.getClass(), "Software Error in BOAM, illegal group type");
            }
        }
        return mo;
    }

    public String getMoTypeName() {
        String name;
        switch (this.eqcGroupType) {
            case 49569: {
                name = "TuDeviceGroup";
                break;
            }
            case 49572: {
                name = "TrxDeviceGroup";
                break;
            }
            case 49575: {
                name = "StrxDeviceGroup";
                break;
            }
            case 49573: {
                name = "TxDeviceGroup";
                break;
            }
            case 49574: {
                name = "RfifDeviceGroup";
                break;
            }
            case 49571: {
                name = "RaxDeviceGroup";
                break;
            }
            case 49570: {
                name = "AiuDeviceGroup";
                break;
            }
            case 49576: {
                name = "ObifDeviceGroup";
                break;
            }
            case 49577: {
                name = "RuifDeviceGroup";
                break;
            }
            case 49582: {
                name = "DeviceGroup_DUI";
                break;
            }
            default: {
                MessageLog.traceError(this.getClass(), "Software Error in BOAM, illegal group type");
                name = "UnknownDeviceGroup";
            }
        }
        return name;
    }

    public static int getGroupFaultCounterValue() {
        return devGroupFaultCounter;
    }

    public static int getGroupEventCounterValue() {
        return devGroupEventCounter;
    }

    public static int getDevGroupHwLogCounterValue() {
        return devGroupHwLogCounter;
    }

    static {
        devGroupFaultCounter = 0;
        devGroupEventCounter = 0;
        devGroupHwLogCounter = 0;
    }
}

