/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.dmo.power;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MibMgr;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFilter;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.mao.common.MoTypeFilter;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxDeviceMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.BfDeviceMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.PowerSupplySystemMo;

public class BfDeviceMoImpl
extends AuxDeviceMoImpl
implements BfDeviceMo {
    public static final int MO_DATA_REVISION = 3020001;

    public BfDeviceMoImpl(ManagedObject parent, String thisMoName, int deviceFroId, String identity, String userLabel, Coordinator context) throws MoAccessException {
        super(parent, thisMoName, 10, deviceFroId, identity, context, userLabel);
        MessageLog.traceEnter(this.getClass(), "Normal constructor");
        int devFroId = this.getAuxDeviceFroId(context);
        ManagedObject elementRef = MibMgr.instance().getMib().getRootMo();
        MoIterator iter = MoRepository.instance().select(elementRef, 2, (MoFilter)new MoTypeFilter("PowerSupplySystem"));
        while (iter.hasMoreElements()) {
            PowerSupplySystemMo poss = (PowerSupplySystemMo)iter.nextMo();
            poss.allocPossDevice(this, devFroId, 10, context);
        }
        this.initAlarmStatus(0, context);
        this.myData.setRevision(3020001);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.addObservers(10, context);
        MessageLog.trace(1, this.getClass(), "BfDevice id=" + identity + " created with devFroId=" + devFroId + ".");
    }

    public BfDeviceMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        MessageLog.traceEnter(this.getClass(), "Recovery constructor");
        this.myData = recoveredData;
        try {
            this.addObservers(10, null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Couldn't init the Observers!!");
        }
        MessageLog.trace(1, this.getClass(), "Mo recovered");
    }

    public void npuDelete(Coordinator context, int deviceType) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "npuDelete() ");
        this.deAllocPoss(context);
        super.npuDelete(context, deviceType);
    }

    public void sysDelete(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "sysDelete()");
        this.deAllocPoss(context);
        super.sysDelete(context);
    }

    private void deAllocPoss(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "deAllocPoss()");
        int devFroId = this.getAuxDeviceFroId(context);
        ManagedObject elementRef = MibMgr.instance().getMib().getRootMo();
        MoIterator iter = MoRepository.instance().select(elementRef, 2, (MoFilter)new MoTypeFilter("PowerSupplySystem"));
        while (iter.hasMoreElements()) {
            PowerSupplySystemMo poss = (PowerSupplySystemMo)iter.nextMo();
            poss.deallocPossDevice(this, devFroId, 10, context);
        }
    }

    public String getBfDeviceId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getBfDeviceId()");
        return this.getIdentity(context);
    }

    public String getType() {
        return "BfDevice";
    }
}

