/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.dmo.rru;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCreateGroupRspS;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxDeviceGroupMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxDeviceGroupMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RruDeviceGroupMo;

public class RruDeviceGroupMoImpl
extends AuxDeviceGroupMoImpl
implements RruDeviceGroupMo {
    public static final int MAX_NO_OF_CHILDREN = 1;
    public static final int MO_DATA_REVISION = 2040001;

    private RruDeviceGroupMoImpl(ManagedObject parent, String userLabel, int alarmStatus, String identity, Coordinator context) throws MoAccessException {
        super(parent, "RruDeviceGroup", identity, context, 1);
        MessageLog.traceEnter(this.getClass(), "Normal constructor");
        EqcCreateGroupRspS rsp = this.createAuxDeviceGroupResource(parent, 49562, context);
        this.initMoData(userLabel, alarmStatus, (int)rsp.groupFroInfo.groupFroId, context);
        AuxDeviceGroupMoFactory.instance(49562).createDeviceGroupMoTree((ManagedObject)this, rsp.groupFroInfo, "", context);
        this.addObservers(49562, context);
    }

    public RruDeviceGroupMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        try {
            this.addObservers(49562, null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Couldn't init the Observers!!");
        }
        MessageLog.trace(1, this.getClass(), "Mo recovered");
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(RruDeviceGroupMoImpl.class, "create()");
        RruDeviceGroupMoImpl thisMo = null;
        RruDeviceGroupMoImpl.checkTransaction(context);
        String checkedUserLabel = ValidateAttributes.checkAndGetStringAttribute(attributes, "userLabel", "optional", "", 0, 128, "RruDeviceGroup");
        int checkedAlarmStatus = RruDeviceGroupMoImpl.checkAndGetAlarmStatus(attributes, 0, "RruDeviceGroup", context);
        ValidateAttributes.checkOtherAttributes(attributes, "RruDeviceGroup");
        thisMo = new RruDeviceGroupMoImpl(parent, checkedUserLabel, checkedAlarmStatus, identity, context);
        return thisMo;
    }

    public void actionStartHwTest(String testId, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "actionStartHwTest()");
        super.actionStartHwTest(testId, context);
    }

    public String getType() {
        return "RruDeviceGroup";
    }

    private void initMoData(String userLabel, int alarmStatus, int auxGroupFroId, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "initMoData() ");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.bcmStoreAndRegisterIntAttribute("auxGroupFroId", auxGroupFroId);
        this.bcmStoreAndRegisterStringAttribute("userLabel", userLabel);
        this.initAlarmStatus(alarmStatus, context);
        this.myData.setRevision(2040001);
    }

    public String checkSpecificEvent(int eventType) {
        if (49160 == eventType) {
            return this.getType() + "_MaintenanceButtonInitiatedBoardRestart";
        }
        return null;
    }
}

