/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.dmo.tr;

import se.ericsson.cello.atm.atm.AtmPortMo;
import se.ericsson.cello.atm.atm.ImaGroupMo;
import se.ericsson.cello.atm.atm.VclTpMo;
import se.ericsson.cello.atm.atm.VpcTpMo;
import se.ericsson.cello.atm.atm.VplTpMo;
import se.ericsson.cello.equipment.PlugInUnitMo;
import se.ericsson.cello.equipment.SlotMo;
import se.ericsson.cello.equipment.SubrackMo;
import se.ericsson.cello.internaltransport.SwitchModuleMo;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoHasChildrenException;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.pdhsdhtrans.E1TtpMo;
import se.ericsson.cello.pdhsdhtrans.Os155SpiTtpMo;
import se.ericsson.cello.pdhsdhtrans.T1TtpMo;
import se.ericsson.cello.pdhsdhtrans.Vc4TtpMo;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.FroNotAccessibleException;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcDeviceGroupProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EcCreateRdbtRspS;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObject;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RdbtAal5TpVccTpMo;

public class RdbtAal5TpVccTpMoImpl
extends BoamManagedObject
implements RdbtAal5TpVccTpMo {
    private static final int MO_DATA_REVISION = 7060601;
    private MoData myData;
    private EqcDeviceGroupProxy eqcDeviceGroupProxy = EqcDeviceGroupProxy.instance();

    private RdbtAal5TpVccTpMoImpl(ManagedObject parent, String moTypeName, String identity, Coordinator context, int txmId, int logicalLineNumber, ManagedObject plugInUnitRef, ManagedObject vclTpRef) throws MoAccessException {
        super(parent, moTypeName, identity, context);
        MessageLog.traceEnter(this.getClass(), "Normal Constructor");
        VclTpMo vclTp = (VclTpMo)vclTpRef;
        VpcTpMo vpcTp = (VpcTpMo)vclTpRef.getParent();
        VplTpMo vplTp = (VplTpMo)vpcTp.getParent();
        AtmPortMo atmPort = (AtmPortMo)vplTp.getParent();
        ManagedObject physPathTerm = atmPort.getUses(context);
        PhysPathTermHandler physPathTermHandler = new PhysPathTermHandler(physPathTerm, context);
        SlotMo slot = physPathTermHandler.slot;
        SubrackMo subrack = (SubrackMo)slot.getParent();
        SwitchModuleMo switchModule = (SwitchModuleMo)subrack.getSwitchModule(context);
        int externalVpi = vplTp.getExternalVpi(context);
        int externalVci = vclTp.getExternalVci(context);
        int smn = switchModule.getSwitchModuleNumber(context);
        int apn = slot.getSlotNumber(context);
        int physicalLineNumber = physPathTermHandler.lineNo;
        int plugInUnitFroId = ((PlugInUnitMo)plugInUnitRef).getFroId(context);
        this.initMoData(context, txmId, logicalLineNumber, physicalLineNumber, plugInUnitFroId, smn, apn, externalVpi, externalVci, plugInUnitRef, vclTpRef);
        MessageLog.trace(1, this.getClass(), "MAO is created");
    }

    public RdbtAal5TpVccTpMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData.getLocalDistinguishedName());
        MessageLog.traceEnter(this.getClass(), "Recovery Constructor");
        this.myData = recoveredData;
        MessageLog.trace(1, this.getClass(), "MAO is recovered");
    }

    private void initMoData(Coordinator context, int txmId, int logicalLineNumber, int physicalLineNumber, int plugInUnitFroId, int smn, int apn, int externalVpi, int externalVci, ManagedObject plugInUnitRef, ManagedObject vclTpRef) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "initMoData()");
        this.myData = new MoData(super.getLocalDistinguishedName(), this.getType(), true, context);
        int froId = this.createRo(context, plugInUnitFroId, txmId, externalVpi, externalVci, smn, apn, physicalLineNumber, logicalLineNumber);
        ((Reservable)plugInUnitRef).reserve((ManagedObject)this, context);
        ((Reservable)vclTpRef).reserve((ManagedObject)this, context);
        this.bcmStoreAndRegisterIntAttribute("froId", froId);
        this.bcmStoreAndRegisterReferenceAttribute("plugInUnitRef", plugInUnitRef);
        this.bcmStoreAndRegisterReferenceAttribute("vclTpRef", vclTpRef);
        this.myData.setRevision(7060601);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(RdbtAal5TpVccTpMoImpl.class, "create()");
        ValidateAttributes.checkTransaction(context);
        ValidateAttributes.checkParent(parent, "TransportNetwork");
        ManagedObject checkedPlugInUnitIdRef = ValidateAttributes.checkAndGetReferenceAttribute("plugInUnitRef", attributes, "mandatory", new String[]{"PlugInUnit"}, "RdbtAal5TpVccTp");
        ManagedObject checkedVclTpRef = ValidateAttributes.checkAndGetReferenceAttribute("vclTpRef", attributes, "mandatory", new String[]{"VclTp"}, "RdbtAal5TpVccTp");
        int checkedTxmId = ValidateAttributes.checkAndGetIntAttribute(attributes, "txmId", "mandatory", 0, RdbtAal5TpVccTpMo.TXM_ID_MIN_VALUES, RdbtAal5TpVccTpMo.TXM_ID_MAX_VALUES, "RdbtAal5TpVccTp");
        int checkedLogicalLineNumber = ValidateAttributes.checkAndGetIntAttribute(attributes, "logicalLineNumber", "optional", 0, RdbtAal5TpVccTpMo.LOGICAL_LINE_NUMBER_MIN_VALUES, RdbtAal5TpVccTpMo.LOGICAL_LINE_NUMBER_MAX_VALUES, "RdbtAal5TpVccTp");
        ValidateAttributes.checkOtherAttributes(attributes, "RdbtAal5TpVccTp");
        RdbtAal5TpVccTpMoImpl createdMo = new RdbtAal5TpVccTpMoImpl(parent, "RdbtAal5TpVccTp", identity, context, checkedTxmId, checkedLogicalLineNumber, checkedPlugInUnitIdRef, checkedVclTpRef);
        return createdMo;
    }

    private int createRo(Coordinator context, int plugInUnitFroId, int txmId, int externalVpi, int externalVci, int smn, int apn, int physicalLineNumber, int logicalLineNumber) throws MoAccessException, FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "createRo()");
        EcCreateRdbtRspS rspSig = this.eqcDeviceGroupProxy.createRdbt(this.getTxIdTransactional(context), 0, plugInUnitFroId, txmId, externalVpi, externalVci, smn, apn, physicalLineNumber, logicalLineNumber);
        return (int)rspSig.froId;
    }

    public int getLogicalLineNumber(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getLogicalLineNumber()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        return (int)this.eqcDeviceGroupProxy.getRdbtParam((int)0, (int)this.getFroId((Coordinator)context), (int)ValidateAttributes.getTxIdNonTransactional((Coordinator)context)).logLineNo;
    }

    public ManagedObject getPlugInUnitRef(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getPlugInUnitRef()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        return this.bcmGetReferenceAttribute("plugInUnitRef", context);
    }

    public int getTxmId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getTxmId()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        return (int)this.eqcDeviceGroupProxy.getRdbtParam((int)0, (int)this.getFroId((Coordinator)context), (int)ValidateAttributes.getTxIdNonTransactional((Coordinator)context)).txmId;
    }

    public ManagedObject getVclTpRef(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getVclTpRef()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        return this.bcmGetReferenceAttribute("vclTpRef", context);
    }

    public int getFroId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getFroId()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        return this.bcmGetIntAttribute("froId", context);
    }

    public void delete(Coordinator context) throws MoHasChildrenException, MoAccessException {
        MessageLog.traceEnter(this.getClass(), "delete() " + this.getFullDistinguishedName());
        ValidateAttributes.checkTransaction(context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        int froId = this.getFroId(context);
        this.eqcDeviceGroupProxy.deleteRdbt(this.getTxIdTransactional(context), 0L, froId);
        ((Reservable)this.getPlugInUnitRef(context)).release((ManagedObject)this, context);
        ((Reservable)this.getVclTpRef(context)).release((ManagedObject)this, context);
        super.delete(context);
        MessageLog.trace(1, this.getClass(), this.getType() + " Mo is Deleted");
    }

    public String getType() {
        return "RdbtAal5TpVccTp";
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData()");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(this.getClass(), "isMyMoDataPersistent()");
        return true;
    }

    static class PhysPathTermHandler {
        SlotMo slot;
        int lineNo;
        private final ManagedObject physPathTerm;
        private final ManagedObject[] imaLinkList;

        PhysPathTermHandler(ManagedObject physPathTerm, Coordinator context) throws MoAccessException {
            this.physPathTerm = physPathTerm;
            this.imaLinkList = physPathTerm instanceof ImaGroupMo ? ((ImaGroupMo)physPathTerm).getPhysicalPortList(context) : null;
            this.initSlot(context);
            this.initLineNo(context);
        }

        void initSlot(Coordinator context) throws MoAccessException {
            this.slot = this.physPathTerm instanceof ImaGroupMo ? (SlotMo)BoamManagedObject.getAncestor(this.imaLinkList[0], "Slot") : (SlotMo)BoamManagedObject.getAncestor(this.physPathTerm, "Slot");
        }

        void initLineNo(Coordinator context) throws NoSuchAttributeException, MoAccessException {
            this.lineNo = this.physPathTerm instanceof Vc4TtpMo ? (Integer)((Os155SpiTtpMo)this.physPathTerm.getParent()).getAttribute("lineNo", context) - 1 : (this.physPathTerm instanceof ImaGroupMo ? (this.imaLinkList[0] instanceof E1TtpMo || this.imaLinkList[0] instanceof T1TtpMo ? (Integer)((Os155SpiTtpMo)BoamManagedObject.getAncestor(this.imaLinkList[0], "Os155SpiTtp")).getAttribute("lineNo", context) - 1 : (Integer)this.imaLinkList[0].getAttribute("lineNo", context) - 1) : (Integer)this.physPathTerm.getAttribute("lineNo", context) - 1);
        }
    }
}

