/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.dmo.tr;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EcCreateRetSetRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGetRetsParametersRspS;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxDeviceMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxDeviceSetMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.dmo.auxdevice.AuxPlugInUnitMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AuxPlugInUnitMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.DeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RetDeviceSetMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.SectorAntennaMo;

public class RetDeviceSetMoImpl
extends AuxDeviceSetMoImpl
implements RetDeviceSetMo {
    public static final int MO_DATA_REVISION = 2020001;

    public RetDeviceSetMoImpl(ManagedObject parent, String thisMoName, int devSetFroId, String identity, String userLabel, Coordinator context) throws MoAccessException {
        super(parent, thisMoName, 49769, devSetFroId, identity, context, userLabel);
        MessageLog.traceEnter(this.getClass(), "Normal constructor");
        int checkedAlarmStatus = 0;
        this.initAlarmStatus(checkedAlarmStatus, context);
        this.myData.setRevision(2020001);
        this.addObservers(49769, context);
    }

    public RetDeviceSetMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        MessageLog.traceEnter(this.getClass(), "Recovery constructor");
        try {
            this.addObservers(49769, null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Couldn't init the Observers!!");
        }
        MessageLog.trace(1, this.getClass(), "Mo recovered");
    }

    public RetDeviceSetMoImpl(ManagedObject parent, String thisMoName, String identity, String userLabel, Coordinator context) throws MoAccessException {
        super(parent, thisMoName, 49769, -1, identity, context, userLabel);
        ManagedObject piu2;
        MessageLog.traceEnter(this.getClass(), "Normal constructor");
        int deviceGroupFroId = ((DeviceGroupMo)parent).getFroId(context);
        int piuFroId1 = -1;
        int piuFroId2 = -1;
        AuxPlugInUnitMo auxPiu = (AuxPlugInUnitMo)parent.getParent();
        ManagedObject piu1 = auxPiu.getPlugInUnitRef1(context);
        if (piu1 != null) {
            piuFroId1 = BoamHelper.getPlugInUnitFroId(AuxPlugInUnitMoImpl.mapPiu2PiuDeviceIfDui(piu1, context), context);
        }
        if ((piu2 = auxPiu.getPlugInUnitRef2(context)) != null) {
            piuFroId2 = BoamHelper.getPlugInUnitFroId(AuxPlugInUnitMoImpl.mapPiu2PiuDeviceIfDui(piu2, context), context);
        }
        int sectorAntennaFroId = ((SectorAntennaMo)auxPiu.getParent()).getFroId(context);
        EcCreateRetSetRspS rspSig = this.eqcDeviceSetProxy.createRetDevSet(this.getTxIdTransactional(context), 0L, deviceGroupFroId, piuFroId1, piuFroId2, sectorAntennaFroId);
        this.bcmStoreAndRegisterIntAttribute("auxDevSetFroId", (int)rspSig.devSetFroId);
        int checkedAlarmStatus = 0;
        this.initAlarmStatus(checkedAlarmStatus, context);
        this.myData.setRevision(2020001);
        this.addObservers(49769, context);
        AuxDeviceMoFactory devFactory = AuxDeviceMoFactory.instance(17);
        devFactory.createTheMo(this, (int)rspSig.deviceFroId, identity, userLabel, context);
        MessageLog.trace(1, this.getClass(), "RetDeviceSet created.");
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(RetDeviceSetMoImpl.class, "create()");
        RetDeviceSetMoImpl.checkTransaction(context);
        RetDeviceSetMoImpl.checkParent(parent);
        String checkedUserLabel = ValidateAttributes.checkAndGetStringAttribute(attributes, "userLabel", "optional", "", 0, 128, "RetDeviceSet");
        return new RetDeviceSetMoImpl(parent, "RetDeviceSet", identity, checkedUserLabel, context);
    }

    public void delete(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "delete()");
        AuxPlugInUnitMo auxMo = (AuxPlugInUnitMo)RetDeviceSetMoImpl.getAncestor(this, "AuxPlugInUnit");
        if (auxMo.getLocalDistinguishedName().indexOf("AIR") != -1) {
            this.eqcDeviceSetProxy.deleteDevSet(context.getTransactionID(), 0L, this.getAuxDevSetFroId(context));
            super.sysDelete(context);
        } else {
            super.delete(context);
        }
    }

    public String getType() {
        return "RetDeviceSet";
    }

    public String getRetDeviceSetId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getRetDeviceSetId()");
        return this.getIdentity(context);
    }

    public String getProductNumber(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getProductNumber() ");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        EqcGetRetsParametersRspS rspSig = this.eqcDeviceSetProxy.getRetsParameters(this.getTxIdNonTransactional(context), 0L, this.getAuxDevSetFroId(null));
        return rspSig.productNumber;
    }

    public String getRevState(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getRevState() ");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        EqcGetRetsParametersRspS rspSig = this.eqcDeviceSetProxy.getRetsParameters(this.getTxIdNonTransactional(context), 0L, this.getAuxDevSetFroId(null));
        return rspSig.productRevision;
    }

    public int getRetType(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getRetType() ");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        EqcGetRetsParametersRspS rspSig = this.eqcDeviceSetProxy.getRetsParameters(this.getTxIdNonTransactional(context), 0L, this.getAuxDevSetFroId(null));
        return rspSig.retType;
    }

    public static void checkParent(ManagedObject parent) throws MoAccessException {
        if (parent == null) {
            throw new IllegalParentException("Parent is null!!");
        }
        if (!parent.getType().equals("DeviceGroup")) {
            throw new IllegalParentException("Expecting:DeviceGroup, but recived:" + parent.getType());
        }
    }
}

