/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.emo.cable;

import se.ericsson.cello.equipment.EquipmentMo;
import se.ericsson.cello.equipment.PlugInUnitMaoi;
import se.ericsson.cello.equipment.PlugInUnitMo;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFilter;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRemovedException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.ResourceLockedException;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.FroNotAccessibleException;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.ServiceNotPublishedException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcCableProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCreateCableRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcGetIntJumpCableParamRspS;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObject;
import se.ericsson.wcdma.rbs.boam.mao.common.MoTypeFilter;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.dmo.device.DeviceGroupMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.emo.cable.AntFeederCableMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.emo.cable.ConnectionFieldMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AiuDeviceGroupMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AntFeederCableMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.ConnectionFieldMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.IntJumperCableMo;

public class IntJumperCableMoImpl
extends BoamManagedObject
implements IntJumperCableMo {
    public static final String INTJUMPER_CABLE_ID = "IntJumperCableId";
    public static final String INTJUMPER_CABLE_FRO_ID = "IntJumperCableFroId";
    public static final String AIU_PIU_INSTANCE_ID = "aiuPiuInstanceId";
    public static final int MO_DATA_REVISION = 70701;
    private static final int FS_CONN_FIELD_CONNECTOR_MAX_LENGTH = 9;
    private MoData myData;
    private EqcCableProxy eqcCableProxy = EqcCableProxy.instance();
    private int intJumperCableFroId;
    private String intJumperCableId;
    private ManagedObject connectionFieldRef;
    private ManagedObject aiuPluginUnitRef;
    private String connFieldConnector;
    private int connectFieldConnector;
    private int dlAttenuation;
    private int dlDelay;
    private int ulAttenuation;
    private int ulDelay;
    private String userLabel;
    private int aiuPiuInstanceId;
    private int aiuConnector;
    private IntegerAttribute intJumperCableFroIdAttr;
    private StringAttribute intJumperCableIdAttr;
    private ReferenceAttribute connectionFieldRefAttr;
    private ReferenceAttribute aiuPluginUnitRefAttr;
    private StringAttribute connFieldConnectorAttr;
    private IntegerAttribute dlAttenuationAttr;
    private IntegerAttribute dlDelayAttr;
    private IntegerAttribute ulAttenuationAttr;
    private IntegerAttribute ulDelayAttr;
    private IntegerAttribute aiuConnectorAttr;
    private IntegerAttribute aiuPiuInstanceIdAttr;
    private StringAttribute userLabelAttr;

    public IntJumperCableMoImpl(ManagedObject parent, String motypeName, String identity, Coordinator context, AttrList attributes, ManagedObject source) throws MoAccessException {
        super(parent, motypeName, identity, context);
        if (!(parent instanceof EquipmentMo)) {
            super.delete(context);
            MessageLog.trace(1, this.getClass(), "Illegal parent");
            throw new IllegalParentException("Expecting EquipmentMo, received:" + parent.getClass().getName());
        }
        MessageLog.traceEnter(this.getClass(), "Normal constructor");
        this.initMoData(identity, attributes, context);
        this.createRo(context);
        MessageLog.trace(1, this.getClass(), "MO is Created");
    }

    public IntJumperCableMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData.getLocalDistinguishedName());
        MessageLog.traceEnter(this.getClass(), "Recovery constructor");
        this.myData = recoveredData;
        this.intJumperCableFroIdAttr = new IntegerAttribute(INTJUMPER_CABLE_FRO_ID, false);
        this.intJumperCableIdAttr = new StringAttribute(INTJUMPER_CABLE_ID, false);
        this.connectionFieldRefAttr = new ReferenceAttribute("connectionFieldRef", false);
        this.connFieldConnectorAttr = new StringAttribute("connFieldConnector", false);
        this.aiuPluginUnitRefAttr = new ReferenceAttribute("aiuPlugInUnitRef", false);
        this.aiuConnectorAttr = (IntegerAttribute)recoveredData.getAttribute("aiuConnector");
        this.aiuPiuInstanceIdAttr = new IntegerAttribute(AIU_PIU_INSTANCE_ID, false);
        this.dlAttenuationAttr = new IntegerAttribute("dlAttenuation", false);
        this.dlDelayAttr = new IntegerAttribute("electricalDlDelay", false);
        this.ulAttenuationAttr = new IntegerAttribute("ulAttenuation", false);
        this.ulDelayAttr = new IntegerAttribute("electricalUlDelay", false);
        this.intJumperCableFroIdAttr = (IntegerAttribute)recoveredData.getAttribute(INTJUMPER_CABLE_FRO_ID);
        this.intJumperCableIdAttr = (StringAttribute)recoveredData.getAttribute(INTJUMPER_CABLE_ID);
        this.connectionFieldRefAttr = (ReferenceAttribute)recoveredData.getAttribute("connectionFieldRef");
        this.connFieldConnectorAttr = (StringAttribute)recoveredData.getAttribute("connFieldConnector");
        this.aiuPluginUnitRefAttr = (ReferenceAttribute)recoveredData.getAttribute("aiuPlugInUnitRef");
        this.aiuConnectorAttr = (IntegerAttribute)recoveredData.getAttribute("aiuConnector");
        this.aiuPiuInstanceIdAttr = (IntegerAttribute)recoveredData.getAttribute(AIU_PIU_INSTANCE_ID);
        this.dlAttenuationAttr = (IntegerAttribute)recoveredData.getAttribute("dlAttenuation");
        this.dlDelayAttr = (IntegerAttribute)recoveredData.getAttribute("electricalDlDelay");
        this.ulAttenuationAttr = (IntegerAttribute)recoveredData.getAttribute("ulAttenuation");
        this.ulDelayAttr = (IntegerAttribute)recoveredData.getAttribute("electricalUlDelay");
        MessageLog.trace(1, this.getClass(), "MO is Recovered, version Attribute in MoData = " + this.myData.getRevision());
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(AntFeederCableMoImpl.class, "create() ");
        IntJumperCableMoImpl createdMo = new IntJumperCableMoImpl(parent, "IntJumperCable", identity, context, attributes, source);
        return createdMo;
    }

    private void initMoData(String identity, AttrList attributes, Coordinator context) throws MoAccessException, TransactionRequiredException, AttrMissingAtCreateException, WrongAttributeTypeException, NotHandledAttributeTypeException, ValueOutOfRangeException {
        MessageLog.trace(1, this.getClass(), "initMoData()");
        this.myData = new MoData(super.getLocalDistinguishedName(), this.getType(), true, context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.checkAndSaveIntJumperCableId(identity);
        this.checkAndSaveAiuPlugInUnitRef(attributes, context);
        this.checkAndSaveAiuConnector(attributes, context);
        this.checkAndSaveAiuPiuInstanceId(attributes, context);
        this.checkAndSaveConnectionFieldRef(attributes, context);
        this.checkAndSaveConnFieldConnector(attributes, context);
        this.checkAndSaveDlAttenuation(attributes, context);
        this.checkAndSaveUlAttenuation(attributes, context);
        this.checkAndSaveDlDelay(attributes, context);
        this.checkAndSaveUlDelay(attributes, context);
        this.checkAndSaveUserLabel(attributes, context);
        ValidateAttributes.checkOtherAttributes(attributes, "IntJumperCable");
        this.intJumperCableFroIdAttr = new IntegerAttribute(INTJUMPER_CABLE_FRO_ID, false);
        this.myData.registerPersistentAttr((Attribute)this.intJumperCableFroIdAttr);
        this.myData.setRevision(70701);
    }

    public void createRo(Coordinator context) throws MoAccessException, TransactionRequiredException, ResourceLockedException, FroRequestFailedException, FroNotAccessibleException {
        MessageLog.traceEnter(this.getClass(), "createRo()");
        int cfConnectorId = this.connFieldConnector.compareTo("H1") == 0 ? 4 : (this.connFieldConnector.compareTo("H2") == 0 ? 5 : (this.connFieldConnector.compareTo("H3") == 0 ? 6 : (this.connFieldConnector.compareTo("J1") == 0 ? 7 : (this.connFieldConnector.compareTo("J2") == 0 ? 8 : (this.connFieldConnector.compareTo("J3") == 0 ? 9 : (this.connFieldConnector.compareTo("A1") == 0 ? 25 : (this.connFieldConnector.compareTo("A2") == 0 ? 26 : (this.connFieldConnector.compareTo("A3") == 0 ? 27 : (this.connFieldConnector.compareTo("A4") == 0 ? 28 : (this.connFieldConnector.compareTo("A5") == 0 ? 29 : (this.connFieldConnector.compareTo("A6") == 0 ? 30 : (this.connFieldConnector.compareTo("J1_AND_K1") == 0 ? 69 : (this.connFieldConnector.compareTo("J3_AND_K2") == 0 ? 70 : (this.connFieldConnector.compareTo("J4") == 0 ? 72 : (this.connFieldConnector.compareTo("J5_AND_K3") == 0 ? 71 : (this.connFieldConnector.compareTo("J6") == 0 ? 73 : -1))))))))))))))));
        EqcCreateCableRspS rspSig = this.eqcCableProxy.createCable(this.getTxIdTransactional(context), 0L, 50157, 0L, 0L, cfConnectorId, this.aiuPiuInstanceId, this.aiuConnector);
        this.intJumperCableFroId = (int)rspSig.cableFroId;
        this.intJumperCableFroIdAttr = (IntegerAttribute)this.myData.getAttribute(INTJUMPER_CABLE_FRO_ID);
        this.intJumperCableFroIdAttr.setValue(this.intJumperCableFroId);
        this.setDlAttenuation(this.dlAttenuation, context);
        this.setElectricalDlDelay(this.dlDelay, context);
        this.setUlAttenuation(this.ulAttenuation, context);
        this.setElectricalUlDelay(this.ulDelay, context);
        MessageLog.trace(1, this.getClass(), " RO is created ");
    }

    public String getType() {
        return "IntJumperCable";
    }

    public int getIntJumperCableMoFroId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getIntJumperCableMoFroId()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        this.intJumperCableFroIdAttr = (IntegerAttribute)this.myData.getAttribute(INTJUMPER_CABLE_FRO_ID);
        this.intJumperCableFroId = this.intJumperCableFroIdAttr.getValue(context);
        return this.intJumperCableFroId;
    }

    public String getIntJumperCableId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getIntJumperCableId()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        this.intJumperCableIdAttr = (StringAttribute)this.myData.getAttribute(INTJUMPER_CABLE_ID);
        this.intJumperCableId = this.intJumperCableIdAttr.getValue(context);
        return this.intJumperCableId;
    }

    public String getUserLabel(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUserLabel()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        this.userLabelAttr = (StringAttribute)this.myData.getAttribute("userLabel");
        return this.userLabelAttr.getValue(context);
    }

    public void setUserLabel(String value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setUserLabel() ");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.bcmSetStringAttribute("userLabel", value, 0, 128, this.getType(), context);
        this.sendAVC("userLabel", value, context);
    }

    public ManagedObject getAiuPlugInUnitRef(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getAiuPlugInUnitRef()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        this.aiuPluginUnitRefAttr = (ReferenceAttribute)this.myData.getAttribute("aiuPlugInUnitRef");
        if (this.aiuPluginUnitRefAttr == null) {
            return null;
        }
        this.aiuPluginUnitRef = this.aiuPluginUnitRefAttr.getValue(context);
        return this.aiuPluginUnitRef;
    }

    protected ManagedObject getAiuDeviceGroupRef(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getAiuDeviceGroupRef()");
        ManagedObject aiuDeviceGroupRef = this.findAiuDeviceGroupRef(context, this.getAiuPlugInUnitRef(context));
        return aiuDeviceGroupRef;
    }

    public AntFeederCableMoImpl checkForAntFeederCable(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "checkForAntFeederCable()");
        ManagedObject antFeederMoRef = null;
        String antFeederConnectorId = "";
        MoIterator moIter1 = MoRepository.instance().select(this.getParent(), 1, (MoFilter)new MoTypeFilter("AntFeederCable"));
        if (moIter1.size() < 1) {
            MessageLog.trace(1, this.getClass(), "No AntFeederCableMo found.");
        } else {
            while (moIter1.hasMoreElements()) {
                antFeederMoRef = moIter1.nextMo();
                antFeederConnectorId = ((AntFeederCableMo)antFeederMoRef).getConnFieldConnector(context);
                MessageLog.trace(1, this.getClass(), "Found one AntFeederCableMo with connector: " + antFeederConnectorId);
                if (antFeederConnectorId.compareTo(this.getConnFieldConnector(context)) != 0) continue;
                MessageLog.trace(1, this.getClass(), "Found AntFeederCableMo with same connFieldConnector: " + antFeederConnectorId);
                return (AntFeederCableMoImpl)antFeederMoRef;
            }
        }
        return null;
    }

    public int getAiuConnector(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getAiuConnector()");
        this.aiuConnector = this.getAttribute(context, "aiuConnector");
        if (this.aiuConnector == 18) {
            this.aiuConnector = 1;
        } else if (this.aiuConnector == 19) {
            this.aiuConnector = 2;
        }
        return this.aiuConnector;
    }

    public ManagedObject getConnectionFieldRef(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getConnectionFieldRef()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        this.connectionFieldRefAttr = (ReferenceAttribute)this.myData.getAttribute("connectionFieldRef");
        if (this.connectionFieldRefAttr == null) {
            return null;
        }
        this.connectionFieldRef = this.connectionFieldRefAttr.getValue(context);
        return this.connectionFieldRef;
    }

    public String getConnFieldConnector(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getConnFieldConnector()");
        this.connectFieldConnector = this.getAttribute(context, "connFieldConnector");
        this.connFieldConnector = this.connectFieldConnector == 4 ? "H1" : (this.connectFieldConnector == 5 ? "H2" : (this.connectFieldConnector == 6 ? "H3" : (this.connectFieldConnector == 7 ? "J1" : (this.connectFieldConnector == 8 ? "J2" : (this.connectFieldConnector == 9 ? "J3" : (this.connectFieldConnector == 25 ? "A1" : (this.connectFieldConnector == 26 ? "A2" : (this.connectFieldConnector == 27 ? "A3" : (this.connectFieldConnector == 28 ? "A4" : (this.connectFieldConnector == 29 ? "A5" : (this.connectFieldConnector == 30 ? "A6" : (this.connectFieldConnector == 69 ? "J1_AND_K1" : (this.connectFieldConnector == 70 ? "J3_AND_K2" : (this.connectFieldConnector == 72 ? "J4" : (this.connectFieldConnector == 71 ? "J5_AND_K3" : (this.connectFieldConnector == 73 ? "J6" : "-"))))))))))))))));
        return this.connFieldConnector;
    }

    public int getUlAttenuation(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUlAttenuation()");
        this.ulAttenuation = this.getAttribute(context, "ulAttenuation");
        return this.ulAttenuation;
    }

    public void setUlAttenuation(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setUlAttenuation()");
        ValidateAttributes.checkTransaction(context);
        this.getMyMoData().handleTransaction(context, MoData.WRITE_ACCESS);
        ValidateAttributes.intValueRangeCheck("ulAttenuation", value, UL_ATTENUATION_MIN_VALUES, UL_ATTENUATION_MAX_VALUES, this.getType());
        this.intJumperCableFroId = this.getIntJumperCableMoFroId(context);
        this.eqcCableProxy.setIntJumpCableParameters(this.getTxIdTransactional(context), 0, this.intJumperCableFroId, 3, 0, 0, value, 0);
        this.sendAVC("ulAttenuation", value, context);
    }

    public int getElectricalUlDelay(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getElectricalUlDelay()");
        this.ulDelay = this.getAttribute(context, "electricalUlDelay");
        return this.ulDelay;
    }

    public void setElectricalUlDelay(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setElectricalUlDelay()");
        ValidateAttributes.checkTransaction(context);
        this.getMyMoData().handleTransaction(context, MoData.WRITE_ACCESS);
        ValidateAttributes.intValueRangeCheck("electricalUlDelay", value, ELECTRICAL_UL_DELAY_MIN_VALUES, ELECTRICAL_UL_DELAY_MAX_VALUES, this.getType());
        this.intJumperCableFroId = this.getIntJumperCableMoFroId(context);
        this.eqcCableProxy.setIntJumpCableParameters(this.getTxIdTransactional(context), 0, this.intJumperCableFroId, 4, 0, 0, 0, value);
    }

    public int getDlAttenuation(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getDlAttenuation()");
        this.dlAttenuation = this.getAttribute(context, "dlAttenuation");
        return this.dlAttenuation;
    }

    public void setDlAttenuation(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setDlAttenuation()");
        ValidateAttributes.checkTransaction(context);
        this.getMyMoData().handleTransaction(context, MoData.WRITE_ACCESS);
        ValidateAttributes.intValueRangeCheck("dlAttenuation", value, DL_ATTENUATION_MIN_VALUES, DL_ATTENUATION_MAX_VALUES, this.getType());
        this.intJumperCableFroId = this.getIntJumperCableMoFroId(context);
        this.eqcCableProxy.setIntJumpCableParameters(this.getTxIdTransactional(context), 0, this.intJumperCableFroId, 1, value, 0, 0, 0);
        this.sendAVC("dlAttenuation", value, context);
    }

    public int getElectricalDlDelay(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getElectricalDlDelay()");
        this.dlDelay = this.getAttribute(context, "electricalDlDelay");
        return this.dlDelay;
    }

    public void setElectricalDlDelay(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setElectricalDlDelay()");
        ValidateAttributes.checkTransaction(context);
        this.getMyMoData().handleTransaction(context, MoData.WRITE_ACCESS);
        ValidateAttributes.intValueRangeCheck("electricalDlDelay", value, ELECTRICAL_DL_DELAY_MIN_VALUES, ELECTRICAL_DL_DELAY_MAX_VALUES, this.getType());
        this.intJumperCableFroId = this.getIntJumperCableMoFroId(context);
        this.eqcCableProxy.setIntJumpCableParameters(this.getTxIdTransactional(context), 0, this.intJumperCableFroId, 2, 0, value, 0, 0);
    }

    public void delete(Coordinator context) throws MoAccessException, MoRemovedException, UndeletableMoException {
        MessageLog.traceEnter(this.getClass(), "delete() the RO");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.intJumperCableFroIdAttr = (IntegerAttribute)this.myData.getAttribute(INTJUMPER_CABLE_FRO_ID);
        int intJumperCableFroId = this.intJumperCableFroIdAttr.getValue(context);
        this.eqcCableProxy.deleteCable(this.getTxIdTransactional(context), 0, intJumperCableFroId, 50157);
        this.releaseReservations(context);
        super.delete(context);
        MessageLog.trace(1, this.getClass(), "Mo is Deleted");
    }

    private void releaseReservations(Coordinator context) throws MoAccessException, MoRemovedException, UndeletableMoException {
        MessageLog.traceEnter(this.getClass(), "releaseReservations()");
        if (this.getAiuPlugInUnitRef(context) != null) {
            ((Reservable)this.getAiuPlugInUnitRef(context)).release((ManagedObject)this, context);
        }
        if (this.getConnectionFieldRef(context) != null) {
            ((Reservable)this.getConnectionFieldRef(context)).release((ManagedObject)this, context);
        }
    }

    private void checkAndSaveAiuConnector(AttrList attributes, Coordinator context) throws MoAccessException {
        int aiuConnectorAttrIndex = attributes.indexOf("aiuConnector");
        if (aiuConnectorAttrIndex == -1) {
            MessageLog.trace(1, this.getClass(), "aiuConnector is not included in the attribute list");
            throw new AttrMissingAtCreateException("aiuConnector", this.getType());
        }
        if (!(attributes.getValue(aiuConnectorAttrIndex) instanceof Integer)) {
            MessageLog.trace(1, this.getClass(), "mcpaConnector has wrong type");
            throw new WrongAttributeTypeException("aiuConnector", this.getType());
        }
        this.aiuConnector = (Integer)attributes.getValue(aiuConnectorAttrIndex);
        if (this.aiuConnector < 1 || this.aiuConnector > 2) {
            String msg = "The attribute aiuConnector is Out of range" + this.aiuConnector;
            MessageLog.trace(1, this.getClass(), msg);
            throw new ValueOutOfRangeException(msg, this.getType());
        }
        if (this.aiuConnector == 1) {
            this.aiuConnector = 18;
        } else if (this.aiuConnector == 2) {
            this.aiuConnector = 19;
        } else {
            String msg = "The attribute aiuConnector is Out of range" + this.aiuConnector;
            MessageLog.trace(1, this.getClass(), msg);
            throw new ValueOutOfRangeException(msg, this.getType());
        }
        this.aiuConnectorAttr = new IntegerAttribute("aiuConnector", false);
        this.myData.registerPersistentAttr((Attribute)this.aiuConnectorAttr);
        this.aiuConnectorAttr.setValue(this.aiuConnector);
        attributes.removeElementAt(aiuConnectorAttrIndex);
    }

    public void proxiesUnavailable() {
        MessageLog.traceEnter(this.getClass(), "proxiesUnavailable()");
    }

    public void proxiesAvailable() throws ServiceNotPublishedException {
        MessageLog.traceEnter(this.getClass(), "proxiesAvailable()");
    }

    private void checkAndSaveIntJumperCableId(String identity) throws MoAccessException {
        this.intJumperCableIdAttr = new StringAttribute(INTJUMPER_CABLE_ID, false);
        this.intJumperCableIdAttr.setValue(identity);
        this.myData.registerPersistentAttr((Attribute)this.intJumperCableIdAttr);
    }

    private void checkAndSaveAiuPiuInstanceId(AttrList attributes, Coordinator context) throws MoAccessException {
        this.aiuPiuInstanceId = ((PlugInUnitMaoi)this.getAiuPlugInUnitRef(context)).getFroId(context);
        this.aiuPiuInstanceIdAttr = new IntegerAttribute(AIU_PIU_INSTANCE_ID, false);
        this.myData.registerPersistentAttr((Attribute)this.aiuPiuInstanceIdAttr);
        this.aiuPiuInstanceIdAttr.setValue(this.aiuPiuInstanceId);
    }

    private void checkAndSaveConnectionFieldRef(AttrList attributes, Coordinator context) throws MoAccessException {
        int connectionFieldRefAttrIndex = attributes.indexOf("connectionFieldRef");
        if (connectionFieldRefAttrIndex == -1) {
            MessageLog.trace(1, this.getClass(), "connectionFieldRef is not included in the attribute list");
            throw new AttrMissingAtCreateException("connectionFieldRef", this.getType());
        }
        if (!(attributes.getValue(connectionFieldRefAttrIndex) instanceof ConnectionFieldMo)) {
            MessageLog.trace(1, this.getClass(), "connectionFieldRef has wrong type");
            throw new WrongAttributeTypeException("connectionFieldRef", this.getType());
        }
        this.connectionFieldRef = (ConnectionFieldMoImpl)attributes.getValue(connectionFieldRefAttrIndex);
        this.connectionFieldRefAttr = new ReferenceAttribute("connectionFieldRef", false);
        this.myData.registerPersistentAttr((Attribute)this.connectionFieldRefAttr);
        this.connectionFieldRefAttr.setValue(this.connectionFieldRef);
        ((Reservable)this.connectionFieldRef).reserve((ManagedObject)this, context);
        attributes.removeElementAt(connectionFieldRefAttrIndex);
    }

    private void checkAndSaveAiuPlugInUnitRef(AttrList attributes, Coordinator context) throws MoAccessException {
        int aiuPluginUnitRefAttrIndex = attributes.indexOf("aiuPlugInUnitRef");
        if (aiuPluginUnitRefAttrIndex == -1) {
            MessageLog.trace(1, this.getClass(), "aiuPluginUnitRef is not included in the attribute list");
            throw new AttrMissingAtCreateException("aiuPlugInUnitRef", this.getType());
        }
        if (!(attributes.getValue(aiuPluginUnitRefAttrIndex) instanceof PlugInUnitMo)) {
            MessageLog.trace(1, this.getClass(), "aiuPluginUnitRef has wrong type");
            throw new WrongAttributeTypeException("aiuPlugInUnitRef", this.getType());
        }
        this.aiuPluginUnitRefAttr = new ReferenceAttribute("aiuPlugInUnitRef", false);
        this.myData.registerPersistentAttr((Attribute)this.aiuPluginUnitRefAttr);
        this.aiuPluginUnitRef = (ManagedObject)attributes.getValue(aiuPluginUnitRefAttrIndex);
        this.aiuPluginUnitRefAttr.setValue(this.aiuPluginUnitRef);
        ((Reservable)this.aiuPluginUnitRef).reserve((ManagedObject)this, context);
        attributes.removeElementAt(aiuPluginUnitRefAttrIndex);
    }

    private ManagedObject findAiuDeviceGroupRef(Coordinator context, ManagedObject aiuPluginUnitRef) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "findAiuDeviceGroupRef() ");
        MoIterator iter = aiuPluginUnitRef.getChildren();
        while (iter.hasMoreElements()) {
            ManagedObject amo = iter.nextMo();
            if (!(amo instanceof AiuDeviceGroupMo) && !DeviceGroupMoImpl.checkIfMoIsGenericDeviceGroupOfType(amo, "AIU")) continue;
            return amo;
        }
        String msg = " AiuPlugInUnitRef is not parent to AiuDeviceGroup ";
        MessageLog.trace(1, this.getClass(), msg);
        throw new MoCanNotBeCreatedException(msg);
    }

    private void checkAndSaveConnFieldConnector(AttrList attributes, Coordinator context) throws MoAccessException {
        int connFieldConnectorAttrIndex = attributes.indexOf("connFieldConnector");
        if (connFieldConnectorAttrIndex == -1) {
            MessageLog.trace(1, this.getClass(), "connFieldConnector is not included in the attribute list");
            throw new AttrMissingAtCreateException("connFieldConnector", this.getType());
        }
        if (!(attributes.getValue(connFieldConnectorAttrIndex) instanceof String)) {
            MessageLog.trace(1, this.getClass(), "connFieldConnector has wrong type");
            throw new WrongAttributeTypeException("connFieldConnector", this.getType());
        }
        this.connFieldConnector = (String)attributes.getValue(connFieldConnectorAttrIndex);
        ValidateAttributes.stringValueInSetCheck("connFieldConnector", this.connFieldConnector, CONN_FIELD_CONNECTOR_VALID_VALUES, this.getType());
        if (this.connFieldConnector.length() > 9) {
            String errMsg = "connFieldConnector has WRONG size ! Expected :9 ; received :" + this.connFieldConnector.length();
            MessageLog.trace(1, this.getClass(), errMsg);
            throw new ValueOutOfRangeException(errMsg, this.getType());
        }
        this.connFieldConnectorAttr = new StringAttribute("connFieldConnector", false);
        this.myData.registerPersistentAttr((Attribute)this.connFieldConnectorAttr);
        this.connFieldConnectorAttr.setValue(this.connFieldConnector);
        attributes.removeElementAt(connFieldConnectorAttrIndex);
    }

    private void checkAndSaveDlAttenuation(AttrList attributes, Coordinator context) throws MoAccessException {
        int dlAttenuationAttrIndex = attributes.indexOf("dlAttenuation");
        if (dlAttenuationAttrIndex == -1) {
            MessageLog.trace(1, this.getClass(), "dlAttenuation is not included in the attribute list");
            throw new AttrMissingAtCreateException("dlAttenuation", this.getType());
        }
        if (!(attributes.getValue(dlAttenuationAttrIndex) instanceof Integer)) {
            MessageLog.trace(1, this.getClass(), "dlAttenuation has wrong type");
            throw new WrongAttributeTypeException("dlAttenuation", this.getType());
        }
        this.dlAttenuation = (Integer)attributes.getValue(dlAttenuationAttrIndex);
        ValidateAttributes.intValueRangeCheck("dlAttenuation", this.dlAttenuation, DL_ATTENUATION_MIN_VALUES, DL_ATTENUATION_MAX_VALUES, this.getType());
        this.dlAttenuationAttr = new IntegerAttribute("dlAttenuation", false);
        this.myData.registerPersistentAttr((Attribute)this.dlAttenuationAttr);
        this.dlAttenuationAttr.setValue(this.dlAttenuation);
        attributes.removeElementAt(dlAttenuationAttrIndex);
    }

    private void checkAndSaveUlAttenuation(AttrList attributes, Coordinator context) throws MoAccessException {
        int ulAttenuationAttrIndex = attributes.indexOf("ulAttenuation");
        if (ulAttenuationAttrIndex == -1) {
            MessageLog.trace(1, this.getClass(), "ulAttenuation is not included in the attribute list");
            throw new AttrMissingAtCreateException("ulAttenuation", this.getType());
        }
        if (!(attributes.getValue(ulAttenuationAttrIndex) instanceof Integer)) {
            MessageLog.trace(1, this.getClass(), "ulAttenuation has wrong type");
            throw new WrongAttributeTypeException("ulAttenuation", this.getType());
        }
        this.ulAttenuation = (Integer)attributes.getValue(ulAttenuationAttrIndex);
        ValidateAttributes.intValueRangeCheck("ulAttenuation", this.ulAttenuation, UL_ATTENUATION_MIN_VALUES, UL_ATTENUATION_MAX_VALUES, this.getType());
        this.ulAttenuationAttr = new IntegerAttribute("ulAttenuation", false);
        this.myData.registerPersistentAttr((Attribute)this.ulAttenuationAttr);
        this.ulAttenuationAttr.setValue(this.ulAttenuation);
        attributes.removeElementAt(ulAttenuationAttrIndex);
    }

    private void checkAndSaveDlDelay(AttrList attributes, Coordinator context) throws MoAccessException {
        int dlDelayAttrIndex = attributes.indexOf("electricalDlDelay");
        if (dlDelayAttrIndex == -1) {
            MessageLog.trace(1, this.getClass(), "dlDelay is not included in the attribute list");
            throw new AttrMissingAtCreateException("electricalDlDelay", this.getType());
        }
        if (!(attributes.getValue(dlDelayAttrIndex) instanceof Integer)) {
            MessageLog.trace(1, this.getClass(), "dlDelay has wrong type");
            throw new WrongAttributeTypeException("electricalDlDelay", this.getType());
        }
        this.dlDelay = (Integer)attributes.getValue(dlDelayAttrIndex);
        ValidateAttributes.intValueRangeCheck("electricalDlDelay", this.dlDelay, ELECTRICAL_DL_DELAY_MIN_VALUES, ELECTRICAL_DL_DELAY_MAX_VALUES, this.getType());
        this.dlDelayAttr = new IntegerAttribute("electricalDlDelay", false);
        this.myData.registerPersistentAttr((Attribute)this.dlDelayAttr);
        this.dlDelayAttr.setValue(this.dlDelay);
        attributes.removeElementAt(dlDelayAttrIndex);
    }

    private void checkAndSaveUlDelay(AttrList attributes, Coordinator context) throws MoAccessException {
        int ulDelayAttrIndex = attributes.indexOf("electricalUlDelay");
        if (ulDelayAttrIndex == -1) {
            MessageLog.trace(1, this.getClass(), "ulDelay is not included in the attribute list");
            throw new AttrMissingAtCreateException("electricalUlDelay", this.getType());
        }
        if (!(attributes.getValue(ulDelayAttrIndex) instanceof Integer)) {
            MessageLog.trace(1, this.getClass(), "ulDelay has wrong type");
            throw new WrongAttributeTypeException("electricalUlDelay", this.getType());
        }
        this.ulDelay = (Integer)attributes.getValue(ulDelayAttrIndex);
        ValidateAttributes.intValueRangeCheck("electricalUlDelay", this.ulDelay, ELECTRICAL_UL_DELAY_MIN_VALUES, ELECTRICAL_UL_DELAY_MAX_VALUES, this.getType());
        this.ulDelayAttr = new IntegerAttribute("electricalUlDelay", false);
        this.myData.registerPersistentAttr((Attribute)this.ulDelayAttr);
        this.ulDelayAttr.setValue(this.ulDelay);
        attributes.removeElementAt(ulDelayAttrIndex);
    }

    private void checkAndSaveUserLabel(AttrList attributes, Coordinator context) throws MoAccessException {
        int userLabelAttrIndex = attributes.indexOf("userLabel");
        if (userLabelAttrIndex == -1) {
            this.userLabel = "";
        } else {
            this.userLabel = (String)attributes.getValue(userLabelAttrIndex);
            if (this.userLabel.length() > 128) {
                String errMsg = "userLabel has WRONG size ! Expected :128 ; received :" + this.userLabel.length();
                MessageLog.trace(1, this.getClass(), errMsg);
                throw new ValueOutOfRangeException(errMsg, this.getType());
            }
            attributes.removeElementAt(userLabelAttrIndex);
        }
        this.userLabelAttr = new StringAttribute("userLabel", false);
        this.myData.registerPersistentAttr((Attribute)this.userLabelAttr);
    }

    private int getAttribute(Coordinator context, String attributeName) throws MoAccessException, ServiceNotPublishedException, NoSuchAttributeException {
        MessageLog.traceEnter(this.getClass(), "getAttribute()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        this.intJumperCableFroId = this.getIntJumperCableMoFroId(context);
        EqcGetIntJumpCableParamRspS rspSig = this.eqcCableProxy.getIntJumpCableParameters(this.getTxIdNonTransactional(context), 0, this.intJumperCableFroId);
        if (attributeName.equals("aiuConnector")) {
            return rspSig.aiuConnectorId;
        }
        if (attributeName.equals("connFieldConnector")) {
            return rspSig.cfConnectorId;
        }
        if (attributeName.equals("dlAttenuation")) {
            return rspSig.dlAttenuation;
        }
        if (attributeName.equals("ulAttenuation")) {
            return rspSig.ulAttenuation;
        }
        if (attributeName.equals("electricalDlDelay")) {
            return rspSig.electricalDlDelay;
        }
        if (attributeName.equals("electricalUlDelay")) {
            return rspSig.electricalUlDelay;
        }
        String msg = "Attribute EqcGetHiPowTxCableParametersRspS." + attributeName + " no such attribute";
        MessageLog.trace(2, this.getClass(), msg);
        throw new NoSuchAttributeException(msg, this.getType());
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData()");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(this.getClass(), "isMyMoDataPersistent()");
        return true;
    }
}

