/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.emo.cable;

import se.ericsson.cello.equipment.EquipmentMo;
import se.ericsson.cello.equipment.PlugInUnitMaoi;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCreateCableRspS;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.emo.cable.RbsCableMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.BbifBoardMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.InterSubTimingCableMo;

public class InterSubTimingCableMoImpl
extends RbsCableMoImpl
implements InterSubTimingCableMo {
    private static final int INTER_SUB_MAX_NO_OF_CHILDREN = 2;
    private static final int INTER_SUB_TIMING_PARAM_ELECTRICAL_DELAY = 1;
    private static final int INTER_SUB_NOT_APPLICABLE = 0;
    public static final int MO_DATA_REVISION = 4010101;

    public InterSubTimingCableMoImpl(ManagedObject parent, String motypeName, AttrList attributes, String identity, Coordinator context, String checkedUserLabel, ManagedObject checkedBbifBoardRef, int checkedBbifConnector, ManagedObject checkedRfifPlugInUnitRef, int checkedRfifConnector, int checkedElectricalDelay, int checkedAlarmStatus) throws MoAccessException {
        super(parent, motypeName, identity, context, 2);
        MessageLog.traceEnter(this.getClass(), " InterSubTimingCableMoImpl()");
        ManagedObject rfifDeviceGroupRef = null;
        rfifDeviceGroupRef = this.checkPreconditionsGetRfifDeviceGroupRef(checkedRfifPlugInUnitRef, context);
        this.setReservation("bbifBoardRef", checkedBbifBoardRef, context);
        this.setReservation("rfifPlugInUnitRef", checkedRfifPlugInUnitRef, context);
        int bbifFroId = ((BbifBoardMo)checkedBbifBoardRef).getBbifFroId(context);
        int rfifPlugInUnitFroId = ((PlugInUnitMaoi)checkedRfifPlugInUnitRef).getFroId(context);
        EqcCreateCableRspS rspSig = this.eqcCableProxy.createCable(this.getTxIdTransactional(context), 0L, 50158, 0L, bbifFroId, checkedBbifConnector, rfifPlugInUnitFroId, checkedRfifConnector);
        int cableFroId = (int)rspSig.cableFroId;
        this.eqcCableProxy.setIstCableParameters(this.getTxIdTransactional(context), 0, cableFroId, 1, checkedElectricalDelay);
        this.initMoData(checkedUserLabel, checkedBbifBoardRef, checkedRfifPlugInUnitRef, rfifDeviceGroupRef, cableFroId, checkedAlarmStatus, context);
        this.addObservers(50158, context);
    }

    public InterSubTimingCableMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        MessageLog.traceEnter(this.getClass(), "InterSubTimingCableMoImpl()");
        try {
            this.addObservers(50158, null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Couldn't init the Observers!!");
        }
        MessageLog.trace(1, this.getClass(), "Mo recovered");
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(InterSubTimingCableMoImpl.class, "create()");
        InterSubTimingCableMoImpl.checkTransaction(context);
        InterSubTimingCableMoImpl.checkParent(parent);
        String checkedUserLabel = ValidateAttributes.checkAndGetStringAttribute(attributes, "userLabel", "optional", "", 0, 128, "InterSubTimingCable");
        ManagedObject checkedBbifBoardRef = InterSubTimingCableMoImpl.checkAndGetBbifBoardRef(attributes, context);
        int checkedBbifConnector = ValidateAttributes.checkAndGetIntAttribute(attributes, "bbifConnector", "mandatory", 1, 1, 1, "InterSubTimingCable");
        if (checkedBbifConnector == 1) {
            checkedBbifConnector = 3;
        } else {
            MessageLog.trace(1, InterSubTimingCableMoImpl.class, "incorrect input parameter");
        }
        ManagedObject checkedRfifPlugInUnitRef = InterSubTimingCableMoImpl.checkAndGetRfifPlugInUnitRef(attributes, context);
        int checkedRfifConnector = ValidateAttributes.checkAndGetIntAttribute(attributes, "rfifConnector", "mandatory", 1, 1, 1, "InterSubTimingCable");
        if (checkedRfifConnector == 1) {
            checkedRfifConnector = 2;
        } else {
            MessageLog.trace(1, InterSubTimingCableMoImpl.class, "incorrect input parameter");
        }
        int checkedElectricalDelay = ValidateAttributes.checkAndGetIntAttribute(attributes, "electricalDlDelay", "mandatory", 0, ELECTRICAL_DL_DELAY_MIN_VALUES, ELECTRICAL_DL_DELAY_MAX_VALUES, "InterSubTimingCable");
        int checkedAlarmStatus = ValidateAttributes.checkAndGetIntAttribute(attributes, "alarmStatus", "optional", 0, ALARM_STATUS_MIN_VALUES, ALARM_STATUS_MAX_VALUES, "InterSubTimingCable");
        ValidateAttributes.checkOtherAttributes(attributes, "InterSubTimingCable");
        InterSubTimingCableMoImpl createdMo = new InterSubTimingCableMoImpl(parent, "InterSubTimingCable", attributes, identity, context, checkedUserLabel, checkedBbifBoardRef, checkedBbifConnector, checkedRfifPlugInUnitRef, checkedRfifConnector, checkedElectricalDelay, checkedAlarmStatus);
        return createdMo;
    }

    private static void checkParent(ManagedObject parent) throws IllegalParentException {
        MessageLog.traceEnter(InterSubTimingCableMoImpl.class, "checkParent()");
        if (parent == null || !(parent instanceof EquipmentMo)) {
            String msg = " Illegal parent, Expecting EquipmentMo, received for : InterSubTimingCable";
            throw new IllegalParentException(msg);
        }
    }

    public String getType() {
        return "InterSubTimingCable";
    }

    public String getInterSubTimingCableId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getInterSubTimingCableId()");
        return this.getNamingAttributeValue();
    }

    public int getBbifConnector(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getBbifConnector()");
        return this.getRoValue(context, 50158, "bbifConnector", 1, 1);
    }

    public int getRfifConnector(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getRfifConnector()");
        return this.getRoValue(context, 50158, "rfifConnector", 1, 1);
    }

    public int getElectricalDlDelay(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getElectricalDlDelay()");
        return this.getRoValue(context, 50158, "electricalDlDelay", ELECTRICAL_DL_DELAY_MIN_VALUES, ELECTRICAL_DL_DELAY_MAX_VALUES);
    }

    public void setElectricalDlDelay(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setElectricalDlDelay()");
        this.setRoValue(context, 50158, 1, "electricalDlDelay", value, ELECTRICAL_DL_DELAY_MIN_VALUES, ELECTRICAL_DL_DELAY_MAX_VALUES);
    }

    public int getCableType() {
        MessageLog.traceEnter(this.getClass(), "getCableType()");
        return 50158;
    }

    private void initMoData(String checkedUserLabel, ManagedObject checkedBbifBoardRef, ManagedObject checkedRfifPlugInUnitRef, ManagedObject rfifDeviceGroupRef, int cableFroId, int checkedAlarmStatus, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "initMoData() ");
        this.bcmStoreAndRegisterStringAttribute("userLabel", checkedUserLabel);
        this.bcmStoreAndRegisterReferenceAttribute("bbifBoardRef", checkedBbifBoardRef);
        this.bcmStoreAndRegisterReferenceAttribute("rfifPlugInUnitRef", checkedRfifPlugInUnitRef);
        this.bcmStoreAndRegisterReferenceAttribute("rfifDeviceGroupRef", rfifDeviceGroupRef);
        this.bcmStoreAndRegisterIntAttribute("cableFroId", cableFroId);
        this.initAlarmStatus(checkedAlarmStatus, context);
        this.myData.setRevision(4010101);
    }
}

