/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.emo.cable;

import se.ericsson.cello.equipment.EquipmentMo;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcCableProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcRrhIndProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCreateCableRspS;
import se.ericsson.wcdma.rbs.boam.mao.alarm.MoAlarms;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObjectWithAlarms;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.OptoCommCableMo;

public class OptoCommCableMoImpl
extends BoamManagedObjectWithAlarms
implements OptoCommCableMo {
    private static final int NOT_APPLICABLE = 0;
    public static final String OPTO_CABLE_FRO_ID = "optoCommCableFroId";
    public static final int MO_DATA_REVISION = 2020001;
    private EqcCableProxy eqcCableProxy = EqcCableProxy.instance();
    private EqcRrhIndProxy eqcRrhIndProxy = EqcRrhIndProxy.instance();

    public OptoCommCableMoImpl(ManagedObject parent, String motypeName, AttrList attributes, String identity, Coordinator context, String checkedUserLabel, int checkedAlarmStatus) throws MoAccessException {
        super(parent, motypeName, identity, context);
        MessageLog.traceEnter(this.getClass(), " Normal constructor");
        EqcCreateCableRspS rspSig = this.eqcCableProxy.createCable(this.getTxIdTransactional(context), 0L, 50162, 0L, 0L, 0, 0L, 0);
        int OptoCableFroId = (int)rspSig.cableFroId;
        this.initMoData(checkedUserLabel, OptoCableFroId, checkedAlarmStatus, context);
        this.addObservers(50162, context);
    }

    public OptoCommCableMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        MessageLog.traceEnter(this.getClass(), " Recovery constructor");
        this.myData = recoveredData;
        IntegerAttribute optoFroIdAttr = (IntegerAttribute)recoveredData.getAttribute(OPTO_CABLE_FRO_ID);
        if (optoFroIdAttr == null) {
            MessageLog.traceError(this.getClass(), "Recovered attribute OptoCableFroId is null");
        }
        try {
            this.addObservers(50162, null);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), "Couldn't init the Observers!!");
        }
        MessageLog.trace(1, this.getClass(), "Mo recovered");
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(OptoCommCableMoImpl.class, "create()");
        OptoCommCableMoImpl.checkTransaction(context);
        OptoCommCableMoImpl.checkParent(parent);
        String checkedUserLabel = ValidateAttributes.checkAndGetStringAttribute(attributes, "userLabel", "optional", "", 0, 128, "OptoCommCable");
        int checkedAlarmStatus = ValidateAttributes.checkAndGetIntAttribute(attributes, "alarmStatus", "optional", 0, ALARM_STATUS_MIN_VALUES, ALARM_STATUS_MAX_VALUES, "OptoCommCable");
        ValidateAttributes.checkOtherAttributes(attributes, "OptoCommCable");
        OptoCommCableMoImpl createdMo = new OptoCommCableMoImpl(parent, "OptoCommCable", attributes, identity, context, checkedUserLabel, checkedAlarmStatus);
        return createdMo;
    }

    public void delete(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "delete() ");
        MessageLog.trace(1, this.getClass(), "OptoCommCable to be deleted when the PCU aux pluginUnit is deleted");
        throw new UndeletableMoException((ManagedObject)this);
    }

    public void deleteOptoCommCable(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "deleteOptoCommCable()");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        int optoCableFroId = this.getOptoCableFroId(context);
        this.eqcCableProxy.deleteCable(this.getTxIdTransactional(context), 0, optoCableFroId, 50162);
        this.removeObservers(context);
        super.delete(context);
        MessageLog.trace(1, this.getClass(), this.getType() + " Mo is Deleted ");
    }

    public String getType() {
        return "OptoCommCable";
    }

    public int getOptoCableFroId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getOptoCableFroId()");
        return this.bcmGetIntAttribute(OPTO_CABLE_FRO_ID, context);
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData()");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(this.getClass(), "isMyMoDataPersistent()");
        return true;
    }

    public String getUserLabel(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getUserLabel()");
        return this.bcmGetStringAttribute("userLabel", context);
    }

    public void setUserLabel(String value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setUserLabel()");
        this.bcmSetStringAttribute("userLabel", value, 0, 128, this.getType(), context);
        this.sendAVC("userLabel", value, context);
    }

    private static void checkParent(ManagedObject parent) throws IllegalParentException {
        MessageLog.traceEnter(OptoCommCableMoImpl.class, "checkParent");
        if (parent == null || !(parent instanceof EquipmentMo)) {
            String msg = parent != null ? " Illegal parent, Expecting EquipmentMo, received: " + parent.getClass().getName() : "parent is null";
            throw new IllegalParentException(msg);
        }
    }

    private void initMoData(String checkedUserLabel, int optoCableFroId, int checkedAlarmStatus, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "initMoData() ");
        this.myData = new MoData(this.getLocalDistinguishedName(), this.getType(), true, context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.bcmStoreAndRegisterStringAttribute("userLabel", checkedUserLabel);
        this.bcmStoreAndRegisterIntAttribute(OPTO_CABLE_FRO_ID, optoCableFroId);
        this.initAlarmStatus(checkedAlarmStatus, context);
        this.myData.setRevision(2020001);
    }

    private void addObservers(int froType, Coordinator context) throws MoAccessException {
        this.myMoAlarms = new MoAlarms((ManagedObject)this, this.eqcRrhIndProxy, froType, this.getOptoCableFroId(context), context);
    }

    private void removeObservers(Coordinator context) throws MoAccessException {
        this.myMoAlarms.delete(context);
    }

    public int getFroId(Coordinator c) {
        MessageLog.traceEnter(this.getClass(), "getFroId()");
        int froId = 0;
        try {
            froId = this.getOptoCableFroId(c);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(this.getClass(), e.getMessage());
        }
        return froId;
    }
}

