/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.emo.cable;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObjectWithAlarms;
import se.ericsson.wcdma.rbs.boam.mao.emo.cable.GammaCableMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.emo.cable.InterSubTimingCableMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.emo.cable.IntraCabTimingCableMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.emo.cable.OpticalInterfaceLinkMoImpl;

public class RbsCableMoFactory
implements MoFactory {
    private static RbsCableMoFactory istCableInstance;
    private static RbsCableMoFactory ictCableInstance;
    private static RbsCableMoFactory gammaCableInstance;
    private static RbsCableMoFactory oilInstance;
    private int cableType = 0;

    private RbsCableMoFactory(int cableType) {
        MessageLog.traceEnter(this.getClass(), "cableType = " + cableType + ", Normal constructor");
        this.cableType = cableType;
        MoFactoryMgr.instance().register((MoFactory)this, this.getMoTypeName());
    }

    public static synchronized RbsCableMoFactory instance(int cableType) {
        RbsCableMoFactory instance = null;
        switch (cableType) {
            case 50158: {
                if (istCableInstance == null) {
                    istCableInstance = new RbsCableMoFactory(cableType);
                }
                instance = istCableInstance;
                break;
            }
            case 50159: {
                if (ictCableInstance == null) {
                    ictCableInstance = new RbsCableMoFactory(cableType);
                }
                instance = ictCableInstance;
                break;
            }
            case 50160: {
                if (gammaCableInstance == null) {
                    gammaCableInstance = new RbsCableMoFactory(cableType);
                }
                instance = gammaCableInstance;
                break;
            }
            case 50164: {
                if (oilInstance == null) {
                    oilInstance = new RbsCableMoFactory(cableType);
                }
                instance = oilInstance;
                break;
            }
            default: {
                instance = null;
            }
        }
        return instance;
    }

    public ManagedObject createMo(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "createMo()");
        ManagedObject createdMo = this.createTheMo(parent, attributes, identity, context);
        MessageLog.trace(1, this.getClass(), " Cable MO Created");
        return createdMo;
    }

    public ManagedObject createTheMo(ManagedObject parent, AttrList attributes, String identity, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "createTheMo()");
        ManagedObject mo = null;
        switch (this.cableType) {
            case 50158: {
                mo = InterSubTimingCableMoImpl.create(parent, attributes, identity, context);
                break;
            }
            case 50159: {
                mo = IntraCabTimingCableMoImpl.create(parent, attributes, identity, context);
                break;
            }
            case 50160: {
                mo = GammaCableMoImpl.create(parent, attributes, identity, context);
                break;
            }
            case 50164: {
                mo = OpticalInterfaceLinkMoImpl.create(parent, attributes, identity, context);
                break;
            }
            default: {
                MessageLog.trace(1, this.getClass(), "Software Error in BOAM, illegal cable type");
            }
        }
        MessageLog.trace(1, this.getClass(), "createTheMo() return");
        return mo;
    }

    public ManagedObject recoverMo(MoData recoveredData) throws MoNameAlreadyTakenException {
        MessageLog.traceEnter(this.getClass(), "recoverMo for cable type : " + this.cableType);
        BoamManagedObjectWithAlarms mo = null;
        switch (this.cableType) {
            case 50158: {
                mo = new InterSubTimingCableMoImpl(recoveredData);
                break;
            }
            case 50159: {
                mo = new IntraCabTimingCableMoImpl(recoveredData);
                break;
            }
            case 50160: {
                mo = new GammaCableMoImpl(recoveredData);
                break;
            }
            case 50164: {
                mo = new OpticalInterfaceLinkMoImpl(recoveredData);
                break;
            }
            default: {
                MessageLog.trace(1, this.getClass(), "Software Error in BOAM, illegal cable type");
            }
        }
        return mo;
    }

    public String getMoTypeName() {
        MessageLog.traceEnter(this.getClass(), "getMoTypeName()");
        String name = "UnknownCable";
        switch (this.cableType) {
            case 50158: {
                name = "InterSubTimingCable";
                break;
            }
            case 50159: {
                name = "IntraCabTimingCable";
                break;
            }
            case 50160: {
                name = "GammaCable";
                break;
            }
            case 50164: {
                name = "OpticalInterfaceLink";
                break;
            }
            default: {
                MessageLog.trace(2, this.getClass(), "Software Error in BOAM, illegal cable type");
            }
        }
        return name;
    }
}

