/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.rmo.cell;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.AttrNotReadableException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFilter;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.SoftwareErrorException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.wcdma.rbs.boam.common.AvailabilityStatusIntToEnum;
import se.ericsson.wcdma.rbs.boam.common.EnumConverter;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.ServiceNotPublishedException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcSectorProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EcSectorGetParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EqcCreateSectorRspS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.proxies.ScRfAccessProxy;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsCreateRfapRspS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsInitRfapRspS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsInitSectorGetParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsRfapDeviceS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsSectorGetParamRspS;
import se.ericsson.wcdma.rbs.boam.mao.alarm.MoAlarms;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObject;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObjectWithAlarms;
import se.ericsson.wcdma.rbs.boam.mao.common.AttrListImpl;
import se.ericsson.wcdma.rbs.boam.mao.common.ConfigNotSupportedException;
import se.ericsson.wcdma.rbs.boam.mao.common.MaoHasFro;
import se.ericsson.wcdma.rbs.boam.mao.common.MoTypeFilter;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.AlreadyInitiatedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.BandAndFrequencyMismatchException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.ConfigurationNotSupportedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.HsdpaCodeResourceMismatchException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.InternalErrorException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.NotInitiatedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.ResourceLockedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.ResourcesNotAvailableException;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.CarrierMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.ExternalAntennaMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.ExternalTmaMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RbsLocalCellMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.SectorAntennaMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.SectorMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.SystemConstantsMo;
import se.ericsson.wcdma.rbs.boam.mao.rmo.antenna.ExternalTmaMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.rmo.cell.CarrierSectorInitialisation;
import se.ericsson.wcdma.rbs.boam.mao.rmo.cell.SectorAntennaMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.rmo.cell.SectorHelper;

public class SectorMoImpl
extends BoamManagedObjectWithAlarms
implements SectorMo {
    private static final Class THIS_CLASS = SectorMoImpl.class;
    private static final EqcSectorProxy eqcSectorProxy = EqcSectorProxy.instance();
    private static final ScRfAccessProxy lrsRfapProxy = ScRfAccessProxy.instance();
    private static final String RF_ACCESS_POINT_FRO_ID = "rfAccessPointFroId";
    private static final int SEC_MAX_NO_OF_CHILDREN = 12;
    private static final String NORMAL_CONSTRUCTOR = " Normal constructor ";
    private static final String RECOVERY_CONSTRUCTOR = " Recovery constructor ";
    private static final String MAO_IS_DELETED = " MAO is Deleted ";
    public static final int MAX_NR_OF_CELL_IN_SECTOR = 2;
    private static final int DUMMY_VALUE = -1;
    private static final char DELIM_CHAR = '-';
    private static final String SYSTEMCONSTANT_INHIBIT_OPTIMAL_PA_BIAS_LEVEL_NUMBER = "412";
    private static final String SYSTEMCONSTANT_INHIBIT_OPTIMAL_PA_BIAS_LEVEL_NAME = "inhibitOptimalPaBiasLevel";
    private static final String TRUE = "1";
    private static final String FALSE = "0";
    private static final int NORMAL_SECTORCONFIGURATION = 0;
    public static final int Y_CONFIG = 98;
    public static final int PSI_CONFIG = 99;
    public static final int MO_DATA_REVISION = 14010600;

    public SectorMoImpl(ManagedObject parent, String identity, ManagedObject source, Coordinator context, int alarmStatus, String beamDirection, String geoDatum, String height, int latHemisphere, int latitude, int longitude, boolean checkedMaxInternalUIGainOn, String userLabel, int radioBuildingBlock, int lineRate, int checkedSectorGroup, int checkedNumberOfSectorAntennas, int[] checkedSectorConfiguration, boolean checkedmixedModeRadio, int checkedNoiseFigure) throws MoAccessException {
        super(parent, "Sector", identity, context, 12);
        MessageLog.traceEnter(THIS_CLASS, NORMAL_CONSTRUCTOR);
        int sectorFroId = this.createEqcRo(context);
        int rfAccessPointFroId = this.createLrsRo(sectorFroId, EnumConverter.rbsBooleanTConverter(checkedMaxInternalUIGainOn), EnumConverter.rbsBooleanTConverter(checkedmixedModeRadio), context);
        ManagedObject[] saList = this.createSectorAntennas(checkedNumberOfSectorAntennas, sectorFroId, identity, source, context);
        this.initMoData(alarmStatus, beamDirection, geoDatum, height, latHemisphere, latitude, longitude, userLabel, saList, sectorFroId, rfAccessPointFroId, checkedNumberOfSectorAntennas, context);
        this.setSectorParam(identity, radioBuildingBlock, lineRate, sectorFroId, checkedSectorGroup, checkedSectorConfiguration, checkedNoiseFigure, context);
        this.addObservers(108, context);
        this.setSysConstantInhibitOptimalPaBiasLevel(context, false);
    }

    public SectorMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData);
        MessageLog.traceEnter(THIS_CLASS, RECOVERY_CONSTRUCTOR);
        this.myData = recoveredData;
        try {
            this.addObservers(108, null);
        }
        catch (MoAccessException moAccessException) {
            // empty catch block
        }
        MessageLog.trace(2, THIS_CLASS, "Mo recovered");
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "create() ");
        ValidateAttributes.checkTransaction(context);
        ValidateAttributes.checkParent(parent, "NodeBFunction");
        int checkedAlarmStatus = ValidateAttributes.checkAndGetIntAttribute(attributes, "alarmStatus", "optional", 0, ALARM_STATUS_MIN_VALUES, ALARM_STATUS_MAX_VALUES, "Sector");
        SectorMoImpl.checkStringAttrLength(attributes, "beamDirection", 3);
        String checkedBeamDirection = ValidateAttributes.checkAndGetStringAttribute(attributes, "beamDirection", "optional", "000", 3, 3, "Sector");
        SectorMoImpl.checkStringAttrLength(attributes, "geoDatum", 5);
        String checkedGeoDatum = ValidateAttributes.checkAndGetStringAttribute(attributes, "geoDatum", "optional", "WGS84", 5, 5, "Sector");
        String checkedHeight = ValidateAttributes.checkAndGetStringAttribute(attributes, "height", "optional", "", 0, 6, "Sector");
        int checkedLatHemisphere = ValidateAttributes.checkAndGetIntAttribute(attributes, "latHemisphere", "optional", 0, 0, 1, "Sector");
        int checkedLatitude = ValidateAttributes.checkAndGetIntAttribute(attributes, "latitude", "optional", 0, LATITUDE_MIN_VALUES, LATITUDE_MAX_VALUES, "Sector");
        int checkedLongitude = ValidateAttributes.checkAndGetIntAttribute(attributes, "longitude", "optional", 0, LONGITUDE_MIN_VALUES, LONGITUDE_MAX_VALUES, "Sector");
        ValidateAttributes.checkAndGetIntAttribute(attributes, "band", "optional", 0, BAND_MIN_VALUES, BAND_MAX_VALUES, "Sector");
        boolean checkedMaxInternalUIGainOn = ValidateAttributes.checkAndGetBooleanAttribute(attributes, "maxInternalUlGainOn", "optional", false, false, true, "Sector");
        String checkedUserLabel = ValidateAttributes.checkAndGetStringAttribute(attributes, "userLabel", "optional", "", 0, 128, "Sector");
        int checkedRadioBuildingBlock = ValidateAttributes.checkAndGetIntAttribute(attributes, "radioBuildingBlock", "optional", 0, 0, 33, "Sector");
        int checkedLineRate = ValidateAttributes.checkAndGetIntAttribute(attributes, "lineRate", "optional", 0, 0, 2, "Sector");
        int checkedSectorGroup = ValidateAttributes.checkAndGetIntAttribute(attributes, "sectorGroup", "optional", -1, SECTOR_GROUP_MIN_VALUES, SECTOR_GROUP_MAX_VALUES, "Sector");
        int checkedNumberOfSectorAntennas = ValidateAttributes.checkAndGetIntAttribute(attributes, "numberOfSectorAntennas", "optional", 1, NUMBER_OF_SECTOR_ANTENNAS_MIN_VALUES, NUMBER_OF_SECTOR_ANTENNAS_MAX_VALUES, "Sector");
        boolean checkedMixedModeRadio = ValidateAttributes.checkAndGetBooleanAttribute(attributes, "mixedModeRadio", "optional", false, false, true, "Sector");
        int[] checkedSectorConfiguration = SectorMoImpl.checkSectorConfiguration(attributes, "sectorConfiguration", "optional", SECTOR_CONFIGURATION_DEF_VALUE, 1, 3, 10, "Sector");
        int checkedNoiseFigure = ValidateAttributes.checkAndGetIntAttribute(attributes, "noiseFigure", "optional", -1, NOISE_FIGURE_MIN_VALUES, NOISE_FIGURE_MAX_VALUES, "Sector");
        ValidateAttributes.checkOtherAttributes(attributes, "Sector");
        SectorMoImpl createdMo = new SectorMoImpl(parent, identity, source, context, checkedAlarmStatus, checkedBeamDirection, checkedGeoDatum, checkedHeight, checkedLatHemisphere, checkedLatitude, checkedLongitude, checkedMaxInternalUIGainOn, checkedUserLabel, checkedRadioBuildingBlock, checkedLineRate, checkedSectorGroup, checkedNumberOfSectorAntennas, checkedSectorConfiguration, checkedMixedModeRadio, checkedNoiseFigure);
        return createdMo;
    }

    private ManagedObject[] createSectorAntennas(int numberOfSectorAntennas, int sectorFroId, String sectorNo, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "createSectorAntennas()");
        MoIterator iter = BoamHelper.findMOs("Equipment", 1);
        int numOfExistingSa = 0;
        if (iter.size() == 0) {
            throw new MoNotFoundException("ManagedElement=1,Equipment=1");
        }
        ManagedObject equipmentMo = iter.nextMo();
        if (this.myData != null) {
            ManagedObject[] sectorAntennas = this.getSectorAntennasRef(context);
            numOfExistingSa = sectorAntennas.length;
        }
        if (numOfExistingSa + numberOfSectorAntennas > 3) {
            throw new ConfigNotSupportedException("Cannot increase the number of SectorAntennas since the number will be more than the max limit: 3");
        }
        ManagedObject[] saList = new ManagedObject[numberOfSectorAntennas];
        for (int i = numOfExistingSa + 1; i <= numberOfSectorAntennas + numOfExistingSa; ++i) {
            AttrListImpl attributes = new AttrListImpl();
            attributes.insert("sectorFroId", new Integer(sectorFroId));
            SectorAntennaMo sectorAntenna = (SectorAntennaMo)SectorAntennaMoImpl.create(equipmentMo, attributes, sectorNo + '-' + i, source, context);
            sectorAntenna.reserve(this, context);
            saList[i - (numOfExistingSa + 1)] = sectorAntenna;
        }
        return saList;
    }

    private void deleteSectorAntennas(int numSectorAntennasToDelete, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "deleteSectorAntennas()");
        int numberOfRxBranches = this.getNumberOfRxBranches(context);
        ManagedObject[] childlessSectorAntennas = this.getChildlessSectorAntennas(context);
        if (numSectorAntennasToDelete > childlessSectorAntennas.length) {
            throw new ConfigNotSupportedException("All SectorAntenna(s) to delete are not childless, num SectorAntennas to delete: " + numSectorAntennasToDelete + "childless SectorAntennas: " + childlessSectorAntennas.length);
        }
        if (numberOfRxBranches != 2 && numberOfRxBranches != -1) {
            MessageLog.trace(2, THIS_CLASS, "Cannot delete SectorAntenna. numberOfRxBranches = " + numberOfRxBranches);
            throw new ConfigNotSupportedException("Deletion of SectorAntenna is only allowed if Carrier.numberOfRxBranches = 2 for all Carriers of this Sector.");
        }
        for (int i = 0; i < numSectorAntennasToDelete; ++i) {
            try {
                ((SectorAntennaMo)childlessSectorAntennas[i]).release(this, context);
                ((SectorAntennaMo)childlessSectorAntennas[i]).delete(context);
                continue;
            }
            catch (MoAccessException e0) {
                String msg = " Cannot delete SectorAntenna.";
                MessageLog.trace(2, THIS_CLASS, msg);
                throw e0;
            }
        }
    }

    private void setOperatingBandInSector(RbsLocalCellMo localCell, int band, Coordinator c) throws MoAccessException {
        if (localCell.isCombinedCell(c)) {
            boolean anySectorInitialized = false;
            ManagedObject[] carriers = localCell.getCarriersRef(c);
            for (int i = 0; i < carriers.length; ++i) {
                SectorMo sector = (SectorMo)((CarrierMo)carriers[i]).getParent();
                if (sector == null || !sector.isSectorInitialized(c)) continue;
                anySectorInitialized = true;
                break;
            }
            if (anySectorInitialized) {
                if (band != localCell.getOperatingBand(c)) {
                    throw new ConfigurationNotSupportedException("Bands in one Combined Cell should be same!");
                }
            } else {
                localCell.setOperatingBand(band, c);
            }
        } else {
            localCell.setOperatingBand(band, c);
        }
    }

    public void actionInitSector(int numberOfTxBranches, int band, Coordinator c) throws MoAccessException, AlreadyInitiatedException, ConfigurationNotSupportedException, ResourcesNotAvailableException, ResourceLockedException, BandAndFrequencyMismatchException, HsdpaCodeResourceMismatchException {
        MessageLog.traceEnter(THIS_CLASS, "actionInitSector() ");
        ValidateAttributes.checkTransaction(c);
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        ValidateAttributes.intValueRangeCheck("numberOfTxBranches", numberOfTxBranches, 1, 4, "Sector");
        ValidateAttributes.intValueRangeCheck("band", band, 1, 100, "Sector");
        CarrierMo[] carriers = SectorHelper.getCarriers(this);
        if (carriers.length == 0 || carriers[0] == null) {
            throw new ConfigurationNotSupportedException("No Carriers can be found under this Sector");
        }
        int txDiversity = carriers[0].getNumberOfTxBranches(c) - 1;
        int numberOfRxBranches = carriers[0].getNumberOfRxBranches(c);
        int frequencyPlanes = this.getFrequencyPlanes(carriers, c);
        this.checkInitSectorPreconditions(carriers, numberOfTxBranches, numberOfRxBranches, txDiversity, c);
        for (int i = 0; i < carriers.length; ++i) {
            ManagedObject[] carrierResvered = carriers[i].getReservedBy(c);
            RbsLocalCellMo localCell = (RbsLocalCellMo)BoamHelper.getFirstMatchingMo(carrierResvered, "RbsLocalCell");
            if (localCell == null) continue;
            this.setOperatingBandInSector(localCell, band, c);
        }
        int tmaProperties = this.findTmaProperties(c);
        int withTma = tmaProperties == 5 ? 2 : (tmaProperties != 0 ? 1 : 0);
        int withRet = this.hasRet(c) ? 1 : 0;
        this.initEqcRo(frequencyPlanes, numberOfTxBranches, withTma, withRet, txDiversity, c);
        try {
            LrsInitRfapRspS initRfapRsp = this.initLrsRo(tmaProperties, c);
            if (initRfapRsp.noOfTmaDev > 0) {
                this.reserveTmaDevices(initRfapRsp.noOfTmaDev, initRfapRsp.tma, c);
            }
            if (initRfapRsp.noOfRetDev > 0) {
                this.reserveRetDevice(initRfapRsp.noOfRetDev, initRfapRsp.retDevFroId, c);
            }
            for (int i = 0; i < carriers.length; ++i) {
                carriers[i].sectorInitiated(initRfapRsp.noOfDpclDev, initRfapRsp.dpcl, initRfapRsp.noOfTpaDev, initRfapRsp.tpa, initRfapRsp.noOfAiDev, initRfapRsp.ai, initRfapRsp.noOfDbccDev, initRfapRsp.dbcc, initRfapRsp.noOfTrDev, initRfapRsp.tr, c);
            }
            MessageLog.trace(1, THIS_CLASS, "actionInitSector OK");
        }
        catch (MoAccessException e) {
            try {
                c.rollbackOnly();
            }
            catch (InactiveTransactionException e2) {
                // empty catch block
            }
            throw e;
        }
        SectorHelper.checkSumHsNumCodeResourcesInAllTxDeviceGroup(c);
        if (this.isSectorInitialized(c)) {
            this.sendAVC("proceduralStatus", 0, c);
            this.resendDcvoltageToEc(c);
        }
    }

    public void actionUnInitSector(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "actionUnInitSector() ");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        int proceduralStatus = this.getLrsAttribute("proceduralStatus", context);
        if (proceduralStatus != 0) {
            MessageLog.trace(2, THIS_CLASS, "The sector is not initialized.");
            throw new NotInitiatedException();
        }
        this.uninitLrsRo(context);
        try {
            this.uninitEqcRo(context);
            SequenceAttribute tmaDeviceRefAttr = (SequenceAttribute)this.myData.getAttribute("tmaDeviceRef");
            ManagedObject[] tmaDevices = this.getTmaDeviceRef(context);
            for (int i = 0; i < tmaDevices.length; ++i) {
                BoamManagedObject tmaDev = (BoamManagedObject)tmaDevices[i];
                if (tmaDev == null) continue;
                tmaDev.release(this, context);
            }
            tmaDeviceRefAttr.setValue((Attribute[])new ReferenceAttribute[0]);
            this.sendAVC("tmaDeviceRef", this.getTmaDeviceRef(context), context);
            ManagedObject[] retDevices = this.getRetDevicesRef(context);
            if (retDevices != null) {
                for (int i = 0; i < retDevices.length; ++i) {
                    BoamManagedObject retDev = (BoamManagedObject)retDevices[i];
                    if (retDev == null) continue;
                    retDev.release(this, context);
                }
                this.bcmSetSequenceAttribute("retDevicesRef", new Attribute[0], 10, "Sector", context);
                this.sendAVC("retDevicesRef", this.getRetDevicesRef(context), context);
            }
            MoIterator iter = BoamHelper.findMOs("Carrier", this, 1);
            while (iter.hasMoreElements()) {
                CarrierSectorInitialisation carrier = (CarrierSectorInitialisation)iter.nextMo();
                carrier.sectorUnInitiated(context);
            }
            int newProceduralStatus = this.getLrsAttribute("proceduralStatus", context);
            if (newProceduralStatus != 0) {
                this.sendAVC("proceduralStatus", newProceduralStatus, context);
            }
            MessageLog.trace(1, THIS_CLASS, "actionUninitSector OK");
        }
        catch (MoAccessException e) {
            try {
                context.rollbackOnly();
            }
            catch (InactiveTransactionException e2) {
                // empty catch block
            }
            throw e;
        }
    }

    public String getUserLabel(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "getUserLabel() ");
        return this.bcmGetStringAttribute("userLabel", context);
    }

    public void setUserLabel(String value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "setUserLabel() ");
        this.bcmSetStringAttribute("userLabel", value, 0, 128, "Sector", context);
        this.sendAVC("userLabel", value, context);
    }

    public int getOperationalState(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "getOperationalState() ");
        int operationalState = this.getLrsAttribute("operationalState", context);
        return operationalState;
    }

    public int getAvailabilityStatus(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "getAvailabilityStatus() ");
        return AvailabilityStatusIntToEnum.convGetAvailStatIntToEnum(this.getLrsAttribute("availabilityStatus", context));
    }

    public int getProceduralStatus(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "getProceduralStatus() ");
        return this.getLrsAttribute("proceduralStatus", context);
    }

    public int getNumberOfTxBranches(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "getNumberOfTxBranches()");
        return this.getEcAttribute("numberOfTxBranches", context);
    }

    public int getLatitude(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "getLatitude() ");
        return this.bcmGetIntAttribute("latitude", context);
    }

    public void setLatitude(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "setLatitude() ");
        this.bcmSetIntAttribute("latitude", value, LATITUDE_MIN_VALUES, LATITUDE_MAX_VALUES, "Sector", context);
        this.sendAVC("latitude", value, context);
    }

    public int getLatHemisphere(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "getLatHemisphere() ");
        return this.bcmGetIntAttribute("latHemisphere", context);
    }

    public void setLatHemisphere(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "setLatHemisphere() ");
        this.bcmSetIntAttribute("latHemisphere", value, 0, 1, "Sector", context);
        this.sendAVC("latHemisphere", value, context);
    }

    public int getLongitude(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "getLongitude() ");
        return this.bcmGetIntAttribute("longitude", context);
    }

    public void setLongitude(int value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "setLongitude() ");
        this.bcmSetIntAttribute("longitude", value, LONGITUDE_MIN_VALUES, LONGITUDE_MAX_VALUES, "Sector", context);
        this.sendAVC("longitude", value, context);
    }

    public String getGeoDatum(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "getGeoDatum() ");
        return this.bcmGetStringAttribute("geoDatum", context);
    }

    public void setGeoDatum(String value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "setGeoDatum() ");
        if (value == null || value.length() != 5) {
            throw new ValueOutOfRangeException("geoDatum", "Sector");
        }
        this.bcmSetStringAttribute("geoDatum", value, 5, 5, "Sector", context);
        this.sendAVC("geoDatum", value, context);
    }

    public String getBeamDirection(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "getBeamDirection() ");
        return this.bcmGetStringAttribute("beamDirection", context);
    }

    public void setBeamDirection(String value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "setBeamDirection() ");
        if (value == null || value.length() != 3) {
            throw new ValueOutOfRangeException("beamDirection", "Sector");
        }
        this.bcmSetStringAttribute("beamDirection", value, 3, 3, "Sector", context);
        this.sendAVC("beamDirection", value, context);
    }

    public String getHeight(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "getHeight() ");
        return this.bcmGetStringAttribute("height", context);
    }

    public void setHeight(String value, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "setHeight() ");
        this.bcmSetStringAttribute("height", value, 0, 6, "Sector", context);
        this.sendAVC("height", value, context);
    }

    public ManagedObject[] getTmaDeviceRef(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "getTmaDeviceRef() ");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        return this.bcmGetMoRefSequenceAttribute("tmaDeviceRef", context);
    }

    private ManagedObject getExternalAntennaRef(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "getExternalAntennaRef() ");
        ExternalAntennaMo externalAntenna = null;
        ManagedObject[] reservers = this.getReservedBy(context);
        if (reservers != null) {
            for (int i = 0; i < reservers.length; ++i) {
                if (!(reservers[i] instanceof ExternalAntennaMo)) continue;
                externalAntenna = (ExternalAntennaMo)reservers[i];
            }
        }
        return externalAntenna;
    }

    public void delete(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "delete() ");
        int proceduralStatus = this.getLrsAttribute("proceduralStatus", context);
        if (proceduralStatus == 0) {
            String msg = "The sector is not uninitialized.";
            MessageLog.trace(2, THIS_CLASS, msg);
            throw new UndeletableMoException((ManagedObject)this);
        }
        ManagedObject[] sectorAntenna = this.getSectorAntennasRef(context);
        for (int i = 0; i < sectorAntenna.length; ++i) {
            try {
                ((SectorAntennaMo)sectorAntenna[i]).release(this, context);
                ((SectorAntennaMo)sectorAntenna[i]).delete(context);
                continue;
            }
            catch (MoAccessException e0) {
                String msg = " Cannot delete SectorAntenna.";
                MessageLog.trace(2, THIS_CLASS, msg);
                throw e0;
            }
        }
        this.getMyMoData().handleTransaction(context, MoData.WRITE_ACCESS);
        this.deleteLrsRo(context);
        try {
            this.deleteEqcRo(context);
            MessageLog.trace(1, THIS_CLASS, MAO_IS_DELETED);
        }
        catch (MoAccessException e) {
            try {
                context.rollbackOnly();
            }
            catch (InactiveTransactionException e1) {
                // empty catch block
            }
            throw e;
        }
        this.removeObservers(context);
        super.delete(context);
        this.setSysConstantInhibitOptimalPaBiasLevel(context, true);
        MessageLog.trace(1, THIS_CLASS, "Mo is Deleted");
    }

    public String getType() {
        return "Sector";
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(THIS_CLASS, "getMyMoData() ");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(THIS_CLASS, "isMyMoDataPersistent() ");
        return true;
    }

    public int getRfAccessPointFroId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "getRfAccessPointFroId() ");
        return this.bcmGetIntAttribute(RF_ACCESS_POINT_FRO_ID, context);
    }

    public int getSectorFroId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "getSectorFroId() ");
        return this.bcmGetIntAttribute("sectorFroId", context);
    }

    public boolean isSectorInitialized(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "isSectorInitialized() ");
        try {
            return this.getLrsAttribute("proceduralStatus", context) == 0;
        }
        catch (MoAccessException e) {
            return false;
        }
    }

    private void initEqcRo(int frequencyPlanes, int numberOfTxBranches, int withTma, int withRet, int txDiversity, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "initEqcRo() ");
        try {
            eqcSectorProxy.initSector(this.getTxIdTransactional(context), 0, this.getSectorFroId(context), frequencyPlanes, numberOfTxBranches, withTma, withRet, txDiversity);
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 20) {
                throw new ConfigurationNotSupportedException();
            }
            if (e.getOrgErrorCode() == 19) {
                throw new ConfigurationNotSupportedException();
            }
            if (e.getOrgErrorCode() == 47) {
                throw new ConfigurationNotSupportedException();
            }
            if (e.getOrgErrorCode() == 14) {
                throw new ResourcesNotAvailableException();
            }
            if (e.getOrgErrorCode() == 16) {
                throw new AlreadyInitiatedException();
            }
            throw e;
        }
    }

    private LrsInitRfapRspS initLrsRo(int tmaProperties, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, " initLrsRo() ");
        try {
            LrsInitRfapRspS cfmSig = lrsRfapProxy.initRfap(this.getTxIdTransactional(context), 0, this.getRfAccessPointFroId(context), tmaProperties, EnumConverter.rbsBooleanTConverter(this.getMixedModeRadio(context)));
            return cfmSig;
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 5) {
                throw new ResourceLockedException();
            }
            if (e.getOrgErrorCode() == 4) {
                throw new AlreadyInitiatedException();
            }
            if (e.getOrgErrorCode() == 2) {
                throw new ResourcesNotAvailableException();
            }
            if (e.getOrgErrorCode() == 9 || e.getOrgErrorCode() == 28) {
                throw new BandAndFrequencyMismatchException();
            }
            throw e;
        }
    }

    private void uninitLrsRo(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, " uninitLrsRo() ");
        try {
            lrsRfapProxy.uninitRfap(this.getTxIdTransactional(context), 0, this.getRfAccessPointFroId(context));
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 5) {
                throw new ResourceLockedException();
            }
            throw e;
        }
    }

    private void uninitEqcRo(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, " uninitEqcRo() ");
        try {
            eqcSectorProxy.uninitSector(this.getTxIdTransactional(context), 0, this.getSectorFroId(context));
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 5) {
                throw new ResourceLockedException();
            }
            if (e.getOrgErrorCode() == 17) {
                throw new NotInitiatedException();
            }
            throw e;
        }
    }

    private void deleteLrsRo(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, " deleteLrsRo() ");
        lrsRfapProxy.deleteRfap(this.getTxIdTransactional(context), 0, this.getRfAccessPointFroId(context));
    }

    private void deleteEqcRo(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, " deleteEqcRo() ");
        eqcSectorProxy.deleteSector(this.getTxIdTransactional(context), 0, this.getSectorFroId(context));
    }

    private void initMoData(int alarmStatus, String beamDirection, String geoDatum, String height, int latHemisphere, int latitude, int longitude, String userLabel, ManagedObject[] saList, int sectorFroId, int rfAccessPointFroId, int numberOfSectorAntennas, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, " initMoData() ");
        this.myData = new MoData(this.getLocalDistinguishedName(), this.getType(), true, context);
        this.myData.setRevision(14010600);
        this.initAlarmStatus(alarmStatus, context);
        this.bcmStoreAndRegisterStringAttribute("beamDirection", beamDirection);
        this.bcmStoreAndRegisterStringAttribute("geoDatum", geoDatum);
        this.bcmStoreAndRegisterStringAttribute("height", height);
        this.bcmStoreAndRegisterIntAttribute("latHemisphere", latHemisphere);
        this.bcmStoreAndRegisterIntAttribute("latitude", latitude);
        this.bcmStoreAndRegisterIntAttribute("longitude", longitude);
        this.bcmStoreAndRegisterStringAttribute("userLabel", userLabel);
        this.bcmStoreAndRegisterSequenceAttribute("retDevicesRef", new Attribute[0]);
        Attribute[] sectorAntennas = new Attribute[numberOfSectorAntennas];
        for (int i = 0; i < saList.length; ++i) {
            ReferenceAttribute ref = new ReferenceAttribute("SectorAntenna", false);
            ref.setValue(saList[i]);
            sectorAntennas[i] = ref;
        }
        this.bcmStoreAndRegisterSequenceAttribute("sectorAntennasRef", sectorAntennas);
        SequenceAttribute tmaDeviceRefAttr = new SequenceAttribute("tmaDeviceRef", false);
        this.myData.registerPersistentAttr((Attribute)tmaDeviceRefAttr);
        this.bcmStoreAndRegisterIntAttribute("sectorFroId", sectorFroId);
        this.bcmStoreAndRegisterIntAttribute(RF_ACCESS_POINT_FRO_ID, rfAccessPointFroId);
        this.bcmStoreAndRegisterIntAttribute("numberOfSectorAntennas", numberOfSectorAntennas);
    }

    private int createEqcRo(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, " createEqcRo() ");
        EqcCreateSectorRspS cfmSig = eqcSectorProxy.createSector(this.getTxIdTransactional(context), 0);
        return (int)cfmSig.sectorFroId;
    }

    private int createLrsRo(int sectorFroId, int maxInternalUlGainOn, int mixedModeRadio, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, " createLrsRo() ");
        LrsCreateRfapRspS cfmSig = lrsRfapProxy.createRfap(this.getTxIdTransactional(context), 0, sectorFroId, maxInternalUlGainOn, mixedModeRadio, this.getRelativeDistinguishedName());
        return cfmSig.rfAccessPointFroId;
    }

    private static void checkStringAttrLength(AttrList attributes, String attrName, int length) throws ValueOutOfRangeException {
        int index = attributes.indexOf(attrName);
        if (index >= 0) {
            try {
                String strValue = (String)attributes.getValue(index);
                if (strValue == null || strValue.length() != length) {
                    throw new ValueOutOfRangeException(attrName, "Sector");
                }
            }
            catch (ValueOutOfRangeException e) {
            }
            catch (NotHandledAttributeTypeException e) {
            }
            catch (MoNotFoundException e) {
                // empty catch block
            }
        }
    }

    private int getLrsAttribute(String attributeName, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "getLrsAttribute(" + attributeName + ")");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        int rfAccessPointFroId = this.getRfAccessPointFroId(context);
        int transId = this.getTxIdNonTransactional(context);
        if (attributeName.equals("band")) {
            try {
                LrsInitSectorGetParamRspS rspSig = lrsRfapProxy.initSectorGetParam(transId, 0, rfAccessPointFroId);
                return rspSig.band;
            }
            catch (MoAccessException anyException) {
                throw new AttrNotReadableException((ManagedObject)this, attributeName);
            }
        }
        LrsSectorGetParamRspS rspSig = lrsRfapProxy.sectorGetParam(transId, 0, rfAccessPointFroId);
        if (attributeName.equals("operationalState")) {
            return rspSig.operationalState;
        }
        if (attributeName.equals("availabilityStatus")) {
            return rspSig.availStatus;
        }
        if (attributeName.equals("proceduralStatus")) {
            return this.proceduralStatusBinToDecimal(rspSig.proceduralStatus);
        }
        if (attributeName.equals("maxInternalUlGainOn")) {
            return rspSig.maxInternalUlGainOn;
        }
        if (attributeName.equals("mixedModeRadio")) {
            return rspSig.mixedModeRadio;
        }
        throw new SoftwareErrorException();
    }

    private int getEcAttribute(String attributeName, Coordinator context) throws MoAccessException, ServiceNotPublishedException, NoSuchAttributeException {
        MessageLog.traceEnter(THIS_CLASS, "getEcAttribute(" + attributeName + ")");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        EcSectorGetParamRspS rspSig = eqcSectorProxy.sectorGetParam(this.getTxIdNonTransactional(context), 0, this.getSectorFroId(context));
        if (attributeName.equals("numberOfTxBranches")) {
            return rspSig.noOfTxBranches;
        }
        if (attributeName.equals("radioBuildingBlock")) {
            return (int)rspSig.radioBuildingBlock;
        }
        if (attributeName.equals("lineRate")) {
            return (int)rspSig.lineRate;
        }
        if (attributeName.equals("sectorId")) {
            return (int)rspSig.sectorId;
        }
        if (attributeName.equals("sectorGroup")) {
            return rspSig.sectorGroup;
        }
        String msg1 = "Unknown attribute, EcSectorGetParamRspS." + attributeName;
        throw new NoSuchAttributeException(msg1, "Sector");
    }

    private void resendDcvoltageToEc(Coordinator context) throws MoAccessException {
        ManagedObject[] sectorAntennas = this.getSectorAntennasRef(context);
        MessageLog.traceEnter(THIS_CLASS, "resendDcvoltageToEc()");
        for (int i = 0; i < sectorAntennas.length; ++i) {
            ManagedObject extTmaRef = BoamHelper.getFirstMatchingMo(sectorAntennas[i], "ExternalTma");
            if (extTmaRef == null) continue;
            MessageLog.trace(2, THIS_CLASS, " ExternalTma MO has been found.");
            int valueRealDcvoltageFromEc = ((ExternalTmaMoImpl)extTmaRef).getRealDcVoltageFromEc(context);
            if (valueRealDcvoltageFromEc != 0) continue;
            int valueDcvoltageToEc = 0;
            MessageLog.trace(2, THIS_CLASS, "Resend the dcvoltage");
            ((ExternalTmaMoImpl)extTmaRef).setRealDcVoltageToEc(valueDcvoltageToEc, context, false);
        }
    }

    private int findTmaProperties(Coordinator context) throws MoAccessException {
        ManagedObject[] sectorAntennas = this.getSectorAntennasRef(context);
        MessageLog.traceEnter(THIS_CLASS, "findTmaProperties() for  Sector:" + this.getFullDistinguishedName());
        for (int i = 0; i < sectorAntennas.length; ++i) {
            MessageLog.trace(2, THIS_CLASS, "investigating SectorAntenna: " + sectorAntennas[i]);
            if (BoamHelper.getFirstMatchingMo(sectorAntennas[i], "AscDeviceGroup") != null || BoamHelper.getMatchingMo(sectorAntennas[i], "DeviceGroup", "ASC") != null) {
                MessageLog.trace(2, THIS_CLASS, " AscDeviceGroup MO has been found.)");
                return 1;
            }
            if (((SectorAntennaMo)sectorAntennas[i]).hasAtmauDevice()) {
                MessageLog.trace(2, THIS_CLASS, " AtmauDevice MO has been found. ");
                if (BoamHelper.findMOs("ExternalTma", sectorAntennas[i], 1).hasMoreElements()) {
                    return 5;
                }
                return 4;
            }
            if (((SectorAntennaMo)sectorAntennas[i]).hasTmfDevice()) {
                MessageLog.trace(2, THIS_CLASS, " Tmf Device MO has been found. ");
                return 6;
            }
            ManagedObject extTmaRef = BoamHelper.getFirstMatchingMo(sectorAntennas[i], "ExternalTma");
            if (extTmaRef == null) continue;
            MessageLog.trace(2, THIS_CLASS, " ExternalTma MO has been found.");
            int internalPower = ((ExternalTmaMo)extTmaRef).getInternalPower(context);
            if (internalPower == 1) {
                MessageLog.trace(2, THIS_CLASS, " ExternalTma MO is internally (DC) powered.");
                return 3;
            }
            return 2;
        }
        return 0;
    }

    private int[] getSectorConfigurationInternal(Coordinator context) throws MoAccessException, ServiceNotPublishedException, NoSuchAttributeException {
        MessageLog.traceEnter(THIS_CLASS, "getSectorConfigurationInternal()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        EcSectorGetParamRspS rspSig = eqcSectorProxy.sectorGetParam(this.getTxIdNonTransactional(context), 0, this.getSectorFroId(context));
        return rspSig.configuration;
    }

    public int getSectorConfigurationType(Coordinator context) throws MoAccessException, ServiceNotPublishedException, NoSuchAttributeException {
        int type = this.getSectorConfigurationInternal(context)[0];
        if (1 == type) {
            int num = this.bcmGetIntAttribute("numberOfSectorAntennas", context);
            if (2 == num) {
                return 98;
            }
            if (3 == num) {
                return 99;
            }
        }
        return type;
    }

    private void reserveRetDevice(int noOfRetDev, int[] retDeviceFroId, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "reserveRetDevice()");
        SequenceAttribute deviceRefAttr = (SequenceAttribute)this.myData.getAttribute("retDevicesRef");
        ReferenceAttribute[] refs = new ReferenceAttribute[noOfRetDev];
        for (int i = 0; i < noOfRetDev; ++i) {
            Reservable dev = (Reservable)this.findSectorDevices("RetDevice", retDeviceFroId[i], context);
            dev.reserve((ManagedObject)this, context);
            ReferenceAttribute moRefAttr = new ReferenceAttribute("RetDevice", false);
            moRefAttr.setValue((ManagedObject)dev);
            refs[i] = moRefAttr;
        }
        deviceRefAttr.setValue((Attribute[])refs);
        this.sendAVC("retDevicesRef", this.getRetDevicesRef(context), context);
    }

    private void reserveTmaDevices(int noOfTmaDev, LrsRfapDeviceS[] reservedFroIds, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "reserveTmaDevices()");
        SequenceAttribute deviceRefAttr = (SequenceAttribute)this.myData.getAttribute("tmaDeviceRef");
        ReferenceAttribute[] refs = new ReferenceAttribute[noOfTmaDev];
        for (int i = 0; i < noOfTmaDev; ++i) {
            Reservable dev = (Reservable)this.findSectorDevices("TmaDevice", reservedFroIds[i].deviceFroId, context);
            dev.reserve((ManagedObject)this, context);
            ReferenceAttribute moRefAttr = new ReferenceAttribute("TmaDevice", false);
            moRefAttr.setValue((ManagedObject)dev);
            refs[i] = moRefAttr;
        }
        deviceRefAttr.setValue((Attribute[])refs);
        this.sendAVC("tmaDeviceRef", this.getTmaDeviceRef(context), context);
    }

    private MaoHasFro findSectorDevices(String moTypeName, int devFroId, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "findSectorDevices()");
        ManagedObject[] sectorAntennas = this.getSectorAntennasRef(null);
        for (int i = 0; i < sectorAntennas.length; ++i) {
            MaoHasFro dev;
            MoIterator moIter = MoRepository.instance().select(sectorAntennas[i], 4, (MoFilter)new MoTypeFilter(moTypeName));
            while (moIter.hasMoreElements()) {
                dev = (MaoHasFro)moIter.nextMo();
                if (dev.getFroId(context) != devFroId) continue;
                return dev;
            }
            if (!moTypeName.equals("RetDevice") || (dev = this.findExternalAntennaDevices(devFroId, context)) == null) continue;
            return dev;
        }
        MessageLog.traceError(THIS_CLASS, " Cannot find " + moTypeName + " with froId:" + devFroId);
        throw new MoNotFoundException(moTypeName);
    }

    private MaoHasFro findExternalAntennaDevices(int devFroId, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "findExternalAntennaDevices()");
        ManagedObject[] externalAntennaRefList = this.getReservedBy(context);
        if (externalAntennaRefList != null && externalAntennaRefList.length > 0) {
            for (int i = 0; i < externalAntennaRefList.length; ++i) {
                if (!(externalAntennaRefList[i] instanceof ExternalAntennaMo)) continue;
                MoIterator ExternalAntennaMoIter = MoRepository.instance().select((ManagedObject)((ExternalAntennaMo)externalAntennaRefList[i]), 4, (MoFilter)new MoTypeFilter("RetDevice"));
                while (ExternalAntennaMoIter.hasMoreElements()) {
                    MaoHasFro dev = (MaoHasFro)ExternalAntennaMoIter.nextMo();
                    if (dev.getFroId(context) != devFroId) continue;
                    return dev;
                }
            }
        }
        return null;
    }

    private boolean hasRet(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "hasRet");
        ManagedObject[] sectorAntennas = this.getSectorAntennasRef(context);
        for (int i = 0; i < sectorAntennas.length; ++i) {
            MoIterator sectorAntennaMoIter = MoRepository.instance().select(sectorAntennas[i], 4, (MoFilter)new MoTypeFilter("RetDevice"));
            ExternalAntennaMo ExternalAntennaRef = (ExternalAntennaMo)this.getExternalAntennaRef(context);
            MoIterator externalAntennaMoIter = null;
            if (ExternalAntennaRef != null) {
                externalAntennaMoIter = MoRepository.instance().select((ManagedObject)ExternalAntennaRef, 4, (MoFilter)new MoTypeFilter("RetDevice"));
            }
            if (sectorAntennaMoIter.size() > 0) {
                MessageLog.trace(2, THIS_CLASS, " RetDevice MO has been found ");
                return true;
            }
            if (externalAntennaMoIter == null || externalAntennaMoIter.size() <= 0) continue;
            MessageLog.trace(2, THIS_CLASS, " RetDevice MO has been found ");
            return true;
        }
        MessageLog.trace(2, THIS_CLASS, " RetDevice MO not found ");
        return false;
    }

    public boolean getMaxInternalUlGainOn(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "getMaxInternalUlGainOn()");
        return EnumConverter.rbsBooleanTConverter(this.getLrsAttribute("maxInternalUlGainOn", c));
    }

    public void setMaxInternalUlGainOn(boolean value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "setMaxInternalUlGainOn()");
        SectorMoImpl.checkTransaction(c);
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        lrsRfapProxy.rfapSetSetMaxUlGain(this.getTxIdTransactional(c), 0, this.getRfAccessPointFroId(c), EnumConverter.rbsBooleanTConverter(value));
        this.sendAVC("maxInternalUlGainOn", value, c);
    }

    private void addObservers(int froType, Coordinator context) throws MoAccessException {
        this.myMoAlarms = new MoAlarms((ManagedObject)this, lrsRfapProxy, froType, this.getRfAccessPointFroId(context), context);
    }

    private void removeObservers(Coordinator context) throws MoAccessException {
        this.myMoAlarms.delete(context);
    }

    public int getFroId(Coordinator c) {
        MessageLog.traceEnter(THIS_CLASS, "getFroId() ");
        try {
            return this.getSectorFroId(c);
        }
        catch (MoAccessException e) {
            MessageLog.traceError(THIS_CLASS, "Can't find froId", e);
            return -1;
        }
    }

    public int getBand(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "getBand()<---");
        return this.getLrsAttribute("band", c);
    }

    private int proceduralStatusBinToDecimal(int bitValue) {
        MessageLog.traceEnter(THIS_CLASS, "proceduralStatusBitToInt()<---");
        MessageLog.traceParam(THIS_CLASS, "bitValue received is" + bitValue);
        String binaryString = bitValue + "";
        int decimal = 0;
        int power2 = 1;
        int len = binaryString.length();
        for (int i = 0; i < len; ++i) {
            int bit = bitValue % 10;
            decimal += bit * power2;
            bitValue /= 10;
            power2 *= 2;
        }
        if (decimal == 0 || decimal == 1 || decimal == 2 || decimal == 8 || decimal == 16 || decimal == 4) {
            return decimal;
        }
        MessageLog.traceError(THIS_CLASS, "proceduralStatus is none of the possible values");
        return -1;
    }

    private void setSectorParam(String sectorId, int radioBuildingBlock, int lineRate, int sectorFroId, int sectorGroup, int[] configuration, int noiseFigure, Coordinator context) throws MoAccessException {
        int sectorIdAsInt;
        try {
            sectorIdAsInt = Integer.parseInt(sectorId);
        }
        catch (Exception e) {
            MessageLog.trace(2, THIS_CLASS, "Non-integer sectorId: will show as -1");
            sectorIdAsInt = -1;
        }
        int[] tmpValue = new int[10];
        int noOfConfiguration = 0;
        for (int i = 0; i < configuration.length && i < 10; ++i) {
            tmpValue[i] = configuration[i];
            if (configuration[i] == 0) continue;
            ++noOfConfiguration;
        }
        if (noOfConfiguration < 1) {
            noOfConfiguration = 1;
        }
        eqcSectorProxy.setSectorParam(this.getTxIdTransactional(context), 0, sectorFroId, sectorIdAsInt, radioBuildingBlock, lineRate, sectorGroup, noOfConfiguration, tmpValue, noiseFigure);
    }

    public int getNumberOfSectorAntennas(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "getNumberOfSectorAntennas() ");
        this.myData.handleTransaction(c, MoData.READ_ACCESS);
        return this.bcmGetIntAttribute("numberOfSectorAntennas", c);
    }

    public int getRadioBuildingBlock(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "getRadioBuildingBlock()");
        return this.getEcAttribute("radioBuildingBlock", c);
    }

    public ManagedObject[] getRetDevicesRef(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "getRetDevicesRef() ");
        this.myData.handleTransaction(c, MoData.READ_ACCESS);
        return this.bcmGetMoRefSequenceAttribute("retDevicesRef", c);
    }

    public ManagedObject[] getSectorAntennasRef(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "getSectorAntennasRef() ");
        this.myData.handleTransaction(c, MoData.READ_ACCESS);
        return this.bcmGetMoRefSequenceAttribute("sectorAntennasRef", c);
    }

    private void updateSectorAntennasRef(Coordinator c) throws ValueOutOfRangeException, MoAccessException {
        MoIterator moIter;
        MessageLog.traceEnter(THIS_CLASS, "updateSectorAntennasRef() ");
        ArrayList<SectorAntennaMo> sectorAntennas = new ArrayList<SectorAntennaMo>();
        MoIterator iter = moIter = BoamHelper.findMOs("SectorAntenna", 2);
        block0: while (iter.hasMoreElements()) {
            SectorAntennaMo sectorAntenna = (SectorAntennaMo)iter.nextMo();
            ManagedObject[] reservers = sectorAntenna.getReservedBy(c);
            for (int i = 0; i < reservers.length; ++i) {
                if (!reservers[i].equals(this) || sectorAntennas.contains(sectorAntenna)) continue;
                sectorAntennas.add(sectorAntenna);
                continue block0;
            }
        }
        MessageLog.trace(2, this.getClass(), "Found " + sectorAntennas.size() + " sectorAntennas to set");
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        Attribute[] sectorAntennaAttributes = new Attribute[sectorAntennas.size()];
        for (int i = 0; i < sectorAntennas.size(); ++i) {
            ReferenceAttribute ref = new ReferenceAttribute("SectorAntenna", false);
            ref.setValue((ManagedObject)sectorAntennas.get(i));
            sectorAntennaAttributes[i] = ref;
        }
        this.bcmSetSequenceAttribute("sectorAntennasRef", sectorAntennaAttributes, 3, "Sector", c);
    }

    public void setNumberOfSectorAntennas(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "setNumberOfSectorAntennas()");
        SectorMoImpl.checkTransaction(c);
        if (this.isSectorInitialized(c)) {
            throw new ConfigurationNotSupportedException("It is not possible to set numberOfSectorAntennas when sector is initialized");
        }
        int currentNumberOfSectorAntennas = this.getNumberOfSectorAntennas(c);
        if (currentNumberOfSectorAntennas == value) {
            return;
        }
        ValidateAttributes.intValueRangeCheck("numberOfSectorAntennas", value, NUMBER_OF_SECTOR_ANTENNAS_MIN_VALUES, NUMBER_OF_SECTOR_ANTENNAS_MAX_VALUES, "Sector");
        if (value - currentNumberOfSectorAntennas > 0) {
            if (currentNumberOfSectorAntennas == 2 && value == 3) {
                throw new ConfigurationNotSupportedException("It is not possible to change numberOfSectorAntennas from 2 to 3");
            }
            this.createSectorAntennas(value - currentNumberOfSectorAntennas, this.getFroId(c), this.getNamingAttributeValue(), null, c);
        } else {
            if (currentNumberOfSectorAntennas == 3 && value == 2) {
                throw new ConfigurationNotSupportedException("It is not possible to change numberOfSectorAntennas from 3 to 2");
            }
            this.deleteSectorAntennas(currentNumberOfSectorAntennas - value, c);
        }
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        this.bcmSetIntAttribute("numberOfSectorAntennas", value, NUMBER_OF_SECTOR_ANTENNAS_MIN_VALUES, NUMBER_OF_SECTOR_ANTENNAS_MAX_VALUES, "Sector", c);
        this.updateSectorAntennasRef(c);
        this.sendAVC("numberOfSectorAntennas", value);
    }

    public void setRadioBuildingBlock(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "setRadioBuildingBlock()");
        SectorMoImpl.checkTransaction(c);
        if (this.isSectorInitialized(c)) {
            throw new ConfigurationNotSupportedException("It is not possible to set radioBuildingBlock when sector is initialized");
        }
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        ValidateAttributes.intValueRangeCheck("radioBuildingBlock", value, 0, 33, "Sector");
        value = this.convertRadioBuildingBlock(value);
        this.setSectorParam(this.bcmGetIdentity(this.getLocalDistinguishedName(), c), value, this.getLineRate(c), this.getFroId(c), this.getSectorGroup(c), this.getSectorConfigurationInternal(c), this.getNoiseFigure(c), c);
        this.setSysConstantInhibitOptimalPaBiasLevel(c, false);
        this.sendAVC("radioBuildingBlock", value, c);
    }

    public int getLineRate(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "getLineRate()");
        return this.getEcAttribute("lineRate", c);
    }

    public void setLineRate(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "setLineRate()");
        if (this.isSectorInitialized(c)) {
            throw new ConfigurationNotSupportedException("It is not possible to set lineRate when sector is initialized");
        }
        ValidateAttributes.intValueRangeCheck("lineRate", value, 0, 2, "Sector");
        this.setSectorParam(this.bcmGetIdentity(this.getLocalDistinguishedName(), c), this.getRadioBuildingBlock(c), value, this.getFroId(c), this.getSectorGroup(c), this.getSectorConfigurationInternal(c), this.getNoiseFigure(c), c);
        this.sendAVC("lineRate", value, c);
    }

    public int getSectorGroup(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "getSectorGroup()");
        return this.getEcAttribute("sectorGroup", c);
    }

    public void setSectorGroup(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "setSectorGroup()");
        if (this.isSectorInitialized(c)) {
            throw new ConfigurationNotSupportedException("It is not possible to set sectorGroup when sector is initialized");
        }
        ValidateAttributes.intValueRangeCheck("sectorGroup", value, SECTOR_GROUP_MIN_VALUES, SECTOR_GROUP_MAX_VALUES, "Sector");
        this.setSectorParam(this.bcmGetIdentity(this.getLocalDistinguishedName(), c), this.getRadioBuildingBlock(c), this.getLineRate(c), this.getFroId(c), value, this.getSectorConfigurationInternal(c), this.getNoiseFigure(c), c);
        this.sendAVC("sectorGroup", value, c);
    }

    public boolean getMixedModeRadio(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "getMixedModeRadio()");
        return EnumConverter.rbsBooleanTConverter(this.getLrsAttribute("mixedModeRadio", c));
    }

    public void setMixedModeRadio(boolean value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "setMixedModeRadio()");
        if (this.isSectorInitialized(c)) {
            throw new ConfigurationNotSupportedException("It is not possible to set mixedModeRadio when sector is initialized");
        }
        SectorMoImpl.checkTransaction(c);
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        lrsRfapProxy.rfapSetMixedModeRadio(this.getTxIdTransactional(c), 0, this.getRfAccessPointFroId(c), EnumConverter.rbsBooleanTConverter(value));
        this.sendAVC("mixedModeRadio", value, c);
    }

    private int convertRadioBuildingBlock(int radioBuildingBlock) {
        if (radioBuildingBlock == 9) {
            return 1;
        }
        if (radioBuildingBlock == 13) {
            return 8;
        }
        if (radioBuildingBlock == 10) {
            return 16;
        }
        if (radioBuildingBlock == 14) {
            return 17;
        }
        return radioBuildingBlock;
    }

    private void setSysConstantInhibitOptimalPaBiasLevel(Coordinator c, boolean isDelete) throws MoAccessException {
        String sysConstant;
        MessageLog.traceEnter(THIS_CLASS, "setSysConstantInhibitOptimalPaBiasLevel()");
        boolean inhibitOptimalPaBiasLevel = false;
        boolean inhibitOptimalPaBiasLevel_old = false;
        MoIterator sectorMoIter = BoamHelper.findMOs("Sector");
        SystemConstantsMo sysConsMo = (SystemConstantsMo)BoamHelper.getFirstMatchingMo("SystemConstants");
        if (sysConsMo == null) {
            MessageLog.info(this.getClass(), "Ignoreing update the system constant inhibitOptimalPaBiasLevel, the MO SystemConstants=1 does not exist");
            return;
        }
        int numberOfSector = 0;
        if (sectorMoIter != null) {
            numberOfSector = sectorMoIter.size();
        }
        for (int i = 0; i < numberOfSector; ++i) {
            SectorMo aSector = (SectorMo)sectorMoIter.nextMo();
            if (isDelete && aSector.equals(this) || !aSector.getMixedModeRadio(c)) continue;
            inhibitOptimalPaBiasLevel = true;
            break;
        }
        if ((sysConstant = sysConsMo.getSysConstantValue(c, SYSTEMCONSTANT_INHIBIT_OPTIMAL_PA_BIAS_LEVEL_NUMBER)) == null) {
            sysConstant = sysConsMo.getSysConstantValue(c, SYSTEMCONSTANT_INHIBIT_OPTIMAL_PA_BIAS_LEVEL_NAME);
        }
        if (sysConstant == null) {
            inhibitOptimalPaBiasLevel_old = !inhibitOptimalPaBiasLevel;
        } else if (sysConstant.equals(TRUE)) {
            inhibitOptimalPaBiasLevel_old = true;
        } else if (sysConstant.equals(FALSE)) {
            inhibitOptimalPaBiasLevel_old = false;
        } else {
            boolean bl = inhibitOptimalPaBiasLevel_old = !inhibitOptimalPaBiasLevel;
        }
        if (inhibitOptimalPaBiasLevel != inhibitOptimalPaBiasLevel_old) {
            String value = inhibitOptimalPaBiasLevel ? TRUE : FALSE;
            sysConsMo.actionWriteConst(SYSTEMCONSTANT_INHIBIT_OPTIMAL_PA_BIAS_LEVEL_NUMBER, value, c);
        }
    }

    private int getNumberOfRxBranches(Coordinator context) throws MoAccessException {
        MoIterator carrierIterator = BoamHelper.findMOs("Carrier", this, 1);
        int numberOfRxBranches = -1;
        int loopCount = 0;
        MoIterator iter = carrierIterator;
        while (iter.hasMoreElements()) {
            CarrierMo carrier = (CarrierMo)iter.nextMo();
            int newNumberOfRxBranches = carrier.getNumberOfRxBranches(context);
            if (newNumberOfRxBranches != numberOfRxBranches && loopCount != 0) {
                throw new ConfigNotSupportedException("Inconsistency in numberOfRxBranches within the carriers of the sector");
            }
            numberOfRxBranches = newNumberOfRxBranches;
            ++loopCount;
        }
        return numberOfRxBranches;
    }

    private ManagedObject[] getChildlessSectorAntennas(Coordinator context) throws MoAccessException {
        ManagedObject[] sectorAntennas = this.getSectorAntennasRef(context);
        ArrayList<ManagedObject> result2 = new ArrayList<ManagedObject>();
        for (int i = 0; i < sectorAntennas.length; ++i) {
            if (sectorAntennas[i].getChildren().size() != 0) continue;
            result2.add(sectorAntennas[i]);
        }
        ManagedObject[] childlessSectorAntennas = result2.toArray(new ManagedObject[result2.size()]);
        Arrays.sort(childlessSectorAntennas, new SectorAntennaMoComparator());
        return childlessSectorAntennas;
    }

    public int[] getSectorConfiguration(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "getSectorConfiguration()");
        int[] tmpValue = this.getSectorConfigurationInternal(c);
        if (0 == tmpValue[0]) {
            return new int[0];
        }
        return tmpValue;
    }

    public void setSectorConfiguration(int[] value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(THIS_CLASS, "setSectorConfiguration()");
        if (this.isSectorInitialized(c)) {
            throw new ConfigurationNotSupportedException("It is not possible to set SectorConfiguration when sector is initialized");
        }
        this.setSectorConfigurationWithoutInitCheck(value, c);
    }

    public void setSectorConfigurationWithoutInitCheck(int[] value, Coordinator c) throws MoAccessException {
        for (int i = 0; i < value.length; ++i) {
            ValidateAttributes.intValueRangeCheck("sectorConfiguration", value[i], 1, 3, "Sequence");
        }
        if (0 == value.length) {
            value = new int[]{0};
        }
        this.setSectorParam(this.bcmGetIdentity(this.getLocalDistinguishedName(), c), this.getRadioBuildingBlock(c), this.getLineRate(c), this.getFroId(c), this.getSectorGroup(c), value, this.getNoiseFigure(c), c);
        this.sendAVC("sectorConfiguration", value, c);
    }

    public boolean checkSectorStatusOk(Coordinator c) throws MoAccessException {
        return 1 == this.getOperationalState(c) && this.isSectorInitialized(c);
    }

    private void checkInitSectorPreconditions(CarrierMo[] carriers, int numberOfTxBranches, int numberOfRxBranches, int txDiversity, Coordinator c) throws MoAccessException {
        if (this.isSectorInitialized(c)) {
            String msg = "Initiation of the Sector is not required.";
            MessageLog.trace(2, THIS_CLASS, msg);
            throw new AlreadyInitiatedException();
        }
        SectorHelper.checkAntennaBranchPreconditionOnInitSector(this, c);
        SectorHelper.checkCarrierPreconditionOnInitSector(carriers, numberOfTxBranches, c);
        int type = this.getSectorConfigurationInternal(c)[0];
        for (int i = 0; i < carriers.length; ++i) {
            int currentNumberOfRxBranches = carriers[i].getNumberOfRxBranches(c);
            SectorHelper.checkSectorAntennasPrecondition(this, currentNumberOfRxBranches, c);
            if (1 != type || currentNumberOfRxBranches == 0 || currentNumberOfRxBranches == this.getNumberOfSectorAntennas(c) * 2) continue;
            throw new ConfigurationNotSupportedException("Rx branch of all carriers should have the same non-zero value of 4 or 6.");
        }
        SectorHelper.checkRBBPreconditionOnInitSector(this, numberOfTxBranches, numberOfRxBranches, c);
        SectorHelper.checkTxDivPreconditionOnInitSector(numberOfTxBranches, txDiversity);
    }

    private int getFrequencyPlanes(CarrierMo[] carriers, Coordinator c) throws MoAccessException {
        int frequencyPlanes = 0;
        for (int i = 0; i < carriers.length; ++i) {
            if (carriers[i] != null) {
                frequencyPlanes |= 1 << carriers[i].getFrequencyPlane(c) - 1;
                continue;
            }
            throw new ConfigurationNotSupportedException("Cannot get Carrier since it is null");
        }
        return frequencyPlanes;
    }

    private static int[] checkSectorConfiguration(AttrList attributes, String attrName, String attrType, int[] defaultValues, int minValue, int maxValue, int defaultSize, String thisTypeName) throws ValueOutOfRangeException, MoNotFoundException, NotHandledAttributeTypeException, AttrMissingAtCreateException, WrongAttributeTypeException, InternalErrorException, SoftwareErrorException {
        int index = attributes.indexOf(attrName);
        if (index == -1) {
            if (attrType.equalsIgnoreCase("mandatory")) {
                throw new AttrMissingAtCreateException(attrName, thisTypeName);
            }
            if (attrType.equalsIgnoreCase("optional")) {
                return new int[]{0};
            }
            throw new SoftwareErrorException();
        }
        if (!(attributes.getValue(index) instanceof int[])) {
            throw new WrongAttributeTypeException(attrName, thisTypeName);
        }
        int[] result2 = (int[])attributes.getValue(index);
        if (result2.length > defaultSize) {
            throw new ValueOutOfRangeException(attrName, thisTypeName);
        }
        for (int i = 0; i < result2.length; ++i) {
            ValidateAttributes.intValueRangeCheck(attrName, result2[i], minValue, maxValue, thisTypeName);
        }
        attributes.removeElementAt(index);
        return result2;
    }

    public int getNoiseFigure(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getNoiseFigure()");
        return SectorMoImpl.eqcSectorProxy.sectorGetParam((int)this.getTxIdNonTransactional((Coordinator)c), (int)0, (int)this.getSectorFroId((Coordinator)c)).noiseFigure;
    }

    public void setNoiseFigure(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "setNoiseFigure()");
        ValidateAttributes.intValueRangeCheck("noiseFigure", value, NOISE_FIGURE_MIN_VALUES, NOISE_FIGURE_MAX_VALUES, "Sector");
        this.setSectorParam(this.bcmGetIdentity(this.getLocalDistinguishedName(), c), this.getRadioBuildingBlock(c), this.getLineRate(c), this.getFroId(c), this.getSectorGroup(c), this.getSectorConfiguration(c), value, c);
        this.sendAVC("noiseFigure", value, c);
    }

    public String getFqBands(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getFqBands()");
        this.myData.handleTransaction(c, MoData.READ_ACCESS);
        return SectorMoImpl.lrsRfapProxy.initSectorGetParam((int)this.getTxIdNonTransactional((Coordinator)c), (int)0, (int)this.getRfAccessPointFroId((Coordinator)c)).fqBands;
    }

    public void actionInitMultiBandSector(int numberOfTxBranches, Coordinator c) throws MoAccessException, AlreadyInitiatedException, ConfigurationNotSupportedException, ResourcesNotAvailableException, ResourceLockedException, BandAndFrequencyMismatchException, HsdpaCodeResourceMismatchException {
        MessageLog.traceEnter(THIS_CLASS, "actionInitMultiBandSector()");
        ValidateAttributes.checkTransaction(c);
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        ValidateAttributes.intValueRangeCheck("numberOfTxBranches", numberOfTxBranches, 1, 4, "Sector");
        CarrierMo[] carriers = SectorHelper.getCarriers(this);
        if (carriers.length == 0 || carriers[0] == null) {
            throw new ConfigurationNotSupportedException("No Carriers can be found under this Sector");
        }
        int txDiversity = carriers[0].getNumberOfTxBranches(c) - 1;
        int numberOfRxBranches = carriers[0].getNumberOfRxBranches(c);
        int frequencyPlanes = this.getFrequencyPlanes(carriers, c);
        this.checkInitSectorPreconditions(carriers, numberOfTxBranches, numberOfRxBranches, txDiversity, c);
        int tmaProperties = this.findTmaProperties(c);
        int withTma = tmaProperties == 5 ? 2 : (tmaProperties != 0 ? 1 : 0);
        int withRet = this.hasRet(c) ? 1 : 0;
        this.initEqcRo(frequencyPlanes, numberOfTxBranches, withTma, withRet, txDiversity, c);
        try {
            LrsInitRfapRspS initRfapRsp = this.initLrsRo(tmaProperties, c);
            if (initRfapRsp.noOfTmaDev > 0) {
                this.reserveTmaDevices(initRfapRsp.noOfTmaDev, initRfapRsp.tma, c);
            }
            if (initRfapRsp.noOfRetDev > 0) {
                this.reserveRetDevice(initRfapRsp.noOfRetDev, initRfapRsp.retDevFroId, c);
            }
            for (int i = 0; i < carriers.length; ++i) {
                carriers[i].sectorInitiated(initRfapRsp.noOfDpclDev, initRfapRsp.dpcl, initRfapRsp.noOfTpaDev, initRfapRsp.tpa, initRfapRsp.noOfAiDev, initRfapRsp.ai, initRfapRsp.noOfDbccDev, initRfapRsp.dbcc, initRfapRsp.noOfTrDev, initRfapRsp.tr, c);
            }
            MessageLog.trace(1, THIS_CLASS, "actionInitMultiBandSector OK");
        }
        catch (MoAccessException e) {
            try {
                c.rollbackOnly();
            }
            catch (InactiveTransactionException e2) {
                // empty catch block
            }
            throw e;
        }
        SectorHelper.checkSumHsNumCodeResourcesInAllTxDeviceGroup(c);
        if (this.isSectorInitialized(c)) {
            this.sendAVC("proceduralStatus", 0, c);
            this.resendDcvoltageToEc(c);
        }
    }

    private static class SectorAntennaMoComparator
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = 1599671320688067440L;

        private SectorAntennaMoComparator() {
        }

        public int compare(Object o1, Object o2) {
            String id1 = ((BoamManagedObject)((Object)o1)).getNamingAttributeValue();
            String id2 = ((BoamManagedObject)((Object)o2)).getNamingAttributeValue();
            try {
                id1 = id1.substring(id1.indexOf(45) + 1);
                id2 = id2.substring(id2.indexOf(45) + 1);
                int id1_i = Integer.parseInt(id1);
                int id2_i = Integer.parseInt(id2);
                if (id1_i > id2_i) {
                    return -1;
                }
                if (id1_i < id2_i) {
                    return 1;
                }
                return 0;
            }
            catch (RuntimeException e) {
                MessageLog.traceEnter(THIS_CLASS, "SectorAntenna Compare error: " + ((BoamManagedObject)((Object)o1)).getNamingAttributeValue() + "; " + ((BoamManagedObject)((Object)o2)).getNamingAttributeValue());
                return 0;
            }
        }
    }
}

