/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.rmo.channel;

import se.ericsson.cello.mao.IllegalAttributeValueException;
import se.ericsson.cello.moframework.AttrNotReadableException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.ResourceLockedException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.AvailabilityStatusIntToEnum;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcPrachProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsGetPrachParamRspS;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObject;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.AlreadyActiveException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.InternalErrorException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.MoDisabledException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.NotActiveException;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RachMo;

public class RachMoImpl
extends BoamManagedObject
implements RachMo {
    private static final int CLIENT_ID = 0;
    private static final String MEAS_TIME = "BlerMeasTime";
    private static int[] MEAS_TIME_POSSIBLE_VALUES = new int[]{1, 13, 39, 180, 300, 600};
    private MoData myData;
    private int rachFroId;
    private int prachFroId;
    private ChcPrachProxy chcPrachProxy = ChcPrachProxy.instance();

    private RachMoImpl(ManagedObject parent, int prachFroId, int rachFroId, String thisMoName, String identity) throws MoAccessException {
        super(parent, thisMoName, identity, null);
        MessageLog.traceEnter(this.getClass(), "Normal constructor");
        this.myData = new MoData(this.getLocalDistinguishedName(), this.getType(), false, null);
        this.prachFroId = prachFroId;
        this.rachFroId = rachFroId;
        MessageLog.trace(1, this.getClass(), "MO Created");
    }

    public static synchronized ManagedObject create(ManagedObject parent, int prachFroId, int rachFroId, String thisMoName, String identity) throws MoAccessException {
        MessageLog.traceEnter(RachMoImpl.class, "create()");
        return new RachMoImpl(parent, prachFroId, rachFroId, thisMoName, identity);
    }

    public void delete(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "delete()");
        throw new UndeletableMoException((ManagedObject)this);
    }

    public void deleteRach(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "deleteRach()");
        if (super.isReserved(context)) {
            MessageLog.trace(1, this.getClass(), " this Mo is reserved and can not be deleted ");
            throw new UndeletableMoException((ManagedObject)this);
        }
        super.delete(context);
    }

    public String getType() {
        return "Rach";
    }

    public String getRachId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getRachId()");
        return super.bcmGetIdentity(this.getLocalDistinguishedName(), context);
    }

    public int getOperationalState(Coordinator context) throws MoAccessException, TransactionRequiredException, ResourceLockedException {
        MessageLog.traceEnter(this.getClass(), "getOperationalState()");
        LrsGetPrachParamRspS rspSig = this.chcPrachProxy.getPrachParam(0, this.prachFroId);
        return rspSig.rachOpState;
    }

    public int getAvailabilityStatus(Coordinator context) throws MoAccessException, TransactionRequiredException, ResourceLockedException {
        MessageLog.traceEnter(this.getClass(), "getAvailabilityStatus()");
        LrsGetPrachParamRspS rspSig = this.chcPrachProxy.getPrachParam(0, this.prachFroId);
        return AvailabilityStatusIntToEnum.convGetAvailStatIntToEnum(rspSig.rachAvailStatus);
    }

    public int getBlerMeasTime(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getBlerMeasTime()");
        LrsGetPrachParamRspS rspSigParam = this.chcPrachProxy.getPrachParam(0, this.prachFroId);
        if (rspSigParam.rachBlerIsActive == 1) {
            return rspSigParam.rachBlerMeasTime;
        }
        if (rspSigParam.rachBlerIsActive == 0) {
            return 0;
        }
        throw new IllegalAttributeValueException("Illegal value for LrsGetPrachParamRspS.rachBlerIsActive: " + rspSigParam.rachBlerIsActive, "Rach");
    }

    public int getBlerIsActive(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getBlerIsActive()");
        LrsGetPrachParamRspS rspSigParam = this.chcPrachProxy.getPrachParam(0, this.prachFroId);
        return rspSigParam.rachBlerIsActive;
    }

    public String getFileName(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getFileName()");
        LrsGetPrachParamRspS rspSigParam = this.chcPrachProxy.getPrachParam(0, this.prachFroId);
        MessageLog.trace(2, this.getClass(), "fName" + rspSigParam.rachBlerFilename);
        return rspSigParam.rachBlerFilename;
    }

    public void actionStartBler(int measTime, String fileName, Coordinator context) throws MoAccessException, ValueOutOfRangeException {
        MessageLog.traceEnter(this.getClass(), "actionStartBler()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        ValidateAttributes.intValueInSetCheck(MEAS_TIME, measTime, MEAS_TIME_POSSIBLE_VALUES, this.getClass().getName());
        try {
            this.chcPrachProxy.startBlerRach(0, this.prachFroId, measTime, fileName);
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 4) {
                throw new MoDisabledException();
            }
            if (e.getOrgErrorCode() == 2) {
                throw new AlreadyActiveException();
            }
            if (e.getOrgErrorCode() == 1) {
                throw new InternalErrorException();
            }
            throw e;
        }
    }

    public void actionStopBler(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "actionStopBler()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        try {
            this.chcPrachProxy.stopBlerRach(0, this.prachFroId);
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 1) {
                throw new InternalErrorException();
            }
            if (e.getOrgErrorCode() == 3) {
                throw new NotActiveException();
            }
            throw e;
        }
    }

    public Struct actionReadNbapData(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "actionReadNbapData()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        LrsGetPrachParamRspS rspSig = this.chcPrachProxy.getPrachParam(0, this.prachFroId);
        return this.convertSigToStruct(context, rspSig);
    }

    private Struct convertSigToStruct(Coordinator context, LrsGetPrachParamRspS rspSig) throws MoAccessException {
        String[] names = new String[5];
        Object[] values = new Object[5];
        names[0] = "trChId";
        names[1] = "codingMode";
        names[2] = "transTimeInt";
        names[3] = "crcSize";
        names[4] = "rateMatchingAttr";
        Integer rachTranspChId = new Integer(rspSig.rachTranspChId);
        Integer rachCodingMode = new Integer(rspSig.rachCodingMode);
        Integer rachTti = new Integer(rspSig.rachTti);
        Integer rachCrcSize = new Integer(rspSig.rachCrcSize);
        Integer rachRateMatchingAttr = new Integer(rspSig.rachRateMatchingAttr);
        values[0] = rachTranspChId;
        values[1] = rachCodingMode;
        values[2] = rachTti;
        values[3] = rachCrcSize;
        values[4] = rachRateMatchingAttr;
        if (rspSig.nbapIsValid == 1) {
            StructImpl status = new StructImpl(names, values);
            return status;
        }
        MessageLog.trace(2, this.getClass(), " Nbap data is not valid ");
        throw new AttrNotReadableException((ManagedObject)this, this.getType() + "DataNotValid");
    }

    public int getPrachFroId() {
        MessageLog.traceEnter(this.getClass(), "getPrachFroId()");
        return this.prachFroId;
    }

    public int getFroId(Coordinator c) {
        MessageLog.traceEnter(this.getClass(), "getFroId()");
        return this.rachFroId;
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData()");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(this.getClass(), "isMyMoDataPersistent()");
        return false;
    }
}

