/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.rmo.channel;

import java.util.ArrayList;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.moframework.AttrNotReadableException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.ResourceLockedException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.AvailabilityStatusIntToEnum;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcSccpchProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsGetSccpchParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsSccpchCreatedIndS;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObject;
import se.ericsson.wcdma.rbs.boam.mao.common.MaoHasFro;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.DbchDeviceSetMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.FachMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.MichMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.PchMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.PichMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.SccpchMo;
import se.ericsson.wcdma.rbs.boam.mao.rmo.cell.RbsLocalCellMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.rmo.channel.ChannelHelper;
import se.ericsson.wcdma.rbs.boam.mao.rmo.channel.FachMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.rmo.channel.MichMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.rmo.channel.PchMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.rmo.channel.PichMoImpl;
import se.ericsson.wcdma.rbs.boam.mao.rmo.channel.SccpchMoFactory;
import se.ericsson.wcdma.rbs.boam.pms.impl.MoScanner;
import se.ericsson.wcdma.rbs.boam.pms.impl.PmsException;

public class SccpchMoImpl
extends BoamManagedObject
implements SccpchMo {
    public static final String IDENTITY = "1";
    public static final String IDENTITY_WITH_FACH = "2";
    private static final String SCCPCH_FRO_ID = "sccpchFroId";
    private final MoData myData;
    private final IntegerAttribute sccpchFroIdAttr;
    private final ChcSccpchProxy chcSccpchProxy = ChcSccpchProxy.instance();
    private final MoScanner myScanner;
    private final DbchDeviceSetMo dbchDeviceSetRef;
    private final ManagedObject michMoRef;
    private final ManagedObject pichMoRef;

    private SccpchMoImpl(ManagedObject parent, LrsSccpchCreatedIndS indicationSig, String thisMoName, String identity) throws MoAccessException {
        super(parent, thisMoName, identity, null);
        MessageLog.traceEnter(this.getClass(), "Normal constructor");
        this.sccpchFroIdAttr = new IntegerAttribute(SCCPCH_FRO_ID, false, indicationSig.sccpchFroId);
        this.myData = this.initMoData(indicationSig.sccpchDevSetFroId, indicationSig.sccpchFroId, null);
        this.dbchDeviceSetRef = (DbchDeviceSetMo)ChannelHelper.resolveDeviceSetRefAndReserve(indicationSig.sccpchDevSetFroId, "DbchDeviceSet", this);
        this.myScanner = this.createMoScanner(indicationSig.sccpchFroId);
        if (indicationSig.michFroId <= -1) {
            this.michMoRef = null;
        } else {
            MoIterator mos = BoamHelper.findMOs("Mich", parent, 1);
            if (mos.size() > 0) {
                MessageLog.traceEnter(this.getClass(), "MichMo can't be created, Mo already exist!!. Parent: " + this.getLocalDistinguishedName());
                this.michMoRef = null;
            } else {
                this.michMoRef = MichMoImpl.create(parent, indicationSig);
            }
        }
        if (indicationSig.noOfPch != 1) {
            this.pichMoRef = null;
        } else {
            this.pichMoRef = PichMoImpl.create(parent, indicationSig.sccpchFroId, indicationSig.pichFroId, indicationSig.pichDevSetFroId, "Pich", IDENTITY);
            PchMoImpl.create(this, indicationSig.sccpchFroId, indicationSig.pchFroId, "Pch", IDENTITY);
        }
        for (int i = 0; i < indicationSig.noOfFach; ++i) {
            int fachFroId = i == 2 ? indicationSig.fachFroId3 : (i == 1 ? indicationSig.fachFroId2 : indicationSig.fachFroId1);
            String identityFach = Integer.toString(i + 1);
            FachMoImpl.create(this, indicationSig.sccpchFroId, fachFroId, "Fach", identityFach, i);
        }
        MessageLog.trace(1, this.getClass(), "MO Created");
    }

    private MoScanner createMoScanner(int sccpchFroId) {
        try {
            return new MoScanner(this, this.chcSccpchProxy, sccpchFroId, 0, SccpchMoFactory.instance().getCounters(), null, false, null);
        }
        catch (Exception pmse) {
            MessageLog.traceError(this.getClass(), "could not create MoScanner: " + pmse);
            return null;
        }
    }

    public static synchronized ManagedObject create(LrsSccpchCreatedIndS indicationSig) throws MoAccessException {
        MessageLog.traceEnter(SccpchMoImpl.class, "create() ");
        RbsLocalCellMoImpl cellMoRef = (RbsLocalCellMoImpl)SccpchMoImpl.getCellMoRef(indicationSig);
        String identity = Integer.toString(indicationSig.sccpchFroId);
        SccpchMoImpl sccpchMo = null;
        if (cellMoRef.isCombinedCell(null)) {
            sccpchMo = new SccpchMoImpl((ManagedObject)cellMoRef, indicationSig, "Sccpch", identity);
        } else {
            ManagedObject carrierMoRef = cellMoRef.getCarriersRef(null)[0];
            sccpchMo = new SccpchMoImpl(carrierMoRef, indicationSig, "Sccpch", identity);
        }
        return sccpchMo;
    }

    private static ManagedObject getCellMoRef(LrsSccpchCreatedIndS indicationSig) throws MoAccessException {
        MoIterator iter = BoamHelper.findMOs("RbsLocalCell");
        while (iter.hasMoreElements()) {
            ManagedObject mo = iter.nextMo();
            if (((MaoHasFro)mo).getFroId(null) != indicationSig.cellFroId) continue;
            return mo;
        }
        throw new MoNotFoundException("RbsLocalCell has not been created:" + indicationSig.cellFroId);
    }

    public void delete(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "delete()");
        throw new UndeletableMoException((ManagedObject)this);
    }

    public void deleteSccpch(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "deleteSccpch(): " + this);
        if (this.myScanner != null) {
            this.myScanner.delete(context);
        }
        this.deleteMyOwnCommonChannels(context);
        if (super.isReserved(context)) {
            MessageLog.trace(1, this.getClass(), " this Mo is reserved and can not be deleted ");
            throw new UndeletableMoException((ManagedObject)this);
        }
        ManagedObject dbchDevSetRef = this.getDbchDeviceSetRef(context);
        if (dbchDevSetRef != null) {
            ((Reservable)dbchDevSetRef).release((ManagedObject)this, context);
        }
        MessageLog.trace(1, this.getClass(), "relased dbchDeviceSet");
        super.delete(context);
    }

    public String getType() {
        return "Sccpch";
    }

    public int getOperationalState(Coordinator context) throws MoAccessException, TransactionRequiredException, ResourceLockedException {
        MessageLog.traceEnter(this.getClass(), "getOperationalState()");
        LrsGetSccpchParamRspS rspSig = this.chcSccpchProxy.getSccpchParam(0, this.sccpchFroIdAttr.getValue(context));
        return rspSig.sccpchOpState;
    }

    public int getAvailabilityStatus(Coordinator context) throws MoAccessException, TransactionRequiredException, ResourceLockedException {
        MessageLog.traceEnter(this.getClass(), "getAvailabilityStatus()");
        LrsGetSccpchParamRspS rspSig = this.chcSccpchProxy.getSccpchParam(0, this.sccpchFroIdAttr.getValue(context));
        return AvailabilityStatusIntToEnum.convGetAvailStatIntToEnum(rspSig.sccpchAvailStatus);
    }

    public int getTfciPresence(Coordinator context) throws MoAccessException, TransactionRequiredException, ResourceLockedException {
        MessageLog.traceEnter(this.getClass(), "getTfciPresence()");
        LrsGetSccpchParamRspS rspSig = this.chcSccpchProxy.getSccpchParam(0, this.sccpchFroIdAttr.getValue(context));
        return rspSig.tfciPresence;
    }

    public int getSccpchFroId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getSccpchFroId()");
        return this.bcmGetIntAttribute(SCCPCH_FRO_ID, context);
    }

    public ManagedObject getDbchDeviceSetRef(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getDbchDeviceSetRef()");
        return this.dbchDeviceSetRef;
    }

    public int getPnIsActive(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getPnIsActive()");
        LrsGetSccpchParamRspS rspSig = this.chcSccpchProxy.getSccpchParam(0, this.sccpchFroIdAttr.getValue(context));
        return rspSig.sccpchPnGenStatus;
    }

    public Struct actionReadNbapData(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "actionReadNbapData()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        LrsGetSccpchParamRspS rspSig = this.chcSccpchProxy.getSccpchParam(0, this.sccpchFroIdAttr.getValue(context));
        return this.convertSigToStruct(context, rspSig);
    }

    public void actionStartPn(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "actionStartPn()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        this.chcSccpchProxy.startPnGenSccpch(0, this.sccpchFroIdAttr.getValue(context));
    }

    public void actionStopPn(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "actionStopPn()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        this.chcSccpchProxy.stopPnGenSccpch(0, this.sccpchFroIdAttr.getValue(context));
    }

    private Struct convertSigToStruct(Coordinator context, LrsGetSccpchParamRspS rspSig) throws MoAccessException {
        if (rspSig.nbapIsValid == 1) {
            String[] names = new String[10];
            Object[] values = new Object[10];
            names[0] = "dlChannelisationCodeNo";
            names[1] = "dlScramblingCode";
            names[2] = "phChId";
            names[3] = "multiplexingPos";
            names[4] = "pilotBitsPowerOffset";
            names[5] = "sccpchOffset";
            names[6] = "sccpchSlotFormat";
            names[7] = "tfciPowerOffset";
            names[8] = "tfciPresence";
            names[9] = "sccpchFrameOffset";
            values[0] = new Integer(rspSig.sccpchDlChanCodeNo);
            values[1] = new Integer(rspSig.sccpchDlScrCodeIsValid == 1 ? rspSig.sccpchDlScramblingCode : 0);
            values[2] = new Integer(rspSig.sccpchPhysChId);
            values[3] = new Integer(rspSig.sccpchMultiplexingPos);
            values[4] = new Integer(rspSig.sccpchPilotBitsPowerOffset);
            values[5] = new Integer(rspSig.sccpchOffset);
            values[6] = new Integer(rspSig.sccpchSlotFormat);
            values[7] = new Integer(rspSig.sccpchTfciPowerOffset);
            values[8] = new Integer(rspSig.tfciPresence);
            values[9] = new Integer(rspSig.sccpchFrameOffset);
            StructImpl status = new StructImpl(names, values);
            return status;
        }
        throw new AttrNotReadableException((ManagedObject)this, this.getType() + "DataNotValid");
    }

    public int getFroId(Coordinator context) {
        MessageLog.traceEnter(this.getClass(), "getFroId()");
        return this.sccpchFroIdAttr.getValue(context);
    }

    private MoData initMoData(int sccpchDevSetFroId, int sccpchFroId, Coordinator context) throws MoAccessException {
        MessageLog.trace(1, this.getClass(), "initMoData()");
        MoData moData = new MoData(super.getLocalDistinguishedName(), "Sccpch", false, context);
        moData.registerTransientAttr((Attribute)this.sccpchFroIdAttr);
        return moData;
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData()");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(this.getClass(), "isMyMoDataPersistent()");
        return false;
    }

    private void deleteMyOwnCommonChannels(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "deleteMyOwnCommonChannels()");
        this.deletePich(context);
        this.deleteMyChildren(context);
        this.deleteMich(context);
    }

    private void deletePich(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "deletePich()");
        if (this.pichMoRef != null) {
            ((PichMo)this.pichMoRef).deletePich(context);
        }
    }

    private void deleteMich(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "deleteMich()");
        if (this.michMoRef != null) {
            ((MichMo)this.michMoRef).deleteMich(context);
        }
    }

    private void deleteMyChildren(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "deleteMyChildren()");
        ArrayList<ManagedObject> moList = new ArrayList<ManagedObject>();
        MoIterator mos = this.getChildren();
        while (mos.hasMoreElements()) {
            moList.add(mos.nextMo());
        }
        for (int i = 0; i < moList.size(); ++i) {
            ManagedObject mo = (ManagedObject)moList.get(i);
            if (mo instanceof PchMo) {
                ((PchMo)mo).deletePch(context);
                continue;
            }
            if (mo instanceof FachMo) {
                ((FachMo)mo).deleteFach(context);
                continue;
            }
            MessageLog.trace(1, this.getClass(), "wrong type of child: " + mo);
            throw new UndeletableMoException((ManagedObject)this);
        }
    }

    public int[] getScannerValue(String counterName) throws MoAccessException {
        if (this.myScanner == null) {
            throw new PmsException("MoScanner not available");
        }
        return this.myScanner.getValue(counterName);
    }

    public void moScannerServiceNotAvailable() throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "moScannerServiceNotAvailable() ");
        this.myScanner.serviceRemoved(this.chcSccpchProxy.getServiceName());
    }
}

