/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.rmo.channel;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.AvailabilityStatusIntToEnum;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.Strings;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.proxies.ScCellCarrierProxy;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.SccScpichGetNbapParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.SccScpichGetParamRspS;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObject;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.CellNotSetupException;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.CarrierMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RbsLocalCellMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.ScpichMo;

public class ScpichMoImpl
extends BoamManagedObject
implements ScpichMo {
    private static final Class SELF = ScpichMoImpl.class;
    private static final String CELL_CARRIER_FRO_ID = "cellCarrierFroId";
    private static final String IDENTITY = "1";
    private final MoData myData;
    private final ScCellCarrierProxy sccProxy = ScCellCarrierProxy.instance();

    public ScpichMoImpl(ManagedObject parent, AttrList attributes) throws MoAccessException {
        super(parent, "Scpich", IDENTITY, null);
        MessageLog.traceEnter(SELF, "Normal constructor");
        ValidateAttributes.checkParent(parent, new String[]{"Carrier", "RbsLocalCell"});
        this.myData = this.initMoData(IDENTITY, attributes);
        MessageLog.trace(1, SELF, "MO is created");
    }

    public void delete(Coordinator context) throws MoAccessException, UndeletableMoException {
        MessageLog.traceEnter(SELF, "delete()");
        if (super.isReserved(context)) {
            MessageLog.trace(1, SELF, " this Mo is reserved and can not be deleted ");
            throw new UndeletableMoException((ManagedObject)this);
        }
        super.delete(context);
        MessageLog.trace(1, SELF, "Mo is deleted");
    }

    public Struct actionReadNbapData(Coordinator context) throws MoAccessException, CellNotSetupException {
        MessageLog.traceEnter(SELF, "actionReadNbapData()");
        int cellCarrierFroId = this.bcmGetIntAttribute(CELL_CARRIER_FRO_ID, context);
        try {
            SccScpichGetNbapParamRspS rspSig = this.sccProxy.scpichGetNbapParam(0, this.getTxIdNonTransactional(context), cellCarrierFroId);
            return this.convertSigToStruct(context, rspSig);
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 12) {
                throw new CellNotSetupException();
            }
            throw e;
        }
    }

    private Struct convertSigToStruct(Coordinator context, SccScpichGetNbapParamRspS rspSig) throws MoAccessException {
        String[] names = new String[3];
        Object[] values = new Object[3];
        names[0] = "phChId";
        names[1] = "scpichDlChannelisationCodeNo";
        names[2] = "scpichPower";
        Integer phChId = new Integer(rspSig.scpichCommonPhChId);
        Integer scpichDlChannelisationCodeNo = new Integer(rspSig.scpichDlChannelisationCodeNo);
        Integer scpichPower = new Integer(rspSig.scpichPower);
        values[0] = phChId;
        values[1] = scpichDlChannelisationCodeNo;
        values[2] = scpichPower;
        return new StructImpl(names, values);
    }

    private int getAttribute(Coordinator context, String attributeName) throws MoAccessException, NoSuchAttributeException {
        MessageLog.traceEnter(SELF, "getAttribute()");
        if (!Strings.contains(attributeName, new String[]{"operationalState", "availabilityStatus"})) {
            String msg = "Attribute SccPcpichGetParamRspS." + attributeName + ": no such attribute";
            MessageLog.trace(2, SELF, msg);
            throw new NoSuchAttributeException(msg, this.getType());
        }
        int cellCarrierFroId = this.bcmGetIntAttribute(CELL_CARRIER_FRO_ID, context);
        SccScpichGetParamRspS rspSig = this.sccProxy.scpichGetParam(0, this.getTxIdNonTransactional(context), cellCarrierFroId);
        if (attributeName.equals("operationalState")) {
            return rspSig.scpichOpState;
        }
        if (attributeName.equals("availabilityStatus")) {
            return rspSig.scpichAvailStatus;
        }
        throw new NoSuchAttributeException(attributeName, this.getType());
    }

    public int getAvailabilityStatus(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getAvailabilityStatus()");
        int availabilityStatus = this.getAttribute(context, "availabilityStatus");
        return AvailabilityStatusIntToEnum.convGetAvailStatIntToEnum(availabilityStatus);
    }

    public int getOperationalState(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getOperationalState()");
        ManagedObject parent = this.getParent();
        if (parent instanceof CarrierMo) {
            ManagedObject[] reservedBy = ((CarrierMo)parent).getReservedBy(context);
            RbsLocalCellMo cell = (RbsLocalCellMo)BoamHelper.getFirstMatchingMo(reservedBy, "RbsLocalCell");
            return cell.getOperationalState(context);
        }
        return ((RbsLocalCellMo)parent).getOperationalState(context);
    }

    public String getType() {
        return "Scpich";
    }

    public String getScpichId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getScpichId()");
        return super.bcmGetIdentity(this.getLocalDistinguishedName(), context);
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(SELF, "getMyMoData()");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(SELF, "isMyMoDataPersistent()");
        return false;
    }

    private MoData initMoData(String identity, AttrList attributes) throws MoAccessException, TransactionRequiredException, AttrMissingAtCreateException, WrongAttributeTypeException, NotHandledAttributeTypeException, ValueOutOfRangeException {
        MessageLog.traceEnter(this.getClass(), "initMoData()");
        MoData moData = new MoData(this.getLocalDistinguishedName(), "Scpich", false, null);
        IntegerAttribute cellCarrierFroId = new IntegerAttribute(CELL_CARRIER_FRO_ID, false);
        moData.registerTransientAttr((Attribute)cellCarrierFroId);
        cellCarrierFroId.setValue(ValidateAttributes.checkAndGetIntAttribute(attributes, CELL_CARRIER_FRO_ID, "Scpich"));
        return moData;
    }
}

