/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.rmo.iub;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.ConvertHelper;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcEulProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcHsdpaIubProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcIubdsProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcMeasurementProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcGetIubdsParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcTransportOptionT;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObject;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.AlreadyActiveException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.DeviceDisabledException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.InternalErrorException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.NotActiveException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.TxbDoesNotSupportHsException;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.IubDataStreamsMo;
import se.ericsson.wcdma.rbs.boam.mao.rmo.iub.IubDataStreamsMoFactory;
import se.ericsson.wcdma.rbs.boam.pms.impl.MoScanner;
import se.ericsson.wcdma.rbs.boam.pms.impl.PmsException;

public class IubDataStreamsMoImpl
extends BoamManagedObject
implements IubDataStreamsMo {
    public static final Class SELF = IubDataStreamsMoImpl.class;
    public static final int MO_DATA_REVISION = 4030001;
    private static final String PARENT_TYPE = "Iub";
    private static final int DUMMY_FROID = -1;
    private final MoData myMoData;
    private final ChcIubdsProxy chcIubDataStreamsProxy = ChcIubdsProxy.instance();
    private final ChcHsdpaIubProxy chcHsdpaIubProxy = ChcHsdpaIubProxy.instance();
    private final ChcMeasurementProxy chcMeasurementProxy = ChcMeasurementProxy.instance();
    private final MoScanner myScanner;
    static /* synthetic */ Class class$se$ericsson$wcdma$rbs$boam$mao$iface$gen$enumer$SchFlowControlState;

    public IubDataStreamsMoImpl(ManagedObject parent, String motypeName, String identity, Coordinator context, AttrList attributes, ManagedObject source) throws MoAccessException {
        super(parent, motypeName, identity, context);
        MessageLog.traceEnter(SELF, "IubDataStreamsMoImpl()<---");
        ValidateAttributes.checkTransaction(context);
        ValidateAttributes.checkParent(parent, PARENT_TYPE);
        this.myMoData = this.initMoData(context);
        this.myScanner = this.createMoScanner(false, context);
        MessageLog.trace(1, this.getClass(), "IubDataStreams is created ");
    }

    public IubDataStreamsMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData.getLocalDistinguishedName());
        MessageLog.traceEnter(SELF, "recovered IudDataStreamsMoImpl() <---");
        this.myMoData = recoveredData;
        this.myScanner = this.createMoScanner(true, null);
    }

    private MoScanner createMoScanner(boolean isRecovery, Coordinator context) {
        try {
            int[] additionalInfo = new int[]{0};
            MessageLog.trace(1, this.getClass(), "create MoScanner <---");
            MoScanner moScanner = new MoScanner(this, this.chcMeasurementProxy, -1, 0, IubDataStreamsMoFactory.instance().getCounters(), additionalInfo, isRecovery, context);
            MessageLog.trace(1, SELF, "MoScanner created<---");
            return moScanner;
        }
        catch (Exception pmse) {
            MessageLog.traceError(SELF, " Could not create MoScanner: " + pmse);
            return null;
        }
    }

    public void update(boolean bAtm, boolean bIpv4, int ipAccessHostEtFroId, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "update()<---");
        int iAtm = bAtm ? 1 : 0;
        int iIpv4 = bIpv4 ? 1 : 0;
        ChcTransportOptionT userPlaneTransportOption = new ChcTransportOptionT(iAtm, iIpv4);
        this.chcIubDataStreamsProxy.createIubdsParam(0, userPlaneTransportOption, ipAccessHostEtFroId, this.getTxIdTransactional(context));
    }

    public void delete(Coordinator context) throws MoAccessException, UndeletableMoException {
        MessageLog.traceEnter(SELF, "delete(),IubDataStreams is undeletable!");
        throw new UndeletableMoException((ManagedObject)this);
    }

    public void delete(Coordinator context, String thisTypeName) throws MoAccessException, UndeletableMoException {
        MessageLog.traceEnter(SELF, "delete(" + thisTypeName + ")<--");
        if (thisTypeName.compareTo(PARENT_TYPE) == 0) {
            this.myMoData.handleTransaction(context, MoData.WRITE_ACCESS);
            if (this.myScanner != null) {
                this.myScanner.delete(context);
            }
        } else {
            MessageLog.trace(1, SELF, thisTypeName + " cannot make a delete of " + "IubDataStreams");
            throw new UndeletableMoException((ManagedObject)this);
        }
        super.delete(context);
        MessageLog.trace(1, SELF, "IubDataStreams is Deleted ");
    }

    public int getMaxHsRate(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getMaxHsRate() <---");
        return (int)this.chcHsdpaIubProxy.getHsdpaParam((int)0, (int)this.getTxIdNonTransactional((Coordinator)c)).hsMaxRate;
    }

    public void setMaxHsRate(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(SELF, "setMaxHsRate(" + value + ")<---");
        ValidateAttributes.checkTransaction(c);
        this.myMoData.handleTransaction(c, MoData.WRITE_ACCESS);
        ValidateAttributes.intValueRangeCheck("maxHsRate", value, MAX_HS_RATE_MIN_VALUES, MAX_HS_RATE_MAX_VALUES, this.getType());
        this.chcHsdpaIubProxy.setHsdpaParam(0, this.getTxIdTransactional(c), value, this.getHsDataFrameDelayThreshold(c), this.getSchHsFlowControlOnOff(c), this.getHsRbrWeight(c), this.getHsAqmCongCtrlSpiOnOff(c), this.getHsRbrDiscardProbability(c));
        this.sendAVC("maxHsRate", value, c);
    }

    public String getType() {
        return "IubDataStreams";
    }

    public void proxiesUnavailable() {
        MessageLog.traceEnter(SELF, "proxiesUnavailable() ");
    }

    public void proxiesAvailable() {
        MessageLog.traceEnter(SELF, "proxiesAvailable() ");
    }

    public String getIubDataStreamsId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getIubDataStreamsId()");
        return super.bcmGetIdentity(this.getLocalDistinguishedName(), context);
    }

    public int getNoOfCommonStreams(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getNoOfCommonStreams()");
        ChcGetIubdsParamRspS rspSig = this.chcIubDataStreamsProxy.getIubdsParam(0, this.getTxIdNonTransactional(context));
        return rspSig.noOfCommonChannels;
    }

    public int getNoOfDedicatedStreams(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getNoOfDedicatedStreams()");
        ChcGetIubdsParamRspS rspSig = this.chcIubDataStreamsProxy.getIubdsParam(0, this.getTxIdNonTransactional(context));
        return rspSig.noOfDedicatedChannels;
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(SELF, "getMyMoData() ");
        return this.myMoData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(SELF, "isMyMoDataPersistent() ");
        return true;
    }

    private MoData initMoData(Coordinator context) throws MoAccessException, TransactionRequiredException, AttrMissingAtCreateException, WrongAttributeTypeException, NotHandledAttributeTypeException, ValueOutOfRangeException {
        try {
            MessageLog.traceEnter(SELF, "initMoData() <---");
            MoData moData = new MoData(this.getLocalDistinguishedName(), this.getType(), true, context);
            moData.handleTransaction(context, MoData.WRITE_ACCESS);
            moData.setRevision(4030001);
            return moData;
        }
        catch (MoAccessException e) {
            super.delete(context);
            MessageLog.traceError(SELF, " initiation of the DataBase failed ");
            throw e;
        }
    }

    public int[] getActiveRdbtRbsMeasurements(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getActiveRdbtRbsMeasurements()<---");
        return this.chcMeasurementProxy.getUPT(0, -1);
    }

    public void actionStartRdbtRbs(int measType, Coordinator c) throws MoAccessException, InternalErrorException, AlreadyActiveException, DeviceDisabledException, TxbDoesNotSupportHsException {
        MessageLog.traceEnter(SELF, "actionStartRdbtRbs()<---");
        this.myMoData.handleTransaction(c, MoData.READ_ACCESS);
        IubDataStreamsMoImpl.validateRdbtRbsMeas(measType);
        this.chcMeasurementProxy.startUPT(0, measType, -1);
    }

    public void actionStopRdbtRbs(int measType, Coordinator c) throws MoAccessException, NotActiveException {
        MessageLog.traceEnter(SELF, "actionStopRdbtRbs()<---");
        this.myMoData.handleTransaction(c, MoData.READ_ACCESS);
        IubDataStreamsMoImpl.validateRdbtRbsMeas(measType);
        this.chcMeasurementProxy.stopUPT(0, measType, -1);
    }

    private static void validateRdbtRbsMeas(int measType) throws MoAccessException {
        MessageLog.traceEnter(IubDataStreamsMoImpl.class, "validateRdbtRbsMeas(" + measType + ")<---");
        if ((measType < 38 || measType > 42) && measType != 35 && measType != 36 && measType != 45 && measType != 46 && measType != 55 && measType != 56) {
            throw new ValueOutOfRangeException("Invalid Meas Type: " + measType, "IubDataStreams");
        }
    }

    public int getHsDataFrameDelayThreshold(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getHsDataFrameDelayThreshold()");
        return this.chcHsdpaIubProxy.getHsdpaParam((int)0, (int)this.getTxIdNonTransactional((Coordinator)c)).hsDataFrameDelayThreshold;
    }

    public void setHsDataFrameDelayThreshold(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(SELF, "setHsDataFrameDelayThreshold()");
        ValidateAttributes.checkTransaction(c);
        this.myMoData.handleTransaction(c, MoData.WRITE_ACCESS);
        ValidateAttributes.intValueRangeCheck("hsDataFrameDelayThreshold", value, HS_DATA_FRAME_DELAY_THRESHOLD_MIN_VALUES, HS_DATA_FRAME_DELAY_THRESHOLD_MAX_VALUES, this.getType());
        this.chcHsdpaIubProxy.setHsdpaParam(0, this.getTxIdTransactional(c), this.getMaxHsRate(c), value, this.getSchHsFlowControlOnOff(c), this.getHsRbrWeight(c), this.getHsAqmCongCtrlSpiOnOff(c), this.getHsRbrDiscardProbability(c));
        this.sendAVC("hsDataFrameDelayThreshold", value, c);
    }

    public int[] getSchHsFlowControlOnOff(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getSchHsFlowControlOnOff() <---");
        long[] values = this.chcHsdpaIubProxy.getHsdpaParam((int)0, (int)this.getTxIdNonTransactional((Coordinator)c)).schHsFlowControlOnOff;
        return ConvertHelper.longArrayToIntArray(values);
    }

    public void setSchHsFlowControlOnOff(int[] value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(SELF, "setSchHsFlowControlOnOff()<---");
        ValidateAttributes.checkTransaction(c);
        this.myMoData.handleTransaction(c, MoData.WRITE_ACCESS);
        if (value.length != 16) {
            MessageLog.trace(2, this.getClass(), "schHsFlowControlOnOff must have 16 elements");
            throw new WrongAttributeTypeException("schHsFlowControlOnOff", "IubDataStreams");
        }
        for (int i = 0; i < value.length; ++i) {
            if (value[i] >= 0 && value[i] <= 1) continue;
            throw new ValueOutOfRangeException("schHsFlowControlOnOff", "IubDataStreams");
        }
        this.chcHsdpaIubProxy.setHsdpaParam(0, this.getTxIdTransactional(c), this.getMaxHsRate(c), this.getHsDataFrameDelayThreshold(c), value, this.getHsRbrWeight(c), this.getHsAqmCongCtrlSpiOnOff(c), this.getHsRbrDiscardProbability(c));
        this.sendAVC("schHsFlowControlOnOff", value, c);
    }

    public Struct getUserPlaneTransportOption(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getUserPlaneTransportOption()");
        this.myMoData.handleTransaction(c, MoData.READ_ACCESS);
        ChcGetIubdsParamRspS params = this.chcIubDataStreamsProxy.getIubdsParam(0, this.getTxIdNonTransactional(c));
        ChcTransportOptionT userPlaneTransportOption = params.userPlaneTransportOption;
        int atm = userPlaneTransportOption.atm;
        int ipV4 = userPlaneTransportOption.ipV4;
        boolean bAtm = atm == 1;
        boolean bIp = ipV4 == 1;
        return new StructImpl(new String[]{"atm", "ipV4"}, (Object[])new Boolean[]{bAtm, bIp});
    }

    public int[] getScannerValue(String counterName) throws PmsException {
        if (this.myScanner == null) {
            throw new PmsException("MoScanner not available");
        }
        return this.myScanner.getValue(counterName);
    }

    public int[] getHsRbrWeight(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getHsRbrWeight() <---");
        long[] values = this.chcHsdpaIubProxy.getHsdpaParam((int)0, (int)this.getTxIdNonTransactional((Coordinator)c)).hsRbrWeight;
        return ConvertHelper.longArrayToIntArray(values);
    }

    public void setHsRbrWeight(int[] value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(SELF, "setHsRbrWeight()--->");
        ValidateAttributes.checkTransaction(c);
        this.myMoData.handleTransaction(c, MoData.WRITE_ACCESS);
        if (value.length != 16) {
            MessageLog.trace(2, this.getClass(), "hsRbrWeight must have 16 elements");
            throw new WrongAttributeTypeException("hsRbrWeight", "IubDataStreams");
        }
        for (int i = 0; i < value.length; ++i) {
            ValidateAttributes.intValueRangeCheck("hsRbrWeight", value[i], HS_RBR_WEIGHT_MIN_VALUES, HS_RBR_WEIGHT_MAX_VALUES, this.getType());
        }
        this.chcHsdpaIubProxy.setHsdpaParam(0, this.getTxIdTransactional(c), this.getMaxHsRate(c), this.getHsDataFrameDelayThreshold(c), this.getSchHsFlowControlOnOff(c), value, this.getHsAqmCongCtrlSpiOnOff(c), this.getHsRbrDiscardProbability(c));
        this.sendAVC("hsRbrWeight", value, c);
    }

    public int[] getHsAqmCongCtrlSpiOnOff(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getHsAqmCongCtrlSpiOnOff() <---");
        return ConvertHelper.longArrayToIntArray(this.chcHsdpaIubProxy.getHsdpaParam((int)0, (int)this.getTxIdNonTransactional((Coordinator)c)).hsAqmCongCtrlSpiOnOff);
    }

    public void setHsAqmCongCtrlSpiOnOff(int[] value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(SELF, "setHsAqmCongCtrlSpiOnOff()--->");
        ValidateAttributes.checkTransaction(c);
        this.myMoData.handleTransaction(c, MoData.WRITE_ACCESS);
        if (value.length != 16) {
            MessageLog.trace(2, this.getClass(), "hsAqmCongCtrlSpiOnOff must have 16 elements");
            throw new WrongAttributeTypeException("hsAqmCongCtrlSpiOnOff", "IubDataStreams");
        }
        for (int i = 0; i < value.length; ++i) {
            ValidateAttributes.intValueInEnumerationCheck("hsAqmCongCtrlSpiOnOff", value[i], class$se$ericsson$wcdma$rbs$boam$mao$iface$gen$enumer$SchFlowControlState == null ? IubDataStreamsMoImpl.class$("se.ericsson.wcdma.rbs.boam.mao.iface.gen.enumer.SchFlowControlState") : class$se$ericsson$wcdma$rbs$boam$mao$iface$gen$enumer$SchFlowControlState, this.getType());
        }
        this.chcHsdpaIubProxy.setHsdpaParam(0, this.getTxIdTransactional(c), this.getMaxHsRate(c), this.getHsDataFrameDelayThreshold(c), this.getSchHsFlowControlOnOff(c), this.getHsRbrWeight(c), value, this.getHsRbrDiscardProbability(c));
        this.sendAVC("hsAqmCongCtrlSpiOnOff", value, c);
    }

    public int getHsRbrDiscardProbability(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(SELF, "getHsRbrDiscardProbability() <---");
        return (int)this.chcHsdpaIubProxy.getHsdpaParam((int)0, (int)this.getTxIdNonTransactional((Coordinator)c)).hsRbrDiscardProbability;
    }

    public void setHsRbrDiscardProbability(int value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(SELF, "setHsRbrDiscardProbability()--->");
        ValidateAttributes.checkTransaction(c);
        this.myMoData.handleTransaction(c, MoData.WRITE_ACCESS);
        ValidateAttributes.intValueRangeCheck("hsRbrDiscardProbability", value, HS_RBR_DISCARD_PROBABILITY_MIN_VALUES, HS_RBR_DISCARD_PROBABILITY_MAX_VALUES, this.getType());
        this.chcHsdpaIubProxy.setHsdpaParam(0, this.getTxIdTransactional(c), this.getMaxHsRate(c), this.getHsDataFrameDelayThreshold(c), this.getSchHsFlowControlOnOff(c), this.getHsRbrWeight(c), this.getHsAqmCongCtrlSpiOnOff(c), value);
        this.sendAVC("hsRbrDiscardProbability", value, c);
    }

    static {
        ChcEulProxy.instance();
    }
}

