/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.pms.impl;

import java.util.HashSet;
import java.util.Set;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.proxies.ScannedValue;
import se.ericsson.wcdma.rbs.boam.pms.iface.PmPreCondition;
import se.ericsson.wcdma.rbs.boam.pms.iface.Scannable;
import se.ericsson.wcdma.rbs.boam.pms.impl.CounterGroup;
import se.ericsson.wcdma.rbs.boam.pms.impl.MoScanner;

class GroupScanner
implements Scannable,
PmPreCondition {
    private final MoScanner myRO;
    private final CounterGroup counterGroup;
    private final Set reservedBy = new HashSet();
    private final IScannerTiming _scannerTiming = new ScannerTiming();
    private final Object adminLock = new Object();
    private final Object scanLock = new Object();
    private int granularityPeriodInSeconds = 0;
    private ScannedValue[] scannedValues = null;

    public GroupScanner(MoScanner myRO, CounterGroup counterGroup) {
        this.myRO = myRO;
        this.counterGroup = counterGroup;
    }

    public String getLDN() {
        return this.myRO.getLDN();
    }

    public String getTypeName() {
        return this.myRO.getTypeName();
    }

    private ScannedValue getValueByName(String counterName) {
        for (int i = 0; i < this.scannedValues.length; ++i) {
            if (!this.scannedValues[i].getName().equals(counterName)) continue;
            return this.scannedValues[i];
        }
        MessageLog.trace(3, this.getClass(), "there is no counter: " + counterName + " in group: " + this.counterGroup.getGroupName());
        return null;
    }

    private ScannedValue[] createScannedValue(String counterName) {
        MessageLog.trace(3, this.getClass(), "replay()");
        if (this.scannedValues == null || this.scannedValues.length == 0) {
            return new ScannedValue[0];
        }
        ScannedValue v = this.getValueByName(counterName);
        if (v == null) {
            return new ScannedValue[0];
        }
        return new ScannedValue[]{v};
    }

    public boolean isPmCounterStartable(String counterName, Coordinator context) throws MoAccessException {
        return this.myRO.isPmCounterStartable(counterName, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScannedValue[] scan(String counterName) throws MoAccessException {
        Object object = this.scanLock;
        synchronized (object) {
            MessageLog.trace(3, this.getClass(), "scan(), name: " + counterName);
            this._scannerTiming.scanningStarted();
            if (this.scannedValues == null || this._scannerTiming.isNextGP()) {
                this._scannerTiming.calibrateGP(this.getGranularityPeriodInSeconds());
                this.scannedValues = this.myRO.scan(this.counterGroup.getGroupName());
            }
            return this.createScannedValue(counterName);
        }
    }

    private void sendStartReq(int granularityPeriodInMinutes) throws MoAccessException {
        MessageLog.trace(3, this.getClass(), "sendStartReq(),granularityPeriod:" + granularityPeriodInMinutes);
        this.myRO.start(this.counterGroup.getGroupName(), granularityPeriodInMinutes);
    }

    private void sendStopReq() throws MoAccessException {
        MessageLog.trace(3, this.getClass(), "sendStopReq()");
        this.myRO.stop(this.counterGroup.getGroupName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(String counterName, int granularityPeriodInMinutes) throws MoAccessException {
        MessageLog.trace(3, this.getClass(), "start(): counter name: " + counterName + ", group name: " + this.counterGroup.getGroupName());
        Object object = this.adminLock;
        synchronized (object) {
            if (this.reservedBy.isEmpty()) {
                this.sendStartReq(granularityPeriodInMinutes);
                this.granularityPeriodInSeconds = granularityPeriodInMinutes * 60;
            }
            this.reservedBy.add(counterName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(String counterName) throws MoAccessException {
        MessageLog.trace(3, this.getClass(), "stop(): counter name:" + counterName + ", group name: " + this.counterGroup.getGroupName());
        Object object = this.adminLock;
        synchronized (object) {
            this.reservedBy.remove(counterName);
            if (this.reservedBy.isEmpty()) {
                this.sendStopReq();
                this.granularityPeriodInSeconds = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInactive() {
        Object object = this.adminLock;
        synchronized (object) {
            this.reservedBy.clear();
            this.granularityPeriodInSeconds = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getGranularityPeriodInSeconds() {
        Object object = this.adminLock;
        synchronized (object) {
            return this.granularityPeriodInSeconds;
        }
    }

    public static class ScannerTiming
    implements IScannerTiming {
        private long timeOfScanInSeconds = 0L;
        private long tValidRange = 0L;

        public boolean isNextGP() {
            long timeOfAttemptedScan = this.getTimeInSeconds();
            return timeOfAttemptedScan - this.timeOfScanInSeconds > this.tValidRange;
        }

        public void calibrateGP(int gpInSeconds) {
            this.timeOfScanInSeconds = this.getTimeInSeconds();
            this.tValidRange = (long)gpInSeconds - this.timeOfScanInSeconds % (long)gpInSeconds;
        }

        public void scanningStarted() {
        }

        private long getTimeInSeconds() {
            return System.currentTimeMillis() / 1000L;
        }
    }

    public static interface IScannerTiming {
        public boolean isNextGP();

        public void calibrateGP(int var1);

        public void scanningStarted();
    }
}

