/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.omf.aue.step2.actions;

import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.MoDataAction;
import se.ericsson.cello.aueframework.converter.MoDataWrapper;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;

public class FixFroIdAttrAction
implements MoDataAction {
    private static final Class THIS_CLASS = FixFroIdAttrAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public void perform(MoDataWrapper moDataWrapper, ConverterContext converterContext, Coordinator coordinator) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "perform()");
        int n = 0;
        IntegerAttribute integerAttribute = (IntegerAttribute)moDataWrapper.getAttribute("froId");
        IntegerAttribute integerAttribute2 = (IntegerAttribute)moDataWrapper.getAttribute("froid");
        if (integerAttribute2 != null) {
            n = integerAttribute2.getValue(coordinator);
            if (integerAttribute != null) {
                logger.traceGeneral(THIS_CLASS, "Found froid value and existing froId attr for MO: " + moDataWrapper.getLocalDistinguishedName());
                integerAttribute.setValue(n);
            } else {
                logger.traceGeneral(THIS_CLASS, "Found froid value but no existing froId attr for MO: " + moDataWrapper.getLocalDistinguishedName() + " creating froId and setting froid value to it");
                IntegerAttribute integerAttribute3 = new IntegerAttribute("froId", false, 0);
                integerAttribute3.setValue(n);
                moDataWrapper.registerPersistentAttr((Attribute)integerAttribute3);
            }
            logger.traceGeneral(THIS_CLASS, "Deleting froid attr");
            moDataWrapper.deregisterAttribute((Attribute)integerAttribute2);
        } else {
            logger.traceDebug(THIS_CLASS, "froid not found.");
        }
        logger.traceReturn(THIS_CLASS, "perform()");
    }
}

