/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.omf.aue.step2.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.MoDataAccessor;
import se.ericsson.cello.aueframework.converter.MoDataAction;
import se.ericsson.cello.aueframework.converter.MoDataWrapper;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;

public class SetEquipmentSupportFunctionRefOnEcBusesAction
implements MoDataAction {
    private static final Class THIS_CLASS = SetEquipmentSupportFunctionRefOnEcBusesAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String ECBUS_MO_TYPE = "EcBus";
    private static final String ESF_MO_TYPE = "EquipmentSupportFunction";
    private static final String ESFREF_ATTRIBUTE_NAME = "equipmentSupportFunctionRef";
    private static final String RESERVED_BY_ATTRIBUTE_NAME = "reservedBy";

    public void perform(MoDataWrapper moDataWrapper, ConverterContext converterContext, Coordinator coordinator) throws CrbsAueException {
        MoDataWrapper moDataWrapper2;
        logger.traceEnter(THIS_CLASS, "perform()");
        MoDataAccessor moDataAccessor = converterContext.getMoDataAccessor();
        Collection collection = moDataAccessor.getByType(ESF_MO_TYPE);
        Iterator iterator = collection.iterator();
        MoDataWrapper moDataWrapper3 = moDataWrapper2 = iterator.hasNext() ? (MoDataWrapper)iterator.next() : null;
        if (moDataWrapper2 != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            logger.traceDebug(THIS_CLASS, "EquipmentSupportFunction Ldn: " + moDataWrapper2.getLocalDistinguishedName());
            Collection collection2 = moDataAccessor.getByType(ECBUS_MO_TYPE);
            Iterator iterator2 = collection2.iterator();
            while (iterator2.hasNext()) {
                MoDataWrapper moDataWrapper4 = (MoDataWrapper)iterator2.next();
                String string = moDataWrapper4.getLocalDistinguishedName();
                arrayList.add(string);
                logger.traceDebug(THIS_CLASS, "EcBus Ldn: " + string);
                this.setEquipmentSupportFunctionRef(moDataWrapper4, moDataWrapper2, coordinator);
            }
            this.setReservedBy(moDataWrapper2, arrayList, coordinator);
        } else {
            logger.traceDebug(THIS_CLASS, "No EquipmentSupportFunction!");
        }
        logger.traceReturn(THIS_CLASS, "perform()");
    }

    private void setReservedBy(MoDataWrapper moDataWrapper, ArrayList arrayList, Coordinator coordinator) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "setReservedBy()");
        try {
            SequenceAttribute sequenceAttribute = new SequenceAttribute(RESERVED_BY_ATTRIBUTE_NAME, true);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                sequenceAttribute.addElement((Attribute)new ReferenceAttribute("", string, true));
            }
            moDataWrapper.deregisterAttribute(RESERVED_BY_ATTRIBUTE_NAME);
            moDataWrapper.registerPersistentAttr((Attribute)sequenceAttribute);
            moDataWrapper.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        }
        catch (AueException aueException) {
            throw new CrbsAueException(aueException.getMessage(), (Throwable)aueException);
        }
        logger.traceEnter(THIS_CLASS, "setReservedBy()");
    }

    private void setEquipmentSupportFunctionRef(MoDataWrapper moDataWrapper, MoDataWrapper moDataWrapper2, Coordinator coordinator) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "setEquipmentSupportFunctionRef()");
        try {
            ReferenceAttribute referenceAttribute = new ReferenceAttribute(ESFREF_ATTRIBUTE_NAME, moDataWrapper2.getLocalDistinguishedName(), true);
            moDataWrapper.deregisterAttribute(ESFREF_ATTRIBUTE_NAME);
            moDataWrapper.registerPersistentAttr((Attribute)referenceAttribute);
            moDataWrapper.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        }
        catch (AueException aueException) {
            throw new CrbsAueException(aueException.getMessage(), (Throwable)aueException);
        }
        logger.traceReturn(THIS_CLASS, "setEquipmentSupportFunctionRef()");
    }
}

