/*
 *  COPYRIGHT
 *  ---------
 *  Copyright (C) 2008 by
 *  Ericsson AB
 *
 *  The program may be used and/or copied only with the written
 *  permission from Ericsson AB, or in
 *  accordance with the terms and conditions stipulated in the
 *  agreement/contract under which the program has been supplied.
 *
 *  All rights reserved.
 *
 */
/*
 *  COPYRIGHT
 *  ---------
 *  Ericsson AB 2008 All rights reserved.
 *
 * The information in this document is the property of Ericsson.
 * Except as specifically authorized in writing by Ericsson, the
 * receiver of this document shall keep the information contained
 * herein confidential and shall protect the same in whole or in
 * part from disclosure and dissemination to third parties.
 * Disclosure and disseminations to the receiver's employees shall
 * only be made on a strict need to know basis.
 *
 *
 *  REVISION HISTORY
 *  ----------------
 *
 *  Revised: Johan Flinck 14 Feb 2008
 *  Changes: First revision.
 *
 *
 * 2008-09-05 uabflik UABtr62664 CPPClientConfig.xml should be generated on target
 * 
 * 2010-09-01 ehsake HM11102 Removed redundant method, getWholePath()
 */

package se.ericsson.cello.viewfilecreator.mao;

import java.io.File;
import java.io.FileFilter;

public class FilePathCreator {


    private FileFilter filter;


    /**
     * Filter that ends with .jar, regardless of upper/lowercase.
     */
    public static final FileFilter FILTER_JAR_FILES =
        new FileFilter() {
            public boolean accept(File file) {
                return file.getPath().toLowerCase().endsWith(".jar");
            }
        };


    /**
     * Filter that matches the file <code>CPPClientConfig.xml</code>
     */
    public static final FileFilter FILTER_CPPCLIENTCONFIG =
        new FileFilter() {
            public boolean accept(File file) {
                return file.getName().equals("CPPClientConfig.xml");
            }
        };
    

    /**
     * Default behaviour, don't filter out any files, return the first non-directory found.
     */
    public FilePathCreator()
    {
        this(null);
    }

    /**
     * Find the first file matching the supplied filter.
     */
    public FilePathCreator(FileFilter filter)
    {
        this.filter = filter;
    }


    /**
     *
     * @param startDir for example "/c/loadmodules/CXC1322419%11_R71H10"
     * @return relative web server file path to the jar file, for example "/cello/emas/nisse.jar"
     */
    public String getPath(String startDir)
    {
        if ((startDir == null) || (! new File(startDir).exists())) {
            return null;
        }
        
        String path = getFilePath(startDir);
        
        if(path == null) {
            return null;
            
        } else {
            return path.substring(startDir.length());
        }
    }
    
    /**
    *
    * @param startDir for example "/c/loadmodules/CXC1322419%11_R71H10"
    * @return Absolute file path to the jar file, for example "/c/loadmodules/CXC1322419%11_R71H10/cello/emas/nisse.jar"
    */
    public String getFilePath(String startDir)
    {
        File pathFile = new File(startDir);
        String result = null;
        String[] entries;
        
        if (pathFile.isFile()) {
            if ((this.filter == null) || this.filter.accept(pathFile)) {
                result = startDir;
            }
            
        } else {
            entries = pathFile.list();
            
            for (int i = 0; i < entries.length; i++) {
                result = getFilePath(startDir + File.separator + entries[i]);
                
                if (result != null) {
                    return result;
                }
            }
        }
        
        return result;
    }
    
}
