/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.cppsec.esa;

import se.ericsson.security.cppsec.esa.SecurityActivationException;
import se.ericsson.security.cppsec.esa.proxy.EsaProxyFactory;

public class SecmodeExecutor {
    static final String SECMODE_LEVEL = "secmode -l ";
    static final String SECMODE_SHUTDOWN_TELNET_FTP = "secmode -t s";
    private static final String SECMODE_START_TELNET_FTP = "secmode -t u";
    private static final String SECMODE_START_TARGET_MONITOR = "secmode -m u";
    private static final String SECMODE_START_DEBUG_AND_UDP = "secmode -d u";
    private static final String SECMODE_FILE_TRANSFER = "secmode -f ";
    private static final String FILE_TRANSFER_SECURE = "s";
    private static final String FILE_TRANSFER_UNSECURE = "u";

    protected static void adaptSecurityLevel() throws SecurityActivationException {
        int n = EsaProxyFactory.getEsaProxy().runCommand("secmode -l a");
        if (n != 0) {
            throw new SecurityActivationException("Failed to execute the secmode command!Command: secmode -l aResult: " + n);
        }
    }

    protected static void executeLevel(int n) throws SecurityActivationException {
        String string = SECMODE_LEVEL + n;
        int n2 = EsaProxyFactory.getEsaProxy().runCommand(string);
        if (n2 != 0) {
            throw new SecurityActivationException("Failed to execute the secmode command!Command: " + string + "Result: " + n2);
        }
    }

    protected static void executeFileTransferClient(String string) throws SecurityActivationException {
        String string2 = SECMODE_FILE_TRANSFER + ("secure".equalsIgnoreCase(string) ? FILE_TRANSFER_SECURE : FILE_TRANSFER_UNSECURE);
        int n = EsaProxyFactory.getEsaProxy().runCommand(string2);
        if (n != 0) {
            throw new SecurityActivationException("Failed to execute the secmode command!Command: " + string2 + "Result: " + n);
        }
    }

    protected static void executeShutdownFtpAndTelnet() throws SecurityActivationException {
        int n = EsaProxyFactory.getEsaProxy().runCommand(SECMODE_SHUTDOWN_TELNET_FTP);
        if (n != 0) {
            throw new SecurityActivationException("Failed to execute the secmode command!Command: secmode -t sResult: " + n);
        }
    }

    protected static void executeStartFtpAndTelnet() throws SecurityActivationException {
        int n = EsaProxyFactory.getEsaProxy().runCommand(SECMODE_START_TELNET_FTP);
        if (n != 0) {
            throw new SecurityActivationException("Failed to execute the secmode command!Command: secmode -t uResult: " + n);
        }
    }

    protected static void executeStartTargetMonitor() throws SecurityActivationException {
        int n = EsaProxyFactory.getEsaProxy().runCommand(SECMODE_START_TARGET_MONITOR);
        if (n != 0) {
            throw new SecurityActivationException("Failed to execute the secmode command!Command: secmode -m uResult: " + n);
        }
    }

    protected static void executeStartDebugAndUDP() throws SecurityActivationException {
        int n = EsaProxyFactory.getEsaProxy().runCommand(SECMODE_START_DEBUG_AND_UDP);
        if (n != 0) {
            throw new SecurityActivationException("Failed to execute the secmode command!Command: secmode -d uResult: " + n);
        }
    }
}

